/*
 * Decompiled with CFR 0.152.
 */
package com.sap.conn.jco.util;

import com.sap.conn.jco.util.Codecs;
import java.io.CharConversionException;
import java.io.IOException;
import java.io.Writer;

public class XMLWriterBase {
    public static final String NAMESPACE_URN_SOAP_UC = "urn:sap-com:document:sap:soap:functions:uc-style";
    public static final String NAMESPACE_URN_SAP_RFC = "urn:sap-com:document:sap:rfc:functions";
    public static final byte ESCAPE_NONE = 0;
    public static final byte ESCAPE_DEFAULT = 1;
    public static final byte ESCAPE_IDOC46 = 2;
    public static final byte ESCAPE_IDOC610 = 3;
    protected static final int DOCUMENT_BUFFER_SIZE = 1024;
    private static final char[] hex = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};
    private static final char[] LESSTHAN = new char[]{'&', '#', '6', '0', ';'};
    private static final char[] GREATERTHAN = new char[]{'&', '#', '6', '2', ';'};
    private static final char[] AMPERSAND = new char[]{'&', '#', '3', '8', ';'};
    private static final char[] CDATASTART = new char[]{'<', '!', '[', 'C', 'D', 'A', 'T', 'A', '['};
    private static final char[] CDATAEND = new char[]{']', ']', '>'};
    protected XMLWriterBase m_parent = null;
    private char[] m_xmldoc = null;
    private int m_offset = 0;
    private int m_length = 0;
    private char[] m_buffer = new char[0];
    private Writer m_out = null;
    private String m_encoding = "UTF-8";
    protected byte m_escape_mode = 1;
    protected boolean m_with_end_of_line = false;
    protected char[] entity = new char[]{'&', '#', '0', '0', ';'};

    public XMLWriterBase() {
        this.m_xmldoc = new char[1024];
    }

    public XMLWriterBase(XMLWriterBase parent, Writer out) {
        this.m_parent = parent;
        if (this.m_parent == null) {
            this.m_buffer = new char[1024];
            this.m_xmldoc = new char[1024];
            this.m_offset = 0;
            this.m_out = out;
        } else {
            this.m_buffer = this.m_parent.m_buffer;
            this.m_xmldoc = this.m_parent.m_xmldoc;
            this.m_offset = this.m_parent.m_offset;
            this.m_length = this.m_parent.m_length;
            this.m_out = this.m_parent.m_out;
            this.m_encoding = this.m_parent.m_encoding;
            this.m_escape_mode = this.m_parent.m_escape_mode;
        }
    }

    private final void propagateToParent() {
        XMLWriterBase parent = this.m_parent;
        while (parent != null) {
            parent.m_xmldoc = this.m_xmldoc;
            parent.m_offset = this.m_offset;
            parent.m_length = this.m_length;
            parent = parent.m_parent;
        }
    }

    protected final void ensureBufferCapacity(int size) throws IOException {
        if (this.m_offset + size >= this.m_xmldoc.length) {
            if (this.m_out != null && this.m_offset > 0) {
                this.flush();
            }
            if (this.m_offset + size >= this.m_xmldoc.length) {
                char[] old = this.m_xmldoc;
                size += this.m_offset;
                size = (size / 1024 + 1) * 2 * 1024;
                this.m_xmldoc = new char[size];
                System.arraycopy(old, 0, this.m_xmldoc, 0, this.m_offset);
            }
            this.propagateToParent();
        }
    }

    public final String toString() {
        return this.m_out == null ? new String(this.m_xmldoc, 0, this.m_offset) : "";
    }

    public void flush() throws IOException {
        if (this.m_out != null && this.m_offset > 0) {
            this.m_out.write(this.m_xmldoc, 0, this.m_offset);
            this.m_out.flush();
            this.m_length += this.m_offset;
            this.m_offset = 0;
            this.propagateToParent();
        }
    }

    public void close() throws IOException {
        if (this.m_parent == null) {
            this.flush();
        } else {
            this.m_parent.m_buffer = this.m_buffer;
            this.propagateToParent();
        }
    }

    public String escape(String tag) throws CharConversionException {
        if (this.m_escape_mode == 0) {
            return tag;
        }
        int ioffset = 0;
        int length = tag.length();
        if (length * 5 > this.m_buffer.length) {
            this.m_buffer = new char[length * 5];
        }
        if (this.m_escape_mode == 2) {
            for (int i = 0; i < length; ++i) {
                char c = tag.charAt(i);
                if (c >= 'A' && c <= 'Z' || c >= 'a' && c <= 'z') {
                    this.m_buffer[ioffset++] = c;
                    continue;
                }
                if (i > 0 && (c >= '0' && c <= '9' || c == '_')) {
                    this.m_buffer[ioffset++] = c;
                    continue;
                }
                if (c == '/') {
                    this.m_buffer[ioffset++] = i == 0 ? 95 : 45;
                    continue;
                }
                throw new CharConversionException("Field name '" + tag + "' cannot be converted to an XML compliant element tag");
            }
        } else {
            for (int i = 0; i < length; ++i) {
                char c = tag.charAt(i);
                if (c >= 'A' && c <= 'Z' || c >= 'a' && c <= 'z' || c == '_') {
                    this.m_buffer[ioffset++] = c;
                    continue;
                }
                if (i > 0 && (c >= '0' && c <= '9' || c == '.')) {
                    this.m_buffer[ioffset++] = c;
                    continue;
                }
                if (c == '/') {
                    this.m_buffer[ioffset++] = 95;
                    this.m_buffer[ioffset++] = 45;
                    continue;
                }
                this.m_buffer[ioffset++] = 95;
                this.m_buffer[ioffset++] = 45;
                this.m_buffer[ioffset++] = 45;
                this.m_buffer[ioffset++] = hex[c >> 4 & 0xF];
                this.m_buffer[ioffset++] = hex[c >> 0 & 0xF];
            }
        }
        return new String(this.m_buffer, 0, ioffset);
    }

    public final XMLWriterBase content(byte[] value) throws IOException {
        if (value == null) {
            return this;
        }
        return this.content(value, 0, value.length);
    }

    public final XMLWriterBase content(byte[] value, int offset, int length) throws IOException {
        if (value == null) {
            return this;
        }
        char[] svalue = Codecs.Base64.encodeAsCharArray(value, offset, length);
        length = svalue.length;
        this.ensureBufferCapacity(length);
        System.arraycopy(svalue, 0, this.m_xmldoc, this.m_offset, length);
        this.m_offset += length;
        return this;
    }

    public final XMLWriterBase content(char[] value, int offset, int length) throws IOException {
        if (value == null) {
            return this;
        }
        if (length > 0) {
            while (length > 0 && value[offset + length - 1] == ' ') {
                --length;
            }
        }
        if (length <= 0) {
            return this;
        }
        int required_length = length;
        if (this.m_escape_mode == 0) {
            this.ensureBufferCapacity(required_length);
            System.arraycopy(value, offset, this.m_xmldoc, this.m_offset, length);
            this.m_offset += length;
        } else if (this.m_escape_mode == 1 || this.m_escape_mode == 3) {
            int i;
            int end = offset + length;
            required_length = length;
            block10: for (i = offset; i < end; ++i) {
                switch (value[i]) {
                    case '\u0000': 
                    case '\u0001': 
                    case '\u0002': 
                    case '\u0003': 
                    case '\u0004': 
                    case '\u0005': 
                    case '\u0006': 
                    case '\u0007': 
                    case '\b': 
                    case '\u000b': 
                    case '\f': 
                    case '\u000e': 
                    case '\u000f': 
                    case '\u0010': 
                    case '\u0011': 
                    case '\u0012': 
                    case '\u0013': 
                    case '\u0014': 
                    case '\u0015': 
                    case '\u0016': 
                    case '\u0017': 
                    case '\u0018': 
                    case '\u0019': 
                    case '\u001a': 
                    case '\u001b': 
                    case '\u001c': 
                    case '\u001d': 
                    case '\u001e': 
                    case '\u001f': 
                    case '&': 
                    case '<': 
                    case '>': {
                        required_length += 4;
                        continue block10;
                    }
                }
            }
            this.ensureBufferCapacity(required_length);
            if (required_length > length) {
                end = offset + length;
                block11: for (i = offset; i < end; ++i) {
                    switch (value[i]) {
                        case '\u0000': 
                        case '\u0001': 
                        case '\u0002': 
                        case '\u0003': 
                        case '\u0004': 
                        case '\u0005': 
                        case '\u0006': 
                        case '\u0007': 
                        case '\b': 
                        case '\u000b': 
                        case '\f': 
                        case '\u000e': 
                        case '\u000f': 
                        case '\u0010': 
                        case '\u0011': 
                        case '\u0012': 
                        case '\u0013': 
                        case '\u0014': 
                        case '\u0015': 
                        case '\u0016': 
                        case '\u0017': 
                        case '\u0018': 
                        case '\u0019': 
                        case '\u001a': 
                        case '\u001b': 
                        case '\u001c': 
                        case '\u001d': 
                        case '\u001e': 
                        case '\u001f': {
                            this.entity[2] = hex[value[i] / 10];
                            this.entity[3] = hex[value[i] % 10];
                            System.arraycopy(this.entity, 0, this.m_xmldoc, this.m_offset, this.entity.length);
                            this.m_offset += this.entity.length;
                            continue block11;
                        }
                        case '<': {
                            System.arraycopy(LESSTHAN, 0, this.m_xmldoc, this.m_offset, LESSTHAN.length);
                            this.m_offset += LESSTHAN.length;
                            continue block11;
                        }
                        case '>': {
                            System.arraycopy(GREATERTHAN, 0, this.m_xmldoc, this.m_offset, GREATERTHAN.length);
                            this.m_offset += GREATERTHAN.length;
                            continue block11;
                        }
                        case '&': {
                            System.arraycopy(AMPERSAND, 0, this.m_xmldoc, this.m_offset, AMPERSAND.length);
                            this.m_offset += AMPERSAND.length;
                            continue block11;
                        }
                        default: {
                            this.m_xmldoc[this.m_offset++] = value[i];
                        }
                    }
                }
            } else {
                System.arraycopy(value, offset, this.m_xmldoc, this.m_offset, length);
                this.m_offset += length;
            }
        } else {
            char c;
            int i;
            boolean must_escape = false;
            int end = offset + length;
            required_length = length;
            for (i = offset; i < end && !must_escape; ++i) {
                c = value[i];
                if (c != '<' && c != '>' && c != '&') continue;
                must_escape = true;
            }
            if (must_escape) {
                end = offset + length - 2;
                for (i = offset; i < end; ++i) {
                    if (value[i] != ']' || value[i + 1] != ']' || value[i + 2] != '>') continue;
                    required_length += GREATERTHAN.length;
                }
                this.ensureBufferCapacity(required_length + CDATASTART.length + CDATAEND.length);
                System.arraycopy(CDATASTART, 0, this.m_xmldoc, this.m_offset, CDATASTART.length);
                this.m_offset += CDATASTART.length;
                if (required_length > length) {
                    i = offset;
                    end = offset + length - 2;
                    while (i < end) {
                        c = value[i];
                        if (c == ']' && value[i + 1] == ']' && value[i + 2] == '>') {
                            this.m_xmldoc[this.m_offset++] = 93;
                            this.m_xmldoc[this.m_offset++] = 93;
                            System.arraycopy(GREATERTHAN, 0, this.m_xmldoc, this.m_offset, GREATERTHAN.length);
                            this.m_offset += GREATERTHAN.length;
                            i += 3;
                            continue;
                        }
                        this.m_xmldoc[this.m_offset++] = c;
                        ++i;
                    }
                    for (i = end; i < end + 2; ++i) {
                        this.m_xmldoc[this.m_offset++] = value[i];
                    }
                } else {
                    System.arraycopy(value, offset, this.m_xmldoc, this.m_offset, length);
                    this.m_offset += length;
                }
                System.arraycopy(CDATAEND, 0, this.m_xmldoc, this.m_offset, CDATAEND.length);
                this.m_offset += CDATAEND.length;
            } else {
                this.ensureBufferCapacity(required_length);
                System.arraycopy(value, offset, this.m_xmldoc, this.m_offset, length);
                this.m_offset += length;
            }
        }
        return this;
    }

    public final XMLWriterBase content(String value) throws IOException {
        if (value == null) {
            return this;
        }
        int length = value.length();
        if (length > this.m_buffer.length) {
            this.m_buffer = new char[length];
        }
        value.getChars(0, length, this.m_buffer, 0);
        return this.content(this.m_buffer, 0, length);
    }

    public final XMLWriterBase stag(String name) throws IOException {
        return name == null ? this : this.stag(name, null);
    }

    protected final XMLWriterBase stag(String name, String[] attributes) throws IOException {
        int length;
        if (name == null || (length = name.length()) == 0) {
            return this;
        }
        int required_length = length + 2;
        if (attributes == null || attributes.length == 0) {
            this.ensureBufferCapacity(required_length);
            this.m_xmldoc[this.m_offset++] = 60;
            name.getChars(0, length, this.m_xmldoc, this.m_offset);
            this.m_offset += length;
            this.m_xmldoc[this.m_offset++] = 62;
        } else {
            int i;
            for (i = 0; i < attributes.length; ++i) {
                required_length += attributes[i].length() + 1;
            }
            this.ensureBufferCapacity(required_length);
            this.m_xmldoc[this.m_offset++] = 60;
            name.getChars(0, length, this.m_xmldoc, this.m_offset);
            this.m_offset += length;
            for (i = 0; i < attributes.length; ++i) {
                length = attributes[i].length();
                this.m_xmldoc[this.m_offset++] = 32;
                attributes[i].getChars(0, length, this.m_xmldoc, this.m_offset);
                this.m_offset += length;
            }
            this.m_xmldoc[this.m_offset++] = 62;
        }
        return this;
    }

    public final XMLWriterBase etag(String name) throws IOException {
        int length;
        if (name == null || (length = name.length()) == 0) {
            return this;
        }
        int required_length = length + 3;
        this.ensureBufferCapacity(required_length);
        this.m_xmldoc[this.m_offset++] = 60;
        this.m_xmldoc[this.m_offset++] = 47;
        name.getChars(0, length, this.m_xmldoc, this.m_offset);
        this.m_offset += length;
        this.m_xmldoc[this.m_offset++] = 62;
        return this;
    }

    public final XMLWriterBase prolog() throws IOException {
        String prolog = "<?xml version=\"1.0\" encoding=\"" + this.m_encoding + "\"?>";
        int length = prolog.length();
        this.ensureBufferCapacity(length);
        prolog.getChars(0, length, this.m_xmldoc, this.m_offset);
        this.m_offset += length;
        return this;
    }
}

