/*
 * Decompiled with CFR 0.152.
 */
package org.zuinnote.hadoop.office.format.common;

import java.io.IOException;
import java.io.InputStream;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.zuinnote.hadoop.office.format.common.HadoopOfficeReadConfiguration;
import org.zuinnote.hadoop.office.format.common.parser.FormatNotUnderstoodException;
import org.zuinnote.hadoop.office.format.common.parser.OfficeReaderParserInterface;
import org.zuinnote.hadoop.office.format.common.parser.msexcel.MSExcelLowFootprintParser;
import org.zuinnote.hadoop.office.format.common.parser.msexcel.MSExcelParser;

public class OfficeReader {
    private static final Log LOG = LogFactory.getLog((String)OfficeReader.class.getName());
    private static final String FORMAT_EXCEL = "ms-excel";
    private HadoopOfficeReadConfiguration hocr;
    private InputStream in;
    private String[] sheetsArray = null;
    private OfficeReaderParserInterface currentParser = null;

    public OfficeReader(InputStream in, HadoopOfficeReadConfiguration hocr) {
        LOG.debug((Object)"Initializing OfficeReader");
        this.in = in;
        this.hocr = hocr;
        this.sheetsArray = hocr.getSheets() != null && !"".equals(hocr.getSheets()) ? hocr.getSheets().split(":") : null;
    }

    public void parse() throws FormatNotUnderstoodException {
        if (this.hocr.getMimeType().contains(FORMAT_EXCEL)) {
            if (!this.hocr.getLowFootprint()) {
                LOG.info((Object)"Using standard API to parse Excel file");
                this.currentParser = new MSExcelParser(this.hocr, this.sheetsArray);
            } else {
                LOG.info((Object)"Using low footprint API to parse Excel file");
                this.currentParser = new MSExcelLowFootprintParser(this.hocr, this.sheetsArray);
            }
        } else {
            throw new FormatNotUnderstoodException("Format not understood");
        }
        this.currentParser.parse(this.in);
    }

    public boolean getFiltered() {
        if (this.currentParser != null) {
            return this.currentParser.getFiltered();
        }
        return false;
    }

    public OfficeReaderParserInterface getCurrentParser() {
        return this.currentParser;
    }

    public Object[] getNext() {
        if (this.currentParser == null) {
            return null;
        }
        return this.currentParser.getNext();
    }

    public long getCurrentRow() {
        if (this.currentParser == null) {
            return 0L;
        }
        return this.currentParser.getCurrentRow();
    }

    public String getCurrentSheetName() {
        if (this.currentParser == null) {
            return null;
        }
        return this.currentParser.getCurrentSheetName();
    }

    public void close() throws IOException {
        if (this.in != null) {
            this.in.close();
        }
    }
}

