/*
 * Decompiled with CFR 0.152.
 */
package org.zuinnote.hadoop.office.format.common;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.zuinnote.hadoop.office.format.common.HadoopOfficeWriteConfiguration;
import org.zuinnote.hadoop.office.format.common.writer.InvalidWriterConfigurationException;
import org.zuinnote.hadoop.office.format.common.writer.OfficeSpreadSheetWriterInterface;
import org.zuinnote.hadoop.office.format.common.writer.OfficeWriterException;
import org.zuinnote.hadoop.office.format.common.writer.msexcel.MSExcelLowFootprintWriter;
import org.zuinnote.hadoop.office.format.common.writer.msexcel.MSExcelWriter;

public class OfficeWriter {
    private static final String EX_NO_WRITER_INSTANTIATED = "No writer instantiated";
    private static final Log LOG = LogFactory.getLog((String)OfficeWriter.class.getName());
    private OfficeSpreadSheetWriterInterface currentOfficeSpreadSheetWriter = null;
    private HadoopOfficeWriteConfiguration howc;
    private OutputStream oStream;

    public OfficeWriter(HadoopOfficeWriteConfiguration howc) throws InvalidWriterConfigurationException {
        LOG.debug((Object)"Initialize OfficeWriter");
        this.howc = howc;
        String writerFormat = OfficeWriter.getInternalWriterFormatFromMimeType(this.howc.getMimeType());
        if (MSExcelWriter.isSupportedFormat(writerFormat)) {
            if (!this.howc.getLowFootprint()) {
                this.currentOfficeSpreadSheetWriter = new MSExcelWriter(writerFormat, this.howc);
            } else if ("oldexcel".equals(writerFormat)) {
                LOG.warn((Object)"Low footprint mode is only supported for new Excel format .xlsx. Continuing with standard writing mode");
                this.currentOfficeSpreadSheetWriter = new MSExcelWriter(writerFormat, this.howc);
            } else {
                LOG.info((Object)"Storing new Excel file ,xlsx in low footprint mode");
                this.currentOfficeSpreadSheetWriter = new MSExcelLowFootprintWriter(writerFormat, this.howc);
            }
        } else {
            throw new InvalidWriterConfigurationException("Error: Writer does not recognize format +\"" + writerFormat + "\"");
        }
    }

    public void create(OutputStream oStream, Map<String, InputStream> linkedWorkbooks, Map<String, String> linkedWorkbooksPasswords, InputStream template) throws OfficeWriterException {
        this.oStream = oStream;
        if (this.currentOfficeSpreadSheetWriter == null) {
            throw new OfficeWriterException(EX_NO_WRITER_INSTANTIATED);
        }
        this.currentOfficeSpreadSheetWriter.create(oStream, linkedWorkbooks, linkedWorkbooksPasswords, template);
    }

    public void write(Object o) throws OfficeWriterException {
        if (this.currentOfficeSpreadSheetWriter == null) {
            throw new OfficeWriterException(EX_NO_WRITER_INSTANTIATED);
        }
        this.currentOfficeSpreadSheetWriter.write(o);
    }

    public void close() throws IOException {
        if (this.currentOfficeSpreadSheetWriter != null) {
            this.currentOfficeSpreadSheetWriter.close();
        } else {
            LOG.error((Object)EX_NO_WRITER_INSTANTIATED);
        }
    }

    private static String getInternalWriterFormatFromMimeType(String mimeType) throws InvalidWriterConfigurationException {
        if (mimeType == null) {
            throw new InvalidWriterConfigurationException("Please specify a mimetype for writing");
        }
        if (mimeType.contains("ms-excel")) {
            return "oldexcel";
        }
        if (mimeType.contains("openxmlformats-officedocument.spreadsheetml")) {
            return "ooxmlexcel";
        }
        throw new InvalidWriterConfigurationException("Format \"" + mimeType + "\" not recognized");
    }
}

