/*
 * Decompiled with CFR 0.152.
 */
package org.zuinnote.hadoop.office.format.common.util;

import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PublicKey;
import java.security.SignatureException;
import java.security.cert.CertPathBuilder;
import java.security.cert.CertPathBuilderException;
import java.security.cert.CertSelector;
import java.security.cert.CertStore;
import java.security.cert.CertStoreParameters;
import java.security.cert.CertificateException;
import java.security.cert.CollectionCertStoreParameters;
import java.security.cert.PKIXBuilderParameters;
import java.security.cert.PKIXCertPathBuilderResult;
import java.security.cert.TrustAnchor;
import java.security.cert.X509CertSelector;
import java.security.cert.X509Certificate;
import java.util.HashSet;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class CertificateChainVerificationUtil {
    private static final Log LOG = LogFactory.getLog((String)CertificateChainVerificationUtil.class.getName());

    public static boolean verifyCertificateChain(X509Certificate theCertificate, Set<X509Certificate> chainCertificates) throws CertificateException, NoSuchAlgorithmException, NoSuchProviderException, InvalidAlgorithmParameterException {
        if (CertificateChainVerificationUtil.isSelfSigned(theCertificate)) {
            LOG.error((Object)"Certificate is self-signed - no trust chain can be established with provided truststore");
            return false;
        }
        if (chainCertificates.size() < 2) {
            LOG.error((Object)"One needs at least three certificates (including certificate used for signing to establish a trust chain. Please check that you included them");
            return false;
        }
        HashSet<X509Certificate> rootCertificates = new HashSet<X509Certificate>();
        HashSet<X509Certificate> subCertificates = new HashSet<X509Certificate>();
        subCertificates.add(theCertificate);
        for (X509Certificate currentCertificate : chainCertificates) {
            if (CertificateChainVerificationUtil.isSelfSigned(currentCertificate)) {
                LOG.debug((Object)("Root: " + currentCertificate.getSubjectDN().getName()));
                rootCertificates.add(currentCertificate);
                continue;
            }
            LOG.debug((Object)("Sub: " + currentCertificate.getSubjectDN().getName()));
            subCertificates.add(currentCertificate);
        }
        X509CertSelector selector = new X509CertSelector();
        selector.setCertificate(theCertificate);
        CertPathBuilder builder = CertPathBuilder.getInstance("PKIX", "BC");
        HashSet<TrustAnchor> trustAnchors = new HashSet<TrustAnchor>();
        for (X509Certificate currentCertificate : rootCertificates) {
            trustAnchors.add(new TrustAnchor(currentCertificate, null));
        }
        PKIXBuilderParameters builderParams = new PKIXBuilderParameters(trustAnchors, (CertSelector)selector);
        CertStore subCertStore = CertStore.getInstance("Collection", (CertStoreParameters)new CollectionCertStoreParameters(subCertificates), "BC");
        builderParams.addCertStore(subCertStore);
        try {
            PKIXCertPathBuilderResult result = (PKIXCertPathBuilderResult)builder.build(builderParams);
            return true;
        }
        catch (CertPathBuilderException e) {
            LOG.error((Object)"Exception: ", (Throwable)e);
            LOG.error((Object)("Cannot verify certification chain for " + theCertificate.getSubjectX500Principal()));
            return false;
        }
    }

    private static boolean isSelfSigned(X509Certificate certificate) throws CertificateException, NoSuchAlgorithmException, NoSuchProviderException {
        try {
            PublicKey pubKey = certificate.getPublicKey();
            certificate.verify(pubKey);
            return true;
        }
        catch (InvalidKeyException | SignatureException e) {
            return false;
        }
    }
}

