/*
 * Decompiled with CFR 0.152.
 */
package org.zuinnote.hadoop.office.format.common.parser.msexcel;

import java.io.IOException;
import java.io.InputStream;
import java.security.GeneralSecurityException;
import java.security.InvalidAlgorithmParameterException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.stream.XMLStreamException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.poi.EmptyFileException;
import org.apache.poi.EncryptedDocumentException;
import org.apache.poi.hssf.eventusermodel.EventWorkbookBuilder;
import org.apache.poi.hssf.eventusermodel.HSSFEventFactory;
import org.apache.poi.hssf.eventusermodel.HSSFRequest;
import org.apache.poi.hssf.eventusermodel.MissingRecordAwareHSSFListener;
import org.apache.poi.hssf.record.crypto.Biff8EncryptionKey;
import org.apache.poi.ooxml.util.SAXHelper;
import org.apache.poi.openxml4j.exceptions.InvalidFormatException;
import org.apache.poi.openxml4j.exceptions.OpenXML4JException;
import org.apache.poi.openxml4j.opc.OPCPackage;
import org.apache.poi.openxml4j.opc.PackagePart;
import org.apache.poi.poifs.crypt.ChainingMode;
import org.apache.poi.poifs.crypt.CipherAlgorithm;
import org.apache.poi.poifs.crypt.Decryptor;
import org.apache.poi.poifs.crypt.EncryptionInfo;
import org.apache.poi.poifs.crypt.dsig.SignatureConfig;
import org.apache.poi.poifs.crypt.dsig.SignatureInfo;
import org.apache.poi.poifs.crypt.dsig.SignaturePart;
import org.apache.poi.poifs.filesystem.DocumentInputStream;
import org.apache.poi.poifs.filesystem.FileMagic;
import org.apache.poi.poifs.filesystem.POIFSFileSystem;
import org.apache.poi.ss.usermodel.DataFormatter;
import org.apache.poi.xssf.eventusermodel.ReadOnlySharedStringsTable;
import org.apache.poi.xssf.eventusermodel.XSSFReader;
import org.apache.poi.xssf.eventusermodel.XSSFSheetXMLHandler;
import org.apache.poi.xssf.model.StylesTable;
import org.apache.poi.xssf.usermodel.XSSFRelation;
import org.apache.xmlbeans.XmlException;
import org.openxmlformats.schemas.spreadsheetml.x2006.main.WorkbookDocument;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.zuinnote.hadoop.office.format.common.HadoopOfficeReadConfiguration;
import org.zuinnote.hadoop.office.format.common.dao.SpreadSheetCellDAO;
import org.zuinnote.hadoop.office.format.common.parser.FormatNotUnderstoodException;
import org.zuinnote.hadoop.office.format.common.parser.OfficeReaderParserInterface;
import org.zuinnote.hadoop.office.format.common.parser.msexcel.MSExcelParser;
import org.zuinnote.hadoop.office.format.common.parser.msexcel.internal.EncryptedCachedDiskStringsTable;
import org.zuinnote.hadoop.office.format.common.parser.msexcel.internal.HSSFEventParser;
import org.zuinnote.hadoop.office.format.common.parser.msexcel.internal.XSSFEventParser;
import org.zuinnote.hadoop.office.format.common.parser.msexcel.internal.XSSFPullParser;
import org.zuinnote.hadoop.office.format.common.util.CertificateChainVerificationUtil;

public class MSExcelLowFootprintParser
implements OfficeReaderParserInterface {
    public static final int FORMAT_UNSUPPORTED = -1;
    public static final int FORMAT_OLDEXCEL = 0;
    public static final int FORMAT_OOXML = 1;
    private DataFormatter useDataFormatter = null;
    private static final Log LOG = LogFactory.getLog((String)MSExcelLowFootprintParser.class.getName());
    private Map<Integer, List<SpreadSheetCellDAO[]>> spreadSheetCellDAOCache;
    private List<String> sheetNameList;
    private InputStream in;
    private String[] sheets = null;
    private HadoopOfficeReadConfiguration hocr;
    private int currentSheet;
    private int currentRow;
    private String[] header;
    private int currentSkipLine = 0;
    private boolean firstSheetSkipped = false;
    private boolean event = true;
    private List<InputStream> pullSheetInputList;
    private List<String> pullSheetNameList;
    private XSSFPullParser currentPullParser;
    private EncryptedCachedDiskStringsTable pullSST;
    private ReadOnlySharedStringsTable pushSST;
    private CipherAlgorithm ca;
    private ChainingMode cm;
    private StylesTable styles;
    private boolean isDate1904;
    private boolean headerParsed;

    public MSExcelLowFootprintParser(HadoopOfficeReadConfiguration hocr) {
        this(hocr, null);
    }

    public MSExcelLowFootprintParser(HadoopOfficeReadConfiguration hocr, String[] sheets) {
        this.sheets = sheets;
        this.hocr = hocr;
        this.useDataFormatter = hocr.getLocale() == null ? (!this.hocr.getEmulateCSV() ? new DataFormatter() : new DataFormatter(true)) : (!this.hocr.getEmulateCSV() ? new DataFormatter(hocr.getLocale()) : new DataFormatter(hocr.getLocale(), true));
        this.spreadSheetCellDAOCache = new HashMap<Integer, List<SpreadSheetCellDAO[]>>();
        this.sheetNameList = new ArrayList<String>();
        this.currentRow = 0;
        this.currentSheet = 0;
        this.pullSheetInputList = new ArrayList<InputStream>();
        this.pullSheetNameList = new ArrayList<String>();
        this.headerParsed = false;
        if (this.hocr.getReadLinkedWorkbooks() || this.hocr.getIgnoreMissingLinkedWorkbooks()) {
            LOG.warn((Object)"Linked workbooks not supported in low footprint parsing mode");
        }
        if (this.hocr.getMetaDataFilter() != null && this.hocr.getMetaDataFilter().size() > 0) {
            LOG.warn((Object)"Metadata filtering is not supported in low footprint parsing mode");
        }
    }

    @Override
    public void parse(InputStream in) throws FormatNotUnderstoodException {
        block29: {
            this.currentRow = 0;
            try {
                InputStream nin = FileMagic.prepareToCheckMagic(in);
                FileMagic fm = FileMagic.valueOf(nin);
                if (fm == FileMagic.OLE2) {
                    LOG.debug((Object)"Paersing OLE2 container");
                    POIFSFileSystem poifs = new POIFSFileSystem(nin);
                    if (poifs.getRoot().hasEntry("EncryptedPackage")) {
                        LOG.info((Object)"Low footprint parsing of new Excel files (.xlsx) - encrypted file");
                        EncryptionInfo info = new EncryptionInfo(poifs);
                        Decryptor d = Decryptor.getInstance(info);
                        this.ca = d.getEncryptionInfo().getHeader().getCipherAlgorithm();
                        this.cm = d.getEncryptionInfo().getHeader().getChainingMode();
                        try {
                            if (!d.verifyPassword(this.hocr.getPassword())) {
                                throw new FormatNotUnderstoodException("Error: Cannot decrypt new Excel file (.xlsx) in low footprint mode: wrong password");
                            }
                            in = d.getDataStream(poifs);
                        }
                        catch (GeneralSecurityException e) {
                            LOG.error((Object)e);
                            throw new FormatNotUnderstoodException("Error: Cannot decrypt new Excel file (.xlsx) in low footprint mode");
                        }
                        try {
                            OPCPackage pkg = OPCPackage.open(in);
                            this.processOPCPackage(pkg);
                        }
                        catch (InvalidFormatException e) {
                            LOG.error((Object)e);
                            throw new FormatNotUnderstoodException("Error: Cannot read new Excel file (.xlsx) in low footprint mode");
                        }
                        return;
                    }
                    LOG.info((Object)"Low footprint parsing of old Excel files (.xls)");
                    this.event = true;
                    if (this.hocr.getPassword() != null) {
                        Biff8EncryptionKey.setCurrentUserPassword(this.hocr.getPassword());
                    }
                    DocumentInputStream din = poifs.createDocumentInputStream("Workbook");
                    try {
                        HSSFRequest req = new HSSFRequest();
                        HSSFEventParser parser = new HSSFEventParser(this.sheetNameList, this.useDataFormatter, this.spreadSheetCellDAOCache, this.sheets);
                        EventWorkbookBuilder.SheetRecordCollectingListener listener = new EventWorkbookBuilder.SheetRecordCollectingListener(new MissingRecordAwareHSSFListener(parser));
                        parser.setSheetRecordCollectingListener(listener);
                        req.addListenerForAllRecords(listener);
                        HSSFEventFactory factory = new HSSFEventFactory();
                        factory.processEvents(req, din);
                        break block29;
                    }
                    catch (EncryptedDocumentException e) {
                        LOG.error((Object)e);
                        throw new FormatNotUnderstoodException("Cannot decrypt document");
                    }
                    finally {
                        Biff8EncryptionKey.setCurrentUserPassword(null);
                        ((InputStream)din).close();
                        poifs.close();
                    }
                }
                if (fm == FileMagic.OOXML) {
                    LOG.info((Object)"Low footprint parsing of new Excel files (.xlsx) - not encrypted file");
                    try {
                        OPCPackage pkg = OPCPackage.open(nin);
                        this.processOPCPackage(pkg);
                        break block29;
                    }
                    catch (InvalidFormatException e) {
                        LOG.error((Object)e);
                        throw new FormatNotUnderstoodException("Error cannot read new Excel file (.xlsx)");
                    }
                }
                throw new FormatNotUnderstoodException("Could not detect Excel format in low footprint reading mode");
            }
            catch (IOException | EmptyFileException e) {
                LOG.error((Object)e);
                throw new FormatNotUnderstoodException("Could not detect format in Low footprint reading mode");
            }
            finally {
                if (this.in != null) {
                    try {
                        this.in.close();
                    }
                    catch (IOException e) {
                        LOG.error((Object)e);
                        throw new FormatNotUnderstoodException("Error closing inputstream");
                    }
                }
            }
        }
    }

    private void processOPCPackage(OPCPackage pkg) throws FormatNotUnderstoodException {
        XSSFReader r;
        LOG.debug((Object)"Processing OPCPackage in low footprint mode");
        if (this.hocr.getVerifySignature()) {
            LOG.info((Object)"Verifying signature of document");
            SignatureConfig sic = new SignatureConfig();
            sic.setOpcPackage(pkg);
            SignatureInfo si = new SignatureInfo();
            si.setSignatureConfig(sic);
            if (!si.verifySignature()) {
                throw new FormatNotUnderstoodException("Cannot verify signature of OOXML (.xlsx) file: " + this.hocr.getFileName());
            }
            LOG.info((Object)("Successfully verifed first part signature of OXXML (.xlsx) file: " + this.hocr.getFileName()));
            for (SignaturePart currentSP : si.getSignatureParts()) {
                if (!currentSP.validate()) {
                    throw new FormatNotUnderstoodException("Could not validate all signature parts for file: " + this.hocr.getFileName());
                }
                X509Certificate currentCertificate = currentSP.getSigner();
                try {
                    if (this.hocr.getX509CertificateChain().size() <= 0 || CertificateChainVerificationUtil.verifyCertificateChain(currentCertificate, this.hocr.getX509CertificateChain())) continue;
                    throw new FormatNotUnderstoodException("Could not validate signature part for principal \"" + currentCertificate.getSubjectX500Principal().getName() + "\" : " + this.hocr.getFileName());
                }
                catch (InvalidAlgorithmParameterException | NoSuchAlgorithmException | NoSuchProviderException | CertificateException e) {
                    LOG.error((Object)("Could not validate signature part for principal \"" + currentCertificate.getSubjectX500Principal().getName() + "\" : " + this.hocr.getFileName()), (Throwable)e);
                    throw new FormatNotUnderstoodException("Could not validate signature part for principal \"" + currentCertificate.getSubjectX500Principal().getName() + "\" : " + this.hocr.getFileName());
                }
            }
            LOG.info((Object)("Successfully verifed all signatures of OXXML (.xlsx) file: " + this.hocr.getFileName()));
        }
        try {
            r = new XSSFReader(pkg);
        }
        catch (IOException | OpenXML4JException e) {
            LOG.error((Object)e);
            throw new FormatNotUnderstoodException("Error cannot parse new Excel file (.xlsx)");
        }
        try {
            ArrayList<PackagePart> pkgParts;
            InputStream workbookDataXML = r.getWorkbookData();
            WorkbookDocument wd = WorkbookDocument.Factory.parse(workbookDataXML);
            this.isDate1904 = wd.getWorkbook().getWorkbookPr().getDate1904();
            if ("sax".equalsIgnoreCase(this.hocr.getLowFootprintParser())) {
                this.pushSST = new ReadOnlySharedStringsTable(pkg);
            } else if ("stax".equalsIgnoreCase(this.hocr.getLowFootprintParser()) && (pkgParts = pkg.getPartsByContentType(XSSFRelation.SHARED_STRINGS.getContentType())).size() > 0) {
                this.pullSST = new EncryptedCachedDiskStringsTable((PackagePart)pkgParts.get(0), this.hocr.getSstCacheSize(), this.hocr.getCompressSST(), this.ca, this.cm);
            }
            this.styles = r.getStylesTable();
            XSSFReader.SheetIterator iter = (XSSFReader.SheetIterator)r.getSheetsData();
            int sheetNumber = 0;
            while (iter.hasNext()) {
                boolean parse = false;
                if (this.sheets != null) {
                    for (int i = 0; i < this.sheets.length; ++i) {
                        if (!iter.getSheetName().equals(this.sheets[i])) continue;
                        parse = true;
                        break;
                    }
                } else {
                    parse = true;
                }
                if (!parse) continue;
                InputStream rawSheetInputStream = iter.next();
                this.sheetNameList.add(iter.getSheetName());
                InputSource rawSheetInputSource = new InputSource(rawSheetInputStream);
                if ("sax".equalsIgnoreCase(this.hocr.getLowFootprintParser())) {
                    this.event = true;
                    LOG.info((Object)"Using SAX parser for low footprint Excel parsing");
                    XMLReader sheetParser = SAXHelper.newXMLReader();
                    XSSFEventParser xssfp = new XSSFEventParser(sheetNumber, iter.getSheetName(), this.spreadSheetCellDAOCache);
                    XSSFSheetXMLHandler handler = new XSSFSheetXMLHandler(this.styles, iter.getSheetComments(), this.pushSST, xssfp, this.useDataFormatter, false);
                    sheetParser.setContentHandler(handler);
                    sheetParser.parse(rawSheetInputSource);
                    ++sheetNumber;
                    continue;
                }
                if ("stax".equalsIgnoreCase(this.hocr.getLowFootprintParser())) {
                    LOG.info((Object)"Using STAX parser for low footprint Excel parsing");
                    this.event = false;
                    this.pullSheetInputList.add(rawSheetInputStream);
                    this.pullSheetNameList.add(iter.getSheetName());
                    continue;
                }
                LOG.error((Object)("Unknown XML parser configured for low footprint mode: \"" + this.hocr.getLowFootprintParser() + "\""));
                throw new FormatNotUnderstoodException("Unknown XML parser configured for low footprint mode: \"" + this.hocr.getLowFootprintParser() + "\"");
            }
        }
        catch (IOException | InvalidFormatException e) {
            LOG.error((Object)e);
            throw new FormatNotUnderstoodException("Error cannot parse new Excel file (.xlsx)");
        }
        catch (SAXException e) {
            LOG.error((Object)e);
            throw new FormatNotUnderstoodException("Parsing Excel sheet in .xlsx format failed. Cannot read XML content");
        }
        catch (ParserConfigurationException e) {
            LOG.error((Object)e);
            throw new FormatNotUnderstoodException("Parsing Excel sheet in .xlsx format failed. Cannot read XML content");
        }
        catch (XmlException e) {
            LOG.error((Object)e);
            throw new FormatNotUnderstoodException("Parsing Excel sheet in .xlsx format failed. Cannot read XML content");
        }
        for (int i = 0; i < this.hocr.getSkipLines(); ++i) {
            this.getNext();
        }
        if (this.hocr.getReadHeader()) {
            LOG.debug((Object)"Reading header...");
            Object[] firstRow = this.getNext();
            if (firstRow != null) {
                this.header = new String[firstRow.length];
                for (int i = 0; i < firstRow.length; ++i) {
                    if (firstRow[i] == null || "".equals(((SpreadSheetCellDAO)firstRow[i]).getFormattedValue())) continue;
                    this.header[i] = ((SpreadSheetCellDAO)firstRow[i]).getFormattedValue();
                }
                this.header = MSExcelParser.sanitizeHeaders(this.header, this.hocr.getColumnNameRegex(), this.hocr.getColumnNameReplace());
            } else {
                this.header = new String[0];
            }
        }
        this.headerParsed = true;
    }

    @Override
    public long getCurrentRow() {
        if (this.currentRow == 0) {
            return 1L;
        }
        return this.currentRow;
    }

    @Override
    public String getCurrentSheetName() {
        if (this.currentSheet >= this.sheetNameList.size()) {
            return this.sheetNameList.get(this.sheetNameList.size() - 1);
        }
        return this.sheetNameList.get(this.currentSheet);
    }

    @Override
    public boolean addLinkedWorkbook(String name, InputStream inputStream, String password) throws FormatNotUnderstoodException {
        throw new FormatNotUnderstoodException("Workbooks are not supported in low footprint mode");
    }

    @Override
    public List<String> getLinkedWorkbooks() {
        return new ArrayList<String>();
    }

    @Override
    public Object[] getNext() {
        Object[] result = null;
        if (this.event) {
            result = this.getNextEvent();
        } else {
            LOG.info((Object)"Using STAX parser for low footprint Excel parsing");
            try {
                result = this.getNextPull();
            }
            catch (XMLStreamException | FormatNotUnderstoodException e) {
                LOG.error((Object)e);
            }
        }
        return result;
    }

    private Object[] getNextPull() throws XMLStreamException, FormatNotUnderstoodException {
        Object[] result = null;
        if (this.currentPullParser == null || !this.currentPullParser.hasNext()) {
            if (this.pullSheetInputList.size() > 0) {
                try {
                    this.currentPullParser = new XSSFPullParser(this.pullSheetNameList.get(0), this.pullSheetInputList.get(0), this.pullSST, this.styles, this.useDataFormatter, this.isDate1904);
                    this.pullSheetNameList.remove(0);
                    this.pullSheetInputList.remove(0);
                    if (this.hocr.getSkipLinesAllSheets() && this.headerParsed) {
                        for (int i = 0; i < this.hocr.getSkipLines(); ++i) {
                            if (this.currentPullParser.hasNext()) {
                                this.currentPullParser.getNext();
                            }
                            ++this.currentRow;
                        }
                    }
                    if (this.hocr.getIgnoreHeaderInAllSheets() && this.headerParsed) {
                        if (this.currentPullParser.hasNext()) {
                            this.currentPullParser.getNext();
                        }
                        ++this.currentRow;
                    }
                }
                catch (XMLStreamException e) {
                    LOG.error((Object)e);
                }
            } else {
                return result;
            }
        }
        result = this.currentPullParser.getNext();
        return result;
    }

    private Object[] getNextEvent() {
        Object[] result = null;
        if (this.spreadSheetCellDAOCache.size() == 0) {
            return result;
        }
        if (this.spreadSheetCellDAOCache.get(this.currentSheet).size() > 0) {
            result = this.spreadSheetCellDAOCache.get(this.currentSheet).remove(0);
            ++this.currentRow;
        }
        while (this.spreadSheetCellDAOCache.get(this.currentSheet).size() <= 0) {
            this.spreadSheetCellDAOCache.remove(this.currentSheet);
            if (this.spreadSheetCellDAOCache.size() == 0) {
                return result;
            }
            ++this.currentSheet;
            this.currentRow = 0;
            if (this.hocr.getSkipLinesAllSheets()) {
                for (int i = 0; i < this.hocr.getSkipLines(); ++i) {
                    if (this.spreadSheetCellDAOCache.get(this.currentSheet).size() > 0) {
                        this.spreadSheetCellDAOCache.get(this.currentSheet).remove(0);
                    }
                    ++this.currentRow;
                }
            }
            if (!this.hocr.getIgnoreHeaderInAllSheets()) continue;
            if (this.spreadSheetCellDAOCache.get(this.currentSheet).size() > 0) {
                this.spreadSheetCellDAOCache.get(this.currentSheet).remove(0);
            }
            ++this.currentRow;
        }
        return result;
    }

    @Override
    public boolean getFiltered() {
        return true;
    }

    @Override
    public void close() throws IOException {
        if (this.in != null) {
            this.in.close();
        }
        if (this.pullSST != null) {
            this.pullSST.close();
        }
    }

    @Override
    public void setCurrentRow(long row) {
        this.currentRow = (int)row;
    }

    @Override
    public void setCurrentSheet(long sheet) {
        this.currentSheet = (int)sheet;
    }

    @Override
    public long getCurrentSheet() {
        return this.currentSheet;
    }

    @Override
    public String[] getHeader() {
        return this.header;
    }
}

