/*
 * Decompiled with CFR 0.152.
 */
package org.zuinnote.hadoop.office.format.mapred;

import java.io.IOException;
import java.security.GeneralSecurityException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.io.ArrayWritable;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.mapred.FileSplit;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.Reporter;
import org.zuinnote.hadoop.office.format.common.dao.SpreadSheetCellDAO;
import org.zuinnote.hadoop.office.format.common.parser.FormatNotUnderstoodException;
import org.zuinnote.hadoop.office.format.mapred.AbstractSpreadSheetDocumentRecordReader;

public class ExcelRecordReader
extends AbstractSpreadSheetDocumentRecordReader<Text, ArrayWritable> {
    private static final Log LOG = LogFactory.getLog((String)ExcelRecordReader.class.getName());
    private FileSplit split;

    public ExcelRecordReader(FileSplit split, JobConf job, Reporter reporter) throws IOException, FormatNotUnderstoodException, GeneralSecurityException {
        super(split, job, reporter);
        LOG.debug((Object)"Initialize ExcelRecordReader");
        this.split = split;
    }

    public Text createKey() {
        return new Text("");
    }

    public ArrayWritable createValue() {
        ArrayWritable newArrayWritable = new ArrayWritable(SpreadSheetCellDAO.class);
        newArrayWritable.set((Writable[])new SpreadSheetCellDAO[0]);
        return newArrayWritable;
    }

    public boolean next(Text key, ArrayWritable value) throws IOException {
        if (!this.getOfficeReader().getFiltered()) {
            return false;
        }
        Object[] objectArray = this.getOfficeReader().getNext();
        if (objectArray == null) {
            return false;
        }
        Writable[] cellRows = (SpreadSheetCellDAO[])objectArray;
        key.set("[" + this.split.getPath().getName() + "]" + this.getOfficeReader().getCurrentSheetName() + "!A" + this.getOfficeReader().getCurrentRow());
        value.set(cellRows);
        return true;
    }
}

