/*
 * Decompiled with CFR 0.152.
 */
package org.zuinnote.hadoop.office.format.mapred;

import java.io.IOException;
import java.io.Serializable;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.ArrayWritable;
import org.apache.hadoop.io.NullWritable;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.RecordWriter;
import org.apache.hadoop.util.Progressable;
import org.zuinnote.hadoop.office.format.common.HadoopUtil;
import org.zuinnote.hadoop.office.format.common.writer.InvalidWriterConfigurationException;
import org.zuinnote.hadoop.office.format.common.writer.OfficeWriterException;
import org.zuinnote.hadoop.office.format.mapred.AbstractSpreadSheetDocumentFileOutputFormat;
import org.zuinnote.hadoop.office.format.mapred.ExcelFileOutputFormat;
import org.zuinnote.hadoop.office.format.mapred.ExcelRowRecordWriter;

public class ExcelRowFileOutputFormat
extends AbstractSpreadSheetDocumentFileOutputFormat<ArrayWritable>
implements Serializable {
    private static final long serialVersionUID = -1241428157127154160L;
    private static final Log LOG = LogFactory.getLog((String)ExcelRowFileOutputFormat.class.getName());

    @Override
    public RecordWriter<NullWritable, ArrayWritable> getRecordWriter(FileSystem ignored, JobConf conf, String name, Progressable progress) throws IOException {
        Path file;
        String defaultConf = conf.get("hadoopoffice.write.mimeType", "application/vnd.openxmlformats-officedocument.spreadsheetml.sheet");
        conf.set("hadoopoffice.write.mimeType", defaultConf);
        if (name != null) {
            file = ExcelRowFileOutputFormat.getTaskOutputPath((JobConf)conf, (String)name);
            file = file.suffix(ExcelFileOutputFormat.getSuffix(conf.get("hadoopoffice.write.mimeType")));
        } else {
            file = ExcelRowFileOutputFormat.getOutputPath((JobConf)conf);
        }
        try {
            return new ExcelRowRecordWriter<NullWritable, ArrayWritable>(HadoopUtil.getDataOutputStream((Configuration)conf, file, progress, ExcelRowFileOutputFormat.getCompressOutput((JobConf)conf), ExcelRowFileOutputFormat.getOutputCompressorClass((JobConf)conf, (Class)ExcelFileOutputFormat.defaultCompressorClass)), file.getName(), (Configuration)conf);
        }
        catch (InvalidWriterConfigurationException | OfficeWriterException e) {
            LOG.error((Object)e);
            return null;
        }
    }
}

