/*
 * Decompiled with CFR 0.152.
 */
package org.zuinnote.hadoop.office.format.mapreduce;

import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.GeneralSecurityException;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.UnrecoverableEntryException;
import java.security.UnrecoverableKeyException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.security.spec.InvalidKeySpecException;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.ArrayWritable;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.mapreduce.RecordWriter;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.zuinnote.hadoop.office.format.common.HadoopFileReader;
import org.zuinnote.hadoop.office.format.common.HadoopKeyStoreManager;
import org.zuinnote.hadoop.office.format.common.HadoopOfficeWriteConfiguration;
import org.zuinnote.hadoop.office.format.common.OfficeWriter;
import org.zuinnote.hadoop.office.format.common.parser.FormatNotUnderstoodException;
import org.zuinnote.hadoop.office.format.common.writer.InvalidCellSpecificationException;
import org.zuinnote.hadoop.office.format.common.writer.InvalidWriterConfigurationException;
import org.zuinnote.hadoop.office.format.common.writer.OfficeWriterException;

public abstract class AbstractSpreadSheetDocumentRecordWriter<NullWritable, K>
extends RecordWriter<NullWritable, K> {
    public static final Log LOG = LogFactory.getLog((String)AbstractSpreadSheetDocumentRecordWriter.class.getName());
    private OfficeWriter officeWriter;
    private Map<String, InputStream> linkedWorkbooksMap;
    private HadoopOfficeWriteConfiguration howc;
    private HadoopFileReader currentReader;
    private DataOutputStream out;

    public AbstractSpreadSheetDocumentRecordWriter() {
    }

    public AbstractSpreadSheetDocumentRecordWriter(DataOutputStream out, String fileName, Configuration conf) throws IOException, InvalidWriterConfigurationException, InvalidCellSpecificationException, FormatNotUnderstoodException, GeneralSecurityException, OfficeWriterException {
        this.out = out;
        this.howc = new HadoopOfficeWriteConfiguration(conf, fileName);
        this.readKeyStore(conf);
        this.readSigningKeyAndCertificate(conf);
        this.currentReader = new HadoopFileReader(conf);
        this.linkedWorkbooksMap = this.currentReader.loadLinkedWorkbooks(this.howc.getLinkedWorkbooksName());
        this.officeWriter = new OfficeWriter(this.howc);
        InputStream templateInputStream = null;
        if (this.howc.getTemplate() != null && !"".equals(this.howc.getTemplate())) {
            templateInputStream = this.currentReader.loadTemplate(this.howc.getTemplate());
        }
        this.officeWriter.create(out, this.linkedWorkbooksMap, this.howc.getLinkedWBCredentialMap(), templateInputStream);
    }

    private void readKeyStore(Configuration conf) throws IOException, OfficeWriterException {
        if (this.howc.getCryptKeystoreFile() != null && !"".equals(this.howc.getCryptKeystoreFile())) {
            LOG.info((Object)"Using keystore to obtain credentials instead of passwords");
            HadoopKeyStoreManager hksm = new HadoopKeyStoreManager(conf);
            try {
                hksm.openKeyStore(new Path(this.howc.getCryptKeystoreFile()), this.howc.getCryptKeystoreType(), this.howc.getCryptKeystorePassword());
                String password = "";
                password = this.howc.getCryptKeystoreAlias() != null && !"".equals(this.howc.getCryptKeystoreAlias()) ? hksm.getPassword(this.howc.getCryptKeystoreAlias(), this.howc.getCryptKeystorePassword()) : hksm.getPassword(this.howc.getFileName(), this.howc.getCryptKeystorePassword());
                this.howc.setPassword(password);
            }
            catch (IllegalArgumentException | KeyStoreException | NoSuchAlgorithmException | UnrecoverableEntryException | CertificateException | InvalidKeySpecException e) {
                LOG.error((Object)"Cannopt read keystore. Exception: ", (Throwable)e);
                throw new OfficeWriterException("Cannot read keystore to obtain credentials used to encrypt office documents " + e);
            }
        }
    }

    private void readSigningKeyAndCertificate(Configuration conf) throws OfficeWriterException, IOException {
        if (this.howc.getSigKeystoreFile() != null && !"".equals(this.howc.getSigKeystoreFile())) {
            LOG.info((Object)"Signing document");
            if (this.howc.getSigKeystoreAlias() == null || "".equals(this.howc.getSigKeystoreAlias())) {
                LOG.error((Object)"Keystore alias for signature keystore not defined. Cannot sign document");
                throw new OfficeWriterException("Keystore alias for signature keystore not defined. Cannot sign document");
            }
            if (this.howc.getSigKeystoreType() == null || "".equals(this.howc.getSigKeystoreType())) {
                LOG.error((Object)"Keystore type for signature keystore not defined. Cannot sign document");
                throw new OfficeWriterException("Keystore type for signature keystore not defined. Cannot sign document");
            }
            LOG.info((Object)"Reading keystore");
            HadoopKeyStoreManager hksm = new HadoopKeyStoreManager(conf);
            try {
                hksm.openKeyStore(new Path(this.howc.getSigKeystoreFile()), this.howc.getSigKeystoreType(), this.howc.getSigKeystorePassword());
                this.howc.setSigKey(hksm.getPrivateKey(this.howc.getSigKeystoreAlias(), this.howc.getSigKeystorePassword()));
                this.howc.setSigCertificate((X509Certificate)hksm.getCertificate(this.howc.getSigKeystoreAlias()));
            }
            catch (IllegalArgumentException | KeyStoreException | NoSuchAlgorithmException | UnrecoverableKeyException | CertificateException e) {
                LOG.error((Object)"Cannopt read signing certificate. Exception: ", (Throwable)e);
                throw new OfficeWriterException("Cannot read keystore to obtain key and certificate for signing " + e);
            }
        }
    }

    public synchronized void write(NullWritable key, K value) throws IOException {
        try {
            if (value == null) {
                return;
            }
            if (value instanceof ArrayWritable) {
                ArrayWritable row = (ArrayWritable)value;
                Writable[] rowCellDAO = row.get();
                for (int i = 0; i < rowCellDAO.length; ++i) {
                    this.officeWriter.write(rowCellDAO[i]);
                }
            } else {
                this.officeWriter.write(value);
            }
        }
        catch (OfficeWriterException e) {
            LOG.error((Object)e);
        }
    }

    public synchronized void close(TaskAttemptContext context) throws IOException {
        try {
            this.officeWriter.close();
        }
        finally {
            if (this.out != null) {
                this.out.close();
            }
            if (this.currentReader != null) {
                this.currentReader.close();
            }
        }
    }
}

