/*
 * Decompiled with CFR 0.152.
 */
package org.zuinnote.spark.office.excel;

import java.io.Serializable;
import java.text.DecimalFormat;
import java.text.SimpleDateFormat;
import org.apache.hadoop.io.NullWritable;
import org.apache.hadoop.mapreduce.RecordWriter;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.catalyst.CatalystTypeConverters$;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.execution.datasources.OutputWriter;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.StructType;
import org.zuinnote.hadoop.office.format.common.HadoopOfficeWriteConfiguration;
import org.zuinnote.hadoop.office.format.common.converter.ExcelConverterSimpleSpreadSheetCellDAO;
import org.zuinnote.hadoop.office.format.common.dao.SpreadSheetCellDAO;
import org.zuinnote.hadoop.office.format.common.util.msexcel.MSExcelUtil;
import org.zuinnote.hadoop.office.format.mapreduce.ExcelFileOutputFormat;
import scala.Function0;
import scala.Function1;
import scala.Predef$;
import scala.collection.Seq;
import scala.collection.immutable.Map;
import scala.collection.mutable.ArrayOps;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.IntRef;
import scala.runtime.RichInt$;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0001\u0005\u001df!B\u0001\u0003\u0001\ta!!E#yG\u0016dw*\u001e;qkR<&/\u001b;fe*\u00111\u0001B\u0001\u0006Kb\u001cW\r\u001c\u0006\u0003\u000b\u0019\taa\u001c4gS\u000e,'BA\u0004\t\u0003\u0015\u0019\b/\u0019:l\u0015\tI!\"\u0001\u0005{k&tgn\u001c;f\u0015\u0005Y\u0011aA8sON\u0011\u0001!\u0004\t\u0003\u001dai\u0011a\u0004\u0006\u0003!E\t1\u0002Z1uCN|WO]2fg*\u0011!cE\u0001\nKb,7-\u001e;j_:T!\u0001F\u000b\u0002\u0007M\fHN\u0003\u0002\b-)\u0011qCC\u0001\u0007CB\f7\r[3\n\u0005ey!\u0001D(viB,Ho\u0016:ji\u0016\u0014\b\u0002C\u000e\u0001\u0005\u0003\u0005\u000b\u0011B\u000f\u0002\tA\fG\u000f[\u0002\u0001!\tqrE\u0004\u0002 KA\u0011\u0001eI\u0007\u0002C)\u0011!\u0005H\u0001\u0007yI|w\u000e\u001e \u000b\u0003\u0011\nQa]2bY\u0006L!AJ\u0012\u0002\rA\u0013X\rZ3g\u0013\tA\u0013F\u0001\u0004TiJLgn\u001a\u0006\u0003M\rB\u0001b\u000b\u0001\u0003\u0002\u0003\u0006I\u0001L\u0001\u000bI\u0006$\u0018mU2iK6\f\u0007CA\u00171\u001b\u0005q#BA\u0018\u0014\u0003\u0015!\u0018\u0010]3t\u0013\t\tdF\u0001\u0006TiJ,8\r\u001e+za\u0016D\u0001b\r\u0001\u0003\u0002\u0003\u0006I\u0001N\u0001\bG>tG/\u001a=u!\t)$(D\u00017\u0015\t9\u0004(A\u0005nCB\u0014X\rZ;dK*\u0011\u0011HF\u0001\u0007Q\u0006$wn\u001c9\n\u0005m2$A\u0005+bg.\fE\u000f^3naR\u001cuN\u001c;fqRD\u0001\"\u0010\u0001\u0003\u0002\u0003\u0006IAP\u0001\b_B$\u0018n\u001c8t!\u0011qr(H\u000f\n\u0005\u0001K#aA'ba\")!\t\u0001C\u0001\u0007\u00061A(\u001b8jiz\"R\u0001\u0012$H\u0011&\u0003\"!\u0012\u0001\u000e\u0003\tAQaG!A\u0002uAQaK!A\u00021BQaM!A\u0002QBQ!P!A\u0002yBqa\u0013\u0001C\u0002\u0013%A*\u0001\u0007sK\u000e|'\u000fZ,sSR,'/F\u0001N!\u0011)d\n\u0015,\n\u0005=3$\u0001\u0004*fG>\u0014Hm\u0016:ji\u0016\u0014\bCA)U\u001b\u0005\u0011&BA*9\u0003\tIw.\u0003\u0002V%\naa*\u001e7m/JLG/\u00192mKB\u0011q\u000bY\u0007\u00021*\u0011\u0011LW\u0001\u0004I\u0006|'BA.]\u0003\u0019\u0019w.\\7p]*\u0011QLX\u0001\u0007M>\u0014X.\u0019;\u000b\u0005\u0015y&BA\u001d\t\u0013\t\t\u0007L\u0001\nTaJ,\u0017\rZ*iK\u0016$8)\u001a7m\t\u0006{\u0005BB2\u0001A\u0003%Q*A\u0007sK\u000e|'\u000fZ,sSR,'\u000f\t\u0005\bK\u0002\u0001\r\u0011\"\u0003g\u00035\u0019WO\u001d:f]R\u0014vn\u001e(v[V\tq\r\u0005\u0002iS6\t1%\u0003\u0002kG\t\u0019\u0011J\u001c;\t\u000f1\u0004\u0001\u0019!C\u0005[\u0006\t2-\u001e:sK:$(k\\<Ok6|F%Z9\u0015\u00059\f\bC\u00015p\u0013\t\u00018E\u0001\u0003V]&$\bb\u0002:l\u0003\u0003\u0005\raZ\u0001\u0004q\u0012\n\u0004B\u0002;\u0001A\u0003&q-\u0001\bdkJ\u0014XM\u001c;S_^tU/\u001c\u0011\t\u000fY\u0004!\u0019!C\u0005o\u0006!\u0001n\\<d+\u0005A\bCA={\u001b\u0005Q\u0016BA>[\u0005yA\u0015\rZ8pa>3g-[2f/JLG/Z\"p]\u001aLw-\u001e:bi&|g\u000e\u0003\u0004~\u0001\u0001\u0006I\u0001_\u0001\u0006Q><8\r\t\u0005\t\u007f\u0002\u0011\r\u0011\"\u0003\u0002\u0002\u0005\u0001B-\u001a4bk2$8\u000b[3fi:\u000bW.Z\u000b\u0002;!9\u0011Q\u0001\u0001!\u0002\u0013i\u0012!\u00053fM\u0006,H\u000e^*iK\u0016$h*Y7fA!I\u0011\u0011\u0002\u0001A\u0002\u0013%\u00111B\u0001\nkN,\u0007*Z1eKJ,\"!!\u0004\u0011\u0007!\fy!C\u0002\u0002\u0012\r\u0012qAQ8pY\u0016\fg\u000eC\u0005\u0002\u0016\u0001\u0001\r\u0011\"\u0003\u0002\u0018\u0005iQo]3IK\u0006$WM]0%KF$2A\\A\r\u0011%\u0011\u00181CA\u0001\u0002\u0004\ti\u0001\u0003\u0005\u0002\u001e\u0001\u0001\u000b\u0015BA\u0007\u0003))8/\u001a%fC\u0012,'\u000f\t\u0005\f\u0003C\u0001\u0001\u0019!a\u0001\n\u0013\t\u0019#A\u0005d_:4XM\u001d;feV\u0011\u0011Q\u0005\t\bQ\u0006\u001d\u00121FA\u001c\u0013\r\tIc\t\u0002\n\rVt7\r^5p]F\u0002B!!\f\u000245\u0011\u0011q\u0006\u0006\u0004\u0003c\u0019\u0012\u0001C2bi\u0006d\u0017p\u001d;\n\t\u0005U\u0012q\u0006\u0002\f\u0013:$XM\u001d8bYJ{w\u000f\u0005\u0003\u0002:\u0005mR\"A\n\n\u0007\u0005u2CA\u0002S_^D1\"!\u0011\u0001\u0001\u0004\u0005\r\u0011\"\u0003\u0002D\u0005i1m\u001c8wKJ$XM]0%KF$2A\\A#\u0011%\u0011\u0018qHA\u0001\u0002\u0004\t)\u0003C\u0006\u0002J\u0001\u0001\r\u0011!Q!\n\u0005\u0015\u0012AC2p]Z,'\u000f^3sA!I\u0011Q\n\u0001C\u0002\u0013%\u0011qJ\u0001\u000bI\u0006$XMR8s[\u0006$XCAA)!\u0011\t\u0019&!\u0018\u000e\u0005\u0005U#\u0002BA,\u00033\nA\u0001^3yi*\u0011\u00111L\u0001\u0005U\u00064\u0018-\u0003\u0003\u0002`\u0005U#\u0001E*j[BdW\rR1uK\u001a{'/\\1u\u0011!\t\u0019\u0007\u0001Q\u0001\n\u0005E\u0013a\u00033bi\u00164uN]7bi\u0002B\u0011\"a\u001a\u0001\u0005\u0004%I!!\u001b\u0002\u001b\u0011,7-[7bY\u001a{'/\\1u+\t\tY\u0007\u0005\u0003\u0002T\u00055\u0014\u0002BA8\u0003+\u0012Q\u0002R3dS6\fGNR8s[\u0006$\b\u0002CA:\u0001\u0001\u0006I!a\u001b\u0002\u001d\u0011,7-[7bY\u001a{'/\\1uA!I\u0011q\u000f\u0001C\u0002\u0013%\u0011qJ\u0001\u000fI\u0006$X\rV5nK\u001a{'/\\1u\u0011!\tY\b\u0001Q\u0001\n\u0005E\u0013a\u00043bi\u0016$\u0016.\\3G_Jl\u0017\r\u001e\u0011\t\u0013\u0005}\u0004A1A\u0005\n\u0005\u0005\u0015aD:j[BdWmQ8om\u0016\u0014H/\u001a:\u0016\u0005\u0005\r\u0005\u0003BAC\u0003\u0013k!!a\"\u000b\u0007\u0005\u0005\",\u0003\u0003\u0002\f\u0006\u001d%AJ#yG\u0016d7i\u001c8wKJ$XM]*j[BdWm\u00159sK\u0006$7\u000b[3fi\u000e+G\u000e\u001c#B\u001f\"A\u0011q\u0012\u0001!\u0002\u0013\t\u0019)\u0001\ttS6\u0004H.Z\"p]Z,'\u000f^3sA!9\u00111\u0013\u0001\u0005\u0002\u0005U\u0015!B<sSR,Gc\u00018\u0002\u0018\"A\u0011\u0011TAI\u0001\u0004\tY#A\u0002s_^Dq!a%\u0001\t\u0003\ti\nF\u0002o\u0003?C\u0001\"!'\u0002\u001c\u0002\u0007\u0011q\u0007\u0005\b\u0003G\u0003A\u0011IAS\u0003\u0015\u0019Gn\\:f)\u0005q\u0007")
public class ExcelOutputWriter
extends OutputWriter {
    private final TaskAttemptContext context;
    private final RecordWriter<NullWritable, SpreadSheetCellDAO> recordWriter;
    private int currentRowNum;
    private final HadoopOfficeWriteConfiguration howc;
    private final String defaultSheetName;
    private boolean useHeader;
    private Function1<InternalRow, Row> converter;
    private final SimpleDateFormat dateFormat;
    private final DecimalFormat decimalFormat;
    private final SimpleDateFormat dateTimeFormat;
    private final ExcelConverterSimpleSpreadSheetCellDAO simpleConverter;

    private RecordWriter<NullWritable, SpreadSheetCellDAO> recordWriter() {
        return this.recordWriter;
    }

    private int currentRowNum() {
        return this.currentRowNum;
    }

    private void currentRowNum_$eq(int x$1) {
        this.currentRowNum = x$1;
    }

    private HadoopOfficeWriteConfiguration howc() {
        return this.howc;
    }

    private String defaultSheetName() {
        return this.defaultSheetName;
    }

    private boolean useHeader() {
        return this.useHeader;
    }

    private void useHeader_$eq(boolean x$1) {
        this.useHeader = x$1;
    }

    private Function1<InternalRow, Row> converter() {
        return this.converter;
    }

    private void converter_$eq(Function1<InternalRow, Row> x$1) {
        this.converter = x$1;
    }

    private SimpleDateFormat dateFormat() {
        return this.dateFormat;
    }

    private DecimalFormat decimalFormat() {
        return this.decimalFormat;
    }

    private SimpleDateFormat dateTimeFormat() {
        return this.dateTimeFormat;
    }

    private ExcelConverterSimpleSpreadSheetCellDAO simpleConverter() {
        return this.simpleConverter;
    }

    public void write(InternalRow row) {
        this.write((Row)this.converter().apply((Object)row));
    }

    public void write(Row row) {
        if (this.useHeader()) {
            String[] headers = row.schema().fieldNames();
            IntRef i2 = IntRef.create((int)0);
            new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])headers)).foreach((Function1 & Serializable & scala.Serializable)x -> {
                ExcelOutputWriter.$anonfun$write$1(this, i2, x);
                return BoxedUnit.UNIT;
            });
            this.currentRowNum_$eq(this.currentRowNum() + 1);
            this.useHeader_$eq(false);
        }
        if (row.size() > 0) {
            boolean currentColumnNum = false;
            Object[] simpleObject = new Object[row.size()];
            RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(0), row.size() - 1).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
                Object obj = row.get(i);
                if (obj instanceof Seq && ((Seq)obj).length() == 5) {
                    String formattedValue = (String)((Seq)obj).apply(0);
                    String comment = (String)((Seq)obj).apply(1);
                    String formula = (String)((Seq)obj).apply(2);
                    String address = (String)((Seq)obj).apply(3);
                    String sheetName = (String)((Seq)obj).apply(4);
                    simpleObject$1[i] = new SpreadSheetCellDAO(formattedValue, comment, formula, address, sheetName);
                } else {
                    simpleObject$1[i] = obj;
                }
            });
            SpreadSheetCellDAO[] spreadSheetCellDAORow = this.simpleConverter().getSpreadSheetCellDAOfromSimpleDataType(simpleObject, this.defaultSheetName(), this.currentRowNum());
            new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])spreadSheetCellDAORow)).foreach((Function1 & Serializable & scala.Serializable)x -> {
                ExcelOutputWriter.$anonfun$write$3(this, x);
                return BoxedUnit.UNIT;
            });
        }
        this.currentRowNum_$eq(this.currentRowNum() + 1);
    }

    public void close() {
        this.recordWriter().close(this.context);
        this.currentRowNum_$eq(0);
    }

    public static final /* synthetic */ void $anonfun$write$1(ExcelOutputWriter $this, IntRef i$1, String x) {
        SpreadSheetCellDAO headerColumnSCD = new SpreadSheetCellDAO(x, "", "", MSExcelUtil.getCellAddressA1Format($this.currentRowNum(), i$1.elem), $this.defaultSheetName());
        $this.recordWriter().write((Object)NullWritable.get(), (Object)headerColumnSCD);
        ++i$1.elem;
    }

    public static final /* synthetic */ void $anonfun$write$3(ExcelOutputWriter $this, SpreadSheetCellDAO x) {
        $this.recordWriter().write((Object)NullWritable.get(), (Object)x);
    }

    public ExcelOutputWriter(String path, StructType dataSchema, TaskAttemptContext context, Map<String, String> options) {
        this.context = context;
        this.recordWriter = new ExcelFileOutputFormat().getRecordWriter(context);
        this.currentRowNum = 0;
        this.howc = new HadoopOfficeWriteConfiguration(context.getConfiguration(), "");
        this.defaultSheetName = (String)options.getOrElse((Object)"write.spark.defaultsheetname", (Function0 & Serializable & scala.Serializable)() -> "Sheet1");
        this.useHeader = this.howc().getWriteHeader();
        this.converter_$eq((Function1<InternalRow, Row>)CatalystTypeConverters$.MODULE$.createToScalaConverter((DataType)dataSchema));
        this.dateFormat = this.howc().getSimpleDateFormat();
        this.decimalFormat = this.howc().getSimpleDecimalFormat();
        this.dateTimeFormat = this.howc().getSimpleDateTimeFormat();
        this.simpleConverter = new ExcelConverterSimpleSpreadSheetCellDAO(this.dateFormat(), this.decimalFormat(), this.dateTimeFormat());
    }
}

