/*
 * Decompiled with CFR 0.152.
 */
package org.zuinnote.hadoop.office.format.common;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.compress.CodecPool;
import org.apache.hadoop.io.compress.CompressionCodec;
import org.apache.hadoop.io.compress.CompressionCodecFactory;
import org.apache.hadoop.io.compress.Decompressor;
import org.apache.hadoop.io.compress.SplittableCompressionCodec;

public class HadoopFileReader {
    private static final Log LOG = LogFactory.getLog((String)HadoopFileReader.class.getName());
    private CompressionCodecFactory compressionCodecs = null;
    private Configuration conf;
    private ArrayList<Decompressor> openDecompressors;
    private FileSystem fs;

    private HadoopFileReader() {
    }

    public HadoopFileReader(Configuration conf) throws IOException {
        this.conf = conf;
        this.compressionCodecs = new CompressionCodecFactory(conf);
        this.openDecompressors = new ArrayList();
        this.fs = FileSystem.get((Configuration)this.conf);
    }

    public InputStream openFile(Path path) throws IOException {
        CompressionCodec codec = this.compressionCodecs.getCodec(path);
        FSDataInputStream fileIn = this.fs.open(path);
        if (codec == null) {
            LOG.debug((Object)("Reading from an uncompressed file \"" + path + "\""));
            return fileIn;
        }
        Decompressor decompressor = CodecPool.getDecompressor((CompressionCodec)codec);
        this.openDecompressors.add(decompressor);
        if (codec instanceof SplittableCompressionCodec) {
            LOG.debug((Object)("Reading from a compressed file \"" + path + "\" with splittable compression codec"));
            long end = this.fs.getFileStatus(path).getLen();
            return ((SplittableCompressionCodec)codec).createInputStream((InputStream)fileIn, decompressor, 0L, end, SplittableCompressionCodec.READ_MODE.CONTINUOUS);
        }
        LOG.debug((Object)("Reading from a compressed file \"" + path + "\" with non-splittable compression codec"));
        return codec.createInputStream((InputStream)fileIn, decompressor);
    }

    public void close() throws IOException {
        for (Decompressor currentDecompressor : this.openDecompressors) {
            if (currentDecompressor == null) continue;
            CodecPool.returnDecompressor((Decompressor)currentDecompressor);
        }
    }

    public Map<String, InputStream> loadLinkedWorkbooks(String[] fileNames) throws IOException {
        HashMap<String, InputStream> result = new HashMap<String, InputStream>();
        if (fileNames == null) {
            return result;
        }
        for (String currentFile : fileNames) {
            Path currentPath = new Path(currentFile);
            InputStream currentInputStream = this.openFile(currentPath);
            result.put(currentPath.getName(), currentInputStream);
        }
        return result;
    }

    public InputStream loadTemplate(String fileName) throws IOException {
        Path currentPath = new Path(fileName);
        return this.openFile(currentPath);
    }
}

