/*
 * Decompiled with CFR 0.152.
 */
package org.zuinnote.hadoop.office.format.common;

import java.io.Serializable;
import java.security.Key;
import java.security.cert.X509Certificate;
import java.text.DateFormat;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.text.SimpleDateFormat;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import org.apache.hadoop.conf.Configuration;
import org.zuinnote.hadoop.office.format.common.HadoopUtil;

public class HadoopOfficeWriteConfiguration
implements Serializable {
    private static final long serialVersionUID = 4125629762320597440L;
    public static final String CONF_MIMETYPE = "hadoopoffice.write.mimeType";
    public static final String CONF_LOCALE = "hadoopoffice.write.locale.bcp47";
    public static final String CONF_LINKEDWB = "hadoopoffice.write.linkedworkbooks";
    public static final String CONF_IGNOREMISSINGWB = "hadoopoffice.write.ignoremissinglinkedworkbooks";
    public static final String CONF_COMMENTAUTHOR = "hadoopoffice.write.comment.author";
    public static final String CONF_COMMENTWIDTH = "hadoopoffice.write.comment.width";
    public static final String CONF_COMMENTHEIGHT = "hadoopoffice.write.comment.height";
    public static final String CONF_SECURITYCRED = "hadoopoffice.write.security.crypt.password";
    public static final String CONF_SECURITYALGORITHM = "hadoopoffice.write.security.crypt.encrypt.algorithm";
    public static final String CONF_SECURITYMODE = "hadoopoffice.write.security.crypt.encrypt.mode";
    public static final String CONF_CHAINMODE = "hadoopoffice.write.security.crypt.chain.mode";
    public static final String CONF_HASHALGORITHM = "hadoopoffice.write.security.crypt.hash.algorithm";
    public static final String CONF_DECRYPTLINKEDWBBASE = "hadoopoffice.write.security.crypt.linkedworkbooks.";
    public static final String CONF_METADATA = "hadoopoffice.write.metadata.";
    public static final String CONF_TEMPLATE = "hadoopoffice.write.template.file";
    public static final String CONF_TEMPLATEPW = "hadoopoffice.write.template.password";
    public static final String CONF_LOWFOOTPRINT = "hadoopoffice.write.lowFootprint";
    public static final String CONF_LOWFOOTPRINT_CACHEROWS = "hadoopoffice.write.lowFootprint.cacherows";
    public static final String CONF_CRYKEYSTOREFILE = "hadoopoffice.write.security.crypt.credential.keystore.file";
    public static final String CONF_CRYKEYSTORETYPE = "hadoopoffice.write.security.crypt.credential.keystore.type";
    public static final String CONF_CRYKEYSTOREPW = "hadoopoffice.write.security.crypt.credential.keystore.password";
    public static final String CONF_CRYKEYSTOREALIAS = "hadoopoffice.write.security.crypt.credential.keystore.alias";
    public static final String CONF_SIGKEYSTOREFILE = "hadoopoffice.write.security.sign.keystore.file";
    public static final String CONF_SIGKEYSTORETYPE = "hadoopoffice.write.security.sign.keystore.type";
    public static final String CONF_SIGKEYSTOREPW = "hadoopoffice.write.security.sign.keystore.password";
    public static final String CONF_SIGKEYSTOREALIAS = "hadoopoffice.write.security.sign.keystore.alias";
    public static final String CONF_SIGHASH = "hadoopoffice.write.security.sign.hash.algorithm";
    public static final String CONF_IGNORELINEBREAKS = "hadoopoffice.write.security.sign.ignoreLineBreaks";
    public static final String CONF_WRITEHEADER = "hadoopoffice.write.header.write";
    public static final String CONF_SIMPLEDATEFORMAT = "hadoopoffice.write.simple.dateFormat";
    public static final String CONF_SIMPLEDATEPATTERN = "hadoopoffice.write.simple.datePattern";
    public static final String CONF_SIMPLEDATETIMEFORMAT = "hadoopoffice.write.simple.dateTimeFormat";
    public static final String CONF_SIMPLEDATETIMEPATTERN = "hadoopoffice.write.simple.dateTimePattern";
    public static final String CONF_SIMPLEDECIMALFORMAT = "hadoopoffice.write.simple.decimalFormat";
    public static final String DEFAULT_MIMETYPE = "";
    public static final String DEFAULT_LOCALE = "";
    public static final String DEFAULT_LINKEDWB = "";
    public static final boolean DEFAULT_IGNOREMISSINGLINKEDWB = false;
    public static final String DEFAULT_AUTHOR = "hadoopoffice";
    public static final int DEFAULT_COMMENTWIDTH = 1;
    public static final int DEFAULT_COMMENTHEIGHT = 3;
    public static final String DEFAULT_PASSWORD = null;
    public static final String DEFAULT_ALGORITHM = "aes256";
    public static final String DEFAULT_TEMPLATE = "";
    public static final String DEFAULT_TEMPLATEPW = "";
    public static final boolean DEFAULT_LOWFOOTPRINT = false;
    public static final int DEFAULT_LOWFOOTPRINT_CACHEROWS = 1000;
    public static final String DEFAULT_CRYKEYSTOREFILE = "";
    public static final String DEFAULT_CRYKEYSTORETYPE = "JCEKS";
    public static final String DEFAULT_CRYKEYSTOREPW = "";
    public static final String DEFAULT_CRYKEYSTOREALIAS = "";
    public static final String DEFAULT_SIGKEYSTOREFILE = "";
    public static final String DEFAULT_SIGKEYSTORETYPE = "PKCS12";
    public static final String DEFAULT_SIGKEYSTOREPW = "";
    public static final String DEFAULT_SIGKEYSTOREALIAS = "";
    public static final String DEFAULT_SIGHASH = "sha512";
    public static final boolean DEFAULT_IGNORELINEBREAKS = false;
    public static final boolean DEFAULT_WRITEHEADER = false;
    public static final String DEFAULT_SIMPLEDATEFORMAT = "US";
    public static final String DEFAULT_SIMPLEDATEPATTERN = "";
    public static final String DEFAULT_SIMPLEDATETIMEFORMAT = "US";
    public static final String DEFAULT_SIMPLEDATETIMEPATTERN = "";
    public static final String DEFAULT_SIMPLEDECIMALFORMAT = "";
    private String[] linkedWorkbooksName;
    private String fileName;
    private String mimeType;
    private Locale locale;
    private boolean ignoreMissingLinkedWorkbooks;
    private String commentAuthor;
    private int commentWidth;
    private int commentHeight;
    private String password;
    private String encryptAlgorithm;
    private String hashAlgorithm;
    private String encryptMode;
    private String chainMode;
    private String template;
    private String templatePassword;
    private Map<String, String> linkedWBCredentialMap;
    private Map<String, String> metadata;
    private boolean lowFootprint;
    private int lowFootprintCacheRows;
    private String cryptKeystoreFile;
    private String cryptKeystoreType;
    private String cryptKeystorePassword;
    private String cryptKeystoreAlias;
    private String sigKeystoreFile;
    private String sigKeystoreType;
    private String sigKeystorePassword;
    private String sigKeystoreAlias;
    private String sigHash;
    private X509Certificate sigCertificate;
    private Key sigKey;
    private boolean ignoreLineBreaks;
    private boolean writeHeader;
    private SimpleDateFormat simpleDateFormat;
    private SimpleDateFormat simpleDateTimeFormat;
    private DecimalFormat simpleDecimalFormat;

    public HadoopOfficeWriteConfiguration(String fileName) {
        this.linkedWorkbooksName = new String[0];
        this.linkedWBCredentialMap = new HashMap<String, String>();
        this.metadata = new HashMap<String, String>();
        this.setMimeType("");
        String localeStrBCP47 = "";
        if (!"".equals(localeStrBCP47)) {
            this.setLocale(new Locale.Builder().setLanguageTag(localeStrBCP47).build());
        }
        this.setFileName(fileName);
        this.setCommentAuthor(DEFAULT_AUTHOR);
        this.setCommentWidth(1);
        this.setCommentHeight(3);
        String linkedWorkbooksStr = "";
        this.setLinkedWorkbooksName(HadoopUtil.parseLinkedWorkbooks(linkedWorkbooksStr));
        this.setIgnoreMissingLinkedWorkbooks(false);
        this.setTemplate("");
        this.setTemplatePassword("");
        this.setLowFootprint(false);
        this.setLowFootprintCacheRows(1000);
        this.setCryptKeystoreFile("");
        this.setCryptKeystoreType(DEFAULT_CRYKEYSTORETYPE);
        this.setCryptKeystorePassword("");
        this.setCryptKeystoreAlias("");
        this.setSigKeystoreFile("");
        this.setSigKeystoreType(DEFAULT_SIGKEYSTORETYPE);
        this.setSigKeystorePassword("");
        this.setSigKeystoreAlias("");
        this.setSigHash(DEFAULT_SIGHASH);
        Locale dateLocale = Locale.getDefault();
        if (!"".equals("US")) {
            dateLocale = new Locale.Builder().setLanguageTag("US").build();
        }
        this.setSimpleDateFormat((SimpleDateFormat)DateFormat.getDateInstance(3, dateLocale));
        Locale dateTimeLocale = Locale.getDefault();
        if (!"".equals("US")) {
            dateTimeLocale = new Locale.Builder().setLanguageTag("US").build();
        }
        this.setSimpleDateTimeFormat((SimpleDateFormat)DateFormat.getDateTimeInstance(3, 3, dateTimeLocale));
        if (!"".equals("")) {
            this.setSimpleDateFormat(new SimpleDateFormat(""));
        }
        if (!"".equals("")) {
            this.setSimpleDateTimeFormat(new SimpleDateFormat(""));
        }
        Locale decimallocale = Locale.getDefault();
        if (!"".equals("")) {
            decimallocale = new Locale.Builder().setLanguageTag("").build();
        }
        this.setSimpleDecimalFormat((DecimalFormat)NumberFormat.getInstance(decimallocale));
        this.setWriteHeader(false);
        this.setIgnoreLineBreaks(false);
    }

    public HadoopOfficeWriteConfiguration(Configuration conf, String fileName) {
        String dateTimePattern;
        this.setMimeType(conf.get(CONF_MIMETYPE, ""));
        String localeStrBCP47 = conf.get(CONF_LOCALE, "");
        if (!"".equals(localeStrBCP47)) {
            this.setLocale(new Locale.Builder().setLanguageTag(localeStrBCP47).build());
        }
        this.setFileName(fileName);
        this.setCommentAuthor(conf.get(CONF_COMMENTAUTHOR, DEFAULT_AUTHOR));
        this.setCommentWidth(conf.getInt(CONF_COMMENTWIDTH, 1));
        this.setCommentHeight(conf.getInt(CONF_COMMENTHEIGHT, 3));
        String linkedWorkbooksStr = conf.get(CONF_LINKEDWB, "");
        this.setLinkedWorkbooksName(HadoopUtil.parseLinkedWorkbooks(linkedWorkbooksStr));
        this.setIgnoreMissingLinkedWorkbooks(conf.getBoolean(CONF_IGNOREMISSINGWB, false));
        this.setEncryptAlgorithm(conf.get(CONF_SECURITYALGORITHM));
        this.setPassword(conf.get(CONF_SECURITYCRED));
        this.setHashAlgorithm(conf.get(CONF_HASHALGORITHM));
        this.setEncryptMode(conf.get(CONF_SECURITYMODE));
        this.setChainMode(conf.get(CONF_CHAINMODE));
        this.setMetadata(HadoopUtil.parsePropertiesFromBase(conf, CONF_METADATA));
        this.setLinkedWBCredentialMap(HadoopUtil.parsePropertiesFromBase(conf, CONF_DECRYPTLINKEDWBBASE));
        this.setTemplate(conf.get(CONF_TEMPLATE, ""));
        this.setTemplatePassword(conf.get(CONF_TEMPLATEPW, ""));
        this.setLowFootprint(conf.getBoolean(CONF_LOWFOOTPRINT, false));
        this.setLowFootprintCacheRows(conf.getInt(CONF_LOWFOOTPRINT_CACHEROWS, 1000));
        this.setCryptKeystoreFile(conf.get(CONF_CRYKEYSTOREFILE, ""));
        this.setCryptKeystoreType(conf.get(CONF_CRYKEYSTORETYPE, DEFAULT_CRYKEYSTORETYPE));
        this.setCryptKeystorePassword(conf.get(CONF_CRYKEYSTOREPW, ""));
        this.setCryptKeystoreAlias(conf.get(CONF_CRYKEYSTOREALIAS, ""));
        this.setSigKeystoreFile(conf.get(CONF_SIGKEYSTOREFILE, ""));
        this.setSigKeystoreType(conf.get(CONF_SIGKEYSTORETYPE, DEFAULT_SIGKEYSTORETYPE));
        this.setSigKeystorePassword(conf.get(CONF_SIGKEYSTOREPW, ""));
        this.setSigKeystoreAlias(conf.get(CONF_SIGKEYSTOREALIAS, ""));
        this.setSigHash(conf.get(CONF_SIGHASH, DEFAULT_SIGHASH));
        this.setIgnoreLineBreaks(conf.getBoolean(CONF_IGNORELINEBREAKS, false));
        Locale dateLocale = new Locale.Builder().setLanguageTag(conf.get(CONF_SIMPLEDATEFORMAT, "US")).build();
        this.setSimpleDateFormat((SimpleDateFormat)DateFormat.getDateInstance(3, dateLocale));
        Locale dateTimeLocale = new Locale.Builder().setLanguageTag(conf.get(CONF_SIMPLEDATETIMEFORMAT, "US")).build();
        this.setSimpleDateTimeFormat((SimpleDateFormat)DateFormat.getDateTimeInstance(3, 3, dateTimeLocale));
        String datePattern = conf.get(CONF_SIMPLEDATEPATTERN, "");
        if (!"".equals(datePattern)) {
            this.setSimpleDateFormat(new SimpleDateFormat(datePattern));
        }
        if (!"".equals(dateTimePattern = conf.get(CONF_SIMPLEDATETIMEPATTERN, ""))) {
            this.setSimpleDateFormat(new SimpleDateFormat(dateTimePattern));
        }
        String decimaleStr = conf.get(CONF_SIMPLEDECIMALFORMAT, "");
        Locale decimallocale = Locale.getDefault();
        if (!"".equals(decimaleStr)) {
            decimallocale = new Locale.Builder().setLanguageTag(decimaleStr).build();
        }
        this.setSimpleDecimalFormat((DecimalFormat)NumberFormat.getInstance(decimallocale));
        this.setWriteHeader(conf.getBoolean(CONF_WRITEHEADER, false));
    }

    public String[] getLinkedWorkbooksName() {
        return this.linkedWorkbooksName;
    }

    public void setLinkedWorkbooksName(String[] linkedWorkbooksName) {
        this.linkedWorkbooksName = linkedWorkbooksName;
    }

    public String getFileName() {
        return this.fileName;
    }

    public void setFileName(String fileName) {
        this.fileName = fileName;
    }

    public String getMimeType() {
        return this.mimeType;
    }

    public void setMimeType(String mimeType) {
        this.mimeType = mimeType;
    }

    public Locale getLocale() {
        return this.locale;
    }

    public void setLocale(Locale locale) {
        this.locale = locale;
    }

    public boolean getIgnoreMissingLinkedWorkbooks() {
        return this.ignoreMissingLinkedWorkbooks;
    }

    public void setIgnoreMissingLinkedWorkbooks(boolean ignoreMissingLinkedWorkbooks) {
        this.ignoreMissingLinkedWorkbooks = ignoreMissingLinkedWorkbooks;
    }

    public String getCommentAuthor() {
        return this.commentAuthor;
    }

    public void setCommentAuthor(String commentAuthor) {
        this.commentAuthor = commentAuthor;
    }

    public int getCommentWidth() {
        return this.commentWidth;
    }

    public void setCommentWidth(int commentWidth) {
        this.commentWidth = commentWidth;
    }

    public int getCommentHeight() {
        return this.commentHeight;
    }

    public void setCommentHeight(int commentHeight) {
        this.commentHeight = commentHeight;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public String getEncryptAlgorithm() {
        return this.encryptAlgorithm;
    }

    public void setEncryptAlgorithm(String encryptAlgorithm) {
        this.encryptAlgorithm = encryptAlgorithm;
    }

    public String getHashAlgorithm() {
        return this.hashAlgorithm;
    }

    public void setHashAlgorithm(String hashAlgorithm) {
        this.hashAlgorithm = hashAlgorithm;
    }

    public String getEncryptMode() {
        return this.encryptMode;
    }

    public void setEncryptMode(String encryptMode) {
        this.encryptMode = encryptMode;
    }

    public String getChainMode() {
        return this.chainMode;
    }

    public void setChainMode(String chainMode) {
        this.chainMode = chainMode;
    }

    public Map<String, String> getLinkedWBCredentialMap() {
        return this.linkedWBCredentialMap;
    }

    public void setLinkedWBCredentialMap(Map<String, String> linkedWBCredentialMap) {
        this.linkedWBCredentialMap = linkedWBCredentialMap;
    }

    public Map<String, String> getMetadata() {
        return this.metadata;
    }

    public void setMetadata(Map<String, String> metadata) {
        this.metadata = metadata;
    }

    public String getTemplate() {
        return this.template;
    }

    public void setTemplate(String template) {
        this.template = template;
    }

    public String getTemplatePassword() {
        return this.templatePassword;
    }

    public void setTemplatePassword(String templatePassword) {
        this.templatePassword = templatePassword;
    }

    public boolean getLowFootprint() {
        return this.lowFootprint;
    }

    public void setLowFootprint(boolean lowFootprint) {
        this.lowFootprint = lowFootprint;
    }

    public int getLowFootprintCacheRows() {
        return this.lowFootprintCacheRows;
    }

    public void setLowFootprintCacheRows(int lowFootprintCacheRows) {
        this.lowFootprintCacheRows = lowFootprintCacheRows;
    }

    public String getCryptKeystoreFile() {
        return this.cryptKeystoreFile;
    }

    public void setCryptKeystoreFile(String cryptKeystoreFile) {
        this.cryptKeystoreFile = cryptKeystoreFile;
    }

    public String getCryptKeystoreType() {
        return this.cryptKeystoreType;
    }

    public void setCryptKeystoreType(String cryptKeystoreType) {
        this.cryptKeystoreType = cryptKeystoreType;
    }

    public String getCryptKeystorePassword() {
        return this.cryptKeystorePassword;
    }

    public void setCryptKeystorePassword(String cryptKeystorePassword) {
        this.cryptKeystorePassword = cryptKeystorePassword;
    }

    public String getCryptKeystoreAlias() {
        return this.cryptKeystoreAlias;
    }

    public void setCryptKeystoreAlias(String cryptKeystoreAlias) {
        this.cryptKeystoreAlias = cryptKeystoreAlias;
    }

    public String getSigKeystoreFile() {
        return this.sigKeystoreFile;
    }

    public void setSigKeystoreFile(String sigKeystoreFile) {
        this.sigKeystoreFile = sigKeystoreFile;
    }

    public String getSigKeystoreType() {
        return this.sigKeystoreType;
    }

    public void setSigKeystoreType(String sigKeystoreType) {
        this.sigKeystoreType = sigKeystoreType;
    }

    public String getSigKeystorePassword() {
        return this.sigKeystorePassword;
    }

    public void setSigKeystorePassword(String sigKeystorePassword) {
        this.sigKeystorePassword = sigKeystorePassword;
    }

    public String getSigKeystoreAlias() {
        return this.sigKeystoreAlias;
    }

    public void setSigKeystoreAlias(String sigKeystoreAlias) {
        this.sigKeystoreAlias = sigKeystoreAlias;
    }

    public String getSigHash() {
        return this.sigHash;
    }

    public void setSigHash(String sigHash) {
        this.sigHash = sigHash;
    }

    public X509Certificate getSigCertificate() {
        return this.sigCertificate;
    }

    public void setSigCertificate(X509Certificate sigCertificate) {
        this.sigCertificate = sigCertificate;
    }

    public Key getSigKey() {
        return this.sigKey;
    }

    public void setSigKey(Key sigKey) {
        this.sigKey = sigKey;
    }

    public SimpleDateFormat getSimpleDateFormat() {
        return this.simpleDateFormat;
    }

    public void setSimpleDateFormat(SimpleDateFormat simpleDateFormat) {
        this.simpleDateFormat = simpleDateFormat;
    }

    public SimpleDateFormat getSimpleDateTimeFormat() {
        return this.simpleDateTimeFormat;
    }

    public void setSimpleDateTimeFormat(SimpleDateFormat simpleDateTimeFormat) {
        this.simpleDateTimeFormat = simpleDateTimeFormat;
    }

    public DecimalFormat getSimpleDecimalFormat() {
        return this.simpleDecimalFormat;
    }

    public void setSimpleDecimalFormat(DecimalFormat simpleDecimalFormat) {
        this.simpleDecimalFormat = simpleDecimalFormat;
    }

    public boolean getWriteHeader() {
        return this.writeHeader;
    }

    public void setWriteHeader(boolean writeHeader) {
        this.writeHeader = writeHeader;
    }

    public boolean getIgnoreLineBreaks() {
        return this.ignoreLineBreaks;
    }

    public void setIgnoreLineBreaks(boolean ignoreLineBreaks) {
        this.ignoreLineBreaks = ignoreLineBreaks;
        if (this.ignoreLineBreaks) {
            System.setProperty("org.apache.xml.security.ignoreLineBreaks", "true");
        }
    }
}

