/*
 * Decompiled with CFR 0.152.
 */
package org.zuinnote.hadoop.office.format.common.writer.msexcel;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.GeneralSecurityException;
import java.security.cert.X509Certificate;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.xml.crypto.MarshalException;
import javax.xml.crypto.dsig.XMLSignatureException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.poi.hpsf.SummaryInformation;
import org.apache.poi.hssf.record.crypto.Biff8EncryptionKey;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.ooxml.POIXMLProperties;
import org.apache.poi.poifs.crypt.ChainingMode;
import org.apache.poi.poifs.crypt.CipherAlgorithm;
import org.apache.poi.poifs.crypt.EncryptionInfo;
import org.apache.poi.poifs.crypt.EncryptionMode;
import org.apache.poi.poifs.crypt.Encryptor;
import org.apache.poi.poifs.crypt.HashAlgorithm;
import org.apache.poi.poifs.filesystem.POIFSFileSystem;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.ClientAnchor;
import org.apache.poi.ss.usermodel.Comment;
import org.apache.poi.ss.usermodel.Drawing;
import org.apache.poi.ss.usermodel.FormulaEvaluator;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.ss.util.CellAddress;
import org.apache.poi.ss.util.WorkbookUtil;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;
import org.zuinnote.hadoop.office.format.common.HadoopOfficeReadConfiguration;
import org.zuinnote.hadoop.office.format.common.HadoopOfficeWriteConfiguration;
import org.zuinnote.hadoop.office.format.common.dao.SpreadSheetCellDAO;
import org.zuinnote.hadoop.office.format.common.parser.FormatNotUnderstoodException;
import org.zuinnote.hadoop.office.format.common.parser.msexcel.MSExcelParser;
import org.zuinnote.hadoop.office.format.common.util.msexcel.MSExcelOOXMLSignUtil;
import org.zuinnote.hadoop.office.format.common.writer.InvalidWriterConfigurationException;
import org.zuinnote.hadoop.office.format.common.writer.OfficeSpreadSheetWriterInterface;
import org.zuinnote.hadoop.office.format.common.writer.OfficeWriterException;

public class MSExcelWriter
implements OfficeSpreadSheetWriterInterface {
    public static final String FORMAT_OOXML = "ooxmlexcel";
    public static final String FORMAT_OLD = "oldexcel";
    protected static final String[] VALID_FORMAT = new String[]{"ooxmlexcel", "oldexcel"};
    private static final Log LOG = LogFactory.getLog((String)MSExcelWriter.class.getName());
    private static final String DEFAULT_FORMAT = VALID_FORMAT[0];
    private String format = DEFAULT_FORMAT;
    private OutputStream oStream;
    private Workbook currentWorkbook;
    private Map<String, Drawing> mappedDrawings;
    private List<Workbook> listOfWorkbooks;
    private POIFSFileSystem ooxmlDocumentFileSystem;
    private HadoopOfficeWriteConfiguration howc;
    private CipherAlgorithm encryptAlgorithmCipher;
    private HashAlgorithm hashAlgorithmCipher;
    private EncryptionMode encryptionModeCipher;
    private ChainingMode chainModeCipher;
    private boolean hasTemplate;
    private MSExcelOOXMLSignUtil signUtil;

    public MSExcelWriter(String excelFormat, HadoopOfficeWriteConfiguration howc) throws InvalidWriterConfigurationException {
        boolean formatFound = MSExcelWriter.isSupportedFormat(excelFormat);
        if (!formatFound) {
            LOG.error((Object)("Unknown Excel format: " + this.format));
            throw new InvalidWriterConfigurationException("Unknown Excel format: " + this.format);
        }
        this.format = excelFormat;
        this.howc = howc;
        this.encryptAlgorithmCipher = MSExcelWriter.getAlgorithmCipher(this.howc.getEncryptAlgorithm());
        this.hashAlgorithmCipher = MSExcelWriter.getHashAlgorithm(this.howc.getHashAlgorithm());
        this.encryptionModeCipher = MSExcelWriter.getEncryptionModeCipher(this.howc.getEncryptMode());
        this.chainModeCipher = MSExcelWriter.getChainMode(this.howc.getChainMode());
        this.hasTemplate = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void create(OutputStream oStream, Map<String, InputStream> linkedWorkbooks, Map<String, String> linkedWorkbooksPasswords, InputStream template) throws OfficeWriterException {
        this.oStream = oStream;
        if (template != null) {
            LOG.info((Object)("Loading template: " + this.howc.getTemplate()));
            if (this.howc.getLowFootprint()) {
                LOG.warn((Object)"Low footprint mode is not supported with templates. Continuing normal mode");
            }
            this.hasTemplate = true;
            HadoopOfficeReadConfiguration currentTemplateHOCR = new HadoopOfficeReadConfiguration();
            currentTemplateHOCR.setLocale(this.howc.getLocale());
            currentTemplateHOCR.setSheets(null);
            currentTemplateHOCR.setIgnoreMissingLinkedWorkbooks(this.howc.getIgnoreMissingLinkedWorkbooks());
            currentTemplateHOCR.setMetaDataFilter(null);
            currentTemplateHOCR.setPassword(this.howc.getTemplatePassword());
            MSExcelParser currentTemplateParser = new MSExcelParser(currentTemplateHOCR, null);
            try {
                currentTemplateParser.parse(template);
            }
            catch (FormatNotUnderstoodException e) {
                LOG.error((Object)e);
                LOG.error((Object)"Cannot read template");
                throw new OfficeWriterException(e.toString());
            }
            this.currentWorkbook = currentTemplateParser.getCurrentWorkbook();
        } else if (this.format.equals(FORMAT_OOXML)) {
            this.currentWorkbook = new XSSFWorkbook();
            this.ooxmlDocumentFileSystem = new POIFSFileSystem();
        } else if (this.format.equals(FORMAT_OLD)) {
            if (this.howc.getLowFootprint()) {
                LOG.warn((Object)"Low footprint mode writing is not supported for old Excel files (.xls). Continuing normal mode");
            }
            this.currentWorkbook = new HSSFWorkbook();
            ((HSSFWorkbook)this.currentWorkbook).createInformationProperties();
        }
        FormulaEvaluator currentFormulaEvaluator = this.currentWorkbook.getCreationHelper().createFormulaEvaluator();
        HashMap<String, FormulaEvaluator> linkedFormulaEvaluators = new HashMap<String, FormulaEvaluator>();
        linkedFormulaEvaluators.put(this.howc.getFileName(), currentFormulaEvaluator);
        this.mappedDrawings = new HashMap<String, Drawing>();
        this.listOfWorkbooks = new ArrayList<Workbook>();
        try {
            for (Map.Entry<String, InputStream> entry : linkedWorkbooks.entrySet()) {
                HadoopOfficeReadConfiguration currentLinkedWBHOCR = new HadoopOfficeReadConfiguration();
                currentLinkedWBHOCR.setLocale(this.howc.getLocale());
                currentLinkedWBHOCR.setSheets(null);
                currentLinkedWBHOCR.setIgnoreMissingLinkedWorkbooks(this.howc.getIgnoreMissingLinkedWorkbooks());
                currentLinkedWBHOCR.setFileName(entry.getKey());
                currentLinkedWBHOCR.setPassword(linkedWorkbooksPasswords.get(entry.getKey()));
                currentLinkedWBHOCR.setMetaDataFilter(null);
                MSExcelParser currentLinkedWorkbookParser = new MSExcelParser(currentLinkedWBHOCR, null);
                try {
                    currentLinkedWorkbookParser.parse(entry.getValue());
                }
                catch (FormatNotUnderstoodException e) {
                    LOG.error((Object)e);
                    throw new OfficeWriterException(e.toString());
                }
                this.listOfWorkbooks.add(currentLinkedWorkbookParser.getCurrentWorkbook());
                linkedFormulaEvaluators.put(entry.getKey(), currentLinkedWorkbookParser.getCurrentFormulaEvaluator());
                this.currentWorkbook.linkExternalWorkbook(entry.getKey(), currentLinkedWorkbookParser.getCurrentWorkbook());
            }
        }
        catch (Throwable throwable) {
            for (InputStream currentIS : linkedWorkbooks.values()) {
                try {
                    currentIS.close();
                }
                catch (IOException e) {
                    LOG.error((Object)e);
                }
            }
            throw throwable;
        }
        for (InputStream currentIS : linkedWorkbooks.values()) {
            try {
                currentIS.close();
            }
            catch (IOException e) {
                LOG.error((Object)e);
            }
        }
        LOG.debug((Object)("Size of linked formula evaluators map: " + linkedFormulaEvaluators.size()));
        currentFormulaEvaluator.setupReferencedWorkbooks(linkedFormulaEvaluators);
        if (this.howc.getSigKey() != null) {
            try {
                this.signUtil = new MSExcelOOXMLSignUtil(this.oStream);
            }
            catch (IOException e) {
                LOG.error((Object)("Cannot create sign utilities " + e));
                throw new OfficeWriterException(e.toString());
            }
        }
    }

    @Override
    public void write(Object newDAO) throws OfficeWriterException {
        if (newDAO != null) {
            Cell currentCell;
            CellAddress currentCA;
            Row currentRow;
            SpreadSheetCellDAO sscd = MSExcelWriter.checkSpreadSheetCellDAO(newDAO);
            String safeSheetName = WorkbookUtil.createSafeSheetName(sscd.getSheetName());
            Sheet currentSheet = this.currentWorkbook.getSheet(safeSheetName);
            if (currentSheet == null) {
                currentSheet = this.currentWorkbook.createSheet(safeSheetName);
                if (!safeSheetName.equals(sscd.getSheetName())) {
                    LOG.warn((Object)("Sheetname modified from \"" + sscd.getSheetName() + "\" to \"" + safeSheetName + "\" to correspond to Excel conventions."));
                }
                this.mappedDrawings.put(safeSheetName, currentSheet.createDrawingPatriarch());
            }
            if ((currentRow = currentSheet.getRow((currentCA = new CellAddress(sscd.getAddress())).getRow())) == null) {
                currentRow = currentSheet.createRow(currentCA.getRow());
            }
            if ((currentCell = currentRow.getCell(currentCA.getColumn())) != null && !this.hasTemplate) {
                throw new OfficeWriterException("Invalid cell specification: cell already exists at " + currentCA);
            }
            if (!this.hasTemplate || currentCell == null) {
                currentCell = currentRow.createCell(currentCA.getColumn());
            }
            if (!"".equals(sscd.getFormula())) {
                currentCell.setCellFormula(sscd.getFormula());
            } else {
                currentCell.setCellValue(sscd.getFormattedValue());
            }
            if (sscd.getComment() != null && !"".equals(sscd.getComment())) {
                ClientAnchor anchor = this.currentWorkbook.getCreationHelper().createClientAnchor();
                anchor.setCol1(currentCell.getColumnIndex());
                anchor.setCol2(currentCell.getColumnIndex() + this.howc.getCommentWidth());
                anchor.setRow1(currentRow.getRowNum());
                anchor.setRow2(currentRow.getRowNum() + this.howc.getCommentHeight());
                Comment currentComment = this.mappedDrawings.get(safeSheetName).createCellComment(anchor);
                currentComment.setString(this.currentWorkbook.getCreationHelper().createRichTextString(sscd.getComment()));
                currentComment.setAuthor(this.howc.getCommentAuthor());
                currentCell.setCellComment(currentComment);
            }
        }
    }

    public static SpreadSheetCellDAO checkSpreadSheetCellDAO(Object newDAO) throws OfficeWriterException {
        if (!(newDAO instanceof SpreadSheetCellDAO)) {
            throw new OfficeWriterException("Objects which are not of the class SpreadSheetCellDAO are not supported for writing.");
        }
        SpreadSheetCellDAO sscd = (SpreadSheetCellDAO)newDAO;
        if (sscd.getSheetName() == null || "".equals(sscd.getSheetName())) {
            throw new OfficeWriterException("Invalid cell specification: empy sheet name not allowed.");
        }
        if (sscd.getAddress() == null || "".equals(sscd.getAddress())) {
            throw new OfficeWriterException("Invalid cell specification: empy cell address not allowed.");
        }
        if (sscd.getFormula() == null && sscd.getFormattedValue() == null) {
            throw new OfficeWriterException("Invalid cell specification: either formula or formattedValue needs to be specified for cell.");
        }
        return sscd;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws IOException {
        try {
            this.prepareMetaData();
            if (this.oStream != null) {
                if (this.howc.getPassword() == null) {
                    this.finalizeWriteNotEncrypted();
                } else if (this.currentWorkbook instanceof HSSFWorkbook) {
                    this.finalizeWriteEncryptedHSSF();
                } else if (this.currentWorkbook instanceof XSSFWorkbook) {
                    this.finalizeWriteEncryptedXSSF();
                } else {
                    LOG.error((Object)"Could not write encrypted workbook, because type of workbook is unknown");
                }
            }
        }
        finally {
            if (this.ooxmlDocumentFileSystem != null) {
                this.ooxmlDocumentFileSystem.close();
            }
            if (this.currentWorkbook != null) {
                this.currentWorkbook.close();
            }
            for (Workbook currentWorkbookItem : this.listOfWorkbooks) {
                if (currentWorkbookItem == null) continue;
                currentWorkbookItem.close();
            }
        }
        try {
            if (this.signUtil != null) {
                LOG.info((Object)("Signing document \"" + this.howc.getFileName() + "\""));
                if (this.howc.getSigCertificate() == null) {
                    LOG.error((Object)("Cannot sign document \"" + this.howc.getFileName() + "\". No certificate for key provided"));
                } else if (!(this.currentWorkbook instanceof XSSFWorkbook)) {
                    LOG.warn((Object)("Signing of docuemnts in old Excel format not supported for \"" + this.howc.getFileName() + "\""));
                } else {
                    try {
                        ArrayList<X509Certificate> certList = new ArrayList<X509Certificate>();
                        certList.add(this.howc.getSigCertificate());
                        this.signUtil.sign(this.howc.getSigKey(), certList, this.howc.getPassword(), MSExcelWriter.getHashAlgorithm(this.howc.getSigHash()));
                    }
                    catch (IOException | MarshalException | XMLSignatureException | FormatNotUnderstoodException e) {
                        LOG.error((Object)("Cannot sign document \"" + this.howc.getFileName() + "\" " + e));
                    }
                }
            }
        }
        finally {
            if (this.signUtil != null) {
                this.signUtil.close();
            }
        }
    }

    private void finalizeWriteNotEncrypted() throws IOException {
        try {
            if (this.signUtil != null && this.currentWorkbook instanceof XSSFWorkbook) {
                this.currentWorkbook.write(this.signUtil.getTempOutputStream());
            } else {
                this.currentWorkbook.write(this.oStream);
            }
        }
        finally {
            if (this.oStream != null && this.signUtil == null) {
                this.oStream.close();
            }
        }
    }

    private void finalizeWriteEncryptedHSSF() throws IOException {
        LOG.debug((Object)"encrypting HSSFWorkbook");
        Biff8EncryptionKey.setCurrentUserPassword(this.howc.getPassword());
        try {
            this.currentWorkbook.write(this.oStream);
        }
        finally {
            Biff8EncryptionKey.setCurrentUserPassword(null);
            if (this.oStream != null) {
                this.oStream.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void finalizeWriteEncryptedXSSF() throws IOException {
        if (this.encryptAlgorithmCipher == null) {
            LOG.error((Object)"No encryption algorithm specified");
            return;
        }
        if (this.hashAlgorithmCipher == null) {
            LOG.error((Object)"No hash algorithm specified");
            return;
        }
        if (this.encryptionModeCipher == null) {
            LOG.error((Object)"No encryption mode specified");
            return;
        }
        if (this.chainModeCipher == null) {
            LOG.error((Object)"No chain mode specified");
            return;
        }
        OutputStream os = null;
        try {
            EncryptionInfo info = new EncryptionInfo(this.encryptionModeCipher, this.encryptAlgorithmCipher, this.hashAlgorithmCipher, -1, -1, this.chainModeCipher);
            Encryptor enc = info.getEncryptor();
            enc.confirmPassword(this.howc.getPassword());
            try {
                os = enc.getDataStream(this.ooxmlDocumentFileSystem);
                if (os != null) {
                    this.currentWorkbook.write(os);
                }
                if (os != null) {
                    os.close();
                }
            }
            catch (GeneralSecurityException e) {
                LOG.error((Object)e);
            }
            OutputStream theOS = this.oStream;
            if (this.signUtil != null) {
                theOS = this.signUtil.getTempOutputStream();
            }
            this.ooxmlDocumentFileSystem.writeFilesystem(theOS);
        }
        finally {
            if (this.oStream != null && this.signUtil == null) {
                this.oStream.close();
            }
        }
    }

    public static boolean isSupportedFormat(String format) {
        for (int i = 0; i < VALID_FORMAT.length; ++i) {
            if (!VALID_FORMAT[i].equals(format)) continue;
            return true;
        }
        return false;
    }

    public static CipherAlgorithm getAlgorithmCipher(String encryptAlgorithm) {
        if (encryptAlgorithm == null) {
            return null;
        }
        switch (encryptAlgorithm) {
            case "aes128": {
                return CipherAlgorithm.aes128;
            }
            case "aes192": {
                return CipherAlgorithm.aes192;
            }
            case "aes256": {
                return CipherAlgorithm.aes256;
            }
            case "des": {
                return CipherAlgorithm.des;
            }
            case "des3": {
                return CipherAlgorithm.des3;
            }
            case "des3_112": {
                return CipherAlgorithm.des3_112;
            }
            case "rc2": {
                return CipherAlgorithm.rc2;
            }
            case "rc4": {
                return CipherAlgorithm.rc4;
            }
            case "rsa": {
                return CipherAlgorithm.rsa;
            }
        }
        LOG.error((Object)("Uknown encryption algorithm: \"" + encryptAlgorithm + "\""));
        return null;
    }

    public static HashAlgorithm getHashAlgorithm(String hashAlgorithm) {
        if (hashAlgorithm == null) {
            return null;
        }
        switch (hashAlgorithm) {
            case "md2": {
                return HashAlgorithm.md2;
            }
            case "md4": {
                return HashAlgorithm.md4;
            }
            case "md5": {
                return HashAlgorithm.md5;
            }
            case "none": {
                return HashAlgorithm.none;
            }
            case "ripemd128": {
                return HashAlgorithm.ripemd128;
            }
            case "ripemd160": {
                return HashAlgorithm.ripemd160;
            }
            case "sha1": {
                return HashAlgorithm.sha1;
            }
            case "sha224": {
                return HashAlgorithm.sha224;
            }
            case "sha256": {
                return HashAlgorithm.sha256;
            }
            case "sha384": {
                return HashAlgorithm.sha384;
            }
            case "sha512": {
                return HashAlgorithm.sha512;
            }
            case "whirlpool": {
                return HashAlgorithm.whirlpool;
            }
        }
        LOG.error((Object)("Uknown hash algorithm: \"" + hashAlgorithm + "\""));
        return null;
    }

    public static EncryptionMode getEncryptionModeCipher(String encryptionMode) {
        if (encryptionMode == null) {
            return null;
        }
        switch (encryptionMode) {
            case "agile": {
                return EncryptionMode.agile;
            }
            case "binaryRC4": {
                return EncryptionMode.binaryRC4;
            }
            case "cryptoAPI": {
                return EncryptionMode.cryptoAPI;
            }
            case "standard": {
                return EncryptionMode.standard;
            }
        }
        LOG.error((Object)("Uknown enncryption mode \"" + encryptionMode + "\""));
        return null;
    }

    public static ChainingMode getChainMode(String chainMode) {
        if (chainMode == null) {
            return null;
        }
        switch (chainMode) {
            case "cbc": {
                return ChainingMode.cbc;
            }
            case "cfb": {
                return ChainingMode.cfb;
            }
            case "ecb": {
                return ChainingMode.ecb;
            }
        }
        LOG.error((Object)("Uknown chainmode: \"" + chainMode + "\""));
        return null;
    }

    private void prepareMetaData() {
        if (this.currentWorkbook instanceof HSSFWorkbook) {
            this.prepareHSSFMetaData();
        } else if (this.currentWorkbook instanceof XSSFWorkbook) {
            this.prepareXSSFMetaData();
        } else {
            LOG.error((Object)"Unknown workbook type. Cannot write metadata.");
        }
    }

    private void prepareHSSFMetaData() {
        HSSFWorkbook currentHSSFWorkbook = (HSSFWorkbook)this.currentWorkbook;
        SummaryInformation summaryInfo = currentHSSFWorkbook.getSummaryInformation();
        if (summaryInfo == null) {
            currentHSSFWorkbook.createInformationProperties();
            summaryInfo = currentHSSFWorkbook.getSummaryInformation();
        }
        SimpleDateFormat formatSDF = new SimpleDateFormat("hh:mm:ss dd.MM.yyyy");
        for (Map.Entry<String, String> entry : this.howc.getMetadata().entrySet()) {
            try {
                switch (entry.getKey()) {
                    case "applicationname": {
                        summaryInfo.setApplicationName(entry.getValue());
                        break;
                    }
                    case "author": {
                        summaryInfo.setAuthor(entry.getValue());
                        break;
                    }
                    case "charcount": {
                        summaryInfo.setCharCount(Integer.parseInt(entry.getValue()));
                        break;
                    }
                    case "comments": {
                        summaryInfo.setComments(entry.getValue());
                        break;
                    }
                    case "createdatetime": {
                        summaryInfo.setCreateDateTime(formatSDF.parse(entry.getValue()));
                        break;
                    }
                    case "edittime": {
                        summaryInfo.setEditTime(Long.parseLong(entry.getValue()));
                        break;
                    }
                    case "keywords": {
                        summaryInfo.setKeywords(entry.getValue());
                        break;
                    }
                    case "lastauthor": {
                        summaryInfo.setLastAuthor(entry.getValue());
                        break;
                    }
                    case "lastprinted": {
                        summaryInfo.setLastPrinted(formatSDF.parse(entry.getValue()));
                        break;
                    }
                    case "lastsavedatetime": {
                        summaryInfo.setLastSaveDateTime(formatSDF.parse(entry.getValue()));
                        break;
                    }
                    case "pagecount": {
                        summaryInfo.setPageCount(Integer.parseInt(entry.getValue()));
                        break;
                    }
                    case "revnumber": {
                        summaryInfo.setRevNumber(entry.getValue());
                        break;
                    }
                    case "security": {
                        summaryInfo.setSecurity(Integer.parseInt(entry.getValue()));
                        break;
                    }
                    case "subject": {
                        summaryInfo.setSubject(entry.getValue());
                        break;
                    }
                    case "template": {
                        summaryInfo.setTemplate(entry.getValue());
                        break;
                    }
                    case "title": {
                        summaryInfo.setTitle(entry.getValue());
                        break;
                    }
                    case "wordcount": {
                        summaryInfo.setWordCount(Integer.parseInt(entry.getValue()));
                        break;
                    }
                    default: {
                        LOG.warn((Object)("Unknown metadata key: " + entry.getKey()));
                        break;
                    }
                }
            }
            catch (ParseException pe) {
                LOG.error((Object)pe);
            }
        }
    }

    private void prepareXSSFMetaData() {
        XSSFWorkbook currentXSSFWorkbook = (XSSFWorkbook)this.currentWorkbook;
        POIXMLProperties props = currentXSSFWorkbook.getProperties();
        POIXMLProperties.CoreProperties coreProp = props.getCoreProperties();
        POIXMLProperties.CustomProperties custProp = props.getCustomProperties();
        SimpleDateFormat formatSDF = new SimpleDateFormat("hh:mm:ss dd.MM.yyyy");
        for (Map.Entry<String, String> entry : this.howc.getMetadata().entrySet()) {
            boolean attribMatch = false;
            try {
                switch (entry.getKey()) {
                    case "category": {
                        coreProp.setCategory(entry.getValue());
                        attribMatch = true;
                        break;
                    }
                    case "contentstatus": {
                        coreProp.setContentStatus(entry.getValue());
                        attribMatch = true;
                        break;
                    }
                    case "contenttype": {
                        coreProp.setContentType(entry.getValue());
                        attribMatch = true;
                        break;
                    }
                    case "created": {
                        coreProp.setCreated(Optional.of(formatSDF.parse(entry.getValue())));
                        attribMatch = true;
                        break;
                    }
                    case "creator": {
                        coreProp.setCreator(entry.getValue());
                        attribMatch = true;
                        break;
                    }
                    case "description": {
                        coreProp.setDescription(entry.getValue());
                        attribMatch = true;
                        break;
                    }
                    case "identifier": {
                        coreProp.setIdentifier(entry.getValue());
                        attribMatch = true;
                        break;
                    }
                    case "keywords": {
                        coreProp.setKeywords(entry.getValue());
                        attribMatch = true;
                        break;
                    }
                    case "lastmodifiedbyuser": {
                        coreProp.setLastModifiedByUser(entry.getValue());
                        attribMatch = true;
                        break;
                    }
                    case "lastprinted": {
                        coreProp.setLastPrinted(Optional.of(formatSDF.parse(entry.getValue())));
                        attribMatch = true;
                        break;
                    }
                    case "modified": {
                        coreProp.setModified(Optional.of(formatSDF.parse(entry.getValue())));
                        attribMatch = true;
                        break;
                    }
                    case "revision": {
                        coreProp.setRevision(entry.getValue());
                        attribMatch = true;
                        break;
                    }
                    case "subject": {
                        coreProp.setSubjectProperty(entry.getValue());
                        attribMatch = true;
                        break;
                    }
                    case "title": {
                        coreProp.setTitle(entry.getValue());
                        attribMatch = true;
                        break;
                    }
                }
                if (attribMatch) continue;
                this.processCustomProperties(entry.getKey(), entry.getValue(), custProp);
            }
            catch (ParseException pe) {
                LOG.error((Object)pe);
            }
        }
    }

    private void processCustomProperties(String key, String value, POIXMLProperties.CustomProperties custProp) {
        if (key.startsWith("custom.")) {
            String strippedKey = key.substring("custom.".length());
            if (strippedKey.length() > 0) {
                custProp.addProperty(strippedKey, value);
            }
        } else {
            LOG.warn((Object)("Unknown metadata key: " + key));
        }
    }
}

