/*
 * Decompiled with CFR 0.152.
 */
package org.zuinnote.hadoop.office.format.common;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.Key;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.UnrecoverableEntryException;
import java.security.UnrecoverableKeyException;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.security.spec.InvalidKeySpecException;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Set;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.PBEKeySpec;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.zuinnote.hadoop.office.format.common.HadoopFileReader;

public class HadoopKeyStoreManager {
    private static final Log LOG = LogFactory.getLog((String)HadoopKeyStoreManager.class.getName());
    private KeyStore keystore;
    private HadoopFileReader hfr;
    private FileSystem fs;

    private HadoopKeyStoreManager() {
    }

    public HadoopKeyStoreManager(Configuration conf) throws IOException {
        this.hfr = new HadoopFileReader(conf);
        this.fs = FileSystem.get((Configuration)conf);
    }

    public void openKeyStore(Path path, String keyStoreType, String keyStorePassword) throws IOException, NoSuchAlgorithmException, CertificateException, KeyStoreException {
        this.keystore = KeyStore.getInstance(keyStoreType);
        if (path != null) {
            InputStream keyStoreInputStream = this.hfr.openFile(path);
            this.keystore.load(keyStoreInputStream, keyStorePassword.toCharArray());
        } else {
            this.keystore.load(null, keyStorePassword.toCharArray());
        }
    }

    public Key getPrivateKey(String alias, String password) throws UnrecoverableKeyException, KeyStoreException, NoSuchAlgorithmException {
        return this.keystore.getKey(alias, password.toCharArray());
    }

    public Certificate getCertificate(String alias) throws KeyStoreException {
        return this.keystore.getCertificate(alias);
    }

    public String getPassword(String alias, String passwordPassword) throws NoSuchAlgorithmException, UnrecoverableEntryException, KeyStoreException, InvalidKeySpecException {
        SecretKey sk = (SecretKey)this.keystore.getKey(alias, passwordPassword.toCharArray());
        return new String(sk.getEncoded());
    }

    public void setPassword(String alias, String password, String passwordPassword) throws NoSuchAlgorithmException, InvalidKeySpecException, KeyStoreException {
        SecretKeyFactory skf = SecretKeyFactory.getInstance("PBE");
        SecretKey pSecret = skf.generateSecret(new PBEKeySpec(password.toCharArray()));
        KeyStore.PasswordProtection kspp = new KeyStore.PasswordProtection(passwordPassword.toCharArray());
        this.keystore.setEntry(alias, new KeyStore.SecretKeyEntry(pSecret), kspp);
    }

    public void store(Path path, String keyStorePassword) throws KeyStoreException, NoSuchAlgorithmException, CertificateException, IOException {
        FSDataOutputStream os = this.fs.create(path, true);
        this.keystore.store((OutputStream)os, keyStorePassword.toCharArray());
        if (os != null) {
            os.close();
        }
    }

    public Set<X509Certificate> getAllX509Certificates() throws KeyStoreException {
        HashSet<X509Certificate> result = new HashSet<X509Certificate>();
        Enumeration<String> enumAlias = this.keystore.aliases();
        while (enumAlias.hasMoreElements()) {
            Certificate currentCert = this.keystore.getCertificate(enumAlias.nextElement());
            if (!(currentCert instanceof X509Certificate)) continue;
            LOG.debug((Object)((X509Certificate)currentCert).getSubjectDN().getName());
            result.add((X509Certificate)currentCert);
        }
        return result;
    }
}

