/*
 * Decompiled with CFR 0.152.
 */
package org.zuinnote.hadoop.office.format.common;

import java.io.Serializable;
import java.security.cert.X509Certificate;
import java.text.DateFormat;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.text.SimpleDateFormat;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.apache.hadoop.conf.Configuration;
import org.zuinnote.hadoop.office.format.common.HadoopUtil;

public class HadoopOfficeReadConfiguration
implements Serializable {
    private static final long serialVersionUID = 8028549445862365699L;
    public static final String PREFIX_UNKNOWN_COL = "Col";
    public static final String CONF_MIMETYPE = "hadoopoffice.read.mimeType";
    public static final String CONF_SHEETS = "hadoopoffice.read.sheets";
    public static final String CONF_LOCALE = "hadoopoffice.read.locale.bcp47";
    public static final String CONF_LINKEDWB = "hadoopoffice.read.linkedworkbooks";
    public static final String CONF_LINKEDWB_LOCATION = "hadoopoffice.read.linkedworkbooks.location";
    public static final String CONF_IGNOREMISSINGWB = "hadoopoffice.read.ignoremissinglinkedworkbooks";
    public static final String CONF_DECRYPT = "hadoopoffice.read.security.crypt.password";
    public static final String CONF_DECRYPTLINKEDWBBASE = "hadoopoffice.read.security.crypt.linkedworkbooks.";
    public static final String CONF_FILTERMETADATA = "hadoopoffice.read.filter.metadata.";
    public static final String CONF_LOWFOOTPRINT = "hadoopoffice.read.lowFootprint";
    public static final String CONF_LOWFOOTPRINT_PARSER = "hadoopoffice.read.lowFootprint.parser";
    public static final String CONF_LOWFOOTPRINT_STAX_CACHE = "hadoopoffice.read.lowFootprint.stax.sst.cache";
    public static final String CONF_LOWFOOTPRINT_STAX_COMPRESS = "hadoopoffice.read.lowFootprint.stax.sst.compress";
    public static final String CONF_CRYKEYSTOREFILE = "hadoopoffice.read.security.crypt.credential.keystore.file";
    public static final String CONF_CRYKEYSTORETYPE = "hadoopoffice.read.security.crypt.credential.keystore.type";
    public static final String CONF_CRYKEYSTOREPW = "hadoopoffice.read.security.crypt.credential.keystore.password";
    public static final String CONF_CRYKEYSTOREALIAS = "hadoopoffice.read.security.crypt.credential.keystore.alias";
    public static final String CONF_VERIFYSIGNATURE = "hadoopoffice.read.security.sign.verifysignature";
    public static final String CONF_SIGTRUSTFILE = "hadoopoffice.read.security.sign.truststore.file";
    public static final String CONF_SIGTRUSTTYPE = "hadoopoffice.read.security.sign.truststore.type";
    public static final String CONF_SIGTRUSTPW = "hadoopoffice.read.security.sign.truststore.password";
    public static final String CONF_READHEADER = "hadoopoffice.read.header.read";
    public static final String CONF_HEADERIGNOREHEADERALLSHEETS = "hadoopoffice.read.header.skipheaderinallsheets";
    public static final String CONF_SKIPLINES = "hadoopoffice.read.sheet.skiplines.num";
    public static final String CONF_SKIPLINESALLSHEETS = "hadoopoffice.read.sheet.skiplines.allsheets";
    public static final String CONF_COLUMNNAMESREGEX = "hadoopoffice.read.header.column.names.regex";
    public static final String CONF_COLUMNNAMESREPLACE = "hadoopoffice.read.header.column.names.replace";
    public static final String CONF_EMULATECSV = "hadoopoffice.read.emulateCSV";
    public static final String CONF_SIMPLEDATEFORMAT = "hadoopoffice.read.simple.dateFormat";
    public static final String CONF_SIMPLEDATEPATTERN = "hadoopoffice.read.simple.datePattern";
    public static final String CONF_SIMPLEDATETIMEFORMAT = "hadoopoffice.read.simple.dateTimeFormat";
    public static final String CONF_SIMPLEDATETIMEPATTERN = "hadoopoffice.read.simple.dateTimePattern";
    public static final String CONF_SIMPLEDECIMALFORMAT = "hadoopoffice.read.simple.decimalFormat";
    public static final String OPTION_LOWFOOTPRINT_PARSER_STAX = "stax";
    public static final String OPTION_LOWFOOTPRINT_PARSER_SAX = "sax";
    public static final String DEFAULT_MIMETYPE = "";
    public static final String DEFAULT_LOCALE = "";
    public static final String DEFAULT_SHEETS = "";
    public static final boolean DEFAULT_LINKEDWB = false;
    public static final String DEFAULT_LINKEDWB_LOCATION = "";
    public static final boolean DEFAULT_IGNOREMISSINGLINKEDWB = false;
    public static final boolean DEFAULT_LOWFOOTPRINT = false;
    public static final String DEFAULT_CRYKEYSTOREFILE = "";
    public static final String DEFAULT_LOWFOOTPRINT_PARSER = "stax";
    public static final int DEFAULT_LOWFOOTPRINT_STAX_CACHE = 10000;
    public static final boolean DEFAULT_LOWFOOTPRINT_STAX_COMPRESS = false;
    public static final String DEFAULT_CRYKEYSTORETYPE = "JCEKS";
    public static final String DEFAULT_CRYKEYSTOREPW = "";
    public static final String DEFAULT_CRYKEYSTOREALIAS = "";
    public static final boolean DEFAULT_VERIFYSIGNATURE = false;
    public static final String DEFAULT_SIGTRUSTFILE = "";
    public static final String DEFAULT_SIGTRUSTTYPE = "JKS";
    public static final String DEFAULT_SIGTRUSTPW = "";
    public static final boolean DEFAULT_READHEADER = false;
    public static final boolean DEFAULT_HEADERIGNOREHEADERALLSHEETS = false;
    public static final Integer DEFAULT_SKIPLINES = 0;
    public static final boolean DEFAULT_SKIPLINESALLSHEETS = false;
    public static final String DEFAULT_COLUMNNAMESREGEX = "";
    public static final String DEFAULT_COLUMNNAMESREPLACE = "";
    public static final String DEFAULT_SIMPLEDATEFORMAT = "US";
    public static final String DEFAULT_SIMPLEDATEPATTERN = "";
    public static final String DEFAULT_SIMPLEDATETIMEFORMAT = "US";
    public static final String DEFAULT_SIMPLEDATETIMEPATTERN = "";
    public static final String DEFAULT_SIMPLEDECIMALFORMAT = "";
    public static final boolean DEFAULT_EMULATECSV = false;
    private String fileName;
    private String mimeType = null;
    private String localeStrBCP47 = null;
    private String sheets = null;
    private Locale locale = null;
    private boolean readLinkedWorkbooks = false;
    private String linkedWorkbookLocation;
    private boolean ignoreMissingLinkedWorkbooks = false;
    private String password = null;
    private Map<String, String> metadataFilter;
    private Map<String, String> linkedWBCredentialMap;
    private boolean lowFootprint;
    private String lowFootprintParser;
    private String cryptKeystoreFile;
    private String cryptKeystoreType;
    private String cryptKeystorePassword;
    private String cryptKeystoreAlias;
    private boolean verifySignature;
    private String sigTruststoreFile;
    private String sigTruststoreType;
    private String sigTruststorePassword;
    private Set<X509Certificate> x509CertificateChain;
    private boolean readHeader;
    private boolean ignoreHeaderInAllSheets;
    private int skipLines;
    private boolean skipLinesAllSheets;
    private String columnNameRegex;
    private String columnNameReplace;
    private SimpleDateFormat simpleDateFormat;
    private SimpleDateFormat simpleDateTimeFormat;
    private DecimalFormat simpleDecimalFormat;
    private int sstCacheSize;
    private boolean compressSST;
    private boolean emulateCSV;

    public HadoopOfficeReadConfiguration() {
        this.mimeType = "";
        this.sheets = "";
        this.localeStrBCP47 = "";
        this.locale = !"".equals(this.localeStrBCP47) ? new Locale.Builder().setLanguageTag(this.localeStrBCP47).build() : Locale.getDefault();
        this.readLinkedWorkbooks = false;
        this.ignoreMissingLinkedWorkbooks = false;
        this.setLinkedWorkbookLocation("");
        this.password = null;
        this.setCryptKeystoreFile("");
        this.setCryptKeystoreType(DEFAULT_CRYKEYSTORETYPE);
        this.setCryptKeystorePassword("");
        this.setCryptKeystoreAlias("");
        this.setVerifySignature(false);
        this.setSigTruststoreFile("");
        this.setSigTruststoreType(DEFAULT_SIGTRUSTTYPE);
        this.setSigTruststorePassword("");
        this.setReadHeader(false);
        this.setIgnoreHeaderInAllSheets(false);
        this.setSkipLines(DEFAULT_SKIPLINES);
        this.setSkipLinesAllSheets(false);
        this.setColumnNameRegex("");
        this.setColumnNameReplace("");
        this.lowFootprint = false;
        this.setLowFootprintParser("stax");
        this.setEmulateCSV(false);
        Locale dateLocale = Locale.getDefault();
        if (!"".equals("US")) {
            dateLocale = new Locale.Builder().setLanguageTag("US").build();
        }
        this.setSimpleDateFormat((SimpleDateFormat)DateFormat.getDateInstance(3, dateLocale));
        Locale dateTimeLocale = Locale.getDefault();
        if (!"".equals("US")) {
            dateTimeLocale = new Locale.Builder().setLanguageTag("US").build();
        }
        this.setSimpleDateTimeFormat((SimpleDateFormat)DateFormat.getDateTimeInstance(3, 3, dateTimeLocale));
        if (!"".equals("")) {
            this.setSimpleDateFormat(new SimpleDateFormat(""));
        }
        if (!"".equals("")) {
            this.setSimpleDateTimeFormat(new SimpleDateFormat(""));
        }
        Locale decimallocale = Locale.getDefault();
        if (!"".equals("")) {
            decimallocale = new Locale.Builder().setLanguageTag("").build();
        }
        this.setSimpleDecimalFormat((DecimalFormat)NumberFormat.getInstance(decimallocale));
        this.setX509CertificateChain(new HashSet<X509Certificate>());
        this.setSstCacheSize(10000);
        this.setCompressSST(false);
    }

    public HadoopOfficeReadConfiguration(Configuration conf) {
        String dateTimePattern;
        this.mimeType = conf.get(CONF_MIMETYPE, "");
        this.sheets = conf.get(CONF_SHEETS, "");
        this.localeStrBCP47 = conf.get(CONF_LOCALE, "");
        if (!"".equals(this.localeStrBCP47)) {
            this.locale = new Locale.Builder().setLanguageTag(this.localeStrBCP47).build();
        }
        this.readLinkedWorkbooks = conf.getBoolean(CONF_LINKEDWB, false);
        this.ignoreMissingLinkedWorkbooks = conf.getBoolean(CONF_IGNOREMISSINGWB, false);
        this.linkedWorkbookLocation = conf.get(CONF_LINKEDWB_LOCATION, "");
        this.password = conf.get(CONF_DECRYPT);
        this.metadataFilter = HadoopUtil.parsePropertiesFromBase(conf, CONF_FILTERMETADATA);
        this.linkedWBCredentialMap = HadoopUtil.parsePropertiesFromBase(conf, CONF_DECRYPTLINKEDWBBASE);
        this.lowFootprint = conf.getBoolean(CONF_LOWFOOTPRINT, false);
        this.setCryptKeystoreFile(conf.get(CONF_CRYKEYSTOREFILE, ""));
        this.setCryptKeystoreType(conf.get(CONF_CRYKEYSTORETYPE, DEFAULT_CRYKEYSTORETYPE));
        this.setCryptKeystorePassword(conf.get(CONF_CRYKEYSTOREPW, ""));
        this.setCryptKeystoreAlias(conf.get(CONF_CRYKEYSTOREALIAS, ""));
        this.setVerifySignature(conf.getBoolean(CONF_VERIFYSIGNATURE, false));
        this.setSigTruststoreFile(conf.get(CONF_SIGTRUSTFILE, ""));
        this.setSigTruststoreType(conf.get(CONF_SIGTRUSTTYPE, DEFAULT_SIGTRUSTTYPE));
        this.setSigTruststorePassword(conf.get(CONF_SIGTRUSTPW, ""));
        this.setLowFootprintParser(conf.get(CONF_LOWFOOTPRINT_PARSER, "stax"));
        this.setReadHeader(conf.getBoolean(CONF_READHEADER, false));
        this.setIgnoreHeaderInAllSheets(conf.getBoolean(CONF_HEADERIGNOREHEADERALLSHEETS, false));
        this.setSkipLines(conf.getInt(CONF_SKIPLINES, DEFAULT_SKIPLINES.intValue()));
        this.setSkipLinesAllSheets(conf.getBoolean(CONF_SKIPLINESALLSHEETS, false));
        this.setColumnNameRegex(conf.get(CONF_COLUMNNAMESREGEX, ""));
        this.setColumnNameReplace(conf.get(CONF_COLUMNNAMESREPLACE, ""));
        Locale dateLocale = new Locale.Builder().setLanguageTag(conf.get(CONF_SIMPLEDATEFORMAT, "US")).build();
        this.setSimpleDateFormat((SimpleDateFormat)DateFormat.getDateInstance(3, dateLocale));
        Locale dateTimeLocale = new Locale.Builder().setLanguageTag(conf.get(CONF_SIMPLEDATETIMEFORMAT, "US")).build();
        this.setSimpleDateTimeFormat((SimpleDateFormat)DateFormat.getDateTimeInstance(3, 3, dateTimeLocale));
        String datePattern = conf.get(CONF_SIMPLEDATEPATTERN, "");
        if (!"".equals(datePattern)) {
            this.setSimpleDateFormat(new SimpleDateFormat(datePattern));
        }
        if (!"".equals(dateTimePattern = conf.get(CONF_SIMPLEDATETIMEPATTERN, ""))) {
            this.setSimpleDateFormat(new SimpleDateFormat(dateTimePattern));
        }
        String decimaleStr = conf.get(CONF_SIMPLEDECIMALFORMAT, "");
        Locale decimallocale = Locale.getDefault();
        if (!"".equals(decimaleStr)) {
            decimallocale = new Locale.Builder().setLanguageTag(decimaleStr).build();
        }
        this.setSimpleDecimalFormat((DecimalFormat)NumberFormat.getInstance(decimallocale));
        this.setEmulateCSV(conf.getBoolean(CONF_EMULATECSV, false));
        this.setX509CertificateChain(new HashSet<X509Certificate>());
        this.setSstCacheSize(conf.getInt(CONF_LOWFOOTPRINT_STAX_CACHE, 10000));
        this.setCompressSST(conf.getBoolean(CONF_LOWFOOTPRINT_STAX_COMPRESS, false));
    }

    public String getSheets() {
        return this.sheets;
    }

    public void setSheets(String sheets) {
        this.sheets = sheets;
    }

    public String getMimeType() {
        return this.mimeType;
    }

    public void setMimeType(String mimeType) {
        this.mimeType = mimeType;
    }

    public Locale getLocale() {
        return this.locale;
    }

    public void setLocale(Locale locale) {
        this.locale = locale;
    }

    public boolean getReadLinkedWorkbooks() {
        return this.readLinkedWorkbooks;
    }

    public void setReadLinkedWorkbooks(boolean readLinkedWorkbooks) {
        this.readLinkedWorkbooks = readLinkedWorkbooks;
    }

    public boolean getIgnoreMissingLinkedWorkbooks() {
        return this.ignoreMissingLinkedWorkbooks;
    }

    public void setIgnoreMissingLinkedWorkbooks(boolean ignoreMissingLinkedWorkbooks) {
        this.ignoreMissingLinkedWorkbooks = ignoreMissingLinkedWorkbooks;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public Map<String, String> getMetaDataFilter() {
        return this.metadataFilter;
    }

    public void setMetaDataFilter(Map<String, String> metadataFilter) {
        this.metadataFilter = metadataFilter;
    }

    public Map<String, String> getLinkedWBCredentialMap() {
        return this.linkedWBCredentialMap;
    }

    public void setLinkedWBCredentialMap(Map<String, String> linkedWBCredentialMap) {
        this.linkedWBCredentialMap = linkedWBCredentialMap;
    }

    public String getFileName() {
        return this.fileName;
    }

    public void setFileName(String fileName) {
        this.fileName = fileName;
    }

    public boolean getLowFootprint() {
        return this.lowFootprint;
    }

    public void setLowFootprint(boolean lowFootprint) {
        this.lowFootprint = lowFootprint;
    }

    public boolean getVerifySignature() {
        return this.verifySignature;
    }

    public void setVerifySignature(boolean verifySignature) {
        this.verifySignature = verifySignature;
    }

    public String getCryptKeystoreFile() {
        return this.cryptKeystoreFile;
    }

    public void setCryptKeystoreFile(String cryptKeystoreFile) {
        this.cryptKeystoreFile = cryptKeystoreFile;
    }

    public String getCryptKeystoreType() {
        return this.cryptKeystoreType;
    }

    public void setCryptKeystoreType(String cryptKeystoreType) {
        this.cryptKeystoreType = cryptKeystoreType;
    }

    public String getCryptKeystorePassword() {
        return this.cryptKeystorePassword;
    }

    public void setCryptKeystorePassword(String cryptKeystorePassword) {
        this.cryptKeystorePassword = cryptKeystorePassword;
    }

    public String getCryptKeystoreAlias() {
        return this.cryptKeystoreAlias;
    }

    public void setCryptKeystoreAlias(String cryptKeystoreAlias) {
        this.cryptKeystoreAlias = cryptKeystoreAlias;
    }

    public String getSigTruststoreFile() {
        return this.sigTruststoreFile;
    }

    public void setSigTruststoreFile(String sigTruststoreFile) {
        this.sigTruststoreFile = sigTruststoreFile;
    }

    public String getSigTruststoreType() {
        return this.sigTruststoreType;
    }

    public void setSigTruststoreType(String sigTruststoreType) {
        this.sigTruststoreType = sigTruststoreType;
    }

    public String getSigTruststorePassword() {
        return this.sigTruststorePassword;
    }

    public void setSigTruststorePassword(String sigTruststorePassword) {
        this.sigTruststorePassword = sigTruststorePassword;
    }

    public Set<X509Certificate> getX509CertificateChain() {
        return this.x509CertificateChain;
    }

    public void setX509CertificateChain(Set<X509Certificate> x509CertificateChain) {
        this.x509CertificateChain = x509CertificateChain;
    }

    public boolean getReadHeader() {
        return this.readHeader;
    }

    public void setReadHeader(boolean readHeader) {
        this.readHeader = readHeader;
    }

    public boolean getIgnoreHeaderInAllSheets() {
        return this.ignoreHeaderInAllSheets;
    }

    public void setIgnoreHeaderInAllSheets(boolean ignoreHeaderInAllSheets) {
        this.ignoreHeaderInAllSheets = ignoreHeaderInAllSheets;
    }

    public int getSkipLines() {
        return this.skipLines;
    }

    public void setSkipLines(int skipLines) {
        this.skipLines = skipLines;
    }

    public boolean getSkipLinesAllSheets() {
        return this.skipLinesAllSheets;
    }

    public void setSkipLinesAllSheets(boolean skipLinesAllSheets) {
        this.skipLinesAllSheets = skipLinesAllSheets;
    }

    public String getLowFootprintParser() {
        return this.lowFootprintParser;
    }

    public void setLowFootprintParser(String lowFootprintParser) {
        this.lowFootprintParser = lowFootprintParser;
    }

    public String getColumnNameRegex() {
        return this.columnNameRegex;
    }

    public void setColumnNameRegex(String columnNameRegex) {
        this.columnNameRegex = columnNameRegex;
    }

    public String getColumnNameReplace() {
        return this.columnNameReplace;
    }

    public void setColumnNameReplace(String columnNameReplace) {
        this.columnNameReplace = columnNameReplace;
    }

    public SimpleDateFormat getSimpleDateFormat() {
        return this.simpleDateFormat;
    }

    public void setSimpleDateFormat(SimpleDateFormat simpleDateFormat) {
        this.simpleDateFormat = simpleDateFormat;
    }

    public SimpleDateFormat getSimpleDateTimeFormat() {
        return this.simpleDateTimeFormat;
    }

    public void setSimpleDateTimeFormat(SimpleDateFormat simpleDateTimeFormat) {
        this.simpleDateTimeFormat = simpleDateTimeFormat;
    }

    public DecimalFormat getSimpleDecimalFormat() {
        return this.simpleDecimalFormat;
    }

    public void setSimpleDecimalFormat(DecimalFormat simpleDecimalFormat) {
        this.simpleDecimalFormat = simpleDecimalFormat;
    }

    public int getSstCacheSize() {
        return this.sstCacheSize;
    }

    public void setSstCacheSize(int sstCacheSize) {
        this.sstCacheSize = sstCacheSize;
    }

    public boolean getCompressSST() {
        return this.compressSST;
    }

    public void setCompressSST(boolean compressSST) {
        this.compressSST = compressSST;
    }

    public boolean getEmulateCSV() {
        return this.emulateCSV;
    }

    public void setEmulateCSV(boolean emulateCSV) {
        this.emulateCSV = emulateCSV;
    }

    public String getLinkedWorkbookLocation() {
        return this.linkedWorkbookLocation;
    }

    public void setLinkedWorkbookLocation(String linkedWorkbookLocation) {
        this.linkedWorkbookLocation = linkedWorkbookLocation;
    }
}

