/*
 * Decompiled with CFR 0.152.
 */
package org.zuinnote.hadoop.office.format.common.writer.msexcel;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.GeneralSecurityException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import javax.xml.crypto.MarshalException;
import javax.xml.crypto.dsig.XMLSignatureException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.poi.poifs.crypt.ChainingMode;
import org.apache.poi.poifs.crypt.CipherAlgorithm;
import org.apache.poi.poifs.crypt.EncryptionInfo;
import org.apache.poi.poifs.crypt.EncryptionMode;
import org.apache.poi.poifs.crypt.Encryptor;
import org.apache.poi.poifs.crypt.HashAlgorithm;
import org.apache.poi.poifs.filesystem.POIFSFileSystem;
import org.apache.poi.ss.usermodel.ClientAnchor;
import org.apache.poi.ss.usermodel.Comment;
import org.apache.poi.ss.usermodel.Drawing;
import org.apache.poi.ss.usermodel.FormulaEvaluator;
import org.apache.poi.ss.util.CellAddress;
import org.apache.poi.ss.util.WorkbookUtil;
import org.apache.poi.xssf.streaming.SXSSFCell;
import org.apache.poi.xssf.streaming.SXSSFRow;
import org.apache.poi.xssf.streaming.SXSSFSheet;
import org.zuinnote.hadoop.office.format.common.HadoopOfficeWriteConfiguration;
import org.zuinnote.hadoop.office.format.common.dao.SpreadSheetCellDAO;
import org.zuinnote.hadoop.office.format.common.parser.FormatNotUnderstoodException;
import org.zuinnote.hadoop.office.format.common.util.msexcel.MSExcelOOXMLSignUtil;
import org.zuinnote.hadoop.office.format.common.writer.InvalidWriterConfigurationException;
import org.zuinnote.hadoop.office.format.common.writer.OfficeSpreadSheetWriterInterface;
import org.zuinnote.hadoop.office.format.common.writer.OfficeWriterException;
import org.zuinnote.hadoop.office.format.common.writer.msexcel.MSExcelWriter;
import org.zuinnote.hadoop.office.format.common.writer.msexcel.internal.SecureSXSSFWorkbook;

public class MSExcelLowFootprintWriter
implements OfficeSpreadSheetWriterInterface {
    private static final Log LOG = LogFactory.getLog((String)MSExcelLowFootprintWriter.class.getName());
    private SecureSXSSFWorkbook currentWorkbook;
    private String format;
    private HadoopOfficeWriteConfiguration howc;
    private CipherAlgorithm encryptAlgorithmCipher;
    private HashAlgorithm hashAlgorithmCipher;
    private EncryptionMode encryptionModeCipher;
    private ChainingMode chainModeCipher;
    private OutputStream osStream;
    private Map<String, Drawing> mappedDrawings;
    private MSExcelOOXMLSignUtil signUtil;
    private FormulaEvaluator currentFormulaEvaluator;

    public MSExcelLowFootprintWriter(String excelFormat, HadoopOfficeWriteConfiguration howc) throws InvalidWriterConfigurationException {
        boolean formatFound = MSExcelWriter.isSupportedFormat(excelFormat);
        if (!formatFound) {
            LOG.error((Object)("Unknown Excel format: " + this.format));
            throw new InvalidWriterConfigurationException("Unknown Excel format: " + this.format);
        }
        this.format = excelFormat;
        this.howc = howc;
        if (this.howc.getPassword() != null) {
            this.encryptAlgorithmCipher = MSExcelWriter.getAlgorithmCipher(this.howc.getEncryptAlgorithm());
            this.hashAlgorithmCipher = MSExcelWriter.getHashAlgorithm(this.howc.getHashAlgorithm());
            this.encryptionModeCipher = MSExcelWriter.getEncryptionModeCipher(this.howc.getEncryptMode());
            this.chainModeCipher = MSExcelWriter.getChainMode(this.howc.getChainMode());
        }
    }

    @Override
    public void create(OutputStream osStream, Map<String, InputStream> linkedWorkbooks, Map<String, String> linkedWorkbooksPasswords, InputStream template) throws OfficeWriterException {
        if (linkedWorkbooks != null && linkedWorkbooks.size() > 0) {
            throw new OfficeWriterException("Linked Workbooks are not supported in low footprint write mode");
        }
        if (template != null) {
            throw new OfficeWriterException("Templates are not supported in low footprint write mode");
        }
        this.osStream = osStream;
        this.currentWorkbook = new SecureSXSSFWorkbook(this.howc.getLowFootprintCacheRows(), this.encryptAlgorithmCipher, this.chainModeCipher);
        this.currentFormulaEvaluator = this.currentWorkbook.getCreationHelper().createFormulaEvaluator();
        this.mappedDrawings = new HashMap<String, Drawing>();
        if (this.howc.getSigKey() != null) {
            LOG.info((Object)"Creating tempfile for signing");
            try {
                this.signUtil = new MSExcelOOXMLSignUtil(this.osStream);
            }
            catch (IOException e) {
                LOG.error((Object)("Cannot create sign utilities " + e));
                throw new OfficeWriterException(e.toString());
            }
        }
    }

    @Override
    public void write(Object newDAO) throws OfficeWriterException {
        if (newDAO != null) {
            SXSSFCell currentCell;
            CellAddress currentCA;
            SXSSFRow currentRow;
            SpreadSheetCellDAO sscd = MSExcelWriter.checkSpreadSheetCellDAO(newDAO);
            String safeSheetName = WorkbookUtil.createSafeSheetName(sscd.getSheetName());
            SXSSFSheet currentSheet = this.currentWorkbook.getSheet(safeSheetName);
            if (currentSheet == null) {
                currentSheet = this.currentWorkbook.createSheet(safeSheetName);
                if (!safeSheetName.equals(sscd.getSheetName())) {
                    LOG.warn((Object)("Sheetname modified from \"" + sscd.getSheetName() + "\" to \"" + safeSheetName + "\" to correspond to Excel conventions."));
                }
                this.mappedDrawings.put(safeSheetName, currentSheet.createDrawingPatriarch());
            }
            if ((currentRow = currentSheet.getRow((currentCA = new CellAddress(sscd.getAddress())).getRow())) == null) {
                currentRow = currentSheet.createRow(currentCA.getRow());
            }
            if ((currentCell = currentRow.getCell(currentCA.getColumn())) != null) {
                throw new OfficeWriterException("Invalid cell specification: cell already exists at " + currentCA);
            }
            currentCell = currentRow.createCell(currentCA.getColumn());
            if (!"".equals(sscd.getFormula())) {
                currentCell.setCellFormula(sscd.getFormula());
                this.currentFormulaEvaluator.evaluateFormulaCell(currentCell);
            } else {
                currentCell.setCellValue(sscd.getFormattedValue());
            }
            if (sscd.getComment() != null && !"".equals(sscd.getComment())) {
                ClientAnchor anchor = this.currentWorkbook.getCreationHelper().createClientAnchor();
                anchor.setCol1(currentCell.getColumnIndex());
                anchor.setCol2(currentCell.getColumnIndex() + this.howc.getCommentWidth());
                anchor.setRow1(currentRow.getRowNum());
                anchor.setRow2(currentRow.getRowNum() + this.howc.getCommentHeight());
                Comment currentComment = this.mappedDrawings.get(safeSheetName).createCellComment(anchor);
                currentComment.setString(this.currentWorkbook.getCreationHelper().createRichTextString(sscd.getComment()));
                currentComment.setAuthor(this.howc.getCommentAuthor());
                currentCell.setCellComment(currentComment);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws IOException {
        if (this.howc.getPassword() == null) {
            if (this.signUtil != null) {
                this.currentWorkbook.write(this.signUtil.getTempOutputStream());
            } else {
                this.currentWorkbook.write(this.osStream);
                if (this.osStream != null) {
                    this.osStream.close();
                }
            }
        } else {
            POIFSFileSystem fs = new POIFSFileSystem();
            EncryptionInfo info = new EncryptionInfo(this.encryptionModeCipher, this.encryptAlgorithmCipher, this.hashAlgorithmCipher, -1, -1, this.chainModeCipher);
            Encryptor enc = info.getEncryptor();
            enc.confirmPassword(this.howc.getPassword());
            try {
                OutputStream os = enc.getDataStream(fs);
                if (os != null) {
                    this.currentWorkbook.write(os);
                }
                if (os != null) {
                    os.close();
                }
            }
            catch (GeneralSecurityException e) {
                LOG.error((Object)e);
                throw new IOException(e);
            }
            if (this.signUtil != null) {
                fs.writeFilesystem(this.signUtil.getTempOutputStream());
            } else {
                fs.writeFilesystem(this.osStream);
                if (this.osStream != null) {
                    this.osStream.close();
                }
            }
            if (fs != null) {
                fs.close();
            }
        }
        this.currentWorkbook.dispose();
        try {
            if (this.signUtil != null) {
                LOG.info((Object)("Signing document \"" + this.howc.getFileName() + "\""));
                if (this.howc.getSigCertificate() == null) {
                    LOG.error((Object)("Cannot sign document \"" + this.howc.getFileName() + "\". No certificate for key provided"));
                } else {
                    try {
                        ArrayList<X509Certificate> certList = new ArrayList<X509Certificate>();
                        certList.add(this.howc.getSigCertificate());
                        this.signUtil.sign(this.howc.getSigKey(), certList, this.howc.getPassword(), MSExcelWriter.getHashAlgorithm(this.howc.getSigHash()));
                    }
                    catch (IOException | MarshalException | XMLSignatureException | FormatNotUnderstoodException e) {
                        LOG.error((Object)("Cannot sign document \"" + this.howc.getFileName() + "\" " + e));
                    }
                }
            }
        }
        finally {
            if (this.signUtil != null) {
                this.signUtil.close();
            }
        }
    }
}

