/*
 * Decompiled with CFR 0.152.
 */
package org.zuinnote.hadoop.office.format.mapred;

import java.io.IOException;
import java.io.InputStream;
import java.security.GeneralSecurityException;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.UnrecoverableEntryException;
import java.security.cert.CertificateException;
import java.security.spec.InvalidKeySpecException;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.Seekable;
import org.apache.hadoop.io.compress.CodecPool;
import org.apache.hadoop.io.compress.CompressionCodec;
import org.apache.hadoop.io.compress.CompressionCodecFactory;
import org.apache.hadoop.io.compress.Decompressor;
import org.apache.hadoop.io.compress.SplitCompressionInputStream;
import org.apache.hadoop.io.compress.SplittableCompressionCodec;
import org.apache.hadoop.mapred.FileSplit;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.RecordReader;
import org.apache.hadoop.mapred.Reporter;
import org.zuinnote.hadoop.office.format.common.HadoopFileReader;
import org.zuinnote.hadoop.office.format.common.HadoopKeyStoreManager;
import org.zuinnote.hadoop.office.format.common.HadoopOfficeReadConfiguration;
import org.zuinnote.hadoop.office.format.common.OfficeReader;
import org.zuinnote.hadoop.office.format.common.parser.FormatNotUnderstoodException;

public abstract class AbstractSpreadSheetDocumentRecordReader<K, V>
implements RecordReader<K, V> {
    private static final Log LOG = LogFactory.getLog((String)AbstractSpreadSheetDocumentRecordReader.class.getName());
    private OfficeReader officeReader = null;
    private CompressionCodec codec;
    private CompressionCodecFactory compressionCodecs = null;
    private Decompressor decompressor;
    private Configuration conf;
    private long start;
    private long end;
    private final Seekable filePosition;
    private HadoopFileReader currentHFR;
    private HadoopOfficeReadConfiguration hocr;
    private Reporter reporter;

    public AbstractSpreadSheetDocumentRecordReader(FileSplit split, JobConf job, Reporter reporter) throws IOException, FormatNotUnderstoodException, GeneralSecurityException {
        this.conf = job;
        this.reporter = reporter;
        this.reporter.setStatus("Initialize Configuration");
        this.hocr = new HadoopOfficeReadConfiguration(this.conf);
        this.start = split.getStart();
        this.end = this.start + split.getLength();
        Path file = split.getPath();
        this.hocr.setFileName(file.getName());
        this.readKeyStore((Configuration)job);
        this.readTrustStore((Configuration)job);
        this.compressionCodecs = new CompressionCodecFactory((Configuration)job);
        this.codec = this.compressionCodecs.getCodec(file);
        FSDataInputStream fileIn = file.getFileSystem((Configuration)job).open(file);
        if (this.isCompressedInput()) {
            this.decompressor = CodecPool.getDecompressor((CompressionCodec)this.codec);
            if (this.codec instanceof SplittableCompressionCodec) {
                LOG.debug((Object)("Reading from a compressed file \"" + file + "\" with splittable compression codec"));
                SplitCompressionInputStream cIn = ((SplittableCompressionCodec)this.codec).createInputStream((InputStream)fileIn, this.decompressor, this.start, this.end, SplittableCompressionCodec.READ_MODE.CONTINUOUS);
                this.officeReader = new OfficeReader((InputStream)cIn, this.hocr);
                this.start = cIn.getAdjustedStart();
                this.end = cIn.getAdjustedEnd();
                this.filePosition = cIn;
            } else {
                LOG.debug((Object)("Reading from a compressed file \"" + file + "\" with non-splittable compression codec"));
                this.officeReader = new OfficeReader((InputStream)this.codec.createInputStream((InputStream)fileIn, this.decompressor), this.hocr);
                this.filePosition = fileIn;
            }
        } else {
            LOG.debug((Object)("Reading from an uncompressed file \"" + file + "\""));
            fileIn.seek(this.start);
            this.officeReader = new OfficeReader((InputStream)fileIn, this.hocr);
            this.filePosition = fileIn;
        }
        this.reporter.setStatus("Parsing document");
        this.officeReader.parse();
        this.reporter.setStatus("Reading linked documents");
        if (this.hocr.getReadLinkedWorkbooks()) {
            Path currentPath = split.getPath();
            Path parentPath = currentPath.getParent();
            if (!"".equals(this.hocr.getLinkedWorkbookLocation())) {
                parentPath = new Path(this.hocr.getLinkedWorkbookLocation());
            }
            List<String> linkedWorkbookList = this.officeReader.getCurrentParser().getLinkedWorkbooks();
            this.currentHFR = new HadoopFileReader((Configuration)job);
            for (String listItem : linkedWorkbookList) {
                LOG.info((Object)("Adding linked workbook \"" + listItem + "\""));
                String sanitizedListItem = new Path(listItem).getName();
                Path currentFile = new Path(parentPath, sanitizedListItem);
                InputStream currentIn = this.currentHFR.openFile(currentFile);
                this.officeReader.getCurrentParser().addLinkedWorkbook(listItem, currentIn, this.hocr.getLinkedWBCredentialMap().get(sanitizedListItem));
            }
        }
    }

    private void readKeyStore(Configuration conf) throws IOException, FormatNotUnderstoodException {
        if (this.hocr.getCryptKeystoreFile() != null && !"".equals(this.hocr.getCryptKeystoreFile())) {
            LOG.info((Object)"Using keystore to obtain credentials instead of passwords");
            HadoopKeyStoreManager hksm = new HadoopKeyStoreManager(conf);
            try {
                hksm.openKeyStore(new Path(this.hocr.getCryptKeystoreFile()), this.hocr.getCryptKeystoreType(), this.hocr.getCryptKeystorePassword());
                String pw = "";
                pw = this.hocr.getCryptKeystoreAlias() != null && !"".equals(this.hocr.getCryptKeystoreAlias()) ? hksm.getPassword(this.hocr.getCryptKeystoreAlias(), this.hocr.getCryptKeystorePassword()) : hksm.getPassword(this.hocr.getFileName(), this.hocr.getCryptKeystorePassword());
                this.hocr.setPassword(pw);
            }
            catch (IllegalArgumentException | KeyStoreException | NoSuchAlgorithmException | UnrecoverableEntryException | CertificateException | InvalidKeySpecException e) {
                LOG.error((Object)"Cannopt read keystore. Exception: ", (Throwable)e);
                throw new FormatNotUnderstoodException("Cannot read keystore to obtain credentials to access encrypted documents " + e);
            }
        }
    }

    private void readTrustStore(Configuration conf) throws IOException, FormatNotUnderstoodException {
        if (this.hocr.getSigTruststoreFile() != null && !"".equals(this.hocr.getSigTruststoreFile())) {
            LOG.info((Object)"Reading truststore to validate certificate chain for signatures");
            HadoopKeyStoreManager hksm = new HadoopKeyStoreManager(conf);
            try {
                hksm.openKeyStore(new Path(this.hocr.getSigTruststoreFile()), this.hocr.getSigTruststoreType(), this.hocr.getSigTruststorePassword());
                this.hocr.setX509CertificateChain(hksm.getAllX509Certificates());
            }
            catch (IllegalArgumentException | KeyStoreException | NoSuchAlgorithmException | CertificateException e) {
                LOG.error((Object)"Cannopt read truststore. Exception: ", (Throwable)e);
                throw new FormatNotUnderstoodException("Cannot read truststore to establish certificate chain for signature validation " + e);
            }
        }
    }

    public OfficeReader getOfficeReader() {
        return this.officeReader;
    }

    public long getFilePosition() throws IOException {
        return this.filePosition.getPos();
    }

    public long getEnd() {
        return this.end;
    }

    public synchronized float getProgress() throws IOException {
        if (this.start == this.end) {
            return 0.0f;
        }
        return Math.min(1.0f, (float)(this.getFilePosition() - this.start) / (float)(this.end - this.start));
    }

    private boolean isCompressedInput() {
        return this.codec != null;
    }

    public synchronized long getPos() throws IOException {
        return this.filePosition.getPos();
    }

    public synchronized void close() throws IOException {
        try {
            if (this.officeReader != null) {
                this.officeReader.close();
            }
        }
        finally {
            if (this.decompressor != null) {
                CodecPool.returnDecompressor((Decompressor)this.decompressor);
                this.decompressor = null;
            }
            if (this.currentHFR != null) {
                this.currentHFR.close();
            }
        }
    }
}

