/*
 * Decompiled with CFR 0.152.
 */
package org.zuinnote.hadoop.office.format.mapred;

import java.io.IOException;
import java.security.GeneralSecurityException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapred.FileSplit;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.Reporter;
import org.zuinnote.hadoop.office.format.common.dao.SpreadSheetCellDAO;
import org.zuinnote.hadoop.office.format.common.parser.FormatNotUnderstoodException;
import org.zuinnote.hadoop.office.format.mapred.AbstractSpreadSheetDocumentRecordReader;

public class ExcelCellRecordReader
extends AbstractSpreadSheetDocumentRecordReader<Text, SpreadSheetCellDAO> {
    private static final Log LOG = LogFactory.getLog((String)ExcelCellRecordReader.class.getName());
    private FileSplit split;
    private Object[] objectArray;
    private int objectArrayPos;

    public ExcelCellRecordReader(FileSplit split, JobConf job, Reporter reporter) throws IOException, FormatNotUnderstoodException, GeneralSecurityException {
        super(split, job, reporter);
        this.split = split;
        this.objectArrayPos = 0;
    }

    public boolean next(Text key, SpreadSheetCellDAO value) throws IOException {
        if (!this.getOfficeReader().getFiltered()) {
            return false;
        }
        while (this.objectArray == null || this.objectArray.length == 0 || this.objectArrayPos == this.objectArray.length || this.objectArray[this.objectArrayPos] == null) {
            if (this.objectArray != null && this.objectArrayPos < this.objectArray.length && this.objectArray[this.objectArrayPos] == null) {
                ++this.objectArrayPos;
                continue;
            }
            this.objectArray = this.getOfficeReader().getNext();
            this.objectArrayPos = 0;
            if (this.objectArray != null) continue;
            return false;
        }
        SpreadSheetCellDAO currentCell = (SpreadSheetCellDAO)this.objectArray[this.objectArrayPos++];
        key.set("[" + this.split.getPath().getName() + "]" + this.getOfficeReader().getCurrentSheetName() + "!A" + this.getOfficeReader().getCurrentRow());
        value.set(currentCell);
        return true;
    }

    public Text createKey() {
        return new Text("");
    }

    public SpreadSheetCellDAO createValue() {
        return new SpreadSheetCellDAO();
    }
}

