/*
 * Decompiled with CFR 0.152.
 */
package org.zuinnote.hadoop.office.format.mapreduce;

import java.io.IOException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapreduce.lib.input.FileSplit;
import org.zuinnote.hadoop.office.format.common.dao.SpreadSheetCellDAO;
import org.zuinnote.hadoop.office.format.mapreduce.AbstractSpreadSheetDocumentRecordReader;

public class ExcelCellRecordReader
extends AbstractSpreadSheetDocumentRecordReader<Text, SpreadSheetCellDAO> {
    private static final Log LOG = LogFactory.getLog((String)ExcelCellRecordReader.class.getName());
    private FileSplit split;
    private Text currentKey = new Text("");
    private SpreadSheetCellDAO currentValue = new SpreadSheetCellDAO();
    private Object[] objectArray;
    private int objectArrayPos;

    public ExcelCellRecordReader(Configuration conf, FileSplit split) {
        super(conf);
        LOG.debug((Object)"Initalizing ExcelRecordReader");
        this.split = split;
    }

    @Override
    public boolean nextKeyValue() throws IOException {
        if (!this.getOfficeReader().getFiltered()) {
            return false;
        }
        while (this.objectArray == null || this.objectArray.length == 0 || this.objectArrayPos == this.objectArray.length || this.objectArray[this.objectArrayPos] == null) {
            if (this.objectArray != null && this.objectArrayPos < this.objectArray.length && this.objectArray[this.objectArrayPos] == null) {
                ++this.objectArrayPos;
                continue;
            }
            this.objectArray = this.getOfficeReader().getNext();
            this.objectArrayPos = 0;
            if (this.objectArray != null) continue;
            return false;
        }
        SpreadSheetCellDAO currentCell = (SpreadSheetCellDAO)this.objectArray[this.objectArrayPos++];
        this.currentKey.set("[" + this.split.getPath().getName() + "]" + this.getOfficeReader().getCurrentSheetName() + "!A" + this.getOfficeReader().getCurrentRow());
        this.currentValue.set(currentCell);
        return true;
    }

    public Text getCurrentKey() throws IOException, InterruptedException {
        return this.currentKey;
    }

    public SpreadSheetCellDAO getCurrentValue() throws IOException, InterruptedException {
        return this.currentValue;
    }
}

