/*
 * Decompiled with CFR 0.152.
 */
package org.zuinnote.hadoop.office.format.mapreduce;

import java.io.IOException;
import java.io.Serializable;
import java.security.GeneralSecurityException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.NullWritable;
import org.apache.hadoop.io.compress.GzipCodec;
import org.apache.hadoop.mapreduce.JobContext;
import org.apache.hadoop.mapreduce.RecordWriter;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.apache.hadoop.util.Progressable;
import org.zuinnote.hadoop.office.format.common.HadoopUtil;
import org.zuinnote.hadoop.office.format.common.dao.SpreadSheetCellDAO;
import org.zuinnote.hadoop.office.format.common.parser.FormatNotUnderstoodException;
import org.zuinnote.hadoop.office.format.common.writer.InvalidCellSpecificationException;
import org.zuinnote.hadoop.office.format.common.writer.InvalidWriterConfigurationException;
import org.zuinnote.hadoop.office.format.common.writer.OfficeWriterException;
import org.zuinnote.hadoop.office.format.mapreduce.AbstractSpreadSheetDocumentFileOutputFormat;
import org.zuinnote.hadoop.office.format.mapreduce.ExcelRecordWriter;

public class ExcelFileOutputFormat
extends AbstractSpreadSheetDocumentFileOutputFormat<SpreadSheetCellDAO>
implements Serializable {
    private static final long serialVersionUID = -1241096542392745880L;
    private static final Log LOG = LogFactory.getLog((String)ExcelFileOutputFormat.class.getName());
    public static final Class defaultCompressorClass = GzipCodec.class;
    public static final String DEFAULT_MIMETYPE = "application/vnd.openxmlformats-officedocument.spreadsheetml.sheet";
    public static final String SUFFIX_OOXML = ".xlsx";
    public static final String SUFFIX_OLDEXCEL = ".xls";

    @Override
    public RecordWriter<NullWritable, SpreadSheetCellDAO> getRecordWriter(TaskAttemptContext context) throws IOException {
        Configuration conf = context.getConfiguration();
        String defaultConf = conf.get("hadoopoffice.write.mimeType", DEFAULT_MIMETYPE);
        conf.set("hadoopoffice.write.mimeType", defaultConf);
        Path file = this.getDefaultWorkFile(context, ExcelFileOutputFormat.getSuffix(conf.get("hadoopoffice.write.mimeType")));
        try {
            return new ExcelRecordWriter<NullWritable, SpreadSheetCellDAO>(HadoopUtil.getDataOutputStream(conf, file, (Progressable)context, ExcelFileOutputFormat.getCompressOutput((JobContext)context), ExcelFileOutputFormat.getOutputCompressorClass((JobContext)context, (Class)defaultCompressorClass)), file.getName(), conf);
        }
        catch (GeneralSecurityException | FormatNotUnderstoodException | InvalidCellSpecificationException | InvalidWriterConfigurationException | OfficeWriterException e) {
            LOG.error((Object)e);
            return null;
        }
    }

    public static String getSuffix(String mimeType) {
        if (mimeType.contains("openxmlformats-officedocument.spreadsheetml")) {
            return SUFFIX_OOXML;
        }
        if (mimeType.contains("ms-excel")) {
            return SUFFIX_OLDEXCEL;
        }
        return ".unknown";
    }
}

