/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.collect.testing.google;

import com.google.common.annotations.GwtCompatible;
import com.google.common.annotations.GwtIncompatible;
import com.google.common.annotations.J2ktIncompatible;
import com.google.common.collect.Multiset;
import com.google.common.collect.testing.Helpers;
import com.google.common.collect.testing.features.CollectionFeature;
import com.google.common.collect.testing.features.CollectionSize;
import com.google.common.collect.testing.google.AbstractMultisetTester;
import com.google.common.collect.testing.google.ReflectionFreeAssertThrows;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.List;
import org.junit.Ignore;

@Ignore(value="test runners must not instantiate and run this directly, only via suites we build")
@GwtCompatible(emulated=true)
public abstract class AbstractMultisetSetCountTester<E>
extends AbstractMultisetTester<E> {
    private void assertSetCount(E element, int count) {
        this.setCountCheckReturnValue(element, count);
        AbstractMultisetSetCountTester.assertEquals((String)"multiset.count() should return the value passed to setCount()", (int)count, (int)this.getMultiset().count(element));
        int size = 0;
        for (Multiset.Entry entry : this.getMultiset().entrySet()) {
            size += entry.getCount();
        }
        AbstractMultisetSetCountTester.assertEquals((String)"multiset.size() should be the sum of the counts of all entries", (int)size, (int)this.getMultiset().size());
    }

    abstract void setCountCheckReturnValue(E var1, int var2);

    abstract void setCountNoCheckReturnValue(E var1, int var2);

    private void assertSetCountIncreasingFailure(E element, int count) {
        try {
            this.setCountNoCheckReturnValue(element, count);
            AbstractMultisetSetCountTester.fail((String)"a call to multiset.setCount() to increase an element's count should throw");
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
    }

    private void assertSetCountDecreasingFailure(E element, int count) {
        try {
            this.setCountNoCheckReturnValue(element, count);
            AbstractMultisetSetCountTester.fail((String)"a call to multiset.setCount() to decrease an element's count should throw");
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
    }

    private void assertZeroToZero() {
        this.assertSetCount(this.e3(), 0);
    }

    private void assertOneToOne() {
        this.assertSetCount(this.e0(), 1);
    }

    private void assertThreeToThree() {
        this.initThreeCopies();
        this.assertSetCount(this.e0(), 3);
    }

    @CollectionFeature.Require(value={CollectionFeature.SUPPORTS_ADD})
    public void testSetCount_zeroToZero_addSupported() {
        this.assertZeroToZero();
    }

    @CollectionFeature.Require(value={CollectionFeature.SUPPORTS_REMOVE})
    public void testSetCount_zeroToZero_removeSupported() {
        this.assertZeroToZero();
    }

    @CollectionFeature.Require(absent={CollectionFeature.SUPPORTS_ADD, CollectionFeature.SUPPORTS_REMOVE})
    public void testSetCount_zeroToZero_unsupported() {
        try {
            this.assertZeroToZero();
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
    }

    @CollectionSize.Require(absent={CollectionSize.ZERO})
    @CollectionFeature.Require(value={CollectionFeature.SUPPORTS_ADD})
    public void testSetCount_oneToOne_addSupported() {
        this.assertOneToOne();
    }

    @CollectionSize.Require(absent={CollectionSize.ZERO})
    @CollectionFeature.Require(value={CollectionFeature.SUPPORTS_REMOVE})
    public void testSetCount_oneToOne_removeSupported() {
        this.assertOneToOne();
    }

    @CollectionSize.Require(absent={CollectionSize.ZERO})
    @CollectionFeature.Require(absent={CollectionFeature.SUPPORTS_ADD, CollectionFeature.SUPPORTS_REMOVE})
    public void testSetCount_oneToOne_unsupported() {
        try {
            this.assertOneToOne();
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
    }

    @CollectionSize.Require(value={CollectionSize.SEVERAL})
    @CollectionFeature.Require(value={CollectionFeature.SUPPORTS_ADD})
    public void testSetCount_threeToThree_addSupported() {
        this.assertThreeToThree();
    }

    @CollectionSize.Require(value={CollectionSize.SEVERAL})
    @CollectionFeature.Require(value={CollectionFeature.SUPPORTS_REMOVE})
    public void testSetCount_threeToThree_removeSupported() {
        this.assertThreeToThree();
    }

    @CollectionSize.Require(value={CollectionSize.SEVERAL})
    @CollectionFeature.Require(absent={CollectionFeature.SUPPORTS_ADD, CollectionFeature.SUPPORTS_REMOVE})
    public void testSetCount_threeToThree_unsupported() {
        try {
            this.assertThreeToThree();
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
    }

    @CollectionFeature.Require(value={CollectionFeature.SUPPORTS_ADD})
    public void testSetCount_zeroToOne_supported() {
        this.assertSetCount(this.e3(), 1);
    }

    @CollectionFeature.Require(value={CollectionFeature.SUPPORTS_ADD, CollectionFeature.FAILS_FAST_ON_CONCURRENT_MODIFICATION})
    public void testSetCountZeroToOneConcurrentWithIteration() {
        Iterator iterator = this.collection.iterator();
        this.assertSetCount(this.e3(), 1);
        ReflectionFreeAssertThrows.assertThrows(ConcurrentModificationException.class, iterator::next);
    }

    @CollectionFeature.Require(value={CollectionFeature.SUPPORTS_ADD, CollectionFeature.FAILS_FAST_ON_CONCURRENT_MODIFICATION})
    public void testSetCountZeroToOneConcurrentWithEntrySetIteration() {
        Iterator iterator = this.getMultiset().entrySet().iterator();
        this.assertSetCount(this.e3(), 1);
        ReflectionFreeAssertThrows.assertThrows(ConcurrentModificationException.class, iterator::next);
    }

    @CollectionFeature.Require(value={CollectionFeature.SUPPORTS_ADD})
    public void testSetCount_zeroToThree_supported() {
        this.assertSetCount(this.e3(), 3);
    }

    @CollectionSize.Require(absent={CollectionSize.ZERO})
    @CollectionFeature.Require(value={CollectionFeature.SUPPORTS_ADD})
    public void testSetCount_oneToThree_supported() {
        this.assertSetCount(this.e0(), 3);
    }

    @CollectionFeature.Require(absent={CollectionFeature.SUPPORTS_ADD})
    public void testSetCount_zeroToOne_unsupported() {
        this.assertSetCountIncreasingFailure(this.e3(), 1);
    }

    @CollectionFeature.Require(absent={CollectionFeature.SUPPORTS_ADD})
    public void testSetCount_zeroToThree_unsupported() {
        this.assertSetCountIncreasingFailure(this.e3(), 3);
    }

    @CollectionSize.Require(absent={CollectionSize.ZERO})
    @CollectionFeature.Require(absent={CollectionFeature.SUPPORTS_ADD})
    public void testSetCount_oneToThree_unsupported() {
        this.assertSetCountIncreasingFailure(this.e3(), 3);
    }

    @CollectionSize.Require(absent={CollectionSize.ZERO})
    @CollectionFeature.Require(value={CollectionFeature.SUPPORTS_REMOVE})
    public void testSetCount_oneToZero_supported() {
        this.assertSetCount(this.e0(), 0);
    }

    @CollectionFeature.Require(value={CollectionFeature.SUPPORTS_REMOVE, CollectionFeature.FAILS_FAST_ON_CONCURRENT_MODIFICATION})
    @CollectionSize.Require(absent={CollectionSize.ZERO})
    public void testSetCountOneToZeroConcurrentWithIteration() {
        Iterator iterator = this.collection.iterator();
        this.assertSetCount(this.e0(), 0);
        ReflectionFreeAssertThrows.assertThrows(ConcurrentModificationException.class, iterator::next);
    }

    @CollectionFeature.Require(value={CollectionFeature.SUPPORTS_REMOVE, CollectionFeature.FAILS_FAST_ON_CONCURRENT_MODIFICATION})
    @CollectionSize.Require(absent={CollectionSize.ZERO})
    public void testSetCountOneToZeroConcurrentWithEntrySetIteration() {
        Iterator iterator = this.getMultiset().entrySet().iterator();
        this.assertSetCount(this.e0(), 0);
        ReflectionFreeAssertThrows.assertThrows(ConcurrentModificationException.class, iterator::next);
    }

    @CollectionSize.Require(value={CollectionSize.SEVERAL})
    @CollectionFeature.Require(value={CollectionFeature.SUPPORTS_REMOVE})
    public void testSetCount_threeToZero_supported() {
        this.initThreeCopies();
        this.assertSetCount(this.e0(), 0);
    }

    @CollectionSize.Require(value={CollectionSize.SEVERAL})
    @CollectionFeature.Require(value={CollectionFeature.SUPPORTS_REMOVE})
    public void testSetCount_threeToOne_supported() {
        this.initThreeCopies();
        this.assertSetCount(this.e0(), 1);
    }

    @CollectionSize.Require(absent={CollectionSize.ZERO})
    @CollectionFeature.Require(absent={CollectionFeature.SUPPORTS_REMOVE})
    public void testSetCount_oneToZero_unsupported() {
        this.assertSetCountDecreasingFailure(this.e0(), 0);
    }

    @CollectionSize.Require(value={CollectionSize.SEVERAL})
    @CollectionFeature.Require(absent={CollectionFeature.SUPPORTS_REMOVE})
    public void testSetCount_threeToZero_unsupported() {
        this.initThreeCopies();
        this.assertSetCountDecreasingFailure(this.e0(), 0);
    }

    @CollectionSize.Require(value={CollectionSize.SEVERAL})
    @CollectionFeature.Require(absent={CollectionFeature.SUPPORTS_REMOVE})
    public void testSetCount_threeToOne_unsupported() {
        this.initThreeCopies();
        this.assertSetCountDecreasingFailure(this.e0(), 1);
    }

    @CollectionSize.Require(absent={CollectionSize.ZERO})
    @CollectionFeature.Require(value={CollectionFeature.SUPPORTS_REMOVE, CollectionFeature.ALLOWS_NULL_VALUES})
    public void testSetCount_removeNull_nullSupported() {
        this.initCollectionWithNullElement();
        this.assertSetCount(null, 0);
    }

    @CollectionFeature.Require(value={CollectionFeature.SUPPORTS_ADD, CollectionFeature.ALLOWS_NULL_VALUES}, absent={CollectionFeature.RESTRICTS_ELEMENTS})
    public void testSetCount_addNull_nullSupported() {
        this.assertSetCount(null, 1);
    }

    @CollectionFeature.Require(value={CollectionFeature.SUPPORTS_ADD}, absent={CollectionFeature.ALLOWS_NULL_VALUES})
    public void testSetCount_addNull_nullUnsupported() {
        ReflectionFreeAssertThrows.assertThrows(NullPointerException.class, () -> this.setCountNoCheckReturnValue(null, 1));
    }

    @CollectionFeature.Require(value={CollectionFeature.ALLOWS_NULL_VALUES})
    public void testSetCount_noOpNull_nullSupported() {
        try {
            this.assertSetCount(null, 0);
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
    }

    @CollectionFeature.Require(absent={CollectionFeature.ALLOWS_NULL_VALUES})
    public void testSetCount_noOpNull_nullUnsupported() {
        try {
            this.assertSetCount(null, 0);
        }
        catch (NullPointerException | UnsupportedOperationException runtimeException) {
            // empty catch block
        }
    }

    @CollectionSize.Require(absent={CollectionSize.ZERO})
    @CollectionFeature.Require(value={CollectionFeature.ALLOWS_NULL_VALUES})
    public void testSetCount_existingNoNopNull_nullSupported() {
        this.initCollectionWithNullElement();
        try {
            this.assertSetCount(null, 1);
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
    }

    @CollectionFeature.Require(value={CollectionFeature.SUPPORTS_REMOVE})
    public void testSetCount_negative_removeSupported() {
        ReflectionFreeAssertThrows.assertThrows(IllegalArgumentException.class, () -> this.setCountNoCheckReturnValue(this.e3(), -1));
    }

    @CollectionFeature.Require(absent={CollectionFeature.SUPPORTS_REMOVE})
    public void testSetCount_negative_removeUnsupported() {
        try {
            this.setCountNoCheckReturnValue(this.e3(), -1);
            AbstractMultisetSetCountTester.fail((String)"calling setCount() with a negative count should throw IllegalArgumentException or UnsupportedOperationException");
        }
        catch (IllegalArgumentException | UnsupportedOperationException runtimeException) {
            // empty catch block
        }
    }

    @J2ktIncompatible
    @GwtIncompatible
    public static List<Method> getSetCountDuplicateInitializingMethods() {
        return Arrays.asList(AbstractMultisetSetCountTester.getMethod("testSetCount_threeToThree_removeSupported"), AbstractMultisetSetCountTester.getMethod("testSetCount_threeToZero_supported"), AbstractMultisetSetCountTester.getMethod("testSetCount_threeToOne_supported"));
    }

    @J2ktIncompatible
    @GwtIncompatible
    private static Method getMethod(String methodName) {
        return Helpers.getMethod(AbstractMultisetSetCountTester.class, methodName);
    }
}

