/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.collect.testing.google;

import com.google.common.annotations.GwtCompatible;
import com.google.common.collect.Multimap;
import com.google.common.collect.testing.features.CollectionSize;
import com.google.common.collect.testing.features.MapFeature;
import com.google.common.collect.testing.google.AbstractMultimapTester;
import com.google.common.collect.testing.google.ReflectionFreeAssertThrows;
import org.junit.Ignore;

@Ignore(value="test runners must not instantiate and run this directly, only via suites we build")
@GwtCompatible
public class MultimapContainsEntryTester<K, V>
extends AbstractMultimapTester<K, V, Multimap<K, V>> {
    @CollectionSize.Require(absent={CollectionSize.ZERO})
    public void testContainsEntryYes() {
        MultimapContainsEntryTester.assertTrue((boolean)this.multimap().containsEntry(this.k0(), this.v0()));
    }

    public void testContainsEntryNo() {
        MultimapContainsEntryTester.assertFalse((boolean)this.multimap().containsEntry(this.k3(), this.v3()));
    }

    public void testContainsEntryAgreesWithGet() {
        for (Object k : this.sampleKeys()) {
            for (Object v : this.sampleValues()) {
                MultimapContainsEntryTester.assertEquals((boolean)this.multimap().get(k).contains(v), (boolean)this.multimap().containsEntry(k, v));
            }
        }
    }

    @CollectionSize.Require(absent={CollectionSize.ZERO})
    @MapFeature.Require(value={MapFeature.ALLOWS_NULL_KEYS, MapFeature.ALLOWS_NULL_VALUES})
    public void testContainsEntryNullYes() {
        this.initMultimapWithNullKeyAndValue();
        MultimapContainsEntryTester.assertTrue((boolean)this.multimap().containsEntry(null, null));
    }

    @MapFeature.Require(value={MapFeature.ALLOWS_NULL_KEY_QUERIES, MapFeature.ALLOWS_NULL_VALUE_QUERIES})
    public void testContainsEntryNullNo() {
        MultimapContainsEntryTester.assertFalse((boolean)this.multimap().containsEntry(null, null));
    }

    @MapFeature.Require(absent={MapFeature.ALLOWS_NULL_KEY_QUERIES})
    public void testContainsEntryNullDisallowedBecauseKeyQueriesDisallowed() {
        ReflectionFreeAssertThrows.assertThrows(NullPointerException.class, () -> this.multimap().containsEntry(null, this.v3()));
    }

    @MapFeature.Require(absent={MapFeature.ALLOWS_NULL_VALUE_QUERIES})
    public void testContainsEntryNullDisallowedBecauseValueQueriesDisallowed() {
        ReflectionFreeAssertThrows.assertThrows(NullPointerException.class, () -> this.multimap().containsEntry(this.k3(), null));
    }
}

