/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.collect.testing.testers;

import com.google.common.annotations.GwtCompatible;
import com.google.common.collect.testing.AbstractMapTester;
import com.google.common.collect.testing.features.CollectionSize;
import com.google.common.collect.testing.features.MapFeature;
import com.google.common.collect.testing.testers.ReflectionFreeAssertThrows;
import com.google.common.collect.testing.testers.TestExceptions;
import java.util.Map;
import junit.framework.AssertionFailedError;
import org.junit.Ignore;

@Ignore(value="test runners must not instantiate and run this directly, only via suites we build")
@GwtCompatible
public class MapComputeIfAbsentTester<K, V>
extends AbstractMapTester<K, V> {
    @MapFeature.Require(value={MapFeature.SUPPORTS_PUT})
    public void testComputeIfAbsent_supportedAbsent() {
        MapComputeIfAbsentTester.assertEquals((String)"computeIfAbsent(notPresent, function) should return new value", this.v3(), (Object)this.getMap().computeIfAbsent(this.k3(), k -> {
            MapComputeIfAbsentTester.assertEquals(this.k3(), (Object)k);
            return this.v3();
        }));
        this.expectAdded((Map.Entry)this.e3());
    }

    @MapFeature.Require(value={MapFeature.SUPPORTS_PUT})
    @CollectionSize.Require(absent={CollectionSize.ZERO})
    public void testComputeIfAbsent_supportedPresent() {
        MapComputeIfAbsentTester.assertEquals((String)"computeIfAbsent(present, function) should return existing value", this.v0(), (Object)this.getMap().computeIfAbsent(this.k0(), k -> {
            throw new AssertionFailedError();
        }));
        this.expectUnchanged();
    }

    @MapFeature.Require(value={MapFeature.SUPPORTS_PUT})
    public void testComputeIfAbsent_functionReturnsNullNotInserted() {
        MapComputeIfAbsentTester.assertNull("computeIfAbsent(absent, returnsNull) should return null", this.getMap().computeIfAbsent(this.k3(), k -> {
            MapComputeIfAbsentTester.assertEquals(this.k3(), (Object)k);
            return null;
        }));
        this.expectUnchanged();
    }

    @MapFeature.Require(value={MapFeature.SUPPORTS_PUT, MapFeature.ALLOWS_NULL_VALUES})
    @CollectionSize.Require(absent={CollectionSize.ZERO})
    public void testComputeIfAbsent_nullTreatedAsAbsent() {
        this.initMapWithNullValue();
        MapComputeIfAbsentTester.assertEquals((String)"computeIfAbsent(presentAssignedToNull, function) should return newValue", this.getValueForNullKey(), (Object)this.getMap().computeIfAbsent(this.getKeyForNullValue(), k -> {
            MapComputeIfAbsentTester.assertEquals(this.getKeyForNullValue(), (Object)k);
            return this.getValueForNullKey();
        }));
        this.expectReplacement(this.entry(this.getKeyForNullValue(), this.getValueForNullKey()));
    }

    @MapFeature.Require(value={MapFeature.SUPPORTS_PUT, MapFeature.ALLOWS_NULL_KEYS})
    public void testComputeIfAbsent_nullKeySupported() {
        this.getMap().computeIfAbsent(null, k -> {
            MapComputeIfAbsentTester.assertNull((Object)k);
            return this.v3();
        });
        this.expectAdded(this.entry(null, this.v3()));
    }

    @MapFeature.Require(value={MapFeature.SUPPORTS_PUT})
    public void testComputeIfAbsent_functionThrows() {
        ReflectionFreeAssertThrows.assertThrows(TestExceptions.SomeUncheckedException.class, () -> this.getMap().computeIfAbsent(this.k3(), k -> {
            MapComputeIfAbsentTester.assertEquals(this.k3(), (Object)k);
            throw new TestExceptions.SomeUncheckedException();
        }));
        this.expectUnchanged();
    }

    @MapFeature.Require(absent={MapFeature.SUPPORTS_PUT})
    public void testComputeIfAbsent_unsupportedAbsent() {
        ReflectionFreeAssertThrows.assertThrows(UnsupportedOperationException.class, () -> this.getMap().computeIfAbsent(this.k3(), k -> {
            MapComputeIfAbsentTester.assertEquals(this.k3(), (Object)k);
            return this.v3();
        }));
        this.expectUnchanged();
    }

    @MapFeature.Require(absent={MapFeature.SUPPORTS_PUT})
    @CollectionSize.Require(absent={CollectionSize.ZERO})
    public void testComputeIfAbsent_unsupportedPresentExistingValue() {
        try {
            MapComputeIfAbsentTester.assertEquals((String)"computeIfAbsent(present, returnsCurrentValue) should return present or throw", this.v0(), (Object)this.getMap().computeIfAbsent(this.k0(), k -> {
                MapComputeIfAbsentTester.assertEquals(this.k0(), (Object)k);
                return this.v0();
            }));
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
        this.expectUnchanged();
    }

    @MapFeature.Require(absent={MapFeature.SUPPORTS_PUT})
    @CollectionSize.Require(absent={CollectionSize.ZERO})
    public void testComputeIfAbsent_unsupportedPresentDifferentValue() {
        try {
            MapComputeIfAbsentTester.assertEquals((String)"computeIfAbsent(present, returnsDifferentValue) should return present or throw", this.v0(), (Object)this.getMap().computeIfAbsent(this.k0(), k -> {
                MapComputeIfAbsentTester.assertEquals(this.k0(), (Object)k);
                return this.v3();
            }));
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
        this.expectUnchanged();
    }

    @MapFeature.Require(value={MapFeature.SUPPORTS_PUT}, absent={MapFeature.ALLOWS_NULL_KEYS})
    public void testComputeIfAbsent_nullKeyUnsupported() {
        ReflectionFreeAssertThrows.assertThrows(NullPointerException.class, () -> this.getMap().computeIfAbsent(null, k -> {
            MapComputeIfAbsentTester.assertNull((Object)k);
            return this.v3();
        }));
        this.expectUnchanged();
        this.expectNullKeyMissingWhenNullKeysUnsupported("Should not contain null key after unsupported computeIfAbsent(null, function)");
    }
}

