/*
 * Decompiled with CFR 0.152.
 */
package com.helger.commons.collection;

import com.helger.commons.annotation.ReturnsMutableCopy;
import com.helger.commons.collection.ArrayHelper;
import com.helger.commons.collection.CollectionHelper;
import com.helger.commons.collection.NonBlockingStack;
import java.util.Collection;
import java.util.function.Function;
import java.util.function.Predicate;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;

@Immutable
public final class StackHelper {
    private StackHelper() {
    }

    @Nonnull
    @ReturnsMutableCopy
    public static <ELEMENTTYPE> NonBlockingStack<ELEMENTTYPE> newStack(@Nonnegative int n) {
        return new NonBlockingStack(n);
    }

    @Nonnull
    @ReturnsMutableCopy
    public static <ELEMENTTYPE> NonBlockingStack<ELEMENTTYPE> newStack() {
        return new NonBlockingStack();
    }

    @Nonnull
    @ReturnsMutableCopy
    public static <SRCTYPE, DSTTYPE> NonBlockingStack<DSTTYPE> newStackMapped(@Nullable Collection<? extends SRCTYPE> collection, @Nonnull Function<? super SRCTYPE, DSTTYPE> function) {
        if (CollectionHelper.isEmpty(collection)) {
            return StackHelper.newStack(false);
        }
        NonBlockingStack<int> nonBlockingStack = StackHelper.newStack(collection.size());
        for (SRCTYPE SRCTYPE : collection) {
            nonBlockingStack.push((int)function.apply(SRCTYPE));
        }
        return nonBlockingStack;
    }

    @Nonnull
    @ReturnsMutableCopy
    public static <SRCTYPE, DSTTYPE> NonBlockingStack<DSTTYPE> newStackMapped(@Nullable SRCTYPE[] SRCTYPEArray, @Nonnull Function<? super SRCTYPE, DSTTYPE> function) {
        if (ArrayHelper.isEmpty(SRCTYPEArray)) {
            return StackHelper.newStack(false);
        }
        NonBlockingStack<int> nonBlockingStack = StackHelper.newStack(SRCTYPEArray.length);
        for (SRCTYPE SRCTYPE : SRCTYPEArray) {
            nonBlockingStack.push((int)function.apply(SRCTYPE));
        }
        return nonBlockingStack;
    }

    @Nonnull
    @ReturnsMutableCopy
    public static <ELEMENTTYPE> NonBlockingStack<ELEMENTTYPE> newStack(@Nullable ELEMENTTYPE ELEMENTTYPE) {
        NonBlockingStack<ELEMENTTYPE> nonBlockingStack = StackHelper.newStack();
        nonBlockingStack.push(ELEMENTTYPE);
        return nonBlockingStack;
    }

    @Nonnull
    @SafeVarargs
    @ReturnsMutableCopy
    public static <ELEMENTTYPE> NonBlockingStack<ELEMENTTYPE> newStack(ELEMENTTYPE ... ELEMENTTYPEArray) {
        return new NonBlockingStack<ELEMENTTYPE>(ELEMENTTYPEArray);
    }

    @Nonnull
    @ReturnsMutableCopy
    public static <ELEMENTTYPE> NonBlockingStack<ELEMENTTYPE> newStack(@Nullable Collection<? extends ELEMENTTYPE> collection, @Nonnull Predicate<? super ELEMENTTYPE> predicate) {
        if (CollectionHelper.isEmpty(collection)) {
            return StackHelper.newStack(false);
        }
        NonBlockingStack<int> nonBlockingStack = StackHelper.newStack(collection.size());
        CollectionHelper.findAll(collection, predicate, nonBlockingStack::add);
        return nonBlockingStack;
    }

    @Nonnull
    @ReturnsMutableCopy
    public static <ELEMENTTYPE> NonBlockingStack<ELEMENTTYPE> newStack(@Nullable Collection<? extends ELEMENTTYPE> collection) {
        return new NonBlockingStack<ELEMENTTYPE>(collection);
    }

    @Nullable
    @ReturnsMutableCopy
    public static <ELEMENTTYPE> NonBlockingStack<ELEMENTTYPE> getStackCopyWithoutTop(@Nullable NonBlockingStack<ELEMENTTYPE> nonBlockingStack) {
        if (CollectionHelper.isEmpty(nonBlockingStack)) {
            return null;
        }
        NonBlockingStack<ELEMENTTYPE> nonBlockingStack2 = new NonBlockingStack<ELEMENTTYPE>(nonBlockingStack);
        nonBlockingStack2.pop();
        return nonBlockingStack2;
    }
}

