/*
 * Decompiled with CFR 0.152.
 */
package com.helger.commons.system;

import com.helger.commons.equals.EqualsHelper;
import com.helger.commons.string.StringParser;
import com.helger.commons.system.JavaVersionHelper;
import javax.annotation.Nonnull;

public enum EJavaVersion {
    UNKNOWN,
    JDK_1_1(45.3, 46.0, false),
    JDK_1_2(46.0, 47.0, false),
    JDK_1_3(47.0, 48.0, false),
    JDK_1_4(48.0, 49.0, false),
    JDK_1_5(49.0, 50.0, false),
    JDK_1_6(50.0, 51.0, false),
    JDK_1_7(51.0, 52.0, false),
    JDK_1_8(52.0, 53.0, true),
    JDK_9(53.0, 54.0, false),
    JDK_10(54.0, 55.0, false),
    JDK_11(55.0, 56.0, true),
    JDK_12(56.0, 57.0, false),
    JDK_13(57.0, 58.0, false),
    JDK_14(58.0, 59.0, false),
    JDK_15(59.0, 60.0, false),
    JDK_16(60.0, 61.0, false),
    JDK_17(61.0, 62.0, true),
    JDK_18(62.0, 63.0, false),
    JDK_19(63.0, 64.0, false),
    JDK_20(64.0, 65.0, false),
    JDK_21(65.0, 66.0, true),
    JDK_22(66.0, 67.0, false),
    JDK_23(67.0, 68.0, false),
    JDK_24(68.0, 69.0, true);

    private static final EJavaVersion INSTANCE;
    private final double m_dMinVersionIncl;
    private final double m_dMaxVersionExcl;
    private final boolean m_bLTS;
    private final boolean m_bIsIt;

    private EJavaVersion() {
        this.m_dMinVersionIncl = Double.NaN;
        this.m_dMaxVersionExcl = Double.NaN;
        this.m_bLTS = false;
        this.m_bIsIt = EqualsHelper.equals(Double.NaN, JavaVersionHelper.JAVA_CLASS_VERSION);
    }

    private EJavaVersion(double d, double d2, boolean bl) {
        this.m_dMinVersionIncl = d;
        this.m_dMaxVersionExcl = d2;
        this.m_bLTS = bl;
        this.m_bIsIt = this.isMatchingVersion(JavaVersionHelper.JAVA_CLASS_VERSION);
    }

    protected boolean isMatchingVersion(double d) {
        return d >= this.m_dMinVersionIncl && d < this.m_dMaxVersionExcl;
    }

    public boolean isCurrentVersion() {
        return this.m_bIsIt;
    }

    public boolean isSupportedVersion() {
        return this.m_dMinVersionIncl < EJavaVersion.getCurrentVersion().m_dMaxVersionExcl;
    }

    public boolean isOlderOrEqualsThan(@Nonnull EJavaVersion eJavaVersion) {
        return this.m_dMinVersionIncl <= eJavaVersion.m_dMinVersionIncl;
    }

    public boolean isNewerOrEqualsThan(@Nonnull EJavaVersion eJavaVersion) {
        return this.m_dMinVersionIncl >= eJavaVersion.m_dMinVersionIncl;
    }

    public boolean isLTS() {
        return this.m_bLTS;
    }

    @Nonnull
    public static EJavaVersion getCurrentVersion() {
        return INSTANCE;
    }

    @Nonnull
    public static EJavaVersion getFromMajorAndMinor(int n, int n2) {
        double d = StringParser.parseBigDecimal(n + "." + n2).doubleValue();
        return EJavaVersion.getFromVersionNumber(d);
    }

    @Nonnull
    public static EJavaVersion getFromVersionNumber(double d) {
        for (EJavaVersion eJavaVersion : EJavaVersion.values()) {
            if (!eJavaVersion.isMatchingVersion(d)) continue;
            return eJavaVersion;
        }
        return UNKNOWN;
    }

    static {
        EJavaVersion eJavaVersion = UNKNOWN;
        for (EJavaVersion eJavaVersion2 : EJavaVersion.values()) {
            if (!eJavaVersion2.m_bIsIt) continue;
            eJavaVersion = eJavaVersion2;
            break;
        }
        INSTANCE = eJavaVersion;
    }
}

