/*
 * Decompiled with CFR 0.152.
 */
package com.helger.jaxb.adapter;

import com.helger.commons.datetime.PDTWebDateHelper;
import jakarta.xml.bind.annotation.adapters.XmlAdapter;
import java.time.LocalDate;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AdapterLocalDate
extends XmlAdapter<String, LocalDate> {
    private static final Logger LOGGER = LoggerFactory.getLogger(AdapterLocalDate.class);

    public LocalDate unmarshal(@Nullable String string) {
        if (string == null) {
            return null;
        }
        LocalDate localDate = PDTWebDateHelper.getLocalDateFromXSD((String)string.trim());
        if (localDate == null) {
            LOGGER.warn("Failed to parse '" + string + "' to a LocalDate");
        }
        return localDate;
    }

    public String marshal(@Nullable LocalDate localDate) {
        return PDTWebDateHelper.getAsStringXSD((LocalDate)localDate);
    }
}

