/*
 * Decompiled with CFR 0.152.
 */
package com.helger.jaxb.adapter;

import com.helger.datetime.web.PDTWebDateHelper;
import jakarta.annotation.Nullable;
import jakarta.xml.bind.annotation.adapters.XmlAdapter;
import java.time.LocalDateTime;
import java.time.OffsetDateTime;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AdapterLocalDateTime
extends XmlAdapter<String, LocalDateTime> {
    private static final Logger LOGGER = LoggerFactory.getLogger(AdapterLocalDateTime.class);

    public LocalDateTime unmarshal(@Nullable String string) {
        if (string == null) {
            return null;
        }
        String string2 = string.trim();
        OffsetDateTime offsetDateTime = PDTWebDateHelper.getOffsetDateTimeFromXSD((String)string2);
        if (offsetDateTime != null) {
            return offsetDateTime.toLocalDateTime().minusSeconds(offsetDateTime.getOffset().getTotalSeconds());
        }
        LocalDateTime localDateTime = PDTWebDateHelper.getLocalDateTimeFromXSD((String)string2);
        if (localDateTime == null) {
            LOGGER.warn("Failed to parse '" + string + "' to a LocalDateTime");
        }
        return localDateTime;
    }

    public String marshal(@Nullable LocalDateTime localDateTime) {
        return PDTWebDateHelper.getAsStringXSD((LocalDateTime)localDateTime);
    }
}

