/*
 * Decompiled with CFR 0.152.
 */
package com.helger.matrix;

import com.helger.annotation.style.ReturnsMutableCopy;
import com.helger.base.numeric.MathHelper;
import com.helger.matrix.Matrix;
import jakarta.annotation.Nonnull;
import java.util.Arrays;

public class SingularValueDecomposition {
    private static final double EPSILON = Math.pow(2.0, -52.0);
    private static final double TINY = Math.pow(2.0, -966.0);
    private final double[][] m_aU;
    private final double[][] m_aV;
    private final double[] m_aData;
    private final int m_nRows;
    private final int m_nCols;

    public SingularValueDecomposition(@Nonnull Matrix matrix) {
        int n;
        double d;
        int n2;
        int n3;
        double[][] dArray = matrix.getArrayCopy();
        this.m_nRows = matrix.getRowDimension();
        this.m_nCols = matrix.getColumnDimension();
        int n4 = Math.min(this.m_nRows, this.m_nCols);
        this.m_aData = new double[Math.min(this.m_nRows + 1, this.m_nCols)];
        this.m_aU = new double[this.m_nRows][n4];
        this.m_aV = new double[this.m_nCols][this.m_nCols];
        double[] dArray2 = new double[this.m_nCols];
        double[] dArray3 = new double[this.m_nRows];
        int n5 = Math.min(this.m_nRows - 1, this.m_nCols);
        int n6 = Math.max(0, Math.min(this.m_nCols - 2, this.m_nRows));
        for (n3 = 0; n3 < Math.max(n5, n6); ++n3) {
            int n7;
            if (n3 < n5) {
                this.m_aData[n3] = 0.0;
                for (n2 = n3; n2 < this.m_nRows; ++n2) {
                    this.m_aData[n3] = MathHelper.hypot((double)this.m_aData[n3], (double)dArray[n2][n3]);
                }
                if (this.m_aData[n3] != 0.0) {
                    if (dArray[n3][n3] < 0.0) {
                        this.m_aData[n3] = -this.m_aData[n3];
                    }
                    for (n2 = n3; n2 < this.m_nRows; ++n2) {
                        double[] dArray4 = dArray[n2];
                        int n8 = n3;
                        dArray4[n8] = dArray4[n8] / this.m_aData[n3];
                    }
                    double[] dArray5 = dArray[n3];
                    int n9 = n3;
                    dArray5[n9] = dArray5[n9] + 1.0;
                }
                this.m_aData[n3] = -this.m_aData[n3];
            }
            for (n2 = n3 + 1; n2 < this.m_nCols; ++n2) {
                if (n3 < n5 && this.m_aData[n3] != 0.0) {
                    double d2 = 0.0;
                    for (n7 = n3; n7 < this.m_nRows; ++n7) {
                        d2 += dArray[n7][n3] * dArray[n7][n2];
                    }
                    d2 = -d2 / dArray[n3][n3];
                    for (n7 = n3; n7 < this.m_nRows; ++n7) {
                        double[] dArray6 = dArray[n7];
                        int n10 = n2;
                        dArray6[n10] = dArray6[n10] + d2 * dArray[n7][n3];
                    }
                }
                dArray2[n2] = dArray[n3][n2];
            }
            if (n3 < n5) {
                for (n2 = n3; n2 < this.m_nRows; ++n2) {
                    this.m_aU[n2][n3] = dArray[n2][n3];
                }
            }
            if (n3 >= n6) continue;
            dArray2[n3] = 0.0;
            for (n2 = n3 + 1; n2 < this.m_nCols; ++n2) {
                dArray2[n3] = MathHelper.hypot((double)dArray2[n3], (double)dArray2[n2]);
            }
            if (dArray2[n3] != 0.0) {
                if (dArray2[n3 + 1] < 0.0) {
                    dArray2[n3] = -dArray2[n3];
                }
                n2 = n3 + 1;
                while (n2 < this.m_nCols) {
                    int n11 = n2++;
                    dArray2[n11] = dArray2[n11] / dArray2[n3];
                }
                int n12 = n3 + 1;
                dArray2[n12] = dArray2[n12] + 1.0;
            }
            dArray2[n3] = -dArray2[n3];
            if (n3 + 1 < this.m_nRows && dArray2[n3] != 0.0) {
                for (n2 = n3 + 1; n2 < this.m_nRows; ++n2) {
                    dArray3[n2] = 0.0;
                }
                for (n2 = n3 + 1; n2 < this.m_nCols; ++n2) {
                    for (int i = n3 + 1; i < this.m_nRows; ++i) {
                        int n13 = i;
                        dArray3[n13] = dArray3[n13] + dArray2[n2] * dArray[i][n2];
                    }
                }
                for (n2 = n3 + 1; n2 < this.m_nCols; ++n2) {
                    double d3 = -dArray2[n2] / dArray2[n3 + 1];
                    for (n7 = n3 + 1; n7 < this.m_nRows; ++n7) {
                        double[] dArray7 = dArray[n7];
                        int n14 = n2;
                        dArray7[n14] = dArray7[n14] + d3 * dArray3[n7];
                    }
                }
            }
            for (n2 = n3 + 1; n2 < this.m_nCols; ++n2) {
                this.m_aV[n2][n3] = dArray2[n2];
            }
        }
        n3 = Math.min(this.m_nCols, this.m_nRows + 1);
        if (n5 < this.m_nCols) {
            this.m_aData[n5] = dArray[n5][n5];
        }
        if (this.m_nRows < n3) {
            this.m_aData[n3 - 1] = 0.0;
        }
        if (n6 + 1 < n3) {
            dArray2[n6] = dArray[n6][n3 - 1];
        }
        dArray2[n3 - 1] = 0.0;
        for (n2 = n5; n2 < n4; ++n2) {
            for (int i = 0; i < this.m_nRows; ++i) {
                this.m_aU[i][n2] = 0.0;
            }
            this.m_aU[n2][n2] = 1.0;
        }
        for (n2 = n5 - 1; n2 >= 0; --n2) {
            int n15;
            if (this.m_aData[n2] != 0.0) {
                for (n15 = n2 + 1; n15 < n4; ++n15) {
                    d = 0.0;
                    for (n = n2; n < this.m_nRows; ++n) {
                        d += this.m_aU[n][n2] * this.m_aU[n][n15];
                    }
                    d = -d / this.m_aU[n2][n2];
                    for (n = n2; n < this.m_nRows; ++n) {
                        double[] dArray8 = this.m_aU[n];
                        int n16 = n15;
                        dArray8[n16] = dArray8[n16] + d * this.m_aU[n][n2];
                    }
                }
                for (n15 = n2; n15 < this.m_nRows; ++n15) {
                    this.m_aU[n15][n2] = -this.m_aU[n15][n2];
                }
                this.m_aU[n2][n2] = 1.0 + this.m_aU[n2][n2];
                for (n15 = 0; n15 < n2 - 1; ++n15) {
                    this.m_aU[n15][n2] = 0.0;
                }
                continue;
            }
            for (n15 = 0; n15 < this.m_nRows; ++n15) {
                this.m_aU[n15][n2] = 0.0;
            }
            this.m_aU[n2][n2] = 1.0;
        }
        for (n2 = this.m_nCols - 1; n2 >= 0; --n2) {
            int n17;
            if (n2 < n6 && dArray2[n2] != 0.0) {
                for (n17 = n2 + 1; n17 < n4; ++n17) {
                    d = 0.0;
                    for (n = n2 + 1; n < this.m_nCols; ++n) {
                        d += this.m_aV[n][n2] * this.m_aV[n][n17];
                    }
                    d = -d / this.m_aV[n2 + 1][n2];
                    for (n = n2 + 1; n < this.m_nCols; ++n) {
                        double[] dArray9 = this.m_aV[n];
                        int n18 = n17;
                        dArray9[n18] = dArray9[n18] + d * this.m_aV[n][n2];
                    }
                }
            }
            for (n17 = 0; n17 < this.m_nCols; ++n17) {
                this.m_aV[n17][n2] = 0.0;
            }
            this.m_aV[n2][n2] = 1.0;
        }
        n2 = n3 - 1;
        block35: while (n3 > 0) {
            int n19;
            int n20;
            for (n20 = n3 - 2; n20 >= -1 && n20 != -1; --n20) {
                if (!(MathHelper.abs((double)dArray2[n20]) <= TINY + EPSILON * (MathHelper.abs((double)this.m_aData[n20]) + MathHelper.abs((double)this.m_aData[n20 + 1])))) continue;
                dArray2[n20] = 0.0;
                break;
            }
            if (n20 == n3 - 2) {
                n19 = 4;
            } else {
                int n21;
                for (n21 = n3 - 1; n21 >= n20 && n21 != n20; --n21) {
                    double d4 = (n21 != n3 ? MathHelper.abs((double)dArray2[n21]) : 0.0) + (n21 != n20 + 1 ? MathHelper.abs((double)dArray2[n21 - 1]) : 0.0);
                    if (!(MathHelper.abs((double)this.m_aData[n21]) <= TINY + EPSILON * d4)) continue;
                    this.m_aData[n21] = 0.0;
                    break;
                }
                if (n21 == n20) {
                    n19 = 3;
                } else if (n21 == n3 - 1) {
                    n19 = 1;
                } else {
                    n19 = 2;
                    n20 = n21;
                }
            }
            ++n20;
            switch (n19) {
                case 1: {
                    double d5;
                    int n22;
                    double d6;
                    double d7;
                    double d8;
                    double d9 = dArray2[n3 - 2];
                    dArray2[n3 - 2] = 0.0;
                    for (int i = n3 - 2; i >= n20; --i) {
                        d8 = MathHelper.hypot((double)this.m_aData[i], (double)d9);
                        d7 = this.m_aData[i] / d8;
                        d6 = d9 / d8;
                        this.m_aData[i] = d8;
                        if (i != n20) {
                            d9 = -d6 * dArray2[i - 1];
                            int n23 = i - 1;
                            dArray2[n23] = dArray2[n23] * d7;
                        }
                        for (n22 = 0; n22 < this.m_nCols; ++n22) {
                            d5 = this.m_aV[n22][n3 - 1];
                            d8 = d7 * this.m_aV[n22][i] + d6 * d5;
                            this.m_aV[n22][n3 - 1] = -d6 * this.m_aV[n22][i] + d7 * d5;
                            this.m_aV[n22][i] = d8;
                        }
                    }
                    continue block35;
                }
                case 2: {
                    double d5;
                    int n22;
                    double d6;
                    double d7;
                    double d8;
                    double d10 = dArray2[n20 - 1];
                    dArray2[n20 - 1] = 0.0;
                    for (int i = n20; i < n3; ++i) {
                        d8 = MathHelper.hypot((double)this.m_aData[i], (double)d10);
                        d7 = this.m_aData[i] / d8;
                        d6 = d10 / d8;
                        this.m_aData[i] = d8;
                        d10 = -d6 * dArray2[i];
                        dArray2[i] = d7 * dArray2[i];
                        for (n22 = 0; n22 < this.m_nRows; ++n22) {
                            d5 = this.m_aU[n22][n20 - 1];
                            d8 = d7 * this.m_aU[n22][i] + d6 * d5;
                            this.m_aU[n22][n20 - 1] = -d6 * this.m_aU[n22][i] + d7 * d5;
                            this.m_aU[n22][i] = d8;
                        }
                    }
                    continue block35;
                }
                case 3: {
                    double d11 = MathHelper.getMaxDouble((double)MathHelper.abs((double)this.m_aData[n3 - 1]), (double[])new double[]{MathHelper.abs((double)this.m_aData[n3 - 2]), MathHelper.abs((double)dArray2[n3 - 2]), MathHelper.abs((double)this.m_aData[n20]), MathHelper.abs((double)dArray2[n20])});
                    double d12 = this.m_aData[n3 - 1] / d11;
                    double d13 = this.m_aData[n3 - 2] / d11;
                    double d14 = dArray2[n3 - 2] / d11;
                    double d15 = this.m_aData[n20] / d11;
                    double d5 = dArray2[n20] / d11;
                    double d16 = ((d13 + d12) * (d13 - d12) + d14 * d14) / 2.0;
                    double d17 = d12 * d14 * (d12 * d14);
                    double d18 = 0.0;
                    if (d16 != 0.0 || d17 != 0.0) {
                        d18 = Math.sqrt(d16 * d16 + d17);
                        if (d16 < 0.0) {
                            d18 = -d18;
                        }
                        d18 = d17 / (d16 + d18);
                    }
                    double d19 = (d15 + d12) * (d15 - d12) + d18;
                    double d20 = d15 * d5;
                    for (int i = n20; i < n3 - 1; ++i) {
                        int n24;
                        double d21 = MathHelper.hypot((double)d19, (double)d20);
                        double d22 = d19 / d21;
                        double d23 = d20 / d21;
                        if (i != n20) {
                            dArray2[i - 1] = d21;
                        }
                        d19 = d22 * this.m_aData[i] + d23 * dArray2[i];
                        dArray2[i] = d22 * dArray2[i] - d23 * this.m_aData[i];
                        d20 = d23 * this.m_aData[i + 1];
                        this.m_aData[i + 1] = d22 * this.m_aData[i + 1];
                        for (n24 = 0; n24 < this.m_nCols; ++n24) {
                            d21 = d22 * this.m_aV[n24][i] + d23 * this.m_aV[n24][i + 1];
                            this.m_aV[n24][i + 1] = -d23 * this.m_aV[n24][i] + d22 * this.m_aV[n24][i + 1];
                            this.m_aV[n24][i] = d21;
                        }
                        d21 = MathHelper.hypot((double)d19, (double)d20);
                        d22 = d19 / d21;
                        d23 = d20 / d21;
                        this.m_aData[i] = d21;
                        d19 = d22 * dArray2[i] + d23 * this.m_aData[i + 1];
                        this.m_aData[i + 1] = -d23 * dArray2[i] + d22 * this.m_aData[i + 1];
                        d20 = d23 * dArray2[i + 1];
                        dArray2[i + 1] = d22 * dArray2[i + 1];
                        if (i >= this.m_nRows - 1) continue;
                        for (n24 = 0; n24 < this.m_nRows; ++n24) {
                            double d24 = this.m_aU[n24][i + 1];
                            d21 = d22 * this.m_aU[n24][i] + d23 * d24;
                            this.m_aU[n24][i + 1] = -d23 * this.m_aU[n24][i] + d22 * d24;
                            this.m_aU[n24][i] = d21;
                        }
                    }
                    dArray2[n3 - 2] = d19;
                    break;
                }
                case 4: {
                    if (this.m_aData[n20] <= 0.0) {
                        this.m_aData[n20] = this.m_aData[n20] < 0.0 ? -this.m_aData[n20] : 0.0;
                        for (int i = 0; i <= n2; ++i) {
                            this.m_aV[i][n20] = -this.m_aV[i][n20];
                        }
                    }
                    while (n20 < n2 && !(this.m_aData[n20] >= this.m_aData[n20 + 1])) {
                        int n25;
                        double d25 = this.m_aData[n20];
                        this.m_aData[n20] = this.m_aData[n20 + 1];
                        this.m_aData[n20 + 1] = d25;
                        if (n20 < this.m_nCols - 1) {
                            for (n25 = 0; n25 < this.m_nCols; ++n25) {
                                d25 = this.m_aV[n25][n20 + 1];
                                this.m_aV[n25][n20 + 1] = this.m_aV[n25][n20];
                                this.m_aV[n25][n20] = d25;
                            }
                        }
                        if (n20 < this.m_nRows - 1) {
                            for (n25 = 0; n25 < this.m_nRows; ++n25) {
                                d25 = this.m_aU[n25][n20 + 1];
                                this.m_aU[n25][n20 + 1] = this.m_aU[n25][n20];
                                this.m_aU[n25][n20] = d25;
                            }
                        }
                        ++n20;
                    }
                    --n3;
                    break;
                }
                default: {
                    throw new IllegalStateException();
                }
            }
        }
    }

    @Nonnull
    @ReturnsMutableCopy
    public Matrix getU() {
        return new Matrix(this.m_aU, this.m_nRows, Math.min(this.m_nRows + 1, this.m_nCols));
    }

    @Nonnull
    @ReturnsMutableCopy
    public Matrix getV() {
        return new Matrix(this.m_aV, this.m_nCols, this.m_nCols);
    }

    @Nonnull
    public double[] getSingularValues() {
        return this.m_aData;
    }

    @Nonnull
    @ReturnsMutableCopy
    public Matrix getS() {
        Matrix matrix = new Matrix(this.m_nCols, this.m_nCols);
        double[][] dArray = matrix.internalGetArray();
        for (int i = 0; i < this.m_nCols; ++i) {
            Arrays.fill(dArray[i], 0.0);
            dArray[i][i] = this.m_aData[i];
        }
        return matrix;
    }

    public double norm2() {
        return this.m_aData[0];
    }

    public double cond() {
        return this.m_aData[0] / this.m_aData[Math.min(this.m_nRows, this.m_nCols) - 1];
    }

    public int rank() {
        double d = (double)Math.max(this.m_nRows, this.m_nCols) * this.m_aData[0] * EPSILON;
        int n = 0;
        for (double d2 : this.m_aData) {
            if (!(d2 > d)) continue;
            ++n;
        }
        return n;
    }
}

