/*
 * Decompiled with CFR 0.152.
 */
package oasis.names.specification.ubl.schema.xsd.commonaggregatecomponents_23;

import com.helger.commons.annotation.CodingStyleguideUnaware;
import com.helger.commons.annotation.ReturnsMutableCopy;
import com.helger.commons.annotation.ReturnsMutableObject;
import com.helger.commons.equals.EqualsHelper;
import com.helger.commons.hashcode.HashCodeGenerator;
import com.helger.commons.lang.IExplicitlyCloneable;
import com.helger.commons.string.ToStringGenerator;
import jakarta.xml.bind.annotation.XmlAccessType;
import jakarta.xml.bind.annotation.XmlAccessorType;
import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlType;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import oasis.names.specification.ubl.schema.xsd.commonaggregatecomponents_23.AttestationLineType;
import oasis.names.specification.ubl.schema.xsd.commonaggregatecomponents_23.PartyType;
import oasis.names.specification.ubl.schema.xsd.commonaggregatecomponents_23.PeriodType;
import oasis.names.specification.ubl.schema.xsd.commonbasiccomponents_23.AcceptanceIndicatorType;
import oasis.names.specification.ubl.schema.xsd.commonbasiccomponents_23.DescriptionType;
import oasis.names.specification.ubl.schema.xsd.commonbasiccomponents_23.IDType;
import oasis.names.specification.ubl.schema.xsd.commonbasiccomponents_23.NameType;
import oasis.names.specification.ubl.schema.xsd.commonbasiccomponents_23.NoteType;
import oasis.names.specification.ubl.schema.xsd.commonextensioncomponents_23.UBLExtensionsType;

@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlType(name="AttestationType", propOrder={"ublExtensions", "id", "name", "description", "note", "acceptanceIndicator", "validityPeriod", "issuerParty", "attestationLine"})
@CodingStyleguideUnaware
public class AttestationType
implements Serializable,
IExplicitlyCloneable {
    @XmlElement(name="UBLExtensions", namespace="urn:oasis:names:specification:ubl:schema:xsd:CommonExtensionComponents-2")
    private UBLExtensionsType ublExtensions;
    @XmlElement(name="ID", namespace="urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2")
    private IDType id;
    @XmlElement(name="Name", namespace="urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2")
    private NameType name;
    @XmlElement(name="Description", namespace="urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2")
    private List<DescriptionType> description;
    @XmlElement(name="Note", namespace="urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2")
    private List<NoteType> note;
    @XmlElement(name="AcceptanceIndicator", namespace="urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2")
    private AcceptanceIndicatorType acceptanceIndicator;
    @XmlElement(name="ValidityPeriod")
    private PeriodType validityPeriod;
    @XmlElement(name="IssuerParty")
    private PartyType issuerParty;
    @XmlElement(name="AttestationLine", required=true)
    private List<AttestationLineType> attestationLine;

    @Nullable
    public UBLExtensionsType getUBLExtensions() {
        return this.ublExtensions;
    }

    public void setUBLExtensions(@Nullable UBLExtensionsType uBLExtensionsType) {
        this.ublExtensions = uBLExtensionsType;
    }

    @Nullable
    public IDType getID() {
        return this.id;
    }

    public void setID(@Nullable IDType iDType) {
        this.id = iDType;
    }

    @Nullable
    public NameType getName() {
        return this.name;
    }

    public void setName(@Nullable NameType nameType) {
        this.name = nameType;
    }

    @Nonnull
    @ReturnsMutableObject(value="JAXB implementation style")
    public List<DescriptionType> getDescription() {
        if (this.description == null) {
            this.description = new ArrayList<DescriptionType>();
        }
        return this.description;
    }

    @Nonnull
    @ReturnsMutableObject(value="JAXB implementation style")
    public List<NoteType> getNote() {
        if (this.note == null) {
            this.note = new ArrayList<NoteType>();
        }
        return this.note;
    }

    @Nullable
    public AcceptanceIndicatorType getAcceptanceIndicator() {
        return this.acceptanceIndicator;
    }

    public void setAcceptanceIndicator(@Nullable AcceptanceIndicatorType acceptanceIndicatorType) {
        this.acceptanceIndicator = acceptanceIndicatorType;
    }

    @Nullable
    public PeriodType getValidityPeriod() {
        return this.validityPeriod;
    }

    public void setValidityPeriod(@Nullable PeriodType periodType) {
        this.validityPeriod = periodType;
    }

    @Nullable
    public PartyType getIssuerParty() {
        return this.issuerParty;
    }

    public void setIssuerParty(@Nullable PartyType partyType) {
        this.issuerParty = partyType;
    }

    @Nonnull
    @ReturnsMutableObject(value="JAXB implementation style")
    public List<AttestationLineType> getAttestationLine() {
        if (this.attestationLine == null) {
            this.attestationLine = new ArrayList<AttestationLineType>();
        }
        return this.attestationLine;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object == null || !this.getClass().equals(object.getClass())) {
            return false;
        }
        AttestationType attestationType = (AttestationType)object;
        if (!EqualsHelper.equals((Object)this.acceptanceIndicator, (Object)attestationType.acceptanceIndicator)) {
            return false;
        }
        if (!EqualsHelper.equalsCollection(this.attestationLine, attestationType.attestationLine)) {
            return false;
        }
        if (!EqualsHelper.equalsCollection(this.description, attestationType.description)) {
            return false;
        }
        if (!EqualsHelper.equals((Object)this.id, (Object)attestationType.id)) {
            return false;
        }
        if (!EqualsHelper.equals((Object)this.issuerParty, (Object)attestationType.issuerParty)) {
            return false;
        }
        if (!EqualsHelper.equals((Object)this.name, (Object)attestationType.name)) {
            return false;
        }
        if (!EqualsHelper.equalsCollection(this.note, attestationType.note)) {
            return false;
        }
        if (!EqualsHelper.equals((Object)this.ublExtensions, (Object)attestationType.ublExtensions)) {
            return false;
        }
        return EqualsHelper.equals((Object)this.validityPeriod, (Object)attestationType.validityPeriod);
    }

    public int hashCode() {
        return new HashCodeGenerator((Object)this).append((Object)this.acceptanceIndicator).append(this.attestationLine).append(this.description).append((Object)this.id).append((Object)this.issuerParty).append((Object)this.name).append(this.note).append((Object)this.ublExtensions).append((Object)this.validityPeriod).getHashCode();
    }

    public String toString() {
        return new ToStringGenerator((Object)this).append("acceptanceIndicator", (Object)this.acceptanceIndicator).append("attestationLine", this.attestationLine).append("description", this.description).append("id", (Object)this.id).append("issuerParty", (Object)this.issuerParty).append("name", (Object)this.name).append("note", this.note).append("ublExtensions", (Object)this.ublExtensions).append("validityPeriod", (Object)this.validityPeriod).getToString();
    }

    public void setDescription(@Nullable List<DescriptionType> list) {
        this.description = list;
    }

    public void setNote(@Nullable List<NoteType> list) {
        this.note = list;
    }

    public void setAttestationLine(@Nullable List<AttestationLineType> list) {
        this.attestationLine = list;
    }

    public boolean hasDescriptionEntries() {
        return !this.getDescription().isEmpty();
    }

    public boolean hasNoDescriptionEntries() {
        return this.getDescription().isEmpty();
    }

    @Nonnegative
    public int getDescriptionCount() {
        return this.getDescription().size();
    }

    @Nullable
    public DescriptionType getDescriptionAtIndex(@Nonnegative int n) throws IndexOutOfBoundsException {
        return this.getDescription().get(n);
    }

    public void addDescription(@Nonnull DescriptionType descriptionType) {
        this.getDescription().add(descriptionType);
    }

    public boolean hasNoteEntries() {
        return !this.getNote().isEmpty();
    }

    public boolean hasNoNoteEntries() {
        return this.getNote().isEmpty();
    }

    @Nonnegative
    public int getNoteCount() {
        return this.getNote().size();
    }

    @Nullable
    public NoteType getNoteAtIndex(@Nonnegative int n) throws IndexOutOfBoundsException {
        return this.getNote().get(n);
    }

    public void addNote(@Nonnull NoteType noteType) {
        this.getNote().add(noteType);
    }

    public boolean hasAttestationLineEntries() {
        return !this.getAttestationLine().isEmpty();
    }

    public boolean hasNoAttestationLineEntries() {
        return this.getAttestationLine().isEmpty();
    }

    @Nonnegative
    public int getAttestationLineCount() {
        return this.getAttestationLine().size();
    }

    @Nullable
    public AttestationLineType getAttestationLineAtIndex(@Nonnegative int n) throws IndexOutOfBoundsException {
        return this.getAttestationLine().get(n);
    }

    public void addAttestationLine(@Nonnull AttestationLineType attestationLineType) {
        this.getAttestationLine().add(attestationLineType);
    }

    public void cloneTo(@Nonnull AttestationType attestationType) {
        ArrayList<AttestationLineType> arrayList;
        AcceptanceIndicatorType acceptanceIndicatorType = attestationType.acceptanceIndicator = this.acceptanceIndicator == null ? null : this.acceptanceIndicator.clone();
        if (this.attestationLine == null) {
            attestationType.attestationLine = null;
        } else {
            arrayList = new ArrayList<AttestationLineType>();
            for (AttestationLineType serializable : this.getAttestationLine()) {
                arrayList.add(serializable == null ? null : serializable.clone());
            }
            attestationType.attestationLine = arrayList;
        }
        if (this.description == null) {
            attestationType.description = null;
        } else {
            arrayList = new ArrayList();
            for (DescriptionType descriptionType : this.getDescription()) {
                arrayList.add((AttestationLineType)((Object)(descriptionType == null ? null : descriptionType.clone())));
            }
            attestationType.description = arrayList;
        }
        attestationType.id = this.id == null ? null : this.id.clone();
        attestationType.issuerParty = this.issuerParty == null ? null : this.issuerParty.clone();
        NameType nameType = attestationType.name = this.name == null ? null : this.name.clone();
        if (this.note == null) {
            attestationType.note = null;
        } else {
            arrayList = new ArrayList();
            for (NoteType noteType : this.getNote()) {
                arrayList.add((AttestationLineType)((Object)(noteType == null ? null : noteType.clone())));
            }
            attestationType.note = arrayList;
        }
        attestationType.ublExtensions = this.ublExtensions == null ? null : this.ublExtensions.clone();
        attestationType.validityPeriod = this.validityPeriod == null ? null : this.validityPeriod.clone();
    }

    @Nonnull
    @ReturnsMutableCopy
    public AttestationType clone() {
        AttestationType attestationType = new AttestationType();
        this.cloneTo(attestationType);
        return attestationType;
    }

    @Nonnull
    public IDType setID(@Nullable String string) {
        IDType iDType = this.getID();
        if (iDType == null) {
            iDType = new IDType(string);
            this.setID(iDType);
        } else {
            iDType.setValue(string);
        }
        return iDType;
    }

    @Nonnull
    public NameType setName(@Nullable String string) {
        NameType nameType = this.getName();
        if (nameType == null) {
            nameType = new NameType(string);
            this.setName(nameType);
        } else {
            nameType.setValue(string);
        }
        return nameType;
    }

    @Nonnull
    public AcceptanceIndicatorType setAcceptanceIndicator(boolean bl) {
        AcceptanceIndicatorType acceptanceIndicatorType = this.getAcceptanceIndicator();
        if (acceptanceIndicatorType == null) {
            acceptanceIndicatorType = new AcceptanceIndicatorType(bl);
            this.setAcceptanceIndicator(acceptanceIndicatorType);
        } else {
            acceptanceIndicatorType.setValue(bl);
        }
        return acceptanceIndicatorType;
    }

    @Nullable
    public String getIDValue() {
        IDType iDType = this.getID();
        return iDType == null ? null : iDType.getValue();
    }

    @Nullable
    public String getNameValue() {
        NameType nameType = this.getName();
        return nameType == null ? null : nameType.getValue();
    }

    public boolean isAcceptanceIndicatorValue(boolean bl) {
        AcceptanceIndicatorType acceptanceIndicatorType = this.getAcceptanceIndicator();
        return acceptanceIndicatorType == null ? bl : acceptanceIndicatorType.isValue();
    }
}

