/*
 * Decompiled with CFR 0.152.
 */
package com.helger.ubl24;

import com.helger.annotation.Nonempty;
import com.helger.annotation.style.ReturnsMutableCopy;
import com.helger.base.lang.clazz.ClassHelper;
import com.helger.base.string.StringHelper;
import com.helger.collection.commons.ICommonsList;
import com.helger.io.resource.ClassPathResource;
import com.helger.ubl24.UBL24Marshaller;
import jakarta.annotation.Nonnull;
import jakarta.xml.bind.annotation.XmlSchema;
import oasis.names.specification.ubl.schema.xsd.applicationresponse_24.ApplicationResponseType;
import oasis.names.specification.ubl.schema.xsd.attacheddocument_24.AttachedDocumentType;
import oasis.names.specification.ubl.schema.xsd.awardednotification_24.AwardedNotificationType;
import oasis.names.specification.ubl.schema.xsd.billoflading_24.BillOfLadingType;
import oasis.names.specification.ubl.schema.xsd.businesscard_24.BusinessCardType;
import oasis.names.specification.ubl.schema.xsd.businessinformation_24.BusinessInformationType;
import oasis.names.specification.ubl.schema.xsd.callfortenders_24.CallForTendersType;
import oasis.names.specification.ubl.schema.xsd.catalogue_24.CatalogueType;
import oasis.names.specification.ubl.schema.xsd.cataloguedeletion_24.CatalogueDeletionType;
import oasis.names.specification.ubl.schema.xsd.catalogueitemspecificationupdate_24.CatalogueItemSpecificationUpdateType;
import oasis.names.specification.ubl.schema.xsd.cataloguepricingupdate_24.CataloguePricingUpdateType;
import oasis.names.specification.ubl.schema.xsd.cataloguerequest_24.CatalogueRequestType;
import oasis.names.specification.ubl.schema.xsd.certificateoforigin_24.CertificateOfOriginType;
import oasis.names.specification.ubl.schema.xsd.commontransportationreport_24.CommonTransportationReportType;
import oasis.names.specification.ubl.schema.xsd.contractawardnotice_24.ContractAwardNoticeType;
import oasis.names.specification.ubl.schema.xsd.contractnotice_24.ContractNoticeType;
import oasis.names.specification.ubl.schema.xsd.creditnote_24.CreditNoteType;
import oasis.names.specification.ubl.schema.xsd.debitnote_24.DebitNoteType;
import oasis.names.specification.ubl.schema.xsd.despatchadvice_24.DespatchAdviceType;
import oasis.names.specification.ubl.schema.xsd.digitalagreement_24.DigitalAgreementType;
import oasis.names.specification.ubl.schema.xsd.digitalcapability_24.DigitalCapabilityType;
import oasis.names.specification.ubl.schema.xsd.documentstatus_24.DocumentStatusType;
import oasis.names.specification.ubl.schema.xsd.documentstatusrequest_24.DocumentStatusRequestType;
import oasis.names.specification.ubl.schema.xsd.enquiry_24.EnquiryType;
import oasis.names.specification.ubl.schema.xsd.enquiryresponse_24.EnquiryResponseType;
import oasis.names.specification.ubl.schema.xsd.exceptioncriteria_24.ExceptionCriteriaType;
import oasis.names.specification.ubl.schema.xsd.exceptionnotification_24.ExceptionNotificationType;
import oasis.names.specification.ubl.schema.xsd.exportcustomsdeclaration_24.ExportCustomsDeclarationType;
import oasis.names.specification.ubl.schema.xsd.expressionofinterestrequest_24.ExpressionOfInterestRequestType;
import oasis.names.specification.ubl.schema.xsd.expressionofinterestresponse_24.ExpressionOfInterestResponseType;
import oasis.names.specification.ubl.schema.xsd.forecast_24.ForecastType;
import oasis.names.specification.ubl.schema.xsd.forecastrevision_24.ForecastRevisionType;
import oasis.names.specification.ubl.schema.xsd.forwardinginstructions_24.ForwardingInstructionsType;
import oasis.names.specification.ubl.schema.xsd.freightinvoice_24.FreightInvoiceType;
import oasis.names.specification.ubl.schema.xsd.fulfilmentcancellation_24.FulfilmentCancellationType;
import oasis.names.specification.ubl.schema.xsd.goodscertificate_24.GoodsCertificateType;
import oasis.names.specification.ubl.schema.xsd.goodsitemitinerary_24.GoodsItemItineraryType;
import oasis.names.specification.ubl.schema.xsd.goodsitempassport_24.GoodsItemPassportType;
import oasis.names.specification.ubl.schema.xsd.guaranteecertificate_24.GuaranteeCertificateType;
import oasis.names.specification.ubl.schema.xsd.importcustomsdeclaration_24.ImportCustomsDeclarationType;
import oasis.names.specification.ubl.schema.xsd.instructionforreturns_24.InstructionForReturnsType;
import oasis.names.specification.ubl.schema.xsd.inventoryreport_24.InventoryReportType;
import oasis.names.specification.ubl.schema.xsd.invoice_24.InvoiceType;
import oasis.names.specification.ubl.schema.xsd.iteminformationrequest_24.ItemInformationRequestType;
import oasis.names.specification.ubl.schema.xsd.manifest_24.ManifestType;
import oasis.names.specification.ubl.schema.xsd.order_24.OrderType;
import oasis.names.specification.ubl.schema.xsd.ordercancellation_24.OrderCancellationType;
import oasis.names.specification.ubl.schema.xsd.orderchange_24.OrderChangeType;
import oasis.names.specification.ubl.schema.xsd.orderresponse_24.OrderResponseType;
import oasis.names.specification.ubl.schema.xsd.orderresponsesimple_24.OrderResponseSimpleType;
import oasis.names.specification.ubl.schema.xsd.packinglist_24.PackingListType;
import oasis.names.specification.ubl.schema.xsd.priorinformationnotice_24.PriorInformationNoticeType;
import oasis.names.specification.ubl.schema.xsd.productactivity_24.ProductActivityType;
import oasis.names.specification.ubl.schema.xsd.proofofreexportation_24.ProofOfReexportationType;
import oasis.names.specification.ubl.schema.xsd.proofofreexportationreminder_24.ProofOfReexportationReminderType;
import oasis.names.specification.ubl.schema.xsd.proofofreexportationrequest_24.ProofOfReexportationRequestType;
import oasis.names.specification.ubl.schema.xsd.purchasereceipt_24.PurchaseReceiptType;
import oasis.names.specification.ubl.schema.xsd.qualificationapplicationrequest_24.QualificationApplicationRequestType;
import oasis.names.specification.ubl.schema.xsd.qualificationapplicationresponse_24.QualificationApplicationResponseType;
import oasis.names.specification.ubl.schema.xsd.quotation_24.QuotationType;
import oasis.names.specification.ubl.schema.xsd.receiptadvice_24.ReceiptAdviceType;
import oasis.names.specification.ubl.schema.xsd.reminder_24.ReminderType;
import oasis.names.specification.ubl.schema.xsd.remittanceadvice_24.RemittanceAdviceType;
import oasis.names.specification.ubl.schema.xsd.requestforquotation_24.RequestForQuotationType;
import oasis.names.specification.ubl.schema.xsd.retailevent_24.RetailEventType;
import oasis.names.specification.ubl.schema.xsd.selfbilledcreditnote_24.SelfBilledCreditNoteType;
import oasis.names.specification.ubl.schema.xsd.selfbilledinvoice_24.SelfBilledInvoiceType;
import oasis.names.specification.ubl.schema.xsd.statement_24.StatementType;
import oasis.names.specification.ubl.schema.xsd.stockavailabilityreport_24.StockAvailabilityReportType;
import oasis.names.specification.ubl.schema.xsd.tender_24.TenderType;
import oasis.names.specification.ubl.schema.xsd.tendercontract_24.TenderContractType;
import oasis.names.specification.ubl.schema.xsd.tendererqualification_24.TendererQualificationType;
import oasis.names.specification.ubl.schema.xsd.tendererqualificationresponse_24.TendererQualificationResponseType;
import oasis.names.specification.ubl.schema.xsd.tenderreceipt_24.TenderReceiptType;
import oasis.names.specification.ubl.schema.xsd.tenderstatus_24.TenderStatusType;
import oasis.names.specification.ubl.schema.xsd.tenderstatusrequest_24.TenderStatusRequestType;
import oasis.names.specification.ubl.schema.xsd.tenderwithdrawal_24.TenderWithdrawalType;
import oasis.names.specification.ubl.schema.xsd.tradeitemlocationprofile_24.TradeItemLocationProfileType;
import oasis.names.specification.ubl.schema.xsd.transitcustomsdeclaration_24.TransitCustomsDeclarationType;
import oasis.names.specification.ubl.schema.xsd.transportationstatus_24.TransportationStatusType;
import oasis.names.specification.ubl.schema.xsd.transportationstatusrequest_24.TransportationStatusRequestType;
import oasis.names.specification.ubl.schema.xsd.transportexecutionplan_24.TransportExecutionPlanType;
import oasis.names.specification.ubl.schema.xsd.transportexecutionplanrequest_24.TransportExecutionPlanRequestType;
import oasis.names.specification.ubl.schema.xsd.transportprogressstatus_24.TransportProgressStatusType;
import oasis.names.specification.ubl.schema.xsd.transportprogressstatusrequest_24.TransportProgressStatusRequestType;
import oasis.names.specification.ubl.schema.xsd.transportservicedescription_24.TransportServiceDescriptionType;
import oasis.names.specification.ubl.schema.xsd.transportservicedescriptionrequest_24.TransportServiceDescriptionRequestType;
import oasis.names.specification.ubl.schema.xsd.unawardednotification_24.UnawardedNotificationType;
import oasis.names.specification.ubl.schema.xsd.unsubscribefromprocedurerequest_24.UnsubscribeFromProcedureRequestType;
import oasis.names.specification.ubl.schema.xsd.unsubscribefromprocedureresponse_24.UnsubscribeFromProcedureResponseType;
import oasis.names.specification.ubl.schema.xsd.utilitystatement_24.UtilityStatementType;
import oasis.names.specification.ubl.schema.xsd.waybill_24.WaybillType;
import oasis.names.specification.ubl.schema.xsd.weightstatement_24.WeightStatementType;

public enum EUBL24DocumentType {
    APPLICATION_RESPONSE(ApplicationResponseType.class, UBL24Marshaller.getAllApplicationResponseXSDs()),
    ATTACHED_DOCUMENT(AttachedDocumentType.class, UBL24Marshaller.getAllAttachedDocumentXSDs()),
    AWARDED_NOTIFICATION(AwardedNotificationType.class, UBL24Marshaller.getAllAwardedNotificationXSDs()),
    BILL_OF_LADING(BillOfLadingType.class, UBL24Marshaller.getAllBillOfLadingXSDs()),
    BUSINESS_CARD(BusinessCardType.class, UBL24Marshaller.getAllBusinessCardXSDs()),
    BUSINESS_INFORMATION(BusinessInformationType.class, UBL24Marshaller.getAllBusinessInformationXSDs()),
    CALL_FOR_TENDERS(CallForTendersType.class, UBL24Marshaller.getAllCallForTendersXSDs()),
    CATALOGUE(CatalogueType.class, UBL24Marshaller.getAllCatalogueXSDs()),
    CATALOGUE_DELETION(CatalogueDeletionType.class, UBL24Marshaller.getAllCatalogueDeletionXSDs()),
    CATALOGUE_ITEM_SPECIFICATION_UPDATE(CatalogueItemSpecificationUpdateType.class, UBL24Marshaller.getAllCatalogueItemSpecificationUpdateXSDs()),
    CATALOGUE_PRICING_UPDATE(CataloguePricingUpdateType.class, UBL24Marshaller.getAllCataloguePricingUpdateXSDs()),
    CATALOGUE_REQUEST(CatalogueRequestType.class, UBL24Marshaller.getAllCatalogueRequestXSDs()),
    CERTIFICATE_OF_ORIGIN(CertificateOfOriginType.class, UBL24Marshaller.getAllCertificateOfOriginXSDs()),
    COMMON_TRANSPORTATION_REPORT(CommonTransportationReportType.class, UBL24Marshaller.getAllCommonTransportationReportXSDs()),
    CONTRACT_AWARD_NOTICE(ContractAwardNoticeType.class, UBL24Marshaller.getAllContractAwardNoticeXSDs()),
    CONTRACT_NOTICE(ContractNoticeType.class, UBL24Marshaller.getAllContractNoticeXSDs()),
    CREDIT_NOTE(CreditNoteType.class, UBL24Marshaller.getAllCreditNoteXSDs()),
    DEBIT_NOTE(DebitNoteType.class, UBL24Marshaller.getAllDebitNoteXSDs()),
    DESPATCH_ADVICE(DespatchAdviceType.class, UBL24Marshaller.getAllDespatchAdviceXSDs()),
    DIGITAL_AGREEMENT(DigitalAgreementType.class, UBL24Marshaller.getAllDigitalAgreementXSDs()),
    DIGITAL_CAPABILITY(DigitalCapabilityType.class, UBL24Marshaller.getAllDigitalCapabilityXSDs()),
    DOCUMENT_STATUS(DocumentStatusType.class, UBL24Marshaller.getAllDocumentStatusXSDs()),
    DOCUMENT_STATUS_REQUEST(DocumentStatusRequestType.class, UBL24Marshaller.getAllDocumentStatusRequestXSDs()),
    ENQUIRY(EnquiryType.class, UBL24Marshaller.getAllEnquiryXSDs()),
    ENQUIRY_RESPONSE(EnquiryResponseType.class, UBL24Marshaller.getAllEnquiryResponseXSDs()),
    EXCEPTION_CRITERIA(ExceptionCriteriaType.class, UBL24Marshaller.getAllExceptionCriteriaXSDs()),
    EXCEPTION_NOTIFICATION(ExceptionNotificationType.class, UBL24Marshaller.getAllExceptionNotificationXSDs()),
    EXPORT_CUSTOMS_DECLARATION(ExportCustomsDeclarationType.class, UBL24Marshaller.getAllExportCustomsDeclarationXSDs()),
    EXPRESSION_OF_INTEREST_REQUEST(ExpressionOfInterestRequestType.class, UBL24Marshaller.getAllExpressionOfInterestRequestXSDs()),
    EXPRESSION_OF_INTEREST_RESPONSE(ExpressionOfInterestResponseType.class, UBL24Marshaller.getAllExpressionOfInterestResponseXSDs()),
    FORECAST(ForecastType.class, UBL24Marshaller.getAllForecastXSDs()),
    FORECAST_REVISION(ForecastRevisionType.class, UBL24Marshaller.getAllForecastRevisionXSDs()),
    FORWARDING_INSTRUCTIONS(ForwardingInstructionsType.class, UBL24Marshaller.getAllForwardingInstructionsXSDs()),
    FREIGHT_INVOICE(FreightInvoiceType.class, UBL24Marshaller.getAllFreightInvoiceXSDs()),
    FULFILMENT_CANCELLATION(FulfilmentCancellationType.class, UBL24Marshaller.getAllFulfilmentCancellationXSDs()),
    GOODS_CERTIFICATE(GoodsCertificateType.class, UBL24Marshaller.getAllGoodsCertificateXSDs()),
    GOODS_ITEM_ITINERARY(GoodsItemItineraryType.class, UBL24Marshaller.getAllGoodsItemItineraryXSDs()),
    GOODS_ITEM_PASSPORT(GoodsItemPassportType.class, UBL24Marshaller.getAllGoodsItemPassportXSDs()),
    GUARANTEE_CERTIFICATE(GuaranteeCertificateType.class, UBL24Marshaller.getAllGuaranteeCertificateXSDs()),
    IMPORT_CUSTOMS_DECLARATION(ImportCustomsDeclarationType.class, UBL24Marshaller.getAllImportCustomsDeclarationXSDs()),
    INSTRUCTION_FOR_RETURNS(InstructionForReturnsType.class, UBL24Marshaller.getAllInstructionForReturnsXSDs()),
    INVENTORY_REPORT(InventoryReportType.class, UBL24Marshaller.getAllInventoryReportXSDs()),
    INVOICE(InvoiceType.class, UBL24Marshaller.getAllInvoiceXSDs()),
    ITEM_INFORMATION_REQUEST(ItemInformationRequestType.class, UBL24Marshaller.getAllItemInformationRequestXSDs()),
    MANIFEST(ManifestType.class, UBL24Marshaller.getAllManifestXSDs()),
    ORDER(OrderType.class, UBL24Marshaller.getAllOrderXSDs()),
    ORDER_CANCELLATION(OrderCancellationType.class, UBL24Marshaller.getAllOrderCancellationXSDs()),
    ORDER_CHANGE(OrderChangeType.class, UBL24Marshaller.getAllOrderChangeXSDs()),
    ORDER_RESPONSE(OrderResponseType.class, UBL24Marshaller.getAllOrderResponseXSDs()),
    ORDER_RESPONSE_SIMPLE(OrderResponseSimpleType.class, UBL24Marshaller.getAllOrderResponseSimpleXSDs()),
    PACKING_LIST(PackingListType.class, UBL24Marshaller.getAllPackingListXSDs()),
    PRIOR_INFORMATION_NOTICE(PriorInformationNoticeType.class, UBL24Marshaller.getAllPriorInformationNoticeXSDs()),
    PRODUCT_ACTIVITY(ProductActivityType.class, UBL24Marshaller.getAllProductActivityXSDs()),
    PROOF_OF_REEXPORTATION(ProofOfReexportationType.class, UBL24Marshaller.getAllProofOfReexportationXSDs()),
    PROOF_OF_REEXPORTATION_REMINDER(ProofOfReexportationReminderType.class, UBL24Marshaller.getAllProofOfReexportationReminderXSDs()),
    PROOF_OF_REEXPORTATION_REQUEST(ProofOfReexportationRequestType.class, UBL24Marshaller.getAllProofOfReexportationRequestXSDs()),
    PURCHASE_RECEIPT(PurchaseReceiptType.class, UBL24Marshaller.getAllPurchaseReceiptXSDs()),
    QUALIFICATION_APPLICATION_REQUEST(QualificationApplicationRequestType.class, UBL24Marshaller.getAllQualificationApplicationRequestXSDs()),
    QUALIFICATION_APPLICATION_RESPONSE(QualificationApplicationResponseType.class, UBL24Marshaller.getAllQualificationApplicationResponseXSDs()),
    QUOTATION(QuotationType.class, UBL24Marshaller.getAllQuotationXSDs()),
    RECEIPT_ADVICE(ReceiptAdviceType.class, UBL24Marshaller.getAllReceiptAdviceXSDs()),
    REMINDER(ReminderType.class, UBL24Marshaller.getAllReminderXSDs()),
    REMITTANCE_ADVICE(RemittanceAdviceType.class, UBL24Marshaller.getAllRemittanceAdviceXSDs()),
    REQUEST_FOR_QUOTATION(RequestForQuotationType.class, UBL24Marshaller.getAllRequestForQuotationXSDs()),
    RETAIL_EVENT(RetailEventType.class, UBL24Marshaller.getAllRetailEventXSDs()),
    SELF_BILLED_CREDIT_NOTE(SelfBilledCreditNoteType.class, UBL24Marshaller.getAllSelfBilledCreditNoteXSDs()),
    SELF_BILLED_INVOICE(SelfBilledInvoiceType.class, UBL24Marshaller.getAllSelfBilledInvoiceXSDs()),
    STATEMENT(StatementType.class, UBL24Marshaller.getAllStatementXSDs()),
    STOCK_AVAILABILITY_REPORT(StockAvailabilityReportType.class, UBL24Marshaller.getAllStockAvailabilityReportXSDs()),
    TENDER(TenderType.class, UBL24Marshaller.getAllTenderXSDs()),
    TENDER_CONTRACT(TenderContractType.class, UBL24Marshaller.getAllTenderContractXSDs()),
    TENDER_RECEIPT(TenderReceiptType.class, UBL24Marshaller.getAllTenderReceiptXSDs()),
    TENDER_STATUS(TenderStatusType.class, UBL24Marshaller.getAllTenderStatusXSDs()),
    TENDER_STATUS_REQUEST(TenderStatusRequestType.class, UBL24Marshaller.getAllTenderStatusRequestXSDs()),
    TENDER_WITHDRAWAL(TenderWithdrawalType.class, UBL24Marshaller.getAllTenderWithdrawalXSDs()),
    TENDERER_QUALIFICATION(TendererQualificationType.class, UBL24Marshaller.getAllTendererQualificationXSDs()),
    TENDERER_QUALIFICATION_RESPONSE(TendererQualificationResponseType.class, UBL24Marshaller.getAllTendererQualificationResponseXSDs()),
    TRADE_ITEM_LOCATION_PROFILE(TradeItemLocationProfileType.class, UBL24Marshaller.getAllTradeItemLocationProfileXSDs()),
    TRANSIT_CUSTOMS_DECLARATION(TransitCustomsDeclarationType.class, UBL24Marshaller.getAllTransitCustomsDeclarationXSDs()),
    TRANSPORT_EXECUTION_PLAN(TransportExecutionPlanType.class, UBL24Marshaller.getAllTransportExecutionPlanXSDs()),
    TRANSPORT_EXECUTION_PLAN_REQUEST(TransportExecutionPlanRequestType.class, UBL24Marshaller.getAllTransportExecutionPlanRequestXSDs()),
    TRANSPORT_PROGRESS_STATUS(TransportProgressStatusType.class, UBL24Marshaller.getAllTransportProgressStatusXSDs()),
    TRANSPORT_PROGRESS_STATUS_REQUEST(TransportProgressStatusRequestType.class, UBL24Marshaller.getAllTransportProgressStatusRequestXSDs()),
    TRANSPORT_SERVICE_DESCRIPTION(TransportServiceDescriptionType.class, UBL24Marshaller.getAllTransportServiceDescriptionXSDs()),
    TRANSPORT_SERVICE_DESCRIPTION_REQUEST(TransportServiceDescriptionRequestType.class, UBL24Marshaller.getAllTransportServiceDescriptionRequestXSDs()),
    TRANSPORTATION_STATUS(TransportationStatusType.class, UBL24Marshaller.getAllTransportationStatusXSDs()),
    TRANSPORTATION_STATUS_REQUEST(TransportationStatusRequestType.class, UBL24Marshaller.getAllTransportationStatusRequestXSDs()),
    UNAWARDED_NOTIFICATION(UnawardedNotificationType.class, UBL24Marshaller.getAllUnawardedNotificationXSDs()),
    UNSUBSCRIBE_FROM_PROCEDURE_REQUEST(UnsubscribeFromProcedureRequestType.class, UBL24Marshaller.getAllUnsubscribeFromProcedureRequestXSDs()),
    UNSUBSCRIBE_FROM_PROCEDURE_RESPONSE(UnsubscribeFromProcedureResponseType.class, UBL24Marshaller.getAllUnsubscribeFromProcedureResponseXSDs()),
    UTILITY_STATEMENT(UtilityStatementType.class, UBL24Marshaller.getAllUtilityStatementXSDs()),
    WAYBILL(WaybillType.class, UBL24Marshaller.getAllWaybillXSDs()),
    WEIGHT_STATEMENT(WeightStatementType.class, UBL24Marshaller.getAllWeightStatementXSDs());

    private final Class<?> m_aImplClass;
    private final ICommonsList<ClassPathResource> m_aXSDs;
    private final String m_sRootElementLocalName;
    private final String m_sRootElementNSURI;

    private EUBL24DocumentType(Class<?> clazz, ICommonsList<ClassPathResource> iCommonsList) {
        this.m_aImplClass = clazz;
        this.m_aXSDs = iCommonsList;
        this.m_sRootElementLocalName = StringHelper.trimEnd((String)ClassHelper.getClassLocalName(clazz), (String)"Type");
        this.m_sRootElementNSURI = clazz.getPackage().getAnnotation(XmlSchema.class).namespace();
    }

    @Nonnull
    public Class<?> getImplementationClass() {
        return this.m_aImplClass;
    }

    @Nonnull
    @Nonempty
    @ReturnsMutableCopy
    public ICommonsList<ClassPathResource> getAllXSDResources() {
        return (ICommonsList)this.m_aXSDs.getClone();
    }

    @Nonnull
    @Nonempty
    public String getRootElementLocalName() {
        return this.m_sRootElementLocalName;
    }

    @Nonnull
    @Nonempty
    public String getRootElementNamespaceURI() {
        return this.m_sRootElementNSURI;
    }
}

