/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.kernel.utils;

import com.itextpdf.io.util.MessageFormatUtil;
import com.itextpdf.kernel.PdfException;
import com.itextpdf.kernel.utils.IXmlParserFactory;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXNotRecognizedException;
import org.xml.sax.SAXNotSupportedException;
import org.xml.sax.XMLReader;

public class DefaultSafeXmlParserFactory
implements IXmlParserFactory {
    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultSafeXmlParserFactory.class);
    private static final String DISALLOW_DOCTYPE_DECL = "http://apache.org/xml/features/disallow-doctype-decl";
    private static final String EXTERNAL_GENERAL_ENTITIES = "http://xml.org/sax/features/external-general-entities";
    private static final String EXTERNAL_PARAMETER_ENTITIES = "http://xml.org/sax/features/external-parameter-entities";
    private static final String LOAD_EXTERNAL_DTD = "http://apache.org/xml/features/nonvalidating/load-external-dtd";

    @Override
    public DocumentBuilder createDocumentBuilderInstance(boolean namespaceAware, boolean ignoringComments) {
        DocumentBuilder db;
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        this.configureSafeDocumentBuilderFactory(factory);
        factory.setNamespaceAware(namespaceAware);
        factory.setIgnoringComments(ignoringComments);
        try {
            db = factory.newDocumentBuilder();
        }
        catch (ParserConfigurationException e) {
            throw new PdfException(e.getMessage(), e);
        }
        db.setEntityResolver(new SafeEmptyEntityResolver());
        return db;
    }

    @Override
    public XMLReader createXMLReaderInstance(boolean namespaceAware, boolean validating) {
        XMLReader xmlReader;
        SAXParserFactory factory = SAXParserFactory.newInstance();
        factory.setNamespaceAware(namespaceAware);
        factory.setValidating(validating);
        this.configureSafeSAXParserFactory(factory);
        try {
            SAXParser saxParser = factory.newSAXParser();
            xmlReader = saxParser.getXMLReader();
        }
        catch (ParserConfigurationException | SAXException e) {
            throw new PdfException(e.getMessage(), e);
        }
        xmlReader.setEntityResolver(new SafeEmptyEntityResolver());
        return xmlReader;
    }

    private void configureSafeDocumentBuilderFactory(DocumentBuilderFactory factory) {
        this.tryToSetFeature(factory, DISALLOW_DOCTYPE_DECL, true);
        this.tryToSetFeature(factory, EXTERNAL_GENERAL_ENTITIES, false);
        this.tryToSetFeature(factory, EXTERNAL_PARAMETER_ENTITIES, false);
        this.tryToSetFeature(factory, LOAD_EXTERNAL_DTD, false);
        factory.setXIncludeAware(false);
        factory.setExpandEntityReferences(false);
    }

    private void configureSafeSAXParserFactory(SAXParserFactory factory) {
        this.tryToSetFeature(factory, DISALLOW_DOCTYPE_DECL, true);
        this.tryToSetFeature(factory, EXTERNAL_GENERAL_ENTITIES, false);
        this.tryToSetFeature(factory, EXTERNAL_PARAMETER_ENTITIES, false);
        this.tryToSetFeature(factory, LOAD_EXTERNAL_DTD, false);
        factory.setXIncludeAware(false);
    }

    private void tryToSetFeature(DocumentBuilderFactory factory, String feature, boolean value) {
        try {
            factory.setFeature(feature, value);
        }
        catch (ParserConfigurationException e) {
            LOGGER.info(MessageFormatUtil.format((String)"Exception was thrown: {0}. The feature {1} is probably not supported by your XML processor.", (Object[])new Object[]{e.getMessage(), feature}));
        }
    }

    private void tryToSetFeature(SAXParserFactory factory, String feature, boolean value) {
        try {
            factory.setFeature(feature, value);
        }
        catch (ParserConfigurationException | SAXNotRecognizedException | SAXNotSupportedException e) {
            LOGGER.info(MessageFormatUtil.format((String)"Exception was thrown: {0}. The feature {1} is probably not supported by your XML processor.", (Object[])new Object[]{e.getMessage(), feature}));
        }
    }

    private static class SafeEmptyEntityResolver
    implements EntityResolver {
        @Override
        public InputSource resolveEntity(String publicId, String systemId) {
            throw new PdfException("External entity element found in XML. This entity will not be parsed to prevent XML attacks.");
        }
    }
}

