/*
 * Decompiled with CFR 0.152.
 */
package com.maojianwei.maocloud.monitor.raspberry.core;

import com.maojianwei.maocloud.monitor.raspberry.AppEntry;
import com.maojianwei.maocloud.monitor.raspberry.base.NodeUdpInfo;
import com.maojianwei.maocloud.monitor.raspberry.network.NetworkCore;
import com.maojianwei.maocloud.monitor.raspberry.network.api.UdpListener;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;

public class Core {
    private AppEntry appEntry;
    private NetworkCore networkCore;
    private UdpListener udpListener = new InternalUdpListener();
    private ObservableList<NodeUdpInfo> data = FXCollections.observableArrayList();

    public Core(AppEntry appEntry) {
        this.appEntry = appEntry;
        this.networkCore = new NetworkCore();
    }

    public void start() {
        this.networkCore.startUdpRecv();
        this.networkCore.addListener(this.udpListener);
        this.appEntry.getMainPageGuiController().setTableViewDataBinding(this.data);
    }

    public void shutdown() {
        this.appEntry.getMainPageGuiController().cancalTableViewDataBinding();
        this.networkCore.delListener(this.udpListener);
        this.networkCore.stopUdpRecv();
    }

    private class InternalUdpListener
    implements UdpListener {
        private InternalUdpListener() {
        }

        @Override
        public void processMessage(String msg) {
            NodeUdpInfo nodeUdpInfo = this.buildNodeUdpInfo(msg);
            int index = Core.this.data.indexOf((Object)nodeUdpInfo);
            if (index == -1) {
                Core.this.data.add((Object)nodeUdpInfo);
            } else {
                Core.this.data.set(index, (Object)nodeUdpInfo);
            }
        }

        private NodeUdpInfo buildNodeUdpInfo(String sourceMsg) {
            String[] items;
            NodeUdpInfo nodeUdpInfo = new NodeUdpInfo();
            block22: for (String item : items = sourceMsg.split(";")) {
                String[] kv = item.split("=");
                switch (kv[0]) {
                    case "IP": {
                        nodeUdpInfo.setIp(kv[1]);
                        continue block22;
                    }
                    case "CPU_Temp": {
                        nodeUdpInfo.setCpuTemp(Double.parseDouble(kv[1]));
                        continue block22;
                    }
                    case "GPU_Temp": {
                        nodeUdpInfo.setGpuTemp(Double.parseDouble(kv[1]));
                        continue block22;
                    }
                    case "Count": {
                        nodeUdpInfo.setCount(Integer.parseInt(kv[1]));
                        continue block22;
                    }
                    case "SysTime": {
                        nodeUdpInfo.setSysTime(kv[1]);
                        continue block22;
                    }
                    case "GPS": {
                        String[] gpsInfo = kv[1].split(",");
                        if (!gpsInfo[0].equals("lost")) {
                            nodeUdpInfo.setLatitude(Double.parseDouble(gpsInfo[0]));
                        }
                        if (!gpsInfo[1].equals("lost")) {
                            nodeUdpInfo.setLongitude(Double.parseDouble(gpsInfo[1]));
                        }
                        nodeUdpInfo.setSatellite(Integer.parseInt(gpsInfo[2]));
                        continue block22;
                    }
                    case "GpsTime": {
                        nodeUdpInfo.setGpsTime(kv[1]);
                        continue block22;
                    }
                    case "Temperature": {
                        nodeUdpInfo.setEnvTemp(Double.parseDouble(kv[1]));
                        continue block22;
                    }
                    case "NodeName": {
                        nodeUdpInfo.setName(kv[1].replace("Bigmao", ""));
                        continue block22;
                    }
                }
            }
            return nodeUdpInfo;
        }
    }
}

