/*
 * Decompiled with CFR 0.152.
 */
package com.marklogic.mapreduce;

import com.marklogic.mapreduce.DocumentURI;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import org.apache.hadoop.io.Text;

public class DocumentURIWithSourceInfo
extends DocumentURI {
    private String srcId = "";
    private String subId = "";
    private int lineNumber = 0;
    private int colNumber = 0;
    private String skipReason = "";

    public DocumentURIWithSourceInfo() {
    }

    public DocumentURIWithSourceInfo(String uri, String src) {
        if (uri == null) {
            uri = "";
        } else {
            this.uri = uri;
        }
        this.srcId = src;
    }

    public DocumentURIWithSourceInfo(String uri, String src, String sub) {
        if (uri == null) {
            uri = "";
        } else {
            this.uri = uri;
        }
        this.srcId = src;
        this.subId = sub;
    }

    public DocumentURIWithSourceInfo(String uri, String src, String sub, int line, int col) {
        if (uri == null) {
            uri = "";
        } else {
            this.uri = uri;
        }
        this.srcId = src;
        this.subId = sub;
        this.lineNumber = line;
        this.colNumber = col;
    }

    public DocumentURIWithSourceInfo(DocumentURIWithSourceInfo uri) {
        this.uri = uri.uri;
        this.srcId = uri.srcId;
        this.subId = uri.subId;
        this.lineNumber = uri.lineNumber;
        this.colNumber = uri.colNumber;
        this.skipReason = uri.skipReason;
    }

    public boolean isSkip() {
        return this.uri.isEmpty();
    }

    @Override
    public void readFields(DataInput in) throws IOException {
        this.uri = Text.readString((DataInput)in);
        this.srcId = Text.readString((DataInput)in);
        this.subId = Text.readString((DataInput)in);
        this.lineNumber = in.readInt();
        this.colNumber = in.readInt();
        this.skipReason = Text.readString((DataInput)in);
    }

    @Override
    public void write(DataOutput out) throws IOException {
        Text.writeString((DataOutput)out, (String)this.uri);
        Text.writeString((DataOutput)out, (String)this.srcId);
        Text.writeString((DataOutput)out, (String)this.subId);
        out.writeInt(this.lineNumber);
        out.writeInt(this.colNumber);
        Text.writeString((DataOutput)out, (String)this.skipReason);
    }

    public String getSrcId() {
        return this.srcId;
    }

    public void setSrcId(String srcId) {
        this.srcId = srcId;
    }

    public String getSubId() {
        return this.subId;
    }

    public void setSubId(String subId) {
        this.subId = subId;
    }

    public int getLineNumber() {
        return this.lineNumber;
    }

    public void setLineNumber(int lineNumber) {
        this.lineNumber = lineNumber;
    }

    public int getColNumber() {
        return this.colNumber;
    }

    public void setColNumber(int colNumber) {
        this.colNumber = colNumber;
    }

    public String getSkipReason() {
        return this.skipReason;
    }

    public void setSkipReason(String reason) {
        this.skipReason = reason;
    }

    @Override
    public String toString() {
        StringBuilder buf = new StringBuilder();
        buf.append(this.uri.isEmpty() ? "()" : this.uri);
        if (this.subId.length() > 0) {
            buf.append(" from ").append(this.subId);
        }
        if (this.srcId.length() > 0) {
            buf.append(" in ").append(this.srcId);
        }
        if (this.lineNumber > 0) {
            buf.append(" at line ").append(this.lineNumber);
        }
        if (this.colNumber > 0) {
            buf.append(":").append(this.colNumber);
        }
        if (!this.skipReason.isEmpty()) {
            buf.append(", reason: ");
            buf.append(this.skipReason);
        }
        return buf.toString();
    }

    @Override
    public Object clone() {
        return new DocumentURIWithSourceInfo(this);
    }
}

