/*
 * Decompiled with CFR 0.152.
 */
package com.marklogic.mapreduce;

import com.marklogic.io.IOHelper;
import com.marklogic.mapreduce.ContentType;
import com.marklogic.xcc.ResultItem;
import com.marklogic.xcc.types.ItemType;
import com.marklogic.xcc.types.XdmAttribute;
import com.marklogic.xcc.types.XdmDocument;
import com.marklogic.xcc.types.XdmElement;
import com.marklogic.xcc.types.XdmText;
import com.marklogic.xcc.types.impl.AttributeImpl;
import com.marklogic.xcc.types.impl.DocumentImpl;
import com.marklogic.xcc.types.impl.TextImpl;
import java.io.ByteArrayOutputStream;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.TransformerException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.commons.modeler.util.DomUtil;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.io.Writable;
import org.w3c.dom.Attr;
import org.w3c.dom.Node;
import org.xml.sax.SAXException;

public class MarkLogicNode
implements Writable {
    public static final Log LOG = LogFactory.getLog(MarkLogicNode.class);
    private Node node;
    private static final ThreadLocal<DocumentBuilder> builderLocal = new ThreadLocal<DocumentBuilder>(){

        @Override
        protected DocumentBuilder initialValue() {
            try {
                return DocumentBuilderFactory.newInstance().newDocumentBuilder();
            }
            catch (ParserConfigurationException e) {
                LOG.error((Object)e);
                return null;
            }
        }
    };
    static DocumentBuilderFactory dbFactory = DocumentBuilderFactory.newInstance();

    public MarkLogicNode() {
    }

    public MarkLogicNode(Node node) {
        this.node = node;
    }

    public MarkLogicNode(ResultItem item) {
        this.set(item);
    }

    public MarkLogicNode(String content, ContentType contentType) {
        try {
            if (contentType == ContentType.TEXT) {
                this.node = new TextImpl(content).asW3cText();
            } else if (contentType == ContentType.XML) {
                this.node = new DocumentImpl(content).asW3cDocument();
            }
        }
        catch (IOException e) {
            LOG.error((Object)e);
        }
        catch (SAXException e) {
            LOG.error((Object)"error parsing result", (Throwable)e);
        }
        catch (ParserConfigurationException e) {
            LOG.error((Object)e);
        }
    }

    public Node get() {
        return this.node;
    }

    public void set(Node node) {
        this.node = node;
    }

    public void set(ResultItem item) {
        block7: {
            ItemType type = item.getItemType();
            DocumentBuilder docBuilder = builderLocal.get();
            try {
                if (type == ItemType.ELEMENT) {
                    this.node = ((XdmElement)item.getItem()).asW3cElement(docBuilder);
                    break block7;
                }
                if (type == ItemType.TEXT) {
                    this.node = ((XdmText)item.getItem()).asW3cText(docBuilder);
                    break block7;
                }
                if (type == ItemType.DOCUMENT) {
                    this.node = ((XdmDocument)item.getItem()).asW3cDocument(docBuilder);
                    break block7;
                }
                if (type == ItemType.ATTRIBUTE) {
                    this.node = ((XdmAttribute)item.getItem()).asW3cAttr(docBuilder);
                    break block7;
                }
                throw new UnsupportedOperationException("Unexpected item type: " + item.getItemType());
            }
            catch (IOException e) {
                LOG.error((Object)e);
            }
            catch (SAXException e) {
                LOG.error((Object)"error parsing result", (Throwable)e);
            }
        }
    }

    public void readFields(DataInput in) throws IOException {
        int type = in.readInt();
        DocumentBuilder docBuilder = builderLocal.get();
        String val = Text.readString((DataInput)in);
        try {
            if (type == 2) {
                AttributeImpl attr = new AttributeImpl(Text.readString((DataInput)in), Text.readString((DataInput)in));
                this.node = attr.asW3cNode(docBuilder);
            } else {
                this.node = DomUtil.readXml((InputStream)IOHelper.newStream((String)val));
            }
        }
        catch (SAXException e) {
            LOG.error((Object)"error parsing input", (Throwable)e);
            throw new IOException(e);
        }
        catch (ParserConfigurationException e) {
            LOG.error((Object)"error parsing input", (Throwable)e);
            throw new IOException(e);
        }
    }

    public void write(DataOutput out) throws IOException {
        if (this.node != null) {
            short type = this.node.getNodeType();
            out.writeInt(type);
            if (type == 2) {
                Text.writeString((DataOutput)out, (String)this.node.getNodeName());
                Text.writeString((DataOutput)out, (String)this.node.getNodeValue());
            } else {
                ByteArrayOutputStream baos = new ByteArrayOutputStream();
                try {
                    DomUtil.writeXml((Node)this.node, (OutputStream)baos);
                    Text.writeString((DataOutput)out, (String)baos.toString());
                }
                catch (TransformerException e) {
                    LOG.error((Object)"error transforming node", (Throwable)e);
                    throw new IOException(e);
                }
            }
        } else {
            LOG.error((Object)"Node to write is null.");
        }
    }

    public String toString() {
        if (this.node != null) {
            try {
                StringBuilder buf = new StringBuilder();
                if (this.node.getNodeType() == 2) {
                    buf.append("attribute name: ");
                    buf.append(((Attr)this.node).getName());
                    buf.append(", value: ");
                    buf.append(((Attr)this.node).getValue());
                } else {
                    ByteArrayOutputStream bos = new ByteArrayOutputStream();
                    DomUtil.writeXml((Node)this.node, (OutputStream)bos);
                    buf.append(bos.toString());
                }
                return buf.toString();
            }
            catch (TransformerException e) {
                LOG.error((Object)e);
            }
        }
        return null;
    }
}

