/*
 * Decompiled with CFR 0.152.
 */
package com.marklogic.mapreduce;

import com.marklogic.mapreduce.MarkLogicNode;
import com.marklogic.mapreduce.MarkLogicRecordReader;
import com.marklogic.mapreduce.NodePath;
import com.marklogic.xcc.ResultItem;
import java.io.IOException;
import org.apache.hadoop.conf.Configuration;

public class NodeReader
extends MarkLogicRecordReader<NodePath, MarkLogicNode> {
    static final float NODE_TO_FRAGMENT_RATIO = 100.0f;
    private NodePath currentKey;
    private MarkLogicNode currentValue;

    public NodeReader(Configuration conf) {
        super(conf);
    }

    public NodePath getCurrentKey() throws IOException, InterruptedException {
        return this.currentKey;
    }

    @Override
    protected void endOfResult() {
        this.currentKey = null;
        this.currentValue = null;
    }

    @Override
    protected boolean nextResult(ResultItem result) {
        String uri = result.getDocumentURI();
        String path = result.getNodePath();
        if (this.currentKey != null) {
            this.currentKey.set(uri, path);
        } else {
            this.currentKey = new NodePath(uri, path);
        }
        if (this.currentValue != null) {
            this.currentValue.set(result);
        } else {
            this.currentValue = new MarkLogicNode(result);
        }
        return true;
    }

    public MarkLogicNode getCurrentValue() throws IOException, InterruptedException {
        return this.currentValue;
    }

    @Override
    protected float getDefaultRatio() {
        return 100.0f;
    }
}

