/*
 * Decompiled with CFR 0.152.
 */
package com.marklogic.mapreduce;

import org.apache.hadoop.conf.Configuration;

public enum PropertyOpType {
    SET_PROPERTY{

        @Override
        public String getFunctionName() {
            return "xdmp:document-set-property";
        }
    }
    ,
    ADD_PROPERTY{

        @Override
        public String getFunctionName() {
            return "xdmp:document-add-properties";
        }
    };


    public abstract String getFunctionName();

    public String getQuery(Configuration conf) {
        boolean alwaysCreate = conf.getBoolean("mapreduce.marklogic.output.property.alwayscreate", false);
        StringBuilder buf = new StringBuilder();
        buf.append("xquery version \"1.0-ml\"; \n");
        buf.append("declare variable $");
        buf.append("uri");
        buf.append(" as xs:string external;\n");
        buf.append("declare variable $");
        buf.append("node");
        buf.append(" as element() external;\n");
        if (!alwaysCreate) {
            buf.append("let $exist := fn:exists(fn:doc($");
            buf.append("uri");
            buf.append("))\nreturn if ($exist) then \n");
        }
        buf.append(this.getFunctionName());
        buf.append("($");
        buf.append("uri");
        buf.append(", $");
        buf.append("node");
        if (!alwaysCreate) {
            buf.append(") else ()");
        } else {
            buf.append(")");
        }
        return buf.toString();
    }
}

