/*
 * Decompiled with CFR 0.152.
 */
package com.marklogic.mapreduce;

import com.marklogic.mapreduce.MarkLogicConstants;
import com.marklogic.mapreduce.MarkLogicRecordReader;
import com.marklogic.mapreduce.utilities.InternalUtilities;
import com.marklogic.xcc.ResultItem;
import java.io.IOException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.util.ReflectionUtils;

public class ValueReader<VALUEIN>
extends MarkLogicRecordReader<LongWritable, VALUEIN>
implements MarkLogicConstants {
    static final float VALUE_TO_FRAGMENT_RATIO = 100.0f;
    public static final Log LOG = LogFactory.getLog(ValueReader.class);
    private LongWritable key;
    private VALUEIN value;
    private Class<? extends Writable> valueClass;

    public ValueReader(Configuration conf) {
        super(conf);
        this.valueClass = conf.getClass("mapreduce.marklogic.input.valueclass", Text.class, Writable.class);
    }

    public LongWritable getCurrentKey() throws IOException, InterruptedException {
        return this.key;
    }

    public VALUEIN getCurrentValue() throws IOException, InterruptedException {
        return this.value;
    }

    @Override
    protected void endOfResult() {
        this.key = null;
        this.value = null;
    }

    @Override
    protected boolean nextResult(ResultItem result) {
        if (this.key == null) {
            this.key = new LongWritable(this.getCount());
        } else {
            this.key.set(this.getCount());
        }
        if (this.value == null) {
            this.value = ReflectionUtils.newInstance(this.valueClass, (Configuration)this.getConf());
        }
        InternalUtilities.assignResultValue(this.valueClass, result, this.value);
        return true;
    }

    @Override
    protected float getDefaultRatio() {
        return 100.0f;
    }
}

