/*
 * Decompiled with CFR 0.152.
 */
package com.marklogic.mapreduce.functions;

import com.marklogic.mapreduce.functions.PathReference;
import com.marklogic.mapreduce.functions.Reference;
import com.marklogic.mapreduce.functions.ValueOrWordMatchFunction;
import java.util.ArrayList;

public abstract class ValueMatch
extends ValueOrWordMatchFunction {
    public abstract Reference[] getReferences();

    @Override
    void appendFunctionName(StringBuilder buf) {
        buf.append("cts:value-match");
    }

    @Override
    void appendNamesParams(StringBuilder buf) {
        Reference[] refs = this.getReferences();
        buf.append("(");
        for (int i = 0; i < refs.length; ++i) {
            if (i > 0) {
                buf.append(",");
            }
            refs[i].append(buf);
        }
        buf.append("),\n");
    }

    public static void main(String[] args) {
        ValueMatchFunction matchFunc = new ValueMatchFunction();
        ArrayList<String> nsbindings = new ArrayList<String>();
        for (int i = 0; i < args.length; ++i) {
            nsbindings.add(args[i]);
        }
        System.out.println(matchFunc.getInputQuery(nsbindings, 1L, 1000L));
    }

    static class MyPathReference
    extends PathReference {
        MyPathReference() {
        }

        @Override
        public String getPathExpression() {
            return "/my:a[@his:b='B1']/my:c";
        }
    }

    static class ValueMatchFunction
    extends ValueMatch {
        ValueMatchFunction() {
        }

        @Override
        public String getPattern() {
            return "\"?3\"";
        }

        @Override
        public Reference[] getReferences() {
            MyPathReference pathRef = new MyPathReference();
            return new Reference[]{pathRef};
        }
    }
}

