/*
 * Decompiled with CFR 0.152.
 */
package com.marklogic.mapreduce.utilities;

import com.marklogic.mapreduce.utilities.ForestHost;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.io.Writable;

public class ForestInfo
implements Writable {
    private String hostName;
    private long frangmentCount;
    private boolean updatable;
    private List<ForestHost> replicas;

    public ForestInfo() {
    }

    public ForestInfo(String hostName, long fmCount, boolean updatable, List<ForestHost> replicas) {
        int i;
        this.hostName = hostName;
        this.frangmentCount = fmCount;
        this.updatable = updatable;
        this.replicas = new ArrayList<ForestHost>();
        int start = 0;
        int len = replicas.size();
        for (i = 0; i < len; ++i) {
            if (!hostName.equals(replicas.get(i).getHostName())) continue;
            start = i;
            break;
        }
        for (i = start; i < len; ++i) {
            this.replicas.add(replicas.get(i));
        }
        for (i = 0; i < start; ++i) {
            this.replicas.add(replicas.get(i));
        }
    }

    public long getFragmentCount() {
        return this.frangmentCount;
    }

    public String getHostName() {
        return this.hostName;
    }

    public boolean getUpdatable() {
        return this.updatable;
    }

    public List<ForestHost> getReplicas() {
        return this.replicas;
    }

    public void readFields(DataInput in) throws IOException {
        this.hostName = Text.readString((DataInput)in);
        this.frangmentCount = in.readLong();
        this.updatable = in.readBoolean();
        int replicaSize = in.readInt();
        this.replicas = new ArrayList<ForestHost>();
        for (int i = 0; i < replicaSize; ++i) {
            String curForest = Text.readString((DataInput)in);
            String curHost = Text.readString((DataInput)in);
            ForestHost fh = new ForestHost(curForest, curHost);
            this.replicas.add(fh);
        }
    }

    public void write(DataOutput out) throws IOException {
        Text.writeString((DataOutput)out, (String)this.hostName);
        out.writeLong(this.frangmentCount);
        out.writeBoolean(this.updatable);
        int replicaSize = this.replicas.size();
        out.writeInt(replicaSize);
        for (int i = 0; i < replicaSize; ++i) {
            Text.writeString((DataOutput)out, (String)this.replicas.get(i).getForest());
            Text.writeString((DataOutput)out, (String)this.replicas.get(i).getHostName());
        }
    }
}

