/*
 * Decompiled with CFR 0.152.
 */
package com.marklogic.mapreduce.utilities;

import com.marklogic.mapreduce.DocumentURI;
import com.marklogic.mapreduce.utilities.AssignmentPolicy;
import java.math.BigInteger;
import java.text.Normalizer;
import java.util.LinkedHashSet;

public class LegacyAssignmentPolicy
extends AssignmentPolicy {
    private static final long HASH64_STEP = 15485863L;
    private static final long HASH64_SEED = 4153748711044459511L;
    private static final BigInteger URI_KEY_HASH = LegacyAssignmentPolicy.hash64("uri()");
    private String[] forests;

    public LegacyAssignmentPolicy() {
    }

    public LegacyAssignmentPolicy(LinkedHashSet<String> uForests) {
        this.uForests = uForests;
        this.forests = uForests.toArray(new String[uForests.size()]);
        this.policy = AssignmentPolicy.Kind.LEGACY;
    }

    public static int getPlacementId(DocumentURI uri, int size) {
        switch (size) {
            case 0: {
                throw new IllegalArgumentException("getPlacementId(size = 0)");
            }
            case 1: {
                return 0;
            }
        }
        String nk = LegacyAssignmentPolicy.normalize(uri.getUri());
        BigInteger uriKey = LegacyAssignmentPolicy.getUriKey(nk);
        long u = uriKey.longValue();
        for (int i = 8; i <= 56; i += 8) {
            u += LegacyAssignmentPolicy.rotl(uriKey, i);
        }
        long v = (65535 + size) / size;
        return (int)((u & 0xFFFFL) / v);
    }

    protected static String normalize(String uri) {
        return Normalizer.normalize(uri, Normalizer.Form.NFC);
    }

    public static BigInteger getUriKey(String uri) {
        BigInteger value = LegacyAssignmentPolicy.hash64(uri).multiply(BigInteger.valueOf(5L)).add(URI_KEY_HASH);
        byte[] valueBytes = value.toByteArray();
        byte[] longBytes = new byte[8];
        System.arraycopy(valueBytes, valueBytes.length - longBytes.length, longBytes, 0, longBytes.length);
        BigInteger key = new BigInteger(1, longBytes);
        return key;
    }

    private static BigInteger hash64(String str) {
        int cp;
        BigInteger value = BigInteger.valueOf(4153748711044459511L);
        for (int i = 0; i < str.length(); i += Character.charCount(cp)) {
            cp = str.codePointAt(i);
            value = value.add(BigInteger.valueOf(cp)).multiply(BigInteger.valueOf(15485863L));
        }
        byte[] valueBytes = value.toByteArray();
        byte[] longBytes = new byte[8];
        System.arraycopy(valueBytes, valueBytes.length - longBytes.length, longBytes, 0, longBytes.length);
        BigInteger hash = new BigInteger(1, longBytes);
        return hash;
    }

    public static long rotl(BigInteger value, int shift) {
        return value.shiftLeft(shift).xor(value.shiftRight(64 - shift)).longValue();
    }

    @Override
    public int getPlacementForestIndex(DocumentURI uri) {
        return LegacyAssignmentPolicy.getPlacementId(uri, this.forests.length);
    }
}

