/*
 * Decompiled with CFR 0.152.
 */
package com.marklogic.contentpump;

import com.marklogic.contentpump.ArchiveOutputFormat;
import com.marklogic.contentpump.ConfigConstants;
import com.marklogic.contentpump.DatabaseContentInputFormat;
import com.marklogic.contentpump.DatabaseContentOutputFormat;
import com.marklogic.contentpump.DatabaseTransformOutputFormat;
import com.marklogic.contentpump.DocumentMapper;
import com.marklogic.contentpump.DocumentPathFilter;
import com.marklogic.contentpump.ExportOutputType;
import com.marklogic.contentpump.InputType;
import com.marklogic.contentpump.LocalJob;
import com.marklogic.contentpump.LocalJobRunner;
import com.marklogic.contentpump.MultithreadedMapper;
import com.marklogic.contentpump.SequenceFileValueType;
import com.marklogic.contentpump.SingleDocumentOutputFormat;
import com.marklogic.contentpump.utilities.AuditUtil;
import com.marklogic.contentpump.utilities.CommandlineOption;
import com.marklogic.http.HttpChannel;
import com.marklogic.mapreduce.ContentType;
import com.marklogic.mapreduce.DatabaseDocument;
import com.marklogic.mapreduce.DocumentURI;
import com.marklogic.mapreduce.ForestDocument;
import com.marklogic.mapreduce.ForestInputFormat;
import com.marklogic.mapreduce.Indentation;
import com.marklogic.mapreduce.MarkLogicDocument;
import com.marklogic.mapreduce.utilities.InternalUtilities;
import com.marklogic.xcc.ContentSource;
import com.marklogic.xcc.Session;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.Random;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.OptionBuilder;
import org.apache.commons.cli.Options;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.mapreduce.Mapper;
import org.apache.hadoop.mapreduce.lib.input.FileInputFormat;

public enum Command implements ConfigConstants
{
    IMPORT{

        @Override
        public void configOptions(Options options) {
            1.configCommonOptions(options);
            1.configConnectionId(options);
            1.configCopyOptions(options);
            1.configCommonOutputOptions(options);
            1.configBatchTxn(options);
            1.configModule(options);
            1.configRDFGraphOutputOptions(options);
            1.configMLCloudAuthOptions(options);
            OptionBuilder.withArgName((String)"string");
            OptionBuilder.hasArg();
            OptionBuilder.withDescription((String)"The file system location for input, as a regular expression");
            Option inputFilePath = OptionBuilder.create((String)"input_file_path");
            inputFilePath.setRequired(true);
            options.addOption(inputFilePath);
            OptionBuilder.withArgName((String)"string");
            OptionBuilder.hasArg();
            OptionBuilder.withDescription((String)"Matching regex pattern for files found in the input file path");
            Option inputFilePattern = OptionBuilder.create((String)"input_file_pattern");
            options.addOption(inputFilePattern);
            OptionBuilder.withArgName((String)"string");
            OptionBuilder.hasArg();
            OptionBuilder.withDescription((String)"Element name in which each document is found");
            Option aggregateRecordElement = OptionBuilder.create((String)"aggregate_record_element");
            options.addOption(aggregateRecordElement);
            OptionBuilder.withArgName((String)"string");
            OptionBuilder.hasArg();
            OptionBuilder.withDescription((String)"Element namespace in which each document is found");
            Option aggregateRecordNamespace = OptionBuilder.create((String)"aggregate_record_namespace");
            options.addOption(aggregateRecordNamespace);
            OptionBuilder.withArgName((String)"string");
            OptionBuilder.hasArg();
            OptionBuilder.withDescription((String)"Deprecated. Name of the first element or attribute within a record element to be used as document URI. If omitted, a sequence id will be generated to  form the document URI.");
            Option aggregateUriId = OptionBuilder.create((String)"aggregate_uri_id");
            options.addOption(aggregateUriId);
            OptionBuilder.withArgName((String)"string");
            OptionBuilder.hasArg();
            OptionBuilder.withDescription((String)"Type of input file.  Valid choices are: aggregates, archive, delimited_text, documents, forest,rdf, sequencefile, delimited_json");
            Option inputFileType = OptionBuilder.create((String)"input_file_type");
            options.addOption(inputFileType);
            OptionBuilder.withArgName((String)"true,false");
            OptionBuilder.hasOptionalArg();
            OptionBuilder.withDescription((String)"Whether the input data is compressed");
            Option inputCompressed = OptionBuilder.create((String)"input_compressed");
            options.addOption(inputCompressed);
            OptionBuilder.withArgName((String)"string");
            OptionBuilder.hasArg();
            OptionBuilder.withDescription((String)"Codec used for compression: ZIP, GZIP");
            Option inputCompressionCodec = OptionBuilder.create((String)"input_compression_codec");
            options.addOption(inputCompressionCodec);
            OptionBuilder.withArgName((String)"string");
            OptionBuilder.hasArg();
            OptionBuilder.withDescription((String)"Type of document content. Valid choices: XML, JSON, TEXT, BINARY, and MIXED.  Default type for document is MIXED, where the type is determined from the MIME type mapping configured in MarkLogic Server.");
            Option documentType = OptionBuilder.create((String)"document_type");
            options.addOption(documentType);
            OptionBuilder.withArgName((String)"character");
            OptionBuilder.hasArg();
            OptionBuilder.withDescription((String)"Delimiter for delimited text.");
            Option delimiter = OptionBuilder.create((String)"delimiter");
            options.addOption(delimiter);
            OptionBuilder.withArgName((String)"string");
            OptionBuilder.hasArg();
            OptionBuilder.withDescription((String)"Deprecated. Delimited uri id for delimited text.");
            Option delimitedUri = OptionBuilder.create((String)"delimited_uri_id");
            options.addOption(delimitedUri);
            OptionBuilder.withArgName((String)"string");
            OptionBuilder.hasArg();
            OptionBuilder.withDescription((String)"Root element local name of the XML document constructed from one delimited text record.");
            Option delimitedRoot = OptionBuilder.create((String)"delimited_root_name");
            options.addOption(delimitedRoot);
            OptionBuilder.withArgName((String)"true,false");
            OptionBuilder.hasOptionalArg();
            OptionBuilder.withDescription((String)"Enables automatic URI generation for delimited text records.");
            Option generateUri = OptionBuilder.create((String)"generate_uri");
            options.addOption(generateUri);
            OptionBuilder.withArgName((String)"string");
            OptionBuilder.hasArg();
            OptionBuilder.withDescription((String)"Namespace used for output document.");
            Option namespace = OptionBuilder.create((String)"namespace");
            options.addOption(namespace);
            OptionBuilder.withArgName((String)"string");
            OptionBuilder.hasArg();
            OptionBuilder.withDescription((String)"Language name to associate with output documents.  A value of \"en\" indicates that the documents are in english.  The default is null, which indicates the server default.");
            Option outputLanguage = OptionBuilder.create((String)"output_language");
            options.addOption(outputLanguage);
            OptionBuilder.withArgName((String)"true,false");
            OptionBuilder.hasOptionalArg();
            OptionBuilder.withDescription((String)"Whether to clean dir before output.");
            Option outputCleanDir = OptionBuilder.create((String)"output_cleandir");
            options.addOption(outputCleanDir);
            OptionBuilder.withArgName((String)"string");
            OptionBuilder.hasArg();
            OptionBuilder.withDescription((String)"Output directory in MarkLogic.");
            Option outputDir = OptionBuilder.create((String)"output_directory");
            options.addOption(outputDir);
            OptionBuilder.withArgName((String)"true,false");
            OptionBuilder.hasOptionalArg();
            OptionBuilder.withDescription((String)"Filename as collection in output.");
            Option outputFilenameCollection = OptionBuilder.create((String)"filename_as_collection");
            options.addOption(outputFilenameCollection);
            OptionBuilder.withArgName((String)"string");
            OptionBuilder.hasArg();
            OptionBuilder.withDescription((String)"Whether to repair documents to make it well formed or throw error.");
            Option repairLevel = OptionBuilder.create((String)"xml_repair_level");
            options.addOption(repairLevel);
            OptionBuilder.withArgName((String)"string");
            OptionBuilder.hasArg();
            OptionBuilder.withDescription((String)"Name of class to be used as key to read the  input SequenceFile");
            Option seqKeyClass = OptionBuilder.create((String)"sequencefile_key_class");
            options.addOption(seqKeyClass);
            OptionBuilder.withArgName((String)"string");
            OptionBuilder.hasArg();
            OptionBuilder.withDescription((String)"Name of class to be used as value to read the input SequenceFile");
            Option seqValueClass = OptionBuilder.create((String)"sequencefile_value_class");
            options.addOption(seqValueClass);
            OptionBuilder.withArgName((String)"string");
            OptionBuilder.hasArg();
            OptionBuilder.withDescription((String)"Type of the value data returned by the above class.  Valid choices are: Text, BytesWritable, MarkLogicDocument and Path.");
            Option seqValueType = OptionBuilder.create((String)"sequencefile_value_type");
            options.addOption(seqValueType);
            OptionBuilder.withArgName((String)"true,false");
            OptionBuilder.hasOptionalArg();
            OptionBuilder.withDescription((String)"Whether to allow empty metadata when importing archive");
            Option allowEmptyMeta = OptionBuilder.create((String)"archive_metadata_optional");
            options.addOption(allowEmptyMeta);
            OptionBuilder.withArgName((String)"true,false");
            OptionBuilder.hasOptionalArg();
            OptionBuilder.withDescription((String)"Whether to use the fast load mode to load content into MarkLogic");
            Option fastLoad = OptionBuilder.create((String)"fastload");
            options.addOption(fastLoad);
            OptionBuilder.withArgName((String)"true,false");
            OptionBuilder.hasOptionalArg();
            OptionBuilder.withDescription((String)"Whether to use streaming to output data to MarkLogic");
            Option streaming = OptionBuilder.create((String)"streaming");
            options.addOption(streaming);
            OptionBuilder.withArgName((String)"string");
            OptionBuilder.hasArg();
            OptionBuilder.withDescription((String)"The charset encoding to be used by the MarkLogic when loading documents.  The default is \"UTF-8\".");
            Option encoding = OptionBuilder.create((String)"content_encoding");
            options.addOption(encoding);
            OptionBuilder.withArgName((String)"string");
            OptionBuilder.hasArg();
            OptionBuilder.withDescription((String)"A column name in delimited text file or an element name in aggregated XML or a property name in delimited json, whose value will be the document uri in MarkLogic Server.");
            Option uriId = OptionBuilder.create((String)"uri_id");
            options.addOption(uriId);
            OptionBuilder.withArgName((String)"comma list");
            OptionBuilder.hasArg();
            OptionBuilder.withDescription((String)"Comma separated list of column name  and data type pairs. 1st to match column name, case sensitive. 2nd the data type, case insensitive.Data type can be String, Number or Boolean.");
            Option dataType = OptionBuilder.create((String)"data_type");
            options.addOption(dataType);
            OptionBuilder.withArgName((String)"number");
            OptionBuilder.hasArg();
            OptionBuilder.withDescription((String)"The number of threads per split");
            Option threadsPerSplit = OptionBuilder.create((String)"thread_count_per_split");
            options.addOption(threadsPerSplit);
            OptionBuilder.withArgName((String)"number");
            OptionBuilder.hasArg();
            OptionBuilder.withDescription((String)"Maximum size of an RDF document to be processed in memory");
            Option rdfMemoryThreshold_opt = OptionBuilder.create((String)"rdf_streaming_memory_threshold");
            CommandlineOption rdfMemoryThreshold = new CommandlineOption(rdfMemoryThreshold_opt);
            rdfMemoryThreshold.setHidden(true);
            options.addOption((Option)rdfMemoryThreshold);
            OptionBuilder.withArgName((String)"number");
            OptionBuilder.hasArg();
            OptionBuilder.withDescription((String)"Maximum number of triples per sem:triples document");
            Option rdfTriplesPerDoc_opt = OptionBuilder.create((String)"rdf_triples_per_document");
            CommandlineOption rdfTriplesPerDoc = new CommandlineOption(rdfTriplesPerDoc_opt);
            rdfTriplesPerDoc.setHidden(true);
            options.addOption((Option)rdfTriplesPerDoc);
            1.configPartition(options);
            OptionBuilder.withArgName((String)"true,false");
            OptionBuilder.hasOptionalArg();
            OptionBuilder.withDescription((String)"Whether to split input files to load into MarkLogic.   Only available for delimited_text.  Default is false.");
            Option splitInput = OptionBuilder.create((String)"split_input");
            options.addOption(splitInput);
            OptionBuilder.withArgName((String)"comma list");
            OptionBuilder.hasArg();
            OptionBuilder.withDescription((String)"Comma-separated list of directories");
            Option df = OptionBuilder.create((String)"directory_filter");
            options.addOption(df);
            OptionBuilder.withArgName((String)"comma list");
            OptionBuilder.hasArg();
            OptionBuilder.withDescription((String)"Comma-separated list of collections");
            Option cf = OptionBuilder.create((String)"collection_filter");
            options.addOption(cf);
            OptionBuilder.withArgName((String)"comma list");
            OptionBuilder.hasArg();
            OptionBuilder.withDescription((String)"Comma-separated list of document types");
            Option tf = OptionBuilder.create((String)"type_filter");
            options.addOption(tf);
            OptionBuilder.withArgName((String)"string");
            OptionBuilder.hasArg();
            OptionBuilder.withDescription((String)"temporal collection name");
            Option tcf = OptionBuilder.create((String)"temporal_collection");
            options.addOption(tcf);
            OptionBuilder.withArgName((String)"number");
            OptionBuilder.hasArg();
            OptionBuilder.withDescription((String)"The maximum number of threads allowed running on the client side");
            Option maxThreads = OptionBuilder.create((String)"max_threads");
            options.addOption(maxThreads);
            OptionBuilder.withArgName((String)"number");
            OptionBuilder.hasArg();
            OptionBuilder.withDescription((String)"The maximum percentage (between 0 and 100) of available server threads used by the client for running mlcp requests.");
            Option maxThreadPercentage = OptionBuilder.create((String)"max_thread_percentage");
            options.addOption(maxThreadPercentage);
            OptionBuilder.withArgName((String)"number");
            OptionBuilder.hasArg();
            OptionBuilder.withDescription((String)"The period (in minutes) mlcp talks to the server to collect maximum available server threads and decides whether to auto-scale.");
            Option pollingPeriod = OptionBuilder.create((String)"polling_period");
            options.addOption(pollingPeriod);
            OptionBuilder.withArgName((String)"number");
            OptionBuilder.hasArg();
            OptionBuilder.withDescription((String)"The initial delay (in minutes) before mlcp starts running polling requests to the server to collectmaximum available server threads for auto-scaling.");
            Option pollingInitDelay = OptionBuilder.create((String)"polling_init_delay");
            options.addOption(pollingInitDelay);
        }

        @Override
        public Job createJob(Configuration conf, CommandLine cmdline) throws IOException {
            Class outputFormatClass;
            this.applyConfigOptions(conf, cmdline);
            InputType type = 1.getInputType(cmdline);
            type.applyConfigOptions(conf, cmdline);
            Job job = LocalJob.getInstance(conf);
            Class inputFormatClass = conf.getClass("mapreduce.job.inputformat.class", null);
            if (inputFormatClass == null) {
                job.setInputFormatClass(type.getInputFormatClass(cmdline, conf));
            }
            if ((outputFormatClass = conf.getClass("mapreduce.job.outputformat.class", null)) == null) {
                job.setOutputFormatClass(type.getOutputFormatClass(cmdline, conf));
            }
            job.setJobName(1.getNewJobName(conf));
            Class mapperClass = conf.getClass("mapreduce.job.map.class", null);
            if (mapperClass == null) {
                this.setMapperClass(job, conf, cmdline);
            }
            if (cmdline.hasOption("input_file_path")) {
                String path = cmdline.getOptionValue("input_file_path");
                FileInputFormat.setInputPaths((Job)job, (String)path);
            }
            if (cmdline.hasOption("input_file_pattern")) {
                FileInputFormat.setInputPathFilter((Job)job, DocumentPathFilter.class);
            }
            return job;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        void applyUriId(Configuration conf, InputType inputType, CommandLine cmdline) {
            String uriId = null;
            if (cmdline.hasOption("delimited_uri_id")) {
                LOG.warn((Object)"delimited_uri_id has been depracated, use uri_id");
                uriId = cmdline.getOptionValue("delimited_uri_id");
            }
            if (cmdline.hasOption("aggregate_uri_id")) {
                LOG.warn((Object)"aggregate_uri_id has been depracated, use uri_id");
                uriId = cmdline.getOptionValue("aggregate_uri_id");
            }
            if (cmdline.hasOption("uri_id")) {
                uriId = cmdline.getOptionValue("uri_id");
            }
            String generate = null;
            if (cmdline.hasOption("generate_uri")) {
                generate = cmdline.getOptionValue("generate_uri");
                if (generate == null) {
                    generate = "true";
                }
                if (!"true".equalsIgnoreCase(generate) && !"false".equalsIgnoreCase(generate)) {
                    throw new IllegalArgumentException("Unrecognized option argument for generate_uri: " + generate);
                }
            }
            if (uriId != null) {
                if (InputType.AGGREGATES != inputType && InputType.DELIMITED_JSON != inputType && InputType.DELIMITED_TEXT != inputType) throw new IllegalArgumentException("uri_id is not applicable to " + inputType.name());
                conf.set("mapreduce.marklogic.input.uriid", uriId);
                if (InputType.AGGREGATES == inputType || generate == null || !"true".equalsIgnoreCase(generate)) return;
                throw new IllegalArgumentException("Only one of generate_uri and uri_id can be specified");
            }
            if (InputType.DELIMITED_TEXT == inputType) {
                if (!"true".equalsIgnoreCase(generate)) return;
                conf.setBoolean("mapreduce.marklogic.input.generateuri", true);
                return;
            } else {
                if (InputType.DELIMITED_JSON != inputType) return;
                if (generate != null && "false".equalsIgnoreCase(generate)) {
                    throw new IllegalArgumentException("generate_uri must be true if uri_id not specified");
                }
                conf.setBoolean("mapreduce.marklogic.input.generateuri", true);
            }
        }

        @Override
        public void applyConfigOptions(Configuration conf, CommandLine cmdline) {
            int maxThreadPercentage;
            int maxThreads;
            int threadCnt;
            String arg;
            String fileType;
            String passwd;
            String path;
            String arg2;
            String type;
            1.applyCopyConfigOptions(conf, cmdline);
            1.applyCommonOutputConfigOptions(conf, cmdline);
            1.applyRDFGraphOutputConfigOptions(conf, cmdline);
            InputType inputType = 1.getInputType(cmdline);
            ContentType contentType = inputType.getContentType(cmdline);
            if (InputType.DELIMITED_TEXT == inputType && ContentType.XML != contentType) {
                if (ContentType.JSON != contentType) {
                    throw new IllegalArgumentException("The setting for document_typeis not applicable to " + inputType);
                }
            }
            this.applyUriId(conf, inputType, cmdline);
            if (cmdline.hasOption("document_type") && InputType.DOCUMENTS != inputType && InputType.DELIMITED_TEXT != inputType) {
                LOG.warn((Object)("document_type is not supported for " + inputType.name()));
            }
            if (cmdline.hasOption("data_type")) {
                if (InputType.DELIMITED_TEXT != inputType) {
                    throw new IllegalArgumentException("data_type is only applicable to " + InputType.DELIMITED_TEXT.name());
                }
                type = cmdline.getOptionValue("document_type", ContentType.XML.name());
                if ("XML".equalsIgnoreCase(type)) {
                    LOG.warn((Object)("data_type is only applicable when document_type is " + ContentType.JSON.name()));
                } else {
                    String value = cmdline.getOptionValue("data_type");
                    String[] types = value.split(",");
                    if (types.length % 2 != 0) {
                        throw new IllegalArgumentException("Invalid option argument for data_type: " + value);
                    }
                    conf.set("mapreduce.marklogic.delimited.datatype", value);
                }
            }
            conf.set("mapreduce.marklogic.output.content.type", contentType.name());
            if (ContentType.MIXED == contentType) {
                LOG.info((Object)"Content type is set to MIXED.  The format of the  inserted documents will be determined by the MIME  type specification configured on MarkLogic Server.");
            } else {
                LOG.info((Object)("Content type: " + contentType.name()));
            }
            if (Command.isStreaming(cmdline, conf)) {
                conf.setBoolean("mapreduce.marklogic.output.content.streaming", true);
            }
            if (cmdline.hasOption("archive_metadata_optional")) {
                arg2 = cmdline.getOptionValue("archive_metadata_optional");
                if (1.isNullOrEqualsTrue(arg2)) {
                    conf.setBoolean("mapreduce.marklogic.input.archive.metadataoptional", true);
                } else if ("false".equalsIgnoreCase(arg2)) {
                    conf.setBoolean("mapreduce.marklogic.input.archive.metadataoptional", false);
                } else {
                    throw new IllegalArgumentException("Unrecognized option argument for archive_metadata_optional: " + arg2);
                }
            }
            if (cmdline.hasOption("input_compression_codec")) {
                String codec = cmdline.getOptionValue("input_compression_codec");
                conf.set("mapreduce.marklogic.input.compressioncodec", codec.toUpperCase());
            }
            if (cmdline.hasOption("max_split_size")) {
                String maxSize = cmdline.getOptionValue("max_split_size");
                conf.set("mapred.max.split.size", maxSize);
                conf.set("mapreduce.input.fileinputformat.split.maxsize", maxSize);
            }
            if (cmdline.hasOption("min_split_size")) {
                String minSize = cmdline.getOptionValue("min_split_size");
                conf.set("mapred.min.split.size", minSize);
                conf.set("mapreduce.input.fileinputformat.split.minsize", minSize);
            }
            if (cmdline.hasOption("aggregate_record_element")) {
                String recElem = cmdline.getOptionValue("aggregate_record_element");
                conf.set("mapreduce.marklogic.aggregate.recordelement", recElem);
            }
            if (cmdline.hasOption("aggregate_record_namespace")) {
                String recNs = cmdline.getOptionValue("aggregate_record_namespace");
                conf.set("mapreduce.marklogic.aggregate.recordnamespace", recNs);
            }
            if (cmdline.hasOption("delimiter")) {
                String delim = cmdline.getOptionValue("delimiter");
                if (delim == null || delim.length() != 1) {
                    throw new IllegalArgumentException("Invalid delimiter: " + delim);
                }
                conf.set("mapreduce.marklogic.delimited.delimiter", delim);
            }
            if (cmdline.hasOption("delimited_root_name")) {
                type = cmdline.getOptionValue("document_type", ContentType.XML.name());
                if ("JSON".equalsIgnoreCase(type)) {
                    LOG.warn((Object)("delimited_root_name is only applicable when document_type is " + ContentType.XML.name()));
                } else {
                    String delimRoot = cmdline.getOptionValue("delimited_root_name");
                    conf.set("mapreduce.marklogic.delimited.rootname", delimRoot);
                }
            }
            if (cmdline.hasOption("filename_as_collection")) {
                arg2 = cmdline.getOptionValue("filename_as_collection");
                conf.setBoolean("mapreduce.marklogic.output.filenameascollection", 1.isNullOrEqualsTrue(arg2));
            }
            if (cmdline.hasOption("output_directory")) {
                String outDir = cmdline.getOptionValue("output_directory");
                conf.set("mapreduce.marklogic.output.content.directory", outDir);
            }
            if (cmdline.hasOption("output_cleandir")) {
                arg2 = cmdline.getOptionValue("output_cleandir");
                if (1.isNullOrEqualsTrue(arg2)) {
                    conf.setBoolean("mapreduce.marklogic.output.content.cleandir", true);
                } else if ("false".equalsIgnoreCase(arg2)) {
                    conf.setBoolean("mapreduce.marklogic.output.content.cleandir", false);
                } else {
                    throw new IllegalArgumentException("Unrecognized option argument for output_cleandir: " + arg2);
                }
            }
            if (cmdline.hasOption("namespace")) {
                String ns = cmdline.getOptionValue("namespace");
                conf.set("mapreduce.marklogic.output.content.namespace", ns);
            }
            if (cmdline.hasOption("output_language")) {
                String language = cmdline.getOptionValue("output_language");
                conf.set("mapreduce.marklogic.output.content.language", language);
            }
            if (cmdline.hasOption("input_file_pattern")) {
                if (inputType == InputType.FOREST) {
                    LOG.warn((Object)("The setting for input_file_pattern is ignored for input type " + inputType.name()));
                } else {
                    String pattern = cmdline.getOptionValue("input_file_pattern");
                    conf.set("mapreduce.marklogic.input.filepattern", pattern);
                }
            }
            if (cmdline.hasOption("username")) {
                String username = cmdline.getOptionValue("username");
                conf.set("mapreduce.marklogic.output.username", username);
            }
            if (cmdline.hasOption("password")) {
                String password = cmdline.getOptionValue("password");
                conf.set("mapreduce.marklogic.output.password", password);
            }
            if (cmdline.hasOption("base_path")) {
                String basePath = cmdline.getOptionValue("base_path");
                conf.set("mapreduce.marklogic.output.base.path", basePath);
            }
            if (cmdline.hasOption("api_key")) {
                String apiKey = cmdline.getOptionValue("api_key");
                conf.set("mapreduce.marklogic.output.api.key", apiKey);
                if (conf.get("mapreduce.marklogic.output.base.path") == null) {
                    throw new IllegalArgumentException("Option base_path cannot be empty when api key is specified.");
                }
            }
            String port = "8000";
            if (cmdline.hasOption("port")) {
                port = cmdline.getOptionValue("port");
            }
            if (conf.get("mapreduce.marklogic.output.api.key") != null) {
                port = "443";
            }
            conf.set("mapreduce.marklogic.output.port", port);
            if (cmdline.hasOption("host")) {
                String hosts = cmdline.getOptionValue("host");
                InternalUtilities.verifyHosts(hosts, conf.get("mapreduce.marklogic.output.port"));
                conf.set("mapreduce.marklogic.output.host", hosts);
            }
            if (cmdline.hasOption("restrict_hosts")) {
                String restrict = cmdline.getOptionValue("restrict_hosts");
                if (1.isNullOrEqualsTrue(restrict)) {
                    conf.setBoolean("mapreduce.marklogic.output.restricthosts", true);
                    HttpChannel.setUseHTTP((boolean)true);
                } else if (!"false".equalsIgnoreCase(restrict)) {
                    throw new IllegalArgumentException("Unrecognized option argument for restrict_output_hosts: " + restrict);
                }
            } else {
                HttpChannel.setUseHTTP((boolean)true);
            }
            if (conf.get("mapreduce.marklogic.output.base.path") != null) {
                conf.setBoolean("mapreduce.marklogic.output.restricthosts", true);
                HttpChannel.setUseHTTP((boolean)true);
            }
            if (cmdline.hasOption("database")) {
                String db = cmdline.getOptionValue("database");
                conf.set("mapreduce.marklogic.output.databasename", db);
            }
            if (cmdline.hasOption("ssl")) {
                String arg3 = cmdline.getOptionValue("ssl");
                if (1.isNullOrEqualsTrue(arg3)) {
                    conf.setBoolean("mapreduce.marklogic.output.usessl", true);
                } else if (!"false".equalsIgnoreCase(arg3)) {
                    throw new IllegalArgumentException("Unrecognized option argument for ssl: " + arg3);
                }
            }
            if (conf.get("mapreduce.marklogic.output.api.key") != null) {
                conf.setBoolean("mapreduce.marklogic.output.usessl", true);
            }
            1.applyProtocol(conf, cmdline, "ssl_protocol", "mapreduce.marklogic.output.sslprotocol");
            if (cmdline.hasOption("keystore_path")) {
                path = cmdline.getOptionValue("keystore_path");
                path = new Path(path).toString();
                conf.set("mapreduce.marklogic.output.keystorepath", path);
            }
            if (cmdline.hasOption("keystore_password")) {
                passwd = cmdline.getOptionValue("keystore_password");
                conf.set("mapreduce.marklogic.output.keystorepassword", passwd);
            }
            if (cmdline.hasOption("truststore_path")) {
                path = cmdline.getOptionValue("truststore_path");
                path = new Path(path).toString();
                conf.set("mapreduce.marklogic.output.truststorepath", path);
            }
            if (cmdline.hasOption("truststore_password")) {
                passwd = cmdline.getOptionValue("truststore_password");
                conf.set("mapreduce.marklogic.output.truststorepassword", passwd);
            }
            if (cmdline.hasOption("temporal_collection")) {
                String tempColl = cmdline.getOptionValue("temporal_collection");
                conf.set("mapreduce.marklogic.output.temporalcollection", tempColl);
            }
            String repairLevel = cmdline.getOptionValue("xml_repair_level", "DEFAULT");
            conf.set("mapreduce.marklogic.output.content.repairlevel", repairLevel.toUpperCase());
            if (cmdline.hasOption("sequencefile_key_class")) {
                String keyClass = cmdline.getOptionValue("sequencefile_key_class");
                conf.set("mapreduce.marklogic.input.sequencefile.keyclass", keyClass);
            }
            if (cmdline.hasOption("sequencefile_value_class")) {
                String valueClass = cmdline.getOptionValue("sequencefile_value_class");
                conf.set("mapreduce.marklogic.input.sequencefile.valueclass", valueClass);
            }
            if (cmdline.hasOption("sequencefile_value_type")) {
                String valueType = cmdline.getOptionValue("sequencefile_value_type", "TEXT");
                conf.set("mapreduce.marklogic.input.sequencefile.valuetype", valueType.toUpperCase());
                if (SequenceFileValueType.BYTESWRITABLE.toString().equalsIgnoreCase(valueType)) {
                    conf.set("mapreduce.marklogic.output.content.type", ContentType.BINARY.toString());
                }
            } else if (conf.get("mapreduce.marklogic.input.sequencefile.valuetype") == null) {
                conf.set("mapreduce.marklogic.input.sequencefile.valuetype", "TEXT");
            }
            if (cmdline.hasOption("input_file_type")) {
                fileType = cmdline.getOptionValue("input_file_type");
                if (InputType.ARCHIVE.toString().equalsIgnoreCase(fileType)) {
                    conf.set("mapreduce.marklogic.output.content.type", ContentType.UNKNOWN.toString());
                }
            }
            if (cmdline.hasOption("fastload")) {
                arg = cmdline.getOptionValue("fastload");
                if (1.isNullOrEqualsTrue(arg)) {
                    conf.setBoolean("mapreduce.marklogic.output.content.fastload", true);
                    LOG.info((Object)"Option fastload is specified.Please make sure that all conditions required to run in fastload mode are satisfied to avoid XDMP-DBDUPURI errors.");
                } else if ("false".equalsIgnoreCase(arg)) {
                    conf.setBoolean("mapreduce.marklogic.output.content.fastload", false);
                } else {
                    throw new IllegalArgumentException("Unrecognized option argument for fastload: " + arg);
                }
            }
            if (cmdline.hasOption("content_encoding")) {
                arg = cmdline.getOptionValue("content_encoding").toUpperCase();
                if ("SYSTEM".equals(arg)) {
                    arg = Charset.defaultCharset().name();
                } else if (!Charset.isSupported(arg)) {
                    throw new IllegalArgumentException(arg + " encoding is not supported");
                }
                conf.set("mapreduce.marklogic.output.content.encoding", arg);
            }
            if (cmdline.hasOption("thread_count_per_split")) {
                arg = cmdline.getOptionValue("thread_count_per_split");
                threadCnt = Integer.parseInt(arg);
                if (threadCnt > 1 && 1.isStreaming(cmdline, conf)) {
                    LOG.warn((Object)"The setting for thread_count_per_split is ignored because streaming is enabled.");
                } else {
                    if (threadCnt < inputType.getMinThreads()) {
                        throw new IllegalArgumentException("Cannot set thread_count_per_split to a value less than the minimum required  threads (" + inputType.getMinThreads() + ")for the job.");
                    }
                    conf.set("mapreduce.marklogic.multithreadedmapper.threads", arg);
                }
            }
            if (cmdline.hasOption("thread_count") && (threadCnt = Integer.parseInt(arg = cmdline.getOptionValue("thread_count"))) < inputType.getMinThreads()) {
                throw new IllegalArgumentException("Cannot set thread_count to a value less than the minimum required  threads (" + inputType.getMinThreads() + ") for the job.");
            }
            if (cmdline.hasOption("max_threads") && (maxThreads = Integer.parseInt(arg = cmdline.getOptionValue("max_threads"))) < inputType.getMinThreads()) {
                throw new IllegalArgumentException("Cannot set max_threads to a value less than the minimum required threads (" + inputType.getMinThreads() + ") for the job.");
            }
            if (cmdline.hasOption("max_thread_percentage") && ((maxThreadPercentage = Integer.parseInt(arg = cmdline.getOptionValue("max_thread_percentage"))) <= 0 || maxThreadPercentage > 100)) {
                throw new IllegalArgumentException("Illegal percentage set for max_thread_percentage. Please specify a number between 0 and 100");
            }
            if (cmdline.hasOption("temporal_collection") && (fileType = cmdline.getOptionValue("input_file_type")) != null && InputType.RDF.toString().equalsIgnoreCase(fileType)) {
                throw new IllegalArgumentException("Cannot ingest RDF into temporal collection");
            }
            1.applyPartitionConfigOptions(conf, cmdline);
            1.applyModuleConfigOptions(conf, cmdline);
            1.applyBatchTxn(conf, cmdline, 200);
            if (cmdline.hasOption("split_input")) {
                arg = cmdline.getOptionValue("split_input");
                if (1.isNullOrEqualsTrue(arg)) {
                    if (1.isInputCompressed(cmdline)) {
                        LOG.warn((Object)"input_compressed disables split_input");
                        conf.setBoolean("mapreduce.marklogic.splitinput", false);
                    }
                    if (inputType != InputType.DELIMITED_TEXT) {
                        throw new IllegalArgumentException("The setting for split_input option is not supported for " + inputType);
                    }
                    conf.setBoolean("mapreduce.marklogic.splitinput", true);
                } else if ("false".equalsIgnoreCase(arg)) {
                    conf.setBoolean("mapreduce.marklogic.splitinput", false);
                } else {
                    throw new IllegalArgumentException("Unrecognized option argument for split_input: " + arg);
                }
            }
            if (cmdline.hasOption("collection_filter")) {
                if (inputType == InputType.FOREST) {
                    String colFilter = cmdline.getOptionValue("collection_filter");
                    conf.set("mapreduce.marklogic.input.filter.collection", colFilter);
                } else {
                    LOG.warn((Object)("The setting for collection_filter is not applicable for " + inputType));
                }
            }
            if (cmdline.hasOption("directory_filter")) {
                if (inputType == InputType.FOREST) {
                    String dirFilter = cmdline.getOptionValue("directory_filter");
                    conf.set("mapreduce.marklogic.input.filter.directory", dirFilter);
                } else {
                    LOG.warn((Object)("The setting for directory_filter is not applicable for " + inputType));
                }
            }
            if (cmdline.hasOption("type_filter")) {
                if (inputType == InputType.FOREST) {
                    String typeFilter = cmdline.getOptionValue("type_filter");
                    conf.set("mapreduce.marklogic.input.filter.type", typeFilter);
                } else {
                    LOG.warn((Object)("The setting for type_filter is not applicable for " + inputType));
                }
            }
            if (cmdline.hasOption("token_endpoint")) {
                String tokenEndpoint = cmdline.getOptionValue("token_endpoint");
                conf.set("mapreduce.marklogic.output.token.endpoint", tokenEndpoint);
            }
            if (cmdline.hasOption("grant_type")) {
                String grantType = cmdline.getOptionValue("grant_type");
                conf.set("mapreduce.marklogic.output.grant.type", grantType);
            }
            if (cmdline.hasOption("token_duration")) {
                String tokenDuration = cmdline.getOptionValue("token_duration");
                conf.set("mapreduce.marklogic.output.token.duration", tokenDuration);
            }
        }

        @Override
        public void setMapperClass(Job job, Configuration conf, CommandLine cmdline) {
            String inputTypeOption = cmdline.getOptionValue("input_file_type", "documents");
            InputType type = InputType.forName(inputTypeOption);
            int minThreads = type.getMinThreads();
            if (minThreads > 1) {
                conf.setInt("mapreduce.marklogic.minthreads", minThreads);
            }
            int threadCnt = conf.getInt("mapreduce.marklogic.multithreadedmapper.threads", 1);
            threadCnt = Math.max(threadCnt, minThreads);
            Class internalMapperClass = type.getMapperClass(cmdline, conf);
            if (threadCnt > 1 && !1.isStreaming(cmdline, conf)) {
                job.setMapperClass(MultithreadedMapper.class);
                MultithreadedMapper.setMapperClass(job.getConfiguration(), internalMapperClass);
                MultithreadedMapper.setNumberOfThreads(job, threadCnt);
            } else {
                job.setMapperClass(internalMapperClass);
            }
        }

        @Override
        public Class<? extends Mapper<?, ?, ?, ?>> getRuntimeMapperClass(Job job, Class<? extends Mapper<?, ?, ?, ?>> mapper, int threadsPerSplit) {
            if (threadsPerSplit == 0 && !job.getConfiguration().getBoolean("mapreduce.marklogic.output.content.streaming", false)) {
                Class<MultithreadedMapper> mapperClass = MultithreadedMapper.class;
                MultithreadedMapper.setMapperClass(job.getConfiguration(), mapper);
                return mapperClass;
            }
            return mapper;
        }
    }
    ,
    EXPORT{

        @Override
        public void configOptions(Options options) {
            2.configCommonOptions(options);
            2.configConnectionId(options);
            2.configCopyOptions(options);
            2.configFilteringOptions(options);
            2.configRedactionOptions(options);
            2.configMLCloudAuthOptions(options);
            OptionBuilder.withArgName((String)"string");
            OptionBuilder.hasArg();
            OptionBuilder.withDescription((String)"export output type");
            Option outputType = OptionBuilder.create((String)"output_type");
            options.addOption(outputType);
            OptionBuilder.withArgName((String)"string");
            OptionBuilder.hasArg();
            OptionBuilder.withDescription((String)"export output file path");
            Option outputFilePath = OptionBuilder.create((String)"output_file_path");
            outputFilePath.setRequired(true);
            options.addOption(outputFilePath);
            OptionBuilder.withArgName((String)"true,false");
            OptionBuilder.hasOptionalArg();
            OptionBuilder.withDescription((String)"Whether to compress the output document");
            Option exportCompress = OptionBuilder.create((String)"compress");
            options.addOption(exportCompress);
            OptionBuilder.withArgName((String)"true,false");
            OptionBuilder.hasOptionalArg();
            OptionBuilder.withDescription((String)"Whether to format XML data with indentation");
            Option exportIndented = OptionBuilder.create((String)"indented");
            options.addOption(exportIndented);
            OptionBuilder.withArgName((String)"true,false");
            OptionBuilder.hasOptionalArg();
            OptionBuilder.withDescription((String)"Whether to use a consistent timestamp to fetch data from the source database");
            Option snapshot = OptionBuilder.create((String)"snapshot");
            options.addOption(snapshot);
            OptionBuilder.withArgName((String)"string");
            OptionBuilder.hasArg();
            OptionBuilder.withDescription((String)"The charset encoding to be used by the MarkLogic when exporting documents");
            Option encoding = OptionBuilder.create((String)"content_encoding");
            options.addOption(encoding);
        }

        @Override
        public Job createJob(Configuration conf, CommandLine cmdline) throws IOException {
            Class outputKeyClass;
            Class outputFormatClass;
            Class mapOutputValueClass;
            Class mapOutputKeyClass;
            Class mapperClass;
            this.applyConfigOptions(conf, cmdline);
            String type = conf.get("mapreduce.marklogic.output.type", "document");
            ExportOutputType outputType = ExportOutputType.valueOf(type.toUpperCase());
            if (outputType.equals((Object)ExportOutputType.DOCUMENT)) {
                conf.set("mapreduce.marklogic.input.valueclass", DatabaseDocument.class.getCanonicalName());
            }
            if (cmdline.hasOption("snapshot")) {
                String arg = cmdline.getOptionValue("snapshot");
                if (2.isNullOrEqualsTrue(arg)) {
                    2.setQueryTimestamp(conf);
                } else if (!"false".equalsIgnoreCase(arg)) {
                    throw new IllegalArgumentException("Unrecognized option argument for snapshot: " + arg);
                }
            }
            Job job = LocalJob.getInstance(conf);
            job.setJarByClass(this.getClass());
            Class inputFormatClass = conf.getClass("mapreduce.job.inputformat.class", null);
            if (inputFormatClass == null) {
                job.setInputFormatClass(outputType.getInputFormatClass());
            }
            if ((mapperClass = conf.getClass("mapreduce.job.map.class", null)) == null) {
                this.setMapperClass(job, conf, cmdline);
            }
            if ((mapOutputKeyClass = conf.getClass("mapreduce.map.output.key.class", null)) == null) {
                job.setMapOutputKeyClass(DocumentURI.class);
            }
            if ((mapOutputValueClass = conf.getClass("mapreduce.map.output.value.class", null)) == null) {
                job.setMapOutputValueClass(MarkLogicDocument.class);
            }
            if ((outputFormatClass = conf.getClass("mapreduce.job.outputformat.class", null)) == null) {
                job.setOutputFormatClass(outputType.getOutputFormatClass(cmdline));
            }
            if ((outputKeyClass = conf.getClass("mapreduce.job.output.key.class", null)) == null) {
                job.setOutputKeyClass(DocumentURI.class);
            }
            job.setJobName(2.getNewJobName(conf));
            AuditUtil.prepareAuditMlcpStart(job, this.name(), cmdline);
            return job;
        }

        @Override
        public void applyConfigOptions(Configuration conf, CommandLine cmdline) {
            String passwd;
            String path;
            String arg;
            String isIndented;
            2.applyCopyConfigOptions(conf, cmdline);
            2.applyFilteringConfigOptions(conf, cmdline);
            2.applyRedactionConfigOptions(conf, cmdline);
            if (cmdline.hasOption("output_type")) {
                String outputType = cmdline.getOptionValue("output_type");
                conf.set("mapreduce.marklogic.output.type", outputType);
            }
            if (cmdline.hasOption("output_file_path")) {
                String path2 = cmdline.getOptionValue("output_file_path");
                String wkdir = conf.get("mapreduce.job.working.dir");
                if (wkdir != null) {
                    path2 = new Path(wkdir, path2).toString();
                }
                conf.set("mapreduce.output.fileoutputformat.outputdir", path2);
            }
            if (cmdline.hasOption("indented") && (isIndented = cmdline.getOptionValue("indented")) != null) {
                Indentation indent = Indentation.forName(isIndented);
                conf.set("mapreduce.marklogic.input.indented", indent.name());
            }
            if (cmdline.hasOption("base_path")) {
                String basePath = cmdline.getOptionValue("base_path");
                conf.set("mapreduce.marklogic.input.base.path", basePath);
            }
            if (cmdline.hasOption("api_key")) {
                String apiKey = cmdline.getOptionValue("api_key");
                conf.set("mapreduce.marklogic.input.api.key", apiKey);
                if (conf.get("mapreduce.marklogic.input.base.path") == null) {
                    throw new IllegalArgumentException("Option base_path cannot be empty when api key is specified.");
                }
            }
            String port = "8000";
            if (cmdline.hasOption("port")) {
                port = cmdline.getOptionValue("port");
            }
            if (conf.get("mapreduce.marklogic.input.api.key") != null) {
                port = "443";
            }
            conf.set("mapreduce.marklogic.input.port", port);
            if (cmdline.hasOption("host")) {
                String hosts = cmdline.getOptionValue("host");
                InternalUtilities.verifyHosts(hosts, conf.get("mapreduce.marklogic.input.port"));
                conf.set("mapreduce.marklogic.input.host", hosts);
            }
            if (cmdline.hasOption("restrict_hosts")) {
                String restrict = cmdline.getOptionValue("restrict_hosts");
                if (2.isNullOrEqualsTrue(restrict)) {
                    conf.setBoolean("mapreduce.marklogic.input.restricthosts", true);
                    HttpChannel.setUseHTTP((boolean)true);
                } else if (!"false".equalsIgnoreCase(restrict)) {
                    throw new IllegalArgumentException("Unrecognized option argument for restrict_input_hosts: " + restrict);
                }
            } else {
                HttpChannel.setUseHTTP((boolean)true);
            }
            if (conf.get("mapreduce.marklogic.input.base.path") != null) {
                conf.setBoolean("mapreduce.marklogic.input.restricthosts", true);
                HttpChannel.setUseHTTP((boolean)true);
            }
            if (cmdline.hasOption("username")) {
                String user = cmdline.getOptionValue("username");
                conf.set("mapreduce.marklogic.input.username", user);
            }
            if (cmdline.hasOption("password")) {
                String pswd = cmdline.getOptionValue("password");
                conf.set("mapreduce.marklogic.input.password", pswd);
            }
            if (cmdline.hasOption("database")) {
                String db = cmdline.getOptionValue("database");
                conf.set("mapreduce.marklogic.input.databasename", db);
            }
            if (cmdline.hasOption("ssl")) {
                arg = cmdline.getOptionValue("ssl");
                if (2.isNullOrEqualsTrue(arg)) {
                    conf.setBoolean("mapreduce.marklogic.input.usessl", true);
                } else if (!"false".equalsIgnoreCase(arg)) {
                    throw new IllegalArgumentException("Unrecognized option argument for ssl: " + arg);
                }
            }
            if (conf.get("mapreduce.marklogic.input.api.key") != null) {
                conf.setBoolean("mapreduce.marklogic.input.usessl", true);
            }
            2.applyProtocol(conf, cmdline, "ssl_protocol", "mapreduce.marklogic.input.sslprotocol");
            if (cmdline.hasOption("keystore_path")) {
                path = cmdline.getOptionValue("keystore_path");
                path = new Path(path).toString();
                conf.set("mapreduce.marklogic.input.keystorepath", path);
            }
            if (cmdline.hasOption("keystore_password")) {
                passwd = cmdline.getOptionValue("keystore_password");
                conf.set("mapreduce.marklogic.input.keystorepassword", passwd);
            }
            if (cmdline.hasOption("truststore_path")) {
                path = cmdline.getOptionValue("truststore_path");
                path = new Path(path).toString();
                conf.set("mapreduce.marklogic.input.truststorepath", path);
            }
            if (cmdline.hasOption("truststore_password")) {
                passwd = cmdline.getOptionValue("truststore_password");
                conf.set("mapreduce.marklogic.input.truststorepassword", passwd);
            }
            if (cmdline.hasOption("max_split_size")) {
                String maxSize = cmdline.getOptionValue("max_split_size");
                conf.set("mapreduce.marklogic.input.maxsplitsize", maxSize);
            }
            if (cmdline.hasOption("content_encoding")) {
                arg = cmdline.getOptionValue("content_encoding").toUpperCase();
                if ("SYSTEM".equals(arg)) {
                    arg = Charset.defaultCharset().name();
                } else if (!Charset.isSupported(arg)) {
                    throw new IllegalArgumentException(arg + " encoding is not supported");
                }
                conf.set("mapreduce.marklogic.output.content.encoding", arg);
            }
            if (cmdline.hasOption("token_endpoint")) {
                String tokenEndpoint = cmdline.getOptionValue("token_endpoint");
                conf.set("mapreduce.marklogic.input.token.endpoint", tokenEndpoint);
            }
            if (cmdline.hasOption("grant_type")) {
                String grantType = cmdline.getOptionValue("grant_type");
                conf.set("mapreduce.marklogic.input.grant.type", grantType);
            }
            if (cmdline.hasOption("token_duration")) {
                String tokenDuration = cmdline.getOptionValue("token_duration");
                conf.set("mapreduce.marklogic.input.token.duration", tokenDuration);
            }
        }

        @Override
        public void setMapperClass(Job job, Configuration conf, CommandLine cmdline) {
            job.setMapperClass(DocumentMapper.class);
        }

        @Override
        public Class<? extends Mapper<?, ?, ?, ?>> getRuntimeMapperClass(Job job, Class<? extends Mapper<?, ?, ?, ?>> mapper, int threadsPerSplit) {
            return mapper;
        }
    }
    ,
    COPY{

        @Override
        public void configOptions(Options options) {
            3.configCommonOptions(options);
            3.configCopyOptions(options);
            3.configCommonOutputOptions(options);
            3.configFilteringOptions(options);
            3.configBatchTxn(options);
            3.configModule(options);
            3.configRedactionOptions(options);
            3.configCopyMLCloudAuthOptions(options);
            OptionBuilder.withArgName((String)"string");
            OptionBuilder.hasArg();
            OptionBuilder.withDescription((String)"User name of the input MarkLogic Server");
            Option inputUsername = OptionBuilder.create((String)"input_username");
            options.addOption(inputUsername);
            OptionBuilder.withArgName((String)"string");
            OptionBuilder.hasArg();
            OptionBuilder.withDescription((String)"Password of the input MarkLogic Server");
            Option inputPassword = OptionBuilder.create((String)"input_password");
            options.addOption(inputPassword);
            OptionBuilder.withArgName((String)"comma list");
            OptionBuilder.hasArg();
            OptionBuilder.withDescription((String)"Comma-separated list of hosts of the input MarkLogic Server");
            Option inputHost = OptionBuilder.create((String)"input_host");
            inputHost.setRequired(true);
            options.addOption(inputHost);
            OptionBuilder.withArgName((String)"number");
            OptionBuilder.hasArg();
            OptionBuilder.withDescription((String)"Port of the input MarkLogic Server");
            Option inputPort = OptionBuilder.create((String)"input_port");
            options.addOption(inputPort);
            OptionBuilder.withArgName((String)"string");
            OptionBuilder.hasArg();
            OptionBuilder.withDescription((String)"Database of the input MarkLogic Server");
            Option inputDB = OptionBuilder.create((String)"input_database");
            options.addOption(inputDB);
            OptionBuilder.withArgName((String)"true,false");
            OptionBuilder.hasOptionalArg();
            OptionBuilder.withDescription((String)"Whether to restrict the input hosts mlcp connects to");
            Option restrictInputHosts = OptionBuilder.create((String)"restrict_input_hosts");
            options.addOption(restrictInputHosts);
            OptionBuilder.withArgName((String)"true,false");
            OptionBuilder.hasOptionalArg();
            OptionBuilder.withDescription((String)"Use ssl to encrypt communication with input MarkLogic Server");
            Option inputSSL = OptionBuilder.create((String)"input_ssl");
            options.addOption(inputSSL);
            OptionBuilder.withArgName((String)"string");
            OptionBuilder.hasArg();
            OptionBuilder.withDescription((String)"Input ssl protocol, e.g. TLS, TLSv1.2");
            Option inputSSLProtocol = OptionBuilder.create((String)"input_ssl_protocol");
            options.addOption(inputSSLProtocol);
            OptionBuilder.withArgName((String)"string");
            OptionBuilder.hasArg();
            OptionBuilder.withDescription((String)"Input Keystore path to use for SSL connections.");
            Option inputKeystorePath = OptionBuilder.create((String)"input_keystore_path");
            options.addOption(inputKeystorePath);
            OptionBuilder.withArgName((String)"string");
            OptionBuilder.hasArg();
            OptionBuilder.withDescription((String)"Input Keystore password to use for SSL connections");
            Option inputKeystorePasswd = OptionBuilder.create((String)"input_keystore_password");
            options.addOption(inputKeystorePasswd);
            OptionBuilder.withArgName((String)"string");
            OptionBuilder.hasArg();
            OptionBuilder.withDescription((String)"Input Truststore path to use for SSL connections.");
            Option inputTruststorePath = OptionBuilder.create((String)"input_truststore_path");
            options.addOption(inputTruststorePath);
            OptionBuilder.withArgName((String)"string");
            OptionBuilder.hasArg();
            OptionBuilder.withDescription((String)"Input Truststore password to use for SSL connections");
            Option inputTruststorePasswd = OptionBuilder.create((String)"input_truststore_password");
            options.addOption(inputTruststorePasswd);
            OptionBuilder.withArgName((String)"string");
            OptionBuilder.hasArg();
            OptionBuilder.withDescription((String)"Input base path that maps to a MarkLogic Application Server");
            Option inputBasePath = OptionBuilder.create((String)"input_base_path");
            options.addOption(inputBasePath);
            OptionBuilder.withArgName((String)"string");
            OptionBuilder.hasArg();
            OptionBuilder.withDescription((String)"API key for the input MarkLogic Cloud");
            Option inputApiKey = OptionBuilder.create((String)"input_api_key");
            options.addOption(inputApiKey);
            OptionBuilder.withArgName((String)"string");
            OptionBuilder.hasArg();
            OptionBuilder.withDescription((String)"User Name of the output MarkLogic Server");
            Option outputUsername = OptionBuilder.create((String)"output_username");
            options.addOption(outputUsername);
            OptionBuilder.withArgName((String)"string");
            OptionBuilder.hasArg();
            OptionBuilder.withDescription((String)"Password of the output MarkLogic Server");
            Option outputPassword = OptionBuilder.create((String)"output_password");
            options.addOption(outputPassword);
            OptionBuilder.withArgName((String)"comma list");
            OptionBuilder.hasArg();
            OptionBuilder.withDescription((String)"Comma-separated list of hosts of the output MarkLogic Server");
            Option outputHost = OptionBuilder.create((String)"output_host");
            outputHost.setRequired(true);
            options.addOption(outputHost);
            OptionBuilder.withArgName((String)"number");
            OptionBuilder.hasArg();
            OptionBuilder.withDescription((String)"Port of the output MarkLogic Server");
            Option outputPort = OptionBuilder.create((String)"output_port");
            options.addOption(outputPort);
            OptionBuilder.withArgName((String)"string");
            OptionBuilder.hasArg();
            OptionBuilder.withDescription((String)"Database of the output MarkLogic Server");
            Option outputDB = OptionBuilder.create((String)"output_database");
            options.addOption(outputDB);
            OptionBuilder.withArgName((String)"true,fasle");
            OptionBuilder.hasOptionalArg();
            OptionBuilder.withDescription((String)"Whether to the restrict output hosts mlcp connects to");
            Option restrictOutputHosts = OptionBuilder.create((String)"restrict_output_hosts");
            options.addOption(restrictOutputHosts);
            OptionBuilder.withArgName((String)"true,false");
            OptionBuilder.hasOptionalArg();
            OptionBuilder.withDescription((String)"Use ssl to encryt communication with the output MarkLogic Server");
            Option outputSSL = OptionBuilder.create((String)"output_ssl");
            options.addOption(outputSSL);
            OptionBuilder.withArgName((String)"string");
            OptionBuilder.hasArg();
            OptionBuilder.withDescription((String)"Output ssl protocol, e.g.TLS, TLSv1");
            Option outputSSLProtocol = OptionBuilder.create((String)"output_ssl_protocol");
            options.addOption(outputSSLProtocol);
            OptionBuilder.withArgName((String)"string");
            OptionBuilder.hasArg();
            OptionBuilder.withDescription((String)"Output Keystore path to use for SSL connections.");
            Option outputKeystorePath = OptionBuilder.create((String)"output_keystore_path");
            options.addOption(outputKeystorePath);
            OptionBuilder.withArgName((String)"string");
            OptionBuilder.hasArg();
            OptionBuilder.withDescription((String)"Output Keystore password to use for SSL connections");
            Option outputKeystorePasswd = OptionBuilder.create((String)"output_keystore_password");
            options.addOption(outputKeystorePasswd);
            OptionBuilder.withArgName((String)"string");
            OptionBuilder.hasArg();
            OptionBuilder.withDescription((String)"Output Truststore path to use for SSL connections.");
            Option outputTruststorePath = OptionBuilder.create((String)"output_truststore_path");
            options.addOption(outputTruststorePath);
            OptionBuilder.withArgName((String)"string");
            OptionBuilder.hasArg();
            OptionBuilder.withDescription((String)"Output Truststore password to use for SSL connections");
            Option outputTruststorePasswd = OptionBuilder.create((String)"output_truststore_password");
            options.addOption(outputTruststorePasswd);
            OptionBuilder.withArgName((String)"string");
            OptionBuilder.hasArg();
            OptionBuilder.withDescription((String)"Output base path that maps to a MarkLogic Application Server");
            Option outputBasePath = OptionBuilder.create((String)"output_base_path");
            options.addOption(outputBasePath);
            OptionBuilder.withArgName((String)"string");
            OptionBuilder.hasArg();
            OptionBuilder.withDescription((String)"API key for the output MarkLogic Cloud");
            Option outputApiKey = OptionBuilder.create((String)"output_api_key");
            options.addOption(outputApiKey);
            OptionBuilder.withArgName((String)"string");
            OptionBuilder.hasArg();
            OptionBuilder.withDescription((String)"temporal collection name, used only for temporal documents");
            Option tcf = OptionBuilder.create((String)"temporal_collection");
            options.addOption(tcf);
            OptionBuilder.withArgName((String)"true,false");
            OptionBuilder.hasOptionalArg();
            OptionBuilder.withDescription((String)"Whether to use the fast load mode to load content into MarkLogic");
            Option fastLoad = OptionBuilder.create((String)"fastload");
            options.addOption(fastLoad);
            OptionBuilder.withArgName((String)"string");
            OptionBuilder.hasArg();
            OptionBuilder.withDescription((String)"Output directory in MarkLogic.");
            Option outputDir = OptionBuilder.create((String)"output_directory");
            options.addOption(outputDir);
            3.configPartition(options);
            OptionBuilder.withArgName((String)"true,false");
            OptionBuilder.hasOptionalArg();
            OptionBuilder.withDescription((String)"Whether to use a consistent timestamp to fetch data from the source database");
            Option snapshot = OptionBuilder.create((String)"snapshot");
            options.addOption(snapshot);
        }

        @Override
        public Job createJob(Configuration conf, CommandLine cmdline) throws IOException {
            Class outputKeyClass;
            Class outputFormatClass;
            Class mapOutputValueClass;
            Class mapOutputKeyClass;
            Class mapperClass;
            this.applyConfigOptions(conf, cmdline);
            if (cmdline.hasOption("snapshot")) {
                String arg = cmdline.getOptionValue("snapshot");
                if (3.isNullOrEqualsTrue(arg)) {
                    3.setQueryTimestamp(conf);
                } else if (!"false".equalsIgnoreCase(arg)) {
                    throw new IllegalArgumentException("Unrecognized option argument for snapshot: " + arg);
                }
            }
            Job job = LocalJob.getInstance(conf);
            job.setJarByClass(this.getClass());
            Class inputFormatClass = conf.getClass("mapreduce.job.inputformat.class", null);
            if (inputFormatClass == null) {
                job.setInputFormatClass(DatabaseContentInputFormat.class);
            }
            if ((mapperClass = conf.getClass("mapreduce.job.map.class", null)) == null) {
                job.setMapperClass(DocumentMapper.class);
            }
            if ((mapOutputKeyClass = conf.getClass("mapreduce.map.output.key.class", null)) == null) {
                job.setMapOutputKeyClass(DocumentURI.class);
            }
            if ((mapOutputValueClass = conf.getClass("mapreduce.map.output.value.class", null)) == null) {
                job.setMapOutputValueClass(MarkLogicDocument.class);
            }
            if ((outputFormatClass = conf.getClass("mapreduce.job.outputformat.class", null)) == null) {
                if (cmdline.hasOption("transform_module")) {
                    job.setOutputFormatClass(DatabaseTransformOutputFormat.class);
                } else {
                    job.setOutputFormatClass(DatabaseContentOutputFormat.class);
                }
            }
            if ((outputKeyClass = conf.getClass("mapreduce.job.output.key.class", null)) == null) {
                job.setOutputKeyClass(DocumentURI.class);
            }
            job.setJobName(3.getNewJobName(conf));
            AuditUtil.prepareAuditMlcpStart(job, this.name(), cmdline);
            return job;
        }

        @Override
        public void applyConfigOptions(Configuration conf, CommandLine cmdline) {
            String passwd;
            String path;
            String arg;
            String passwd2;
            String path2;
            3.applyCopyConfigOptions(conf, cmdline);
            3.applyFilteringConfigOptions(conf, cmdline);
            3.applyCommonOutputConfigOptions(conf, cmdline);
            3.applyRedactionConfigOptions(conf, cmdline);
            if (cmdline.hasOption("output_username")) {
                String username = cmdline.getOptionValue("output_username");
                conf.set("mapreduce.marklogic.output.username", username);
            }
            if (cmdline.hasOption("output_password")) {
                String password = cmdline.getOptionValue("output_password");
                conf.set("mapreduce.marklogic.output.password", password);
            }
            if (cmdline.hasOption("output_base_path")) {
                String outputBasePath = cmdline.getOptionValue("output_base_path");
                conf.set("mapreduce.marklogic.output.base.path", outputBasePath);
            }
            if (cmdline.hasOption("output_api_key")) {
                String outputApiKey = cmdline.getOptionValue("output_api_key");
                conf.set("mapreduce.marklogic.output.api.key", outputApiKey);
                if (conf.get("mapreduce.marklogic.output.base.path") == null) {
                    throw new IllegalArgumentException("Option output_base_path cannot be empty when output api key is specified.");
                }
            }
            String outputPort = "8000";
            if (cmdline.hasOption("output_port")) {
                outputPort = cmdline.getOptionValue("output_port");
            }
            if (conf.get("mapreduce.marklogic.output.api.key") != null) {
                outputPort = "443";
            }
            conf.set("mapreduce.marklogic.output.port", outputPort);
            if (cmdline.hasOption("output_host")) {
                String outputHosts = cmdline.getOptionValue("output_host");
                InternalUtilities.verifyHosts(outputHosts, conf.get("mapreduce.marklogic.output.port"));
                conf.set("mapreduce.marklogic.output.host", outputHosts);
            }
            if (cmdline.hasOption("output_database")) {
                String db = cmdline.getOptionValue("output_database");
                conf.set("mapreduce.marklogic.output.databasename", db);
            }
            if (cmdline.hasOption("restrict_output_hosts")) {
                String restrict = cmdline.getOptionValue("restrict_output_hosts");
                if (3.isNullOrEqualsTrue(restrict)) {
                    conf.setBoolean("mapreduce.marklogic.output.restricthosts", true);
                    HttpChannel.setUseHTTP((boolean)true);
                } else if (!"false".equalsIgnoreCase(restrict)) {
                    throw new IllegalArgumentException("Unrecognized option argument for restrict_output_hosts: " + restrict);
                }
            } else {
                HttpChannel.setUseHTTP((boolean)true);
            }
            if (conf.get("mapreduce.marklogic.output.base.path") != null) {
                conf.setBoolean("mapreduce.marklogic.output.restricthosts", true);
                HttpChannel.setUseHTTP((boolean)true);
            }
            if (cmdline.hasOption("output_ssl")) {
                String arg2 = cmdline.getOptionValue("output_ssl");
                if (3.isNullOrEqualsTrue(arg2)) {
                    conf.setBoolean("mapreduce.marklogic.output.usessl", true);
                } else if (!"false".equalsIgnoreCase(arg2)) {
                    throw new IllegalArgumentException("Unrecognized option argument for output_ssl: " + arg2);
                }
            }
            if (conf.get("mapreduce.marklogic.output.api.key") != null) {
                conf.setBoolean("mapreduce.marklogic.output.usessl", true);
            }
            3.applyProtocol(conf, cmdline, "output_ssl_protocol", "mapreduce.marklogic.output.sslprotocol");
            if (cmdline.hasOption("output_keystore_path")) {
                path2 = cmdline.getOptionValue("output_keystore_path");
                path2 = new Path(path2).toString();
                conf.set("mapreduce.marklogic.output.keystorepath", path2);
            }
            if (cmdline.hasOption("output_keystore_password")) {
                passwd2 = cmdline.getOptionValue("output_keystore_password");
                conf.set("mapreduce.marklogic.output.keystorepassword", passwd2);
            }
            if (cmdline.hasOption("output_truststore_path")) {
                path2 = cmdline.getOptionValue("output_truststore_path");
                path2 = new Path(path2).toString();
                conf.set("mapreduce.marklogic.output.truststorepath", path2);
            }
            if (cmdline.hasOption("output_truststore_password")) {
                passwd2 = cmdline.getOptionValue("output_truststore_password");
                conf.set("mapreduce.marklogic.output.truststorepassword", passwd2);
            }
            if (cmdline.hasOption("output_token_endpoint")) {
                String outputTokenEndpoint = cmdline.getOptionValue("output_token_endpoint");
                conf.set("mapreduce.marklogic.output.token.endpoint", outputTokenEndpoint);
            }
            if (cmdline.hasOption("output_grant_type")) {
                String outputGrantType = cmdline.getOptionValue("output_grant_type");
                conf.set("mapreduce.marklogic.output.grant.type", outputGrantType);
            }
            if (cmdline.hasOption("output_token_duration")) {
                String outputTokenDuration = cmdline.getOptionValue("output_token_duration");
                conf.set("mapreduce.marklogic.output.token.duration", outputTokenDuration);
            }
            if (cmdline.hasOption("input_username")) {
                String username = cmdline.getOptionValue("input_username");
                conf.set("mapreduce.marklogic.input.username", username);
            }
            if (cmdline.hasOption("input_password")) {
                String password = cmdline.getOptionValue("input_password");
                conf.set("mapreduce.marklogic.input.password", password);
            }
            if (cmdline.hasOption("input_base_path")) {
                String inputBasePath = cmdline.getOptionValue("input_base_path");
                conf.set("mapreduce.marklogic.input.base.path", inputBasePath);
            }
            if (cmdline.hasOption("input_api_key")) {
                String inputApiKey = cmdline.getOptionValue("input_api_key");
                conf.set("mapreduce.marklogic.input.api.key", inputApiKey);
                if (conf.get("mapreduce.marklogic.input.base.path") == null) {
                    throw new IllegalArgumentException("Option input_base_path cannot be empty when input api key is specified.");
                }
            }
            String inputPort = "8000";
            if (cmdline.hasOption("input_port")) {
                inputPort = cmdline.getOptionValue("input_port");
            }
            if (conf.get("mapreduce.marklogic.input.api.key") != null) {
                inputPort = "443";
            }
            conf.set("mapreduce.marklogic.input.port", inputPort);
            if (cmdline.hasOption("input_host")) {
                String inputHosts = cmdline.getOptionValue("input_host");
                InternalUtilities.verifyHosts(inputHosts, conf.get("mapreduce.marklogic.input.port"));
                conf.set("mapreduce.marklogic.input.host", inputHosts);
            }
            if (cmdline.hasOption("input_database")) {
                String db = cmdline.getOptionValue("input_database");
                conf.set("mapreduce.marklogic.input.databasename", db);
            }
            if (cmdline.hasOption("restrict_input_hosts")) {
                String restrict = cmdline.getOptionValue("restrict_input_hosts");
                if (3.isNullOrEqualsTrue(restrict)) {
                    conf.setBoolean("mapreduce.marklogic.input.restricthosts", true);
                    HttpChannel.setUseHTTP((boolean)true);
                } else if (!"false".equalsIgnoreCase(restrict)) {
                    throw new IllegalArgumentException("Unrecognized option argument for restrict_input_hosts: " + restrict);
                }
            } else {
                HttpChannel.setUseHTTP((boolean)true);
            }
            if (conf.get("mapreduce.marklogic.input.base.path") != null) {
                conf.setBoolean("mapreduce.marklogic.input.restricthosts", true);
                HttpChannel.setUseHTTP((boolean)true);
            }
            if (cmdline.hasOption("input_ssl")) {
                arg = cmdline.getOptionValue("input_ssl");
                if (3.isNullOrEqualsTrue(arg)) {
                    conf.setBoolean("mapreduce.marklogic.input.usessl", true);
                } else if (!"false".equalsIgnoreCase(arg)) {
                    throw new IllegalArgumentException("Unrecognized option argument for input_ssl: " + arg);
                }
            }
            if (conf.get("mapreduce.marklogic.input.api.key") != null) {
                conf.setBoolean("mapreduce.marklogic.input.usessl", true);
            }
            3.applyProtocol(conf, cmdline, "input_ssl_protocol", "mapreduce.marklogic.input.sslprotocol");
            if (cmdline.hasOption("input_keystore_path")) {
                path = cmdline.getOptionValue("input_keystore_path");
                path = new Path(path).toString();
                conf.set("mapreduce.marklogic.input.keystorepath", path);
            }
            if (cmdline.hasOption("input_keystore_password")) {
                passwd = cmdline.getOptionValue("input_keystore_password");
                conf.set("mapreduce.marklogic.input.keystorepassword", passwd);
            }
            if (cmdline.hasOption("input_truststore_path")) {
                path = cmdline.getOptionValue("input_truststore_path");
                path = new Path(path).toString();
                conf.set("mapreduce.marklogic.input.truststorepath", path);
            }
            if (cmdline.hasOption("input_truststore_password")) {
                passwd = cmdline.getOptionValue("input_truststore_password");
                conf.set("mapreduce.marklogic.input.truststorepassword", passwd);
            }
            if (cmdline.hasOption("input_token_endpoint")) {
                String inputTokenEndpoint = cmdline.getOptionValue("input_token_endpoint");
                conf.set("mapreduce.marklogic.input.token.endpoint", inputTokenEndpoint);
            }
            if (cmdline.hasOption("input_grant_type")) {
                String inputGrantType = cmdline.getOptionValue("input_grant_type");
                conf.set("mapreduce.marklogic.input.grant.type", inputGrantType);
            }
            if (cmdline.hasOption("input_token_duration")) {
                String inputTokenDuration = cmdline.getOptionValue("input_token_duration");
                conf.set("mapreduce.marklogic.input.token.duration", inputTokenDuration);
            }
            if (cmdline.hasOption("temporal_collection")) {
                String tempColl = cmdline.getOptionValue("temporal_collection");
                conf.set("mapreduce.marklogic.output.temporalcollection", tempColl);
            }
            if (cmdline.hasOption("max_split_size")) {
                String maxSize = cmdline.getOptionValue("max_split_size");
                conf.set("mapreduce.marklogic.input.maxsplitsize", maxSize);
            }
            if (cmdline.hasOption("fastload")) {
                arg = cmdline.getOptionValue("fastload");
                conf.setBoolean("mapreduce.marklogic.output.content.fastload", 3.isNullOrEqualsTrue(arg));
            }
            if (cmdline.hasOption("output_directory")) {
                String outDir = cmdline.getOptionValue("output_directory");
                conf.set("mapreduce.marklogic.output.content.directory", outDir);
            }
            if (cmdline.hasOption("temporal_collection")) {
                InputType inputType = 3.getInputType(cmdline);
                String fileType = cmdline.getOptionValue("input_file_type");
                ContentType contentType = inputType.getContentType(cmdline);
                if (fileType != null && InputType.RDF.toString().equalsIgnoreCase(fileType)) {
                    throw new IllegalArgumentException("Cannot ingest RDF into temporal collection");
                }
                if (contentType != null && ContentType.BINARY == contentType) {
                    throw new IllegalArgumentException("Cannot ingest BINARY into temporal collection");
                }
            }
            3.applyPartitionConfigOptions(conf, cmdline);
            3.applyModuleConfigOptions(conf, cmdline);
            3.applyBatchTxn(conf, cmdline, 200);
        }

        @Override
        public void setMapperClass(Job job, Configuration conf, CommandLine cmdline) {
            job.setMapperClass(DocumentMapper.class);
        }

        @Override
        public Class<? extends Mapper<?, ?, ?, ?>> getRuntimeMapperClass(Job job, Class<? extends Mapper<?, ?, ?, ?>> mapper, int threadsPerSplit) {
            return mapper;
        }
    }
    ,
    EXTRACT{

        @Override
        public void applyConfigOptions(Configuration conf, CommandLine cmdline) {
            if (cmdline.hasOption("output_file_path")) {
                String path = cmdline.getOptionValue("output_file_path");
                String wkdir = conf.get("mapreduce.job.working.dir");
                if (wkdir != null) {
                    path = new Path(wkdir, path).toString();
                }
                conf.set("mapreduce.output.fileoutputformat.outputdir", path);
            }
            if (cmdline.hasOption("min_split_size")) {
                String minSize = cmdline.getOptionValue("min_split_size");
                conf.set("mapred.min.split.size", minSize);
                conf.set("mapreduce.input.fileinputformat.split.minsize", minSize);
            }
            if (cmdline.hasOption("max_split_size")) {
                String maxSize = cmdline.getOptionValue("max_split_size");
                conf.set("mapred.max.split.size", maxSize);
                conf.set("mapreduce.input.fileinputformat.split.maxsize", maxSize);
            }
            if (cmdline.hasOption("collection_filter")) {
                String colFilter = cmdline.getOptionValue("collection_filter");
                conf.set("mapreduce.marklogic.input.filter.collection", colFilter);
            }
            if (cmdline.hasOption("directory_filter")) {
                String dirFilter = cmdline.getOptionValue("directory_filter");
                conf.set("mapreduce.marklogic.input.filter.directory", dirFilter);
            }
            if (cmdline.hasOption("type_filter")) {
                String typeFilter = cmdline.getOptionValue("type_filter");
                conf.set("mapreduce.marklogic.input.filter.type", typeFilter);
            }
        }

        @Override
        public void configOptions(Options options) {
            4.configCommonOptions(options);
            OptionBuilder.withArgName((String)"string");
            OptionBuilder.hasArg();
            OptionBuilder.withDescription((String)"The file system location for input, as a regular expression");
            Option inputFilePath = OptionBuilder.create((String)"input_file_path");
            inputFilePath.setRequired(true);
            options.addOption(inputFilePath);
            OptionBuilder.withArgName((String)"string");
            OptionBuilder.hasArg();
            OptionBuilder.withDescription((String)"export output file path");
            Option outputFilePath = OptionBuilder.create((String)"output_file_path");
            outputFilePath.setRequired(true);
            options.addOption(outputFilePath);
            OptionBuilder.withArgName((String)"true,false");
            OptionBuilder.hasOptionalArg();
            OptionBuilder.withDescription((String)"Whether to compress the output document");
            Option exportCompress = OptionBuilder.create((String)"compress");
            options.addOption(exportCompress);
            OptionBuilder.withArgName((String)"comma list");
            OptionBuilder.hasArg();
            OptionBuilder.withDescription((String)"Comma-separated list of directories");
            Option df = OptionBuilder.create((String)"directory_filter");
            options.addOption(df);
            OptionBuilder.withArgName((String)"comma list");
            OptionBuilder.hasArg();
            OptionBuilder.withDescription((String)"Comma-separated list of collections");
            Option cf = OptionBuilder.create((String)"collection_filter");
            options.addOption(cf);
            OptionBuilder.withArgName((String)"comma list");
            OptionBuilder.hasArg();
            OptionBuilder.withDescription((String)"Comma-separated list of document types");
            Option tf = OptionBuilder.create((String)"type_filter");
            options.addOption(tf);
        }

        @Override
        public Job createJob(Configuration conf, CommandLine cmdline) throws IOException {
            this.applyConfigOptions(conf, cmdline);
            Job job = LocalJob.getInstance(conf);
            job.setInputFormatClass(ForestInputFormat.class);
            Class outputFormatClass = Command.isOutputCompressed(cmdline) ? ArchiveOutputFormat.class : SingleDocumentOutputFormat.class;
            job.setOutputFormatClass(outputFormatClass);
            this.setMapperClass(job, conf, cmdline);
            job.setMapOutputKeyClass(DocumentURI.class);
            job.setMapOutputValueClass(ForestDocument.class);
            job.setJobName(4.getNewJobName(conf));
            if (cmdline.hasOption("input_file_path")) {
                String path = cmdline.getOptionValue("input_file_path");
                FileInputFormat.setInputPaths((Job)job, (String)path);
            }
            return job;
        }

        @Override
        public Class<? extends Mapper<?, ?, ?, ?>> getRuntimeMapperClass(Job job, Class<? extends Mapper<?, ?, ?, ?>> mapper, int threadsPerSplit) {
            return mapper;
        }

        @Override
        public void setMapperClass(Job job, Configuration conf, CommandLine cmdline) {
            job.setMapperClass(DocumentMapper.class);
        }
    };

    public static final Log LOG;
    private static int jobid;
    private static Random rand;

    public static Command forName(String cmd) {
        if (IMPORT.name().equalsIgnoreCase(cmd)) {
            return IMPORT;
        }
        if (EXPORT.name().equalsIgnoreCase(cmd)) {
            return EXPORT;
        }
        if (COPY.name().equalsIgnoreCase(cmd)) {
            return COPY;
        }
        if (EXTRACT.name().equalsIgnoreCase(cmd)) {
            return EXTRACT;
        }
        throw new IllegalArgumentException("Unknown command: " + cmd);
    }

    protected static boolean isInputCompressed(CommandLine cmdline) {
        if (cmdline.hasOption("input_compressed")) {
            String isCompress = cmdline.getOptionValue("input_compressed");
            return Command.isNullOrEqualsTrue(isCompress);
        }
        return false;
    }

    protected static boolean isOutputCompressed(CommandLine cmdline) {
        if (cmdline.hasOption("compress")) {
            String isCompress = cmdline.getOptionValue("compress");
            return Command.isNullOrEqualsTrue(isCompress);
        }
        return false;
    }

    protected static boolean isStreaming(CommandLine cmdline, Configuration conf) {
        if (conf.get("mapreduce.marklogic.output.content.streaming") != null) {
            return conf.getBoolean("mapreduce.marklogic.output.content.streaming", false);
        }
        String arg = null;
        if (cmdline.hasOption("streaming") && Command.isNullOrEqualsTrue(arg = cmdline.getOptionValue("streaming"))) {
            InputType inputType = Command.getInputType(cmdline);
            if (inputType != InputType.DOCUMENTS) {
                LOG.warn((Object)("Streaming option is not applicable to input type " + inputType));
                conf.setBoolean("mapreduce.marklogic.output.content.streaming", false);
                return false;
            }
            conf.setBoolean("mapreduce.marklogic.output.content.streaming", true);
            return true;
        }
        conf.setBoolean("mapreduce.marklogic.output.content.streaming", false);
        return false;
    }

    public abstract void configOptions(Options var1);

    public abstract Job createJob(Configuration var1, CommandLine var2) throws IOException;

    public abstract void applyConfigOptions(Configuration var1, CommandLine var2);

    public abstract void setMapperClass(Job var1, Configuration var2, CommandLine var3);

    public abstract Class<? extends Mapper<?, ?, ?, ?>> getRuntimeMapperClass(Job var1, Class<? extends Mapper<?, ?, ?, ?>> var2, int var3);

    static void setQueryTimestamp(Configuration conf) throws IOException {
        try {
            ContentSource cs = InternalUtilities.getInputContentSource(conf);
            Session session = cs.newSession();
            conf.set("mapreduce.marklogic.input.querytimestamp", session.getCurrentServerPointInTime().toString());
        }
        catch (Exception ex) {
            throw new IOException("Error getting query timestamp", ex);
        }
    }

    static void configRedactionOptions(Options options) {
        OptionBuilder.withArgName((String)"comma list");
        OptionBuilder.hasArg();
        OptionBuilder.withDescription((String)"Comma separated list of redaction rule collection URIs");
        Option redaction = OptionBuilder.create((String)"redaction");
        options.addOption(redaction);
    }

    static void configCommonOptions(Options options) {
        OptionBuilder.withArgName((String)"string");
        OptionBuilder.hasArg();
        OptionBuilder.withDescription((String)"Whether to run in local or distributed mode.");
        Option mode = OptionBuilder.create((String)"mode");
        options.addOption(mode);
        OptionBuilder.withArgName((String)"string");
        OptionBuilder.hasArg();
        OptionBuilder.withDescription((String)"Override $HADOOP_CONF_DIR");
        Option hadoopConfDir = OptionBuilder.create((String)"hadoop_conf_dir");
        options.addOption(hadoopConfDir);
        OptionBuilder.withArgName((String)"number");
        OptionBuilder.hasArg();
        OptionBuilder.withDescription((String)"Number of threads");
        Option threadCount = OptionBuilder.create((String)"thread_count");
        options.addOption(threadCount);
        OptionBuilder.withArgName((String)"number");
        OptionBuilder.hasArg();
        OptionBuilder.withDescription((String)"Maximum number of MarkLogic documents per each input split in export or copy, or maximum number of bytes in file per each split in import");
        Option maxSplitSize = OptionBuilder.create((String)"max_split_size");
        options.addOption(maxSplitSize);
        OptionBuilder.withArgName((String)"number");
        OptionBuilder.hasArg();
        OptionBuilder.withDescription((String)"Minimum number of bytes in file per each split in import");
        Option minSplitSize = OptionBuilder.create((String)"min_split_size");
        options.addOption(minSplitSize);
    }

    static void configRDFGraphOutputOptions(Options options) {
        OptionBuilder.withArgName((String)"string");
        OptionBuilder.hasArg();
        OptionBuilder.withDescription((String)"Default graph for quad");
        Option outputGraph = OptionBuilder.create((String)"output_graph");
        options.addOption(outputGraph);
        OptionBuilder.withArgName((String)"string");
        OptionBuilder.hasArg();
        OptionBuilder.withDescription((String)"Graph overrided for quad");
        Option outputOverrideGraph = OptionBuilder.create((String)"output_override_graph");
        options.addOption(outputOverrideGraph);
    }

    static void configCommonOutputOptions(Options options) {
        OptionBuilder.withArgName((String)"comma list");
        OptionBuilder.hasArg();
        OptionBuilder.withDescription((String)"Comma separated list of regex pattern and string pairs, 1st to match a uri segment, 2nd the string to replace with, with the 2nd one in ''");
        Option outputUriReplace = OptionBuilder.create((String)"output_uri_replace");
        options.addOption(outputUriReplace);
        OptionBuilder.withArgName((String)"string");
        OptionBuilder.hasArg();
        OptionBuilder.withDescription((String)"String to prepend to all document URIs");
        Option outputUriPrefix = OptionBuilder.create((String)"output_uri_prefix");
        options.addOption(outputUriPrefix);
        OptionBuilder.withArgName((String)"string");
        OptionBuilder.hasArg();
        OptionBuilder.withDescription((String)"String to append to all document URIs");
        Option outputUriSuffix = OptionBuilder.create((String)"output_uri_suffix");
        options.addOption(outputUriSuffix);
        OptionBuilder.withArgName((String)"comma list");
        OptionBuilder.hasArg();
        OptionBuilder.withDescription((String)"Comma separated list of collection to be applied to output documents");
        Option outputCollections = OptionBuilder.create((String)"output_collections");
        options.addOption(outputCollections);
        OptionBuilder.withArgName((String)"comma list");
        OptionBuilder.hasArg();
        OptionBuilder.withDescription((String)"Comma separated list of user-privilege pairs to be applied to output documents");
        Option outputPermissions = OptionBuilder.create((String)"output_permissions");
        options.addOption(outputPermissions);
        OptionBuilder.withArgName((String)"number");
        OptionBuilder.hasArg();
        OptionBuilder.withDescription((String)"Quality to be applied to output documents");
        Option outputQuantity = OptionBuilder.create((String)"output_quality");
        options.addOption(outputQuantity);
    }

    static void configConnectionId(Options options) {
        OptionBuilder.withArgName((String)"string");
        OptionBuilder.hasArg();
        OptionBuilder.withDescription((String)"User name of MarkLogic Server");
        Option username = OptionBuilder.create((String)"username");
        options.addOption(username);
        OptionBuilder.withArgName((String)"string");
        OptionBuilder.hasArg();
        OptionBuilder.withDescription((String)"Password of MarkLogic Server");
        Option password = OptionBuilder.create((String)"password");
        options.addOption(password);
        OptionBuilder.withArgName((String)"string");
        OptionBuilder.hasArg();
        OptionBuilder.withDescription((String)"Comma-separated list of hosts of MarkLogic Server");
        Option host = OptionBuilder.create((String)"host");
        host.setRequired(true);
        options.addOption(host);
        OptionBuilder.withArgName((String)"number");
        OptionBuilder.hasArg();
        OptionBuilder.withDescription((String)"Port of MarkLogic Server");
        Option port = OptionBuilder.create((String)"port");
        options.addOption(port);
        OptionBuilder.withArgName((String)"string");
        OptionBuilder.hasArg();
        OptionBuilder.withDescription((String)"Database of MarkLogic Server");
        Option db = OptionBuilder.create((String)"database");
        options.addOption(db);
        OptionBuilder.withArgName((String)"true,false");
        OptionBuilder.hasOptionalArg();
        OptionBuilder.withDescription((String)"Whether to restrict the hosts mlcp connects to");
        Option restricHosts = OptionBuilder.create((String)"restrict_hosts");
        options.addOption(restricHosts);
        OptionBuilder.withArgName((String)"true,false");
        OptionBuilder.hasOptionalArg();
        OptionBuilder.withDescription((String)"Use SSL for encryted communication");
        Option ssl = OptionBuilder.create((String)"ssl");
        options.addOption(ssl);
        OptionBuilder.withArgName((String)"string");
        OptionBuilder.hasArg();
        OptionBuilder.withDescription((String)"SSL protocol, e.g. TLS, TLSv1");
        Option ssl_protocol = OptionBuilder.create((String)"ssl_protocol");
        options.addOption(ssl_protocol);
        OptionBuilder.withArgName((String)"string");
        OptionBuilder.hasArg();
        OptionBuilder.withDescription((String)"Output Keystore path to use for SSL connections.");
        Option keystorePath = OptionBuilder.create((String)"keystore_path");
        options.addOption(keystorePath);
        OptionBuilder.withArgName((String)"string");
        OptionBuilder.hasArg();
        OptionBuilder.withDescription((String)"Keystore password to use for SSL connections");
        Option keystorePasswd = OptionBuilder.create((String)"keystore_password");
        options.addOption(keystorePasswd);
        OptionBuilder.withArgName((String)"string");
        OptionBuilder.hasArg();
        OptionBuilder.withDescription((String)"Truststore path to use for SSL connections.");
        Option truststorePath = OptionBuilder.create((String)"truststore_path");
        options.addOption(truststorePath);
        OptionBuilder.withArgName((String)"string");
        OptionBuilder.hasArg();
        OptionBuilder.withDescription((String)"Truststore password to use for SSL connections");
        Option truststorePasswd = OptionBuilder.create((String)"truststore_password");
        options.addOption(truststorePasswd);
        OptionBuilder.withArgName((String)"string");
        OptionBuilder.hasArg();
        OptionBuilder.withDescription((String)"Base path that maps to a MarkLogic Application Server");
        Option basePath = OptionBuilder.create((String)"base_path");
        options.addOption(basePath);
    }

    static void configCopyOptions(Options options) {
        OptionBuilder.withArgName((String)"true,false");
        OptionBuilder.hasOptionalArg();
        OptionBuilder.withDescription((String)"Whether to copy document collections from source to destination");
        Option cpcol = OptionBuilder.create((String)"copy_collections");
        options.addOption(cpcol);
        OptionBuilder.withArgName((String)"true,false");
        OptionBuilder.hasOptionalArg();
        OptionBuilder.withDescription((String)"Whether to copy document permissions from source to destination");
        Option cppm = OptionBuilder.create((String)"copy_permissions");
        options.addOption(cppm);
        OptionBuilder.withArgName((String)"true,false");
        OptionBuilder.hasOptionalArg();
        OptionBuilder.withDescription((String)"Whether to copy document properties from source to destination");
        Option cppt = OptionBuilder.create((String)"copy_properties");
        options.addOption(cppt);
        OptionBuilder.withArgName((String)"true,false");
        OptionBuilder.hasOptionalArg();
        OptionBuilder.withDescription((String)"Whether to copy document quality from source to destination");
        Option cpqt = OptionBuilder.create((String)"copy_quality");
        options.addOption(cpqt);
        OptionBuilder.withArgName((String)"true,false");
        OptionBuilder.hasOptionalArg();
        OptionBuilder.withDescription((String)"Whether to copy document metadata from source to destination");
        Option cpmeta = OptionBuilder.create((String)"copy_metadata");
        options.addOption(cpmeta);
    }

    static void configBatchTxn(Options options) {
        OptionBuilder.withArgName((String)"number");
        OptionBuilder.hasArg();
        OptionBuilder.withDescription((String)"Number of documents in one request (default 100)");
        Option batchSize = OptionBuilder.create((String)"batch_size");
        options.addOption(batchSize);
        OptionBuilder.withArgName((String)"number");
        OptionBuilder.hasArg();
        OptionBuilder.withDescription((String)"Number of requests in one transaction (default 1)");
        Option txnSize = OptionBuilder.create((String)"transaction_size");
        options.addOption(txnSize);
    }

    static void configModule(Options options) {
        OptionBuilder.withArgName((String)"string");
        OptionBuilder.hasArg();
        OptionBuilder.withDescription((String)"Path to the module containing the transform function");
        Option moduleUri = OptionBuilder.create((String)"transform_module");
        options.addOption(moduleUri);
        OptionBuilder.withArgName((String)"string");
        OptionBuilder.hasArg();
        OptionBuilder.withDescription((String)"Namespace of the transform function");
        Option ns = OptionBuilder.create((String)"transform_namespace");
        options.addOption(ns);
        OptionBuilder.withArgName((String)"string");
        OptionBuilder.hasArg();
        OptionBuilder.withDescription((String)"Name of the transform function");
        Option func = OptionBuilder.create((String)"transform_function");
        options.addOption(func);
        OptionBuilder.withArgName((String)"string");
        OptionBuilder.hasArg();
        OptionBuilder.withDescription((String)"Parameters of the transform function");
        Option param = OptionBuilder.create((String)"transform_param");
        options.addOption(param);
        OptionBuilder.withArgName((String)"string");
        OptionBuilder.hasArg();
        OptionBuilder.withDescription((String)"The database that contains application modules");
        Option modules = OptionBuilder.create((String)"modules");
        options.addOption(modules);
        OptionBuilder.withArgName((String)"string");
        OptionBuilder.hasArg();
        OptionBuilder.withDescription((String)"The root document directory pathname");
        Option root = OptionBuilder.create((String)"modules_root");
        options.addOption(root);
    }

    static void configPartition(Options options) {
        OptionBuilder.withArgName((String)"string");
        OptionBuilder.hasArg();
        OptionBuilder.withDescription((String)"The partition where docs are inserted");
        Option partition = OptionBuilder.create((String)"output_partition");
        options.addOption(partition);
    }

    static void configFilteringOptions(Options options) {
        OptionBuilder.withArgName((String)"string");
        OptionBuilder.hasArg();
        OptionBuilder.withDescription((String)"Comma-separated list of directories");
        Option df = OptionBuilder.create((String)"directory_filter");
        options.addOption(df);
        OptionBuilder.withArgName((String)"comma list");
        OptionBuilder.hasArg();
        OptionBuilder.withDescription((String)"Comma-separated list of collections");
        Option cf = OptionBuilder.create((String)"collection_filter");
        options.addOption(cf);
        OptionBuilder.withArgName((String)"string");
        OptionBuilder.hasArg();
        OptionBuilder.withDescription((String)"Path expression used to retrieve documents or element nodes from the server");
        Option ds = OptionBuilder.create((String)"document_selector");
        options.addOption(ds);
        OptionBuilder.withArgName((String)"comma list");
        OptionBuilder.hasArg();
        OptionBuilder.withDescription((String)"Comma-separated list of alias-URI bindings used in document_selector");
        Option ns = OptionBuilder.create((String)"path_namespace");
        options.addOption(ns);
        OptionBuilder.withArgName((String)"string");
        OptionBuilder.hasArg();
        OptionBuilder.withDescription((String)"cts query to retrieve documents with");
        Option qf = OptionBuilder.create((String)"query_filter");
        options.addOption(qf);
    }

    static void configMLCloudAuthOptions(Options options) {
        OptionBuilder.withArgName((String)"string");
        OptionBuilder.hasArg();
        OptionBuilder.withDescription((String)"A unique key assigned to a MarkLogic Cloud user");
        Option apiKey = OptionBuilder.create((String)"api_key");
        options.addOption(apiKey);
        OptionBuilder.withArgName((String)"string");
        OptionBuilder.hasArg();
        OptionBuilder.withDescription((String)"MarkLogic Cloud token endpoint for obtaining session tokens");
        Option tokenEndpoint = OptionBuilder.create((String)"token_endpoint");
        options.addOption(tokenEndpoint);
        OptionBuilder.withArgName((String)"string");
        OptionBuilder.hasArg();
        OptionBuilder.withDescription((String)"Methods through which applications can gain session tokens");
        Option grantType = OptionBuilder.create((String)"grant_type");
        options.addOption(grantType);
        OptionBuilder.withArgName((String)"string");
        OptionBuilder.hasArg();
        OptionBuilder.withDescription((String)"Lifetime (in minutes) of session tokens");
        Option tokenDuration = OptionBuilder.create((String)"token_duration");
        options.addOption(tokenDuration);
    }

    static void configCopyMLCloudAuthOptions(Options options) {
        OptionBuilder.withArgName((String)"string");
        OptionBuilder.hasArg();
        OptionBuilder.withDescription((String)"A unique key assigned to a input MarkLogic Cloud user");
        Option inputApiKey = OptionBuilder.create((String)"input_api_key");
        options.addOption(inputApiKey);
        OptionBuilder.withArgName((String)"string");
        OptionBuilder.hasArg();
        OptionBuilder.withDescription((String)"A unique key assigned to an output MarkLogic Cloud user");
        Option outputApiKey = OptionBuilder.create((String)"output_api_key");
        options.addOption(outputApiKey);
        OptionBuilder.withArgName((String)"string");
        OptionBuilder.hasArg();
        OptionBuilder.withDescription((String)"Input MarkLogic Cloud token endpoint for obtaining session tokens");
        Option inputTokenEndpoint = OptionBuilder.create((String)"input_token_endpoint");
        options.addOption(inputTokenEndpoint);
        OptionBuilder.withArgName((String)"string");
        OptionBuilder.hasArg();
        OptionBuilder.withDescription((String)"Output MarkLogic Cloud token endpoint for obtaining session tokens");
        Option outputTokenEndpoint = OptionBuilder.create((String)"output_token_endpoint");
        options.addOption(outputTokenEndpoint);
        OptionBuilder.withArgName((String)"string");
        OptionBuilder.hasArg();
        OptionBuilder.withDescription((String)"Input methods through which applications can gain access tokens");
        Option inputGrantType = OptionBuilder.create((String)"input_grant_type");
        options.addOption(inputGrantType);
        OptionBuilder.withArgName((String)"string");
        OptionBuilder.hasArg();
        OptionBuilder.withDescription((String)"Output methods through which applications can gain session tokens");
        Option outputGrantType = OptionBuilder.create((String)"output_grant_type");
        options.addOption(outputGrantType);
        OptionBuilder.withArgName((String)"string");
        OptionBuilder.hasArg();
        OptionBuilder.withDescription((String)"Lifetime (in minutes) of input session tokens");
        Option inputTokenDuration = OptionBuilder.create((String)"input_token_duration");
        options.addOption(inputTokenDuration);
        OptionBuilder.withArgName((String)"string");
        OptionBuilder.hasArg();
        OptionBuilder.withDescription((String)"Lifetime (in minutes) of output session tokens");
        Option outputTokenDuration = OptionBuilder.create((String)"output_token_duration");
        options.addOption(outputTokenDuration);
    }

    static void applyModuleConfigOptions(Configuration conf, CommandLine cmdline) {
        if (cmdline.hasOption("transform_module")) {
            if (conf.getBoolean("mapreduce.marklogic.output.content.streaming", false)) {
                throw new UnsupportedOperationException("Server-side transformation can't work with streaming");
            }
            String arg = cmdline.getOptionValue("transform_module");
            conf.set("mapreduce.marklogic.transformmodule", arg);
            if (cmdline.hasOption("transform_namespace")) {
                arg = cmdline.getOptionValue("transform_namespace");
                conf.set("mapreduce.marklogic.transformnamespace", arg);
            }
            if (cmdline.hasOption("transform_function")) {
                arg = cmdline.getOptionValue("transform_function");
                conf.set("mapreduce.marklogic.transformfunction", arg);
            }
            if (cmdline.hasOption("transform_param")) {
                arg = cmdline.getOptionValue("transform_param");
                conf.set("mapreduce.marklogic.transformparam", arg);
            }
            if (cmdline.hasOption("modules")) {
                arg = cmdline.getOptionValue("modules");
                conf.set("mapreduce.marklogic.input.modules", arg);
            }
            if (cmdline.hasOption("modules_root")) {
                arg = cmdline.getOptionValue("modules_root");
                conf.set("mapreduce.marklogic.input.modulesroot", arg);
            }
        }
    }

    static void applyPartitionConfigOptions(Configuration conf, CommandLine cmdline) {
        if (cmdline.hasOption("output_partition")) {
            String arg = cmdline.getOptionValue("output_partition");
            conf.set("mapreduce.marklogic.output.partition", arg);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    static void applyCopyConfigOptions(Configuration conf, CommandLine cmdline) {
        String arg;
        if (cmdline.hasOption("copy_collections")) {
            arg = cmdline.getOptionValue("copy_collections");
            if (Command.isNullOrEqualsTrue(arg)) {
                conf.setBoolean("mapreduce.marklogic.copycollections", true);
            } else {
                if (!"false".equalsIgnoreCase(arg)) throw new IllegalArgumentException("Unrecognized option argument for copy_collections: " + arg);
                conf.setBoolean("mapreduce.marklogic.copycollections", false);
            }
        } else {
            conf.set("mapreduce.marklogic.copycollections", "true");
        }
        if (cmdline.hasOption("copy_permissions")) {
            arg = cmdline.getOptionValue("copy_permissions");
            if (Command.isNullOrEqualsTrue(arg)) {
                conf.setBoolean("mapreduce.marklogic.copypermissions", true);
            } else {
                if (!"false".equalsIgnoreCase(arg)) throw new IllegalArgumentException("Unrecognized option argument for copy_permissions: " + arg);
                conf.setBoolean("mapreduce.marklogic.copypermissions", false);
            }
        } else {
            conf.set("mapreduce.marklogic.copypermissions", "true");
        }
        if (cmdline.hasOption("copy_properties")) {
            arg = cmdline.getOptionValue("copy_properties");
            conf.setBoolean("mapreduce.marklogic.copyproperties", Command.isNullOrEqualsTrue(arg));
        } else {
            conf.set("mapreduce.marklogic.copyproperties", "true");
        }
        if (cmdline.hasOption("copy_quality")) {
            arg = cmdline.getOptionValue("copy_quality");
            if (Command.isNullOrEqualsTrue(arg)) {
                conf.setBoolean("mapreduce.marklogic.copyquality", true);
            } else {
                if (!"false".equalsIgnoreCase(arg)) throw new IllegalArgumentException("Unrecognized option argument for copy_quality: " + arg);
                conf.setBoolean("mapreduce.marklogic.copyquality", false);
            }
        } else {
            conf.set("mapreduce.marklogic.copyquality", "true");
        }
        if (cmdline.hasOption("copy_metadata")) {
            arg = cmdline.getOptionValue("copy_metadata");
            if (Command.isNullOrEqualsTrue(arg)) {
                conf.setBoolean("mapreduce.marklogic.copymetadata", true);
                return;
            } else {
                if (!"false".equalsIgnoreCase(arg)) throw new IllegalArgumentException("Unrecognized option argument for copy_metadata: " + arg);
                conf.setBoolean("mapreduce.marklogic.copymetadata", false);
            }
            return;
        } else {
            conf.set("mapreduce.marklogic.copymetadata", "true");
        }
    }

    static void applyFilteringConfigOptions(Configuration conf, CommandLine cmdline) {
        int i;
        StringBuilder sb;
        int filters = cmdline.hasOption("collection_filter") ? 1 : 0;
        filters += cmdline.hasOption("directory_filter") ? 1 : 0;
        if ((filters += cmdline.hasOption("document_selector") ? 1 : 0) > 1) {
            LOG.error((Object)"Only one of collection_filter, directory_filter and document_selector can be specified.");
            throw new IllegalArgumentException("Only one of collection_filter, directory_filter, query_filter and document_selector can be specified.");
        }
        if (cmdline.hasOption("collection_filter")) {
            String c = cmdline.getOptionValue("collection_filter");
            String[] cf = c.split(",");
            if (cf.length > 1) {
                sb = new StringBuilder("(");
                for (i = 0; i < cf.length; ++i) {
                    if (i > 0) {
                        sb.append(",");
                    }
                    sb.append("\"");
                    sb.append(cf[i]);
                    sb.append("\"");
                }
                sb.append(")");
                conf.set("mapreduce.marklogic.input.filter.collection", sb.toString());
                conf.set("mapreduce.marklogic.input.documentselector", "fn:collection(" + sb.toString() + ")");
            } else {
                conf.set("mapreduce.marklogic.input.filter.collection", "\"" + c + "\"");
                conf.set("mapreduce.marklogic.input.documentselector", "fn:collection(\"" + c + "\")");
            }
        }
        if (cmdline.hasOption("directory_filter")) {
            String d = cmdline.getOptionValue("directory_filter");
            String[] df = d.split(",");
            if (df.length > 1) {
                sb = new StringBuilder("(");
                for (i = 0; i < df.length; ++i) {
                    if (i > 0) {
                        sb.append(",");
                    }
                    if (!df[i].endsWith("/")) {
                        LOG.warn((Object)("directory_filter: Directory does not end with a forward slash (/): " + df[i]));
                    }
                    sb.append("\"");
                    sb.append(df[i]);
                    sb.append("\"");
                }
                sb.append(")");
                conf.set("mapreduce.marklogic.input.filter.directory", sb.toString());
                conf.set("mapreduce.marklogic.input.documentselector", "xdmp:directory(" + sb.toString() + ",\"infinity\")");
            } else {
                if (!d.endsWith("/")) {
                    LOG.warn((Object)("directory_filter: Directory does not end with a forward slash (/): " + d));
                }
                conf.set("mapreduce.marklogic.input.filter.directory", "\"" + d + "\"");
                conf.set("mapreduce.marklogic.input.documentselector", "xdmp:directory(\"" + d + "\",\"infinity\")");
            }
        }
        if (cmdline.hasOption("document_selector")) {
            conf.set("mapreduce.marklogic.input.documentselector", cmdline.getOptionValue("document_selector"));
        }
        if (cmdline.hasOption("path_namespace")) {
            conf.set("mapreduce.marklogic.input.namespace", cmdline.getOptionValue("path_namespace"));
        }
        if (cmdline.hasOption("query_filter")) {
            conf.set("mapreduce.marklogic.input.filter.query", cmdline.getOptionValue("query_filter"));
        }
    }

    static void applyBatchTxn(Configuration conf, CommandLine cmdline, int maxBatch) {
        int batch;
        String batchSize = cmdline.getOptionValue("batch_size");
        if (batchSize != null) {
            batch = Integer.decode(batchSize);
            if (batch > maxBatch) {
                LOG.warn((Object)("The setting for batch_size is changed to " + maxBatch));
                batch = maxBatch;
            }
        } else {
            batch = 100 > maxBatch ? maxBatch : 100;
        }
        conf.setInt("mapreduce.marklogic.output.batchsize", batch);
        String txnSize = cmdline.getOptionValue("transaction_size");
        if (txnSize != null) {
            int txn = Integer.decode(txnSize);
            if (txn * batch > 4000) {
                txn = 4000 / batch;
                LOG.warn((Object)("The setting for transaction_size is changed to " + txn));
            }
            conf.setInt("mapreduce.marklogic.output.transactionsize", txn);
        }
    }

    static void applyRDFGraphOutputConfigOptions(Configuration conf, CommandLine cmdline) {
        String graph;
        if (cmdline.hasOption("output_graph") && cmdline.hasOption("output_override_graph")) {
            throw new IllegalArgumentException("Only one of output_graph, output_override_graph can be specified.");
        }
        if (cmdline.hasOption("output_graph")) {
            graph = cmdline.getOptionValue("output_graph");
            conf.set("mapreduce.marklogic.output.rdf.graph", graph);
        }
        if (cmdline.hasOption("output_override_graph")) {
            graph = cmdline.getOptionValue("output_override_graph");
            conf.set("mapreduce.marklogic.output.rdf.overridegraph", graph);
        }
    }

    static void applyRedactionConfigOptions(Configuration conf, CommandLine cmdline) {
        if (cmdline.hasOption("redaction")) {
            String value = cmdline.getOptionValue("redaction");
            conf.set("mapreduce.marklogic.input.redaction.rules", value);
        }
    }

    static void applyCommonOutputConfigOptions(Configuration conf, CommandLine cmdline) {
        if (cmdline.hasOption("output_uri_replace")) {
            String uriReplace = cmdline.getOptionValue("output_uri_replace");
            if (uriReplace == null) {
                throw new IllegalArgumentException("Missing option argument: output_uri_replace");
            }
            String[] replace = uriReplace.split(",");
            if (replace.length % 2 != 0) {
                throw new IllegalArgumentException("Invalid option argument for output_uri_replace :" + uriReplace);
            }
            for (int i = 0; i < replace.length - 1; ++i) {
                String replacement;
                if ((replacement = replace[++i].trim()).startsWith("'") && replacement.endsWith("'")) continue;
                throw new IllegalArgumentException("Invalid option argument for output_uri_replace :" + uriReplace);
            }
            conf.setStrings("mapreduce.marklogic.output.urireplace", new String[]{uriReplace});
        }
        if (cmdline.hasOption("output_uri_prefix")) {
            String outPrefix = cmdline.getOptionValue("output_uri_prefix");
            conf.set("mapreduce.marklogic.output_uriprefix", outPrefix);
        }
        if (cmdline.hasOption("output_uri_suffix")) {
            String outSuffix = cmdline.getOptionValue("output_uri_suffix");
            conf.set("mapreduce.marklogic.output_urisuffix", outSuffix);
        }
        if (cmdline.hasOption("output_collections")) {
            String collectionsString = cmdline.getOptionValue("output_collections");
            conf.set("mapreduce.marklogic.output.content.collection", collectionsString);
        }
        if (cmdline.hasOption("output_permissions")) {
            String permissionString = cmdline.getOptionValue("output_permissions");
            conf.set("mapreduce.marklogic.output.content.permission", permissionString);
        }
        if (cmdline.hasOption("output_quality")) {
            String quantity = cmdline.getOptionValue("output_quality");
            conf.set("mapreduce.marklogic.output.content.quality", quantity);
        }
        if (cmdline.hasOption("rdf_streaming_memory_threshold")) {
            String thresh = cmdline.getOptionValue("rdf_streaming_memory_threshold");
            conf.set("rdf_streaming_memory_threshold", thresh);
        }
        if (cmdline.hasOption("rdf_triples_per_document")) {
            String count = cmdline.getOptionValue("rdf_triples_per_document");
            conf.set("rdf_triples_per_document", count);
        }
    }

    static InputType getInputType(CommandLine cmdline) {
        String inputTypeOption = cmdline.getOptionValue("input_file_type", "documents");
        return InputType.forName(inputTypeOption);
    }

    static String getNewJobName(Configuration conf) {
        String mode = conf.get("mapreduce.marklogic.mode", "local");
        StringBuilder jobNameBuf = new StringBuilder();
        jobNameBuf.append(mode);
        jobNameBuf.append('_');
        jobNameBuf.append(rand.nextInt(Integer.MAX_VALUE));
        jobNameBuf.append('_');
        jobNameBuf.append(++jobid);
        return jobNameBuf.toString();
    }

    static boolean isNullOrEqualsTrue(String arg) {
        return arg == null || "true".equalsIgnoreCase(arg);
    }

    static void applyProtocol(Configuration conf, CommandLine cmdline, String option, String protocolName) {
        if (cmdline.hasOption(option)) {
            String arg = cmdline.getOptionValue(option);
            if ("TLS".equalsIgnoreCase(arg)) {
                conf.set(protocolName, "TLS");
            } else if ("TLSv1".equalsIgnoreCase(arg)) {
                conf.set(protocolName, "TLSv1");
            } else if ("TLSv1.1".equalsIgnoreCase(arg)) {
                conf.set(protocolName, "TLSv1.1");
            } else if ("TLSv1.2".equalsIgnoreCase(arg)) {
                conf.set(protocolName, "TLSv1.2");
            } else {
                throw new IllegalArgumentException("Unrecognized option argument for " + option + ": " + arg);
            }
        }
    }

    public void printUsage(Command cmd, Options options) {
        HelpFormatter formatter = new HelpFormatter();
        formatter.printHelp(74, cmd.name(), null, options, null, true);
    }

    static {
        LOG = LogFactory.getLog(LocalJobRunner.class);
        jobid = 0;
        rand = new Random();
    }
}

