/*
 * Decompiled with CFR 0.152.
 */
package com.marklogic.contentpump;

import com.fasterxml.jackson.databind.JsonNode;
import com.marklogic.contentpump.ConfigConstants;
import com.marklogic.contentpump.DatabaseDocumentWithMeta;
import com.marklogic.contentpump.DocumentMetadata;
import com.marklogic.mapreduce.ContentType;
import com.marklogic.mapreduce.DocumentURI;
import com.marklogic.mapreduce.MarkLogicCounter;
import com.marklogic.mapreduce.MarkLogicDocument;
import com.marklogic.mapreduce.MarkLogicInputSplit;
import com.marklogic.mapreduce.MarkLogicRecordReader;
import com.marklogic.mapreduce.utilities.ForestHost;
import com.marklogic.mapreduce.utilities.InternalUtilities;
import com.marklogic.mapreduce.utilities.URIUtil;
import com.marklogic.xcc.AdhocQuery;
import com.marklogic.xcc.ContentSource;
import com.marklogic.xcc.Request;
import com.marklogic.xcc.RequestOptions;
import com.marklogic.xcc.ResultItem;
import com.marklogic.xcc.exceptions.MLCloudRequestException;
import com.marklogic.xcc.exceptions.QueryException;
import com.marklogic.xcc.exceptions.RequestException;
import com.marklogic.xcc.exceptions.XccConfigException;
import com.marklogic.xcc.types.JsonItem;
import com.marklogic.xcc.types.ValueType;
import com.marklogic.xcc.types.XSInteger;
import com.marklogic.xcc.types.XdmElement;
import com.marklogic.xcc.types.XdmItem;
import java.io.IOException;
import java.math.BigInteger;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.mapreduce.InputSplit;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class DatabaseContentReader
extends MarkLogicRecordReader<DocumentURI, MarkLogicDocument>
implements ConfigConstants {
    static final float DOCUMENT_TO_FRAGMENT_RATIO = 1.0f;
    public static final Log LOG = LogFactory.getLog(DatabaseContentReader.class);
    protected boolean copyCollection;
    protected boolean copyPermission;
    protected boolean copyProperties;
    protected boolean copyQuality;
    protected boolean copyMetadata;
    protected HashMap<String, DocumentMetadata> metadataMap;
    protected String ctsQuery = null;
    protected boolean nakedDone = false;
    protected boolean docDone = false;
    protected DocumentURI currentKey;
    protected DatabaseDocumentWithMeta currentValue;
    protected int nakedCount;

    public DatabaseContentReader(Configuration conf) {
        super(conf);
        this.copyCollection = conf.getBoolean("mapreduce.marklogic.copycollections", true);
        this.copyPermission = conf.getBoolean("mapreduce.marklogic.copypermissions", true);
        this.copyProperties = conf.getBoolean("mapreduce.marklogic.copyproperties", true);
        this.copyQuality = conf.getBoolean("mapreduce.marklogic.copyquality", true);
        this.copyMetadata = conf.getBoolean("mapreduce.marklogic.copymetadata", true);
        this.currentKey = new DocumentURI();
        this.metadataMap = new HashMap();
    }

    @Override
    public void initialize(InputSplit inSplit, TaskAttemptContext context) throws IOException, InterruptedException {
        this.mlSplit = (MarkLogicInputSplit)inSplit;
        this.count = 0L;
        this.nakedCount = 0;
        context.getCounter((Enum)MarkLogicCounter.ESTIMATED_INPUT_RECORDS).increment(this.mlSplit.getLength());
        this.hostNames = this.mlSplit.getLocations();
        if (this.hostNames == null || this.hostNames.length < 1) {
            throw new IllegalStateException("Empty split locations.");
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("split location: " + this.hostNames[0]));
        }
        this.replicas = this.mlSplit.getReplicas();
        this.curForest = -1;
        if (this.replicas != null) {
            for (int i = 0; i < this.replicas.size(); ++i) {
                if (!((ForestHost)this.replicas.get(i)).getHostName().equals(this.hostNames[0])) continue;
                this.curForest = i;
                break;
            }
        }
        this.retry = 0;
        this.sleepTime = 500;
        this.init();
    }

    private void init() throws IOException, InterruptedException {
        this.nakedDone = false;
        float recToFragRatio = this.conf.getFloat("mapreduce.marklogic.input.recordtofragmentratio", this.getDefaultRatio());
        this.length = (float)this.mlSplit.getLength() * recToFragRatio;
        long start = this.mlSplit.getStart() + 1L + this.count;
        long end = this.mlSplit.isLastSplit() ? Long.MAX_VALUE : start + this.mlSplit.getLength() - this.count - 1L;
        String src = this.conf.get("mapreduce.marklogic.input.documentselector");
        this.redactionRuleCol = this.conf.getStrings("mapreduce.marklogic.input.redaction.rules");
        Collection nsCol = null;
        if (src != null) {
            nsCol = this.conf.getStringCollection("mapreduce.marklogic.input.namespace");
        } else {
            src = "fn:collection()";
        }
        this.ctsQuery = this.conf.get("mapreduce.marklogic.input.filter.query");
        StringBuilder buf = new StringBuilder();
        if (this.ctsQuery != null) {
            this.buildSearchQuery(src, this.ctsQuery, nsCol, buf);
        } else {
            this.buildDocExprQuery(src, nsCol, null, buf);
        }
        src = buf.toString();
        buf = new StringBuilder();
        buf.append("xquery version \"1.0-ml\"; \n");
        buf.append("import module namespace hadoop = ");
        buf.append("\"http://marklogic.com/xdmp/hadoop\" at ");
        buf.append("\"/MarkLogic/hadoop.xqy\";\n");
        if (this.redactionRuleCol != null) {
            buf.append("import module namespace rdt = \"http://marklogic.com/xdmp/redaction\" at \"/MarkLogic/redaction.xqy\";\n");
        }
        buf.append("declare namespace mlmr=\"http://marklogic.com/hadoop\";\n");
        buf.append("declare option xdmp:output \"indent=no\";\n");
        buf.append("declare option xdmp:output \"indent-untyped=no\";\n");
        buf.append("declare variable $mlmr:splitstart as xs:integer external;\n");
        buf.append("declare variable $mlmr:splitend as xs:integer external;\n");
        buf.append("let $cols := ");
        buf.append(src);
        buf.append("\nlet $all-meta :=");
        buf.append("\nfor $doc in $cols");
        buf.append("\nlet $uri := fn:base-uri($doc)\n return (");
        buf.append("'META',");
        buf.append("$uri,");
        buf.append("if(fn:empty($doc/node())) then 0 ");
        buf.append("else if (fn:count($doc/node())>1) then \"element\" ");
        buf.append("else xdmp:node-kind($doc/node())");
        if (this.copyCollection || this.copyPermission || this.copyProperties || this.copyQuality) {
            buf.append(",");
            if (this.copyCollection) {
                buf.append("xdmp:document-get-collections($uri),\n");
            }
            if (this.copyPermission) {
                buf.append("let $list := xdmp:document-get-permissions($uri)\n");
                buf.append("return hadoop:get-permissions($list),");
            }
            if (this.copyQuality) {
                buf.append("xdmp:document-get-quality($uri),\n");
            } else {
                buf.append("0,");
            }
            if (this.copyMetadata) {
                buf.append("(let $f := fn:function-lookup(xs:QName('xdmp:document-get-metadata'),1)\nreturn if (exists($f)) then $f($uri) else ()),\n");
            }
            if (this.copyProperties) {
                buf.append("xdmp:document-properties($uri)/prop:properties,\n");
            }
        } else {
            buf.append(",0,");
            buf.append("(),\n");
        }
        buf.append("0");
        buf.append(" )\n");
        buf.append("return ($all-meta");
        buf.append(",'EOM',$cols)");
        String queryText = buf.toString();
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)queryText);
        }
        while (this.retry < 15) {
            try {
                if (this.retry == 1) {
                    LOG.info((Object)"Retrying connect");
                }
                String curForestName = "";
                String curHostName = "";
                if (this.curForest == -1) {
                    curForestName = this.mlSplit.getForestId().toString();
                    curHostName = this.hostNames[0];
                } else {
                    curForestName = ((ForestHost)this.replicas.get(this.curForest)).getForest();
                    curHostName = ((ForestHost)this.replicas.get(this.curForest)).getHostName();
                }
                ContentSource cs = InternalUtilities.getInputContentSource(this.conf, curHostName);
                this.session = cs.newSession("#" + curForestName);
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("Connect to forest " + curForestName + " on " + this.session.getConnectionUri().getHost()));
                }
                AdhocQuery aquery = this.session.newAdhocQuery(queryText);
                aquery.setNewIntegerVariable("http://marklogic.com/hadoop", "splitstart", start);
                aquery.setNewIntegerVariable("http://marklogic.com/hadoop", "splitend", end);
                RequestOptions options = new RequestOptions();
                options.setCacheResult(false);
                String ts = this.conf.get("mapreduce.marklogic.input.querytimestamp");
                if (ts != null) {
                    options.setEffectivePointInTime(new BigInteger(ts));
                    if (LOG.isDebugEnabled()) {
                        LOG.debug((Object)("Query timestamp: " + ts));
                    }
                }
                aquery.setOptions(options);
                this.result = this.session.submitRequest((Request)aquery);
                this.initMetadataMap();
                break;
            }
            catch (XccConfigException e) {
                LOG.error((Object)("XccConfigException:" + e));
                throw new IOException(e);
            }
            catch (QueryException e) {
                LOG.error((Object)("QueryException:" + e));
                LOG.debug((Object)("Query: " + queryText));
                throw new IOException(e);
            }
            catch (Exception e) {
                boolean isRetryable = true;
                if (e instanceof MLCloudRequestException) {
                    isRetryable = ((MLCloudRequestException)e).isRetryable();
                    LOG.error((Object)("MLCloudRequestException:" + e.getMessage()));
                } else {
                    LOG.error((Object)("Exception:" + e.getMessage()));
                }
                if (isRetryable && this.curForest != -1) {
                    if (++this.retry < 15) {
                        try {
                            Thread.sleep(this.sleepTime);
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                        this.sleepTime = Math.min(this.sleepTime * 2, 30000);
                        this.curForest = (this.curForest + 1) % this.replicas.size();
                        continue;
                    }
                    LOG.info((Object)"Retry limit exceeded");
                }
                throw new IOException(e);
            }
        }
    }

    protected void queryNakedProperties() throws RequestException {
        StringBuilder buf = new StringBuilder();
        buf.append("xquery version \"1.0-ml\"; \n");
        buf.append("import module namespace hadoop = ");
        buf.append("\"http://marklogic.com/xdmp/hadoop\" at ");
        buf.append("\"/MarkLogic/hadoop.xqy\";\n");
        buf.append("let $props := cts:search(");
        String cFilter = null;
        String dFilter = null;
        cFilter = this.conf.get("mapreduce.marklogic.input.filter.collection");
        if (cFilter != null) {
            buf.append("xdmp:collection-properties(");
            buf.append(cFilter);
            buf.append(")");
        } else {
            dFilter = this.conf.get("mapreduce.marklogic.input.filter.directory");
            if (dFilter != null) {
                buf.append("xdmp:directory-properties(");
                buf.append(dFilter);
                buf.append(", \"infinity\")");
            } else {
                buf.append("xdmp:collection-properties()");
            }
        }
        buf.append(",");
        if (this.ctsQuery == null) {
            buf.append("cts:not-query(cts:document-fragment-query(");
            buf.append("cts:and-query(()))),");
            buf.append("(\"unfiltered\",\"score-zero\"))\n");
        } else {
            buf.append("cts:and-query((cts:query(xdmp:unquote('");
            this.ctsQuery = this.ctsQuery.replaceAll("&", "&amp;");
            this.ctsQuery = this.ctsQuery.replaceAll("'", "&apos;");
            buf.append(this.ctsQuery);
            buf.append("')/*),cts:not-query(cts:document-fragment-query(");
            buf.append("cts:and-query(()))))),");
            buf.append("(\"unfiltered\",\"score-zero\"))\n");
        }
        buf.append("for $doc in $props\n");
        buf.append("let $uri := fn:base-uri($doc)\n return (");
        buf.append("'META',");
        buf.append("$uri,");
        buf.append("if(fn:empty($doc/node())) then 0 else xdmp:node-kind($doc/node()),");
        if (this.copyCollection) {
            buf.append("xdmp:document-get-collections($uri),\n");
        }
        if (this.copyPermission) {
            buf.append("let $list := xdmp:document-get-permissions($uri)\n");
            buf.append("return hadoop:get-permissions($list),");
        }
        if (this.copyQuality) {
            buf.append("xdmp:document-get-quality($uri),\n");
        } else {
            buf.append("0,");
        }
        if (this.copyMetadata) {
            buf.append("(let $f := fn:function-lookup(xs:QName('xdmp:document-get-metadata'),1)\nreturn if (exists($f)) then $f($uri) else ()),\n");
        }
        buf.append("document {$doc/prop:properties}/*, \n");
        buf.append("0");
        buf.append(")");
        String queryText = buf.toString();
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)queryText);
        }
        AdhocQuery aquery = this.session.newAdhocQuery(queryText);
        RequestOptions options = new RequestOptions();
        options.setCacheResult(false);
        String ts = this.conf.get("mapreduce.marklogic.input.querytimestamp");
        if (ts != null) {
            options.setEffectivePointInTime(new BigInteger(ts));
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Query timestamp: " + ts));
            }
        }
        aquery.setOptions(options);
        this.result = this.session.submitRequest((Request)aquery);
        this.nakedDone = true;
    }

    private void initMetadataMap() throws IOException {
        while (this.result.hasNext()) {
            ResultItem item = this.result.next();
            String type = null;
            if (item == null || item.getItemType() != ValueType.XS_STRING) {
                throw new IOException("incorrect format:" + item.getItem() + "\n" + this.result.asString());
            }
            type = item.asString();
            if ("META".equals(type)) {
                DocumentMetadata metadata = new DocumentMetadata();
                String uri = this.parseMetadata(metadata);
                this.metadataMap.put(uri, metadata);
                continue;
            }
            if ("EOM".equals(type)) {
                return;
            }
            throw new IOException("incorrect type");
        }
    }

    private String parseMetadata(DocumentMetadata metadata) throws IOException {
        XdmItem metaItem;
        ResultItem item = this.result.next();
        String uri = item.asString();
        if (uri == null) {
            throw new IOException("Missing document URI for metadata.");
        }
        item = this.result.next();
        String nKind = item.asString();
        metadata.setFormat(nKind);
        item = this.result.next();
        while (item != null && item.getItemType() == ValueType.XS_STRING) {
            if (!this.copyCollection) {
                item = this.result.next();
                continue;
            }
            metadata.addCollection(item.asString());
            item = this.result.next();
        }
        StringBuilder buf = new StringBuilder();
        buf.append("<perms>");
        while (item != null && ValueType.ELEMENT == item.getItemType()) {
            if (!this.copyPermission) {
                item = this.result.next();
                continue;
            }
            try {
                this.readPermission((XdmElement)item.getItem(), metadata, buf);
            }
            catch (Exception e) {
                throw new IOException(e);
            }
            item = this.result.next();
        }
        buf.append("</perms>");
        metadata.setPermString(buf.toString());
        metadata.setQuality((XSInteger)item.getItem());
        item = this.result.next();
        if (this.copyMetadata && (metaItem = item.getItem()) instanceof JsonItem) {
            JsonNode node = ((JsonItem)metaItem).asJsonNode();
            metadata.meta = new HashMap<String, String>(node.size());
            Iterator names = node.fieldNames();
            while (names.hasNext()) {
                String key = (String)names.next();
                JsonNode nodeVal = node.get(key);
                metadata.meta.put(key, nodeVal.asText());
            }
            item = this.result.next();
        }
        if (this.copyProperties && ValueType.ELEMENT == item.getItemType()) {
            String pString = item.asString();
            if (pString != null) {
                metadata.setProperties(pString);
            }
            item = this.result.next();
        }
        if (ValueType.XS_INTEGER != item.getItemType()) {
            throw new IOException(uri + " unexpected " + item.getItemType() + " " + item.asString() + ", expected " + ValueType.XS_INTEGER + " 0");
        }
        return uri;
    }

    @Override
    public boolean nextKeyValue() throws IOException, InterruptedException {
        if (!this.docDone) {
            this.retry = 0;
            this.sleepTime = 500;
            while (this.retry < 15) {
                try {
                    if (this.result != null && this.result.hasNext()) {
                        ResultItem currItem = null;
                        currItem = this.result.next();
                        String uri = null;
                        uri = currItem.getDocumentURI();
                        if (uri == null) {
                            ++this.count;
                            throw new IOException("Missing document URI for result " + currItem.toString());
                        }
                        this.currentValue = new DatabaseDocumentWithMeta();
                        DocumentMetadata metadata = this.metadataMap.get(uri);
                        uri = URIUtil.applyUriReplace(uri, this.conf);
                        uri = URIUtil.applyPrefixSuffix(uri, this.conf);
                        this.currentKey.setUri(uri);
                        if (metadata != null) {
                            this.currentValue.setMeta(metadata);
                            this.currentValue.set(currItem);
                        } else {
                            LOG.error((Object)("no meta for " + uri));
                        }
                        ++this.count;
                        return true;
                    }
                    break;
                }
                catch (RuntimeException e) {
                    LOG.error((Object)("RuntimeException reading " + this.currentKey + " :" + e));
                    StringBuilder buf = new StringBuilder();
                    if (this.hostNames.length > 1) {
                        buf.append("host names: ");
                    } else {
                        buf.append("host name: ");
                    }
                    for (int i = 0; i < this.hostNames.length; ++i) {
                        if (i > 0) {
                            buf.append(", ");
                        }
                        buf.append(this.hostNames[i]);
                    }
                    LOG.info((Object)buf.toString());
                    if (this.curForest != -1) {
                        if (++this.retry < 15) {
                            try {
                                Thread.sleep(this.sleepTime);
                            }
                            catch (Exception i) {
                                // empty catch block
                            }
                            this.sleepTime = Math.min(this.sleepTime * 2, 30000);
                            this.curForest = (this.curForest + 1) % this.replicas.size();
                            this.init();
                            continue;
                        }
                        LOG.info((Object)"Retry limit exceeded");
                    }
                    throw e;
                }
            }
            this.docDone = true;
        }
        if (this.copyProperties && this.mlSplit.getStart() == 0L) {
            this.retry = 0;
            this.sleepTime = 500;
            while (this.retry < 15) {
                try {
                    if (!this.nakedDone) {
                        this.queryNakedProperties();
                        for (int curCount = 0; curCount < this.nakedCount; ++curCount) {
                            if (this.result.hasNext()) {
                                this.result.next();
                                continue;
                            }
                            return false;
                        }
                    }
                    if (this.result.hasNext()) {
                        ResultItem currItem = null;
                        currItem = this.result.next();
                        this.currentValue = new DatabaseDocumentWithMeta();
                        ResultItem item = currItem;
                        String type = null;
                        if (item == null || item.getItemType() != ValueType.XS_STRING) {
                            throw new IOException("incorrect format:" + item.getItem() + "\n" + this.result.asString());
                        }
                        type = item.asString();
                        if (!"META".equals(type)) {
                            throw new IOException("incorrect type");
                        }
                        DocumentMetadata metadata = new DocumentMetadata();
                        String uri = this.parseMetadata(metadata);
                        metadata.setNakedProps(true);
                        uri = URIUtil.applyUriReplace(uri, this.conf);
                        uri = URIUtil.applyPrefixSuffix(uri, this.conf);
                        this.currentKey.setUri(uri);
                        this.currentValue.setMeta(metadata);
                        this.currentValue.setContentType(ContentType.XML);
                        ++this.nakedCount;
                        return true;
                    }
                    break;
                }
                catch (RequestException e) {
                    LOG.error((Object)("RequestException:" + e));
                    if (this.curForest != -1) {
                        if (++this.retry < 15) {
                            try {
                                Thread.sleep(this.sleepTime);
                            }
                            catch (Exception exception) {
                                // empty catch block
                            }
                            this.sleepTime = Math.min(this.sleepTime * 2, 30000);
                            this.curForest = (this.curForest + 1) % this.replicas.size();
                            this.init();
                            continue;
                        }
                        LOG.info((Object)"Exceeded max retry");
                    }
                    throw new IOException(e);
                }
                catch (RuntimeException e) {
                    LOG.error((Object)("RuntimeException:" + e));
                    if (this.curForest != -1) {
                        if (++this.retry < 15) {
                            try {
                                Thread.sleep(this.sleepTime);
                            }
                            catch (Exception exception) {
                                // empty catch block
                            }
                            this.sleepTime = Math.min(this.sleepTime * 2, 30000);
                            this.curForest = (this.curForest + 1) % this.replicas.size();
                            this.init();
                            continue;
                        }
                        LOG.info((Object)"Exceeded max retry");
                    }
                    throw e;
                }
            }
        }
        return false;
    }

    @Override
    protected boolean nextResult(ResultItem result) {
        return false;
    }

    private void readPermission(XdmElement _permissionElement, DocumentMetadata metadata, StringBuilder buf) throws Exception {
        String permString = _permissionElement.asString();
        int i = permString.indexOf("<sec:role-name>");
        int j = permString.indexOf("</sec:role-name>");
        if (i == -1 || j == -1) {
            throw new Exception("Error retrieving document permission");
        }
        buf.append(permString.substring(0, i));
        buf.append(permString.substring(j + 16));
        Element permissionW3cElement = _permissionElement.asW3cElement();
        NodeList capabilities = permissionW3cElement.getElementsByTagName("sec:capability");
        NodeList roles = permissionW3cElement.getElementsByTagName("sec:role-name");
        NodeList ids = permissionW3cElement.getElementsByTagName("sec:role-id");
        if (0 < roles.getLength() && 0 < capabilities.getLength()) {
            Node role = roles.item(0);
            Node capability = capabilities.item(0);
            Node id = ids.item(0);
            metadata.addPermission(capability.getTextContent(), role.getTextContent(), id.getTextContent());
            if (roles.getLength() > 1) {
                LOG.warn((Object)("input permission: " + permissionW3cElement + ": " + roles.getLength() + " roles, using only 1"));
            }
            if (capabilities.getLength() > 1) {
                LOG.warn((Object)("input permission: " + permissionW3cElement + ": " + capabilities.getLength() + " capabilities, using only 1"));
            }
            if (capabilities.getLength() > 1) {
                LOG.warn((Object)("input permission: " + permissionW3cElement + ": " + ids.getLength() + " ids, using only 1"));
            }
        } else {
            if (roles.getLength() < 1) {
                LOG.warn((Object)("skipping input permission: " + permissionW3cElement + ": no roles"));
            }
            if (capabilities.getLength() < 1) {
                LOG.warn((Object)("skipping input permission: " + permissionW3cElement + ": no capabilities"));
            }
        }
    }

    @Override
    protected void endOfResult() {
        this.currentKey = null;
        this.currentValue = null;
    }

    @Override
    protected float getDefaultRatio() {
        return 1.0f;
    }

    public DocumentURI getCurrentKey() throws IOException, InterruptedException {
        return this.currentKey;
    }

    public MarkLogicDocument getCurrentValue() throws IOException, InterruptedException {
        return this.currentValue;
    }
}

