/*
 * Decompiled with CFR 0.152.
 */
package com.marklogic.contentpump;

import com.marklogic.mapreduce.InternalConstants;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.zip.ZipEntry;
import java.util.zip.ZipException;
import java.util.zip.ZipOutputStream;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.LocalFileSystem;
import org.apache.hadoop.fs.Path;

public class OutputArchive
implements InternalConstants {
    public static final Log LOG = LogFactory.getLog(OutputArchive.class);
    public static final String EXTENSION = ".zip";
    private long currentFileBytes = 0L;
    private ZipOutputStream outputStream;
    private String basePath;
    private String currPath;
    private static AtomicInteger fileCount = new AtomicInteger();
    private int currentEntries;
    private Configuration conf;

    public OutputArchive(String path, Configuration conf) {
        this.basePath = path.toLowerCase().endsWith(EXTENSION) ? path : path + EXTENSION;
        this.conf = conf;
    }

    private void newOutputStream() throws IOException {
        int count = fileCount.getAndIncrement();
        this.currPath = OutputArchive.newPackagePath(this.basePath, count, 6);
        if (this.outputStream != null) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("closing output archive: " + this.currPath));
            }
            this.outputStream.flush();
            this.outputStream.close();
        }
        this.currentFileBytes = 0L;
        this.currentEntries = 0;
        Path zpath = new Path(this.currPath);
        FileSystem fs = zpath.getFileSystem(this.conf);
        if (fs.exists(zpath)) {
            throw new IOException(zpath + " already exists.");
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Creating output archive: " + zpath));
            LOG.debug((Object)("Default charset: " + Charset.defaultCharset()));
        }
        if (fs instanceof LocalFileSystem) {
            File f = new File(zpath.toUri().getPath());
            if (!f.exists()) {
                f.getParentFile().mkdirs();
                f.createNewFile();
            }
            FileOutputStream fos = new FileOutputStream(f, false);
            this.outputStream = new ZipOutputStream(new BufferedOutputStream(fos));
        } else {
            FSDataOutputStream fsout = fs.create(zpath, false);
            this.outputStream = new ZipOutputStream(new BufferedOutputStream((OutputStream)fsout));
        }
    }

    protected static String newPackagePath(String canonicalPath, int count, int width) {
        Object path = canonicalPath;
        if (((String)path).endsWith(EXTENSION)) {
            int index1 = ((String)path).lastIndexOf(EXTENSION);
            String subStr = ((String)path).substring(0, index1);
            int index2 = subStr.lastIndexOf(45);
            path = ((String)path).substring(0, index2) + String.format("-%0" + width + "d", count) + ((String)path).substring(index2);
        } else {
            path = (String)path + "-" + count;
        }
        return path;
    }

    public void write(String uri, InputStream is, long size, boolean isExportDoc) throws IOException {
        ZipEntry entry = new ZipEntry(uri);
        if ((this.outputStream == null || this.currentFileBytes + size > Integer.MAX_VALUE && this.currentFileBytes > 0L) && this.currentEntries % 2 == 0 && !isExportDoc) {
            this.newOutputStream();
        }
        long totalRead = 0L;
        try {
            this.outputStream.putNextEntry(entry);
            long bufSize = Math.min(size, 0x1000000L);
            byte[] buf = new byte[(int)bufSize];
            long read = 0L;
            for (long toRead = size; toRead > 0L; toRead -= read) {
                read = is.read(buf, 0, (int)bufSize);
                if (read > 0L) {
                    this.outputStream.write(buf, 0, (int)read);
                    totalRead += read;
                    continue;
                }
                if (size == Integer.MAX_VALUE) break;
                LOG.warn((Object)("Premature EOF: uri=" + uri + ",toRead=" + toRead));
                break;
            }
            this.outputStream.closeEntry();
        }
        catch (ZipException e) {
            LOG.warn((Object)("Exception caught: " + e.getMessage() + entry.getName()));
        }
        this.currentFileBytes += totalRead;
        ++this.currentEntries;
    }

    public long write(String outputPath, byte[] bytes, boolean isExportDoc) throws IOException {
        if (null == outputPath) {
            throw new NullPointerException("null path");
        }
        if (null == bytes) {
            throw new NullPointerException("null content bytes");
        }
        long total = bytes.length;
        ZipEntry entry = new ZipEntry(outputPath);
        if (this.outputStream == null) {
            this.newOutputStream();
        }
        if (this.currentFileBytes > 0L && this.currentFileBytes + total > Integer.MAX_VALUE) {
            if (this.currentEntries % 2 == 0 && !isExportDoc) {
                this.newOutputStream();
            } else {
                LOG.warn((Object)("too many bytes in current package:" + this.currPath));
            }
        }
        try {
            this.outputStream.putNextEntry(entry);
            this.outputStream.write(bytes);
            this.outputStream.closeEntry();
        }
        catch (ZipException e) {
            LOG.warn((Object)("Exception caught: " + e.getMessage() + entry.getName()));
            return 0L;
        }
        this.currentFileBytes += total;
        ++this.currentEntries;
        return total;
    }

    public void close() throws IOException {
        if (this.outputStream != null) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("closing output archive: " + this.currPath));
            }
            this.outputStream.flush();
            this.outputStream.close();
        }
    }
}

