/*
 * Decompiled with CFR 0.152.
 */
package com.marklogic.contentpump;

import com.marklogic.contentpump.FileAndDirectoryInputFormat;
import com.marklogic.contentpump.RDFReader;
import com.marklogic.mapreduce.DocumentURIWithSourceInfo;
import com.marklogic.mapreduce.LinkedMapWritable;
import java.io.IOException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.DefaultStringifier;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapreduce.InputSplit;
import org.apache.hadoop.mapreduce.JobContext;
import org.apache.hadoop.mapreduce.RecordReader;
import org.apache.hadoop.mapreduce.TaskAttemptContext;

public class RDFInputFormat
extends FileAndDirectoryInputFormat<DocumentURIWithSourceInfo, Text> {
    public static final Log LOG = LogFactory.getLog(RDFInputFormat.class);

    @Override
    protected boolean isSplitable(JobContext context, Path filename) {
        return false;
    }

    public RecordReader<DocumentURIWithSourceInfo, Text> createRecordReader(InputSplit is, TaskAttemptContext context) throws IOException, InterruptedException {
        String version = null;
        LinkedMapWritable roleMap = null;
        try {
            version = this.getServerVersion(context);
            roleMap = this.getRoleMap(context);
        }
        catch (IOException e) {
            throw new IOException("Error creating RecordReader:" + e.getMessage());
        }
        return new RDFReader<Text>(version, roleMap);
    }

    protected LinkedMapWritable getRoleMap(TaskAttemptContext context) throws IOException {
        Configuration conf = context.getConfiguration();
        LinkedMapWritable fhmap = null;
        if (conf.get("mapreduce.marklogic.output.rolemap") != null) {
            fhmap = (LinkedMapWritable)DefaultStringifier.load((Configuration)conf, (String)"mapreduce.marklogic.output.rolemap", LinkedMapWritable.class);
        }
        return fhmap;
    }

    protected String getServerVersion(TaskAttemptContext context) throws IOException {
        Configuration conf = context.getConfiguration();
        Text version = (Text)DefaultStringifier.load((Configuration)conf, (String)"mapreduce.marklogic.serverversion", Text.class);
        return version.toString();
    }
}

