/*
 * Decompiled with CFR 0.152.
 */
package com.marklogic.mapreduce;

import com.marklogic.contentpump.LocalJob;
import com.marklogic.mapreduce.MarkLogicConstants;
import com.marklogic.mapreduce.utilities.InternalUtilities;
import com.marklogic.mapreduce.utilities.TextArrayWritable;
import com.marklogic.xcc.AdhocQuery;
import com.marklogic.xcc.ContentSource;
import com.marklogic.xcc.Request;
import com.marklogic.xcc.RequestOptions;
import com.marklogic.xcc.ResultItem;
import com.marklogic.xcc.ResultSequence;
import com.marklogic.xcc.Session;
import com.marklogic.xcc.exceptions.RequestException;
import com.marklogic.xcc.exceptions.ServerConnectionException;
import java.io.IOException;
import java.util.ArrayList;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configurable;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.io.DefaultStringifier;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapreduce.JobContext;
import org.apache.hadoop.mapreduce.OutputCommitter;
import org.apache.hadoop.mapreduce.OutputFormat;
import org.apache.hadoop.mapreduce.TaskAttemptContext;

public abstract class MarkLogicOutputFormat<KEYOUT, VALUEOUT>
extends OutputFormat<KEYOUT, VALUEOUT>
implements MarkLogicConstants,
Configurable {
    public static final Log LOG = LogFactory.getLog(MarkLogicOutputFormat.class);
    static final String DIRECTORY_TEMPLATE = "{dir}";
    static final String DELETE_DIRECTORY_TEMPLATE = "xdmp:directory-delete(\"{dir}\")";
    static final String CHECK_DIRECTORY_EXIST_TEMPLATE = "exists(xdmp:directory(\"{dir}\", \"infinity\"))";
    static final String DIRECTORY_CREATE_QUERY = "import module namespace hadoop = \"http://marklogic.com/xdmp/hadoop\" at \"/MarkLogic/hadoop.xqy\";\nhadoop:get-directory-creation()";
    public static final String HOSTS_QUERY = "import module namespace hadoop = \"http://marklogic.com/xdmp/hadoop\" at \"/MarkLogic/hadoop.xqy\";\nlet $f :=   fn:function-lookup(xs:QName('hadoop:get-host-names'),0)\nlet $f2 :=   fn:function-lookup(xs:QName('hadoop:get-replica-host-names'),0)\nreturn  if (exists($f2)) then $f2() else \n   if(exists($f)) then $f() else\n   for $i at $p in hadoop:get-forest-host-map()   where $p mod 2 eq 0    return $i";
    static final String MANUAL_DIRECTORY_MODE = "manual";
    protected Configuration conf;

    public void checkOutputSpecs(JobContext context) throws IOException {
        String[] hosts = this.conf.getStrings("mapreduce.marklogic.output.host");
        if (hosts == null || hosts.length == 0) {
            throw new IllegalStateException("mapreduce.marklogic.output.host is not specified.");
        }
        for (String host : hosts) {
            try {
                ContentSource cs = InternalUtilities.getOutputContentSource(this.conf, host);
                ((LocalJob)context).getThreadManager().queryServerMaxThreads(cs);
                this.checkOutputSpecs(this.conf, cs, context);
                return;
            }
            catch (Exception ex) {
                if (!(ex instanceof ServerConnectionException)) {
                    LOG.warn((Object)("Exception:" + ex.getMessage()));
                    throw new IOException(ex);
                }
                LOG.warn((Object)("ServerConnectionException:" + ex.getMessage() + " . Unable to connect to " + host + " to query destination information"));
            }
        }
        throw new IOException("Unable to query destination information, no usable hostname found");
    }

    public OutputCommitter getOutputCommitter(TaskAttemptContext context) throws IOException, InterruptedException {
        return new OutputCommitter(){

            public void abortTask(TaskAttemptContext taskContext) {
            }

            public void commitTask(TaskAttemptContext taskContext) {
            }

            public boolean needsTaskCommit(TaskAttemptContext taskContext) {
                return false;
            }

            public void setupJob(JobContext jobContext) {
            }

            public void setupTask(TaskAttemptContext taskContext) {
            }
        };
    }

    public Configuration getConf() {
        return this.conf;
    }

    public void setConf(Configuration conf) {
        this.conf = conf;
    }

    protected TextArrayWritable getHosts(Configuration conf) throws IOException {
        String forestHost = conf.get("mapreduce.marklogic.output.hostforests");
        if (forestHost != null) {
            TextArrayWritable hosts = (TextArrayWritable)((Object)DefaultStringifier.load((Configuration)conf, (String)"mapreduce.marklogic.output.hostforests", TextArrayWritable.class));
            return hosts;
        }
        throw new IOException("Forest host map not found");
    }

    protected TextArrayWritable queryHosts(ContentSource cs) throws IOException {
        return this.queryHosts(cs, null, null);
    }

    protected TextArrayWritable queryHosts(ContentSource cs, String matchHost, String replaceHost) throws IOException {
        Session session = null;
        ResultSequence result = null;
        try {
            session = cs.newSession();
            AdhocQuery query = session.newAdhocQuery(HOSTS_QUERY);
            RequestOptions options = new RequestOptions();
            options.setDefaultXQueryVersion("1.0-ml");
            query.setOptions(options);
            result = session.submitRequest((Request)query);
            ArrayList<Text> hosts = new ArrayList<Text>();
            while (result.hasNext()) {
                ResultItem item = result.next();
                String host = item.asString();
                if (matchHost != null && host.equals(matchHost)) {
                    hosts.add(new Text(replaceHost));
                    continue;
                }
                hosts.add(new Text(host));
            }
            if (hosts.isEmpty()) {
                throw new IOException("Target database has no forests attached: check forests in database");
            }
            TextArrayWritable textArrayWritable = new TextArrayWritable(hosts.toArray(new Text[hosts.size()]));
            return textArrayWritable;
        }
        catch (RequestException e) {
            LOG.error((Object)e.getMessage(), (Throwable)e);
            throw new IOException(e);
        }
        finally {
            if (result != null) {
                result.close();
            }
            if (session != null) {
                session.close();
            }
        }
    }

    public abstract void checkOutputSpecs(Configuration var1, ContentSource var2, JobContext var3) throws IOException;
}

