/*
 * Decompiled with CFR 0.152.
 */
package com.marklogic.mapreduce.examples;

import com.marklogic.mapreduce.KeyValueInputFormat;
import com.marklogic.mapreduce.functions.ElemAttrValueCooccurrences;
import java.io.IOException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.IntWritable;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.mapreduce.Mapper;
import org.apache.hadoop.mapreduce.Reducer;
import org.apache.hadoop.mapreduce.lib.output.FileOutputFormat;
import org.apache.hadoop.mapreduce.lib.output.TextOutputFormat;
import org.apache.hadoop.util.GenericOptionsParser;

public class LinkCountCooccurrences {
    public static void main(String[] args) throws Exception {
        Configuration conf = new Configuration();
        if (args.length < 2) {
            System.err.println("Usage: LinkCountCooccurrences configFile outputDir");
            System.exit(2);
        }
        String[] otherArgs = new GenericOptionsParser(conf, args).getRemainingArgs();
        Job job = Job.getInstance((Configuration)conf, (String)"link count cooccurrences");
        job.setJarByClass(LinkCountCooccurrences.class);
        job.setInputFormatClass(KeyValueInputFormat.class);
        job.setMapperClass(RefMapper.class);
        job.setMapOutputKeyClass(Text.class);
        job.setMapOutputValueClass(IntWritable.class);
        job.setCombinerClass(IntSumReducer.class);
        job.setReducerClass(IntSumReducer.class);
        job.setOutputFormatClass(TextOutputFormat.class);
        job.setOutputKeyClass(Text.class);
        job.setOutputValueClass(IntWritable.class);
        FileOutputFormat.setOutputPath((Job)job, (Path)new Path(otherArgs[1]));
        conf = job.getConfiguration();
        conf.addResource(otherArgs[0]);
        conf.setClass("mapreduce.marklogic.input.keyclass", Text.class, Writable.class);
        conf.setClass("mapreduce.marklogic.input.valueclass", Text.class, Writable.class);
        conf.setClass("mapreduce.marklogic.input.lexiconfunctionclass", HrefTitleMap.class, ElemAttrValueCooccurrences.class);
        System.exit(job.waitForCompletion(true) ? 0 : 1);
    }

    static class HrefTitleMap
    extends ElemAttrValueCooccurrences {
        HrefTitleMap() {
        }

        @Override
        public String getElementName1() {
            return "xs:QName(\"wp:a\")";
        }

        @Override
        public String getElementName2() {
            return "xs:QName(\"wp:a\")";
        }

        @Override
        public String getAttributeName1() {
            return "xs:QName(\"href\")";
        }

        @Override
        public String getAttributeName2() {
            return "xs:QName(\"title\")";
        }

        @Override
        public String[] getUserDefinedOptions() {
            String[] options = new String[]{"collation=http://marklogic.com/collation/codepoint", "proximity=0"};
            return options;
        }

        @Override
        public String getLexiconQuery() {
            return "cts:directory-query(\"enwiki/\", \"infinity\")";
        }
    }

    public static class IntSumReducer
    extends Reducer<Text, IntWritable, Text, IntWritable> {
        private IntWritable result = new IntWritable();

        public void reduce(Text key, Iterable<IntWritable> values, Reducer.Context context) throws IOException, InterruptedException {
            int sum = 0;
            for (IntWritable val : values) {
                sum += val.get();
            }
            this.result.set(sum);
            context.write((Object)key, (Object)this.result);
        }
    }

    public static class RefMapper
    extends Mapper<Text, Text, Text, IntWritable> {
        private static final IntWritable one = new IntWritable(1);
        private Text refURI = new Text();

        public void map(Text key, Text value, Mapper.Context context) throws IOException, InterruptedException {
            String keyStr = key.toString();
            if (!(keyStr.startsWith("#") || keyStr.startsWith("http://") || keyStr.startsWith("File:") || keyStr.startsWith("Image:") || value == null)) {
                this.refURI.set(value);
                context.write((Object)this.refURI, (Object)one);
            }
        }
    }
}

