/*
 * Decompiled with CFR 0.152.
 */
package com.marklogic.mapreduce.test;

import java.io.IOException;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.BytesWritable;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapreduce.InputSplit;
import org.apache.hadoop.mapreduce.RecordReader;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.apache.hadoop.mapreduce.lib.input.FileSplit;

class BinaryFileReader
extends RecordReader<Text, BytesWritable> {
    private Text key = new Text();
    private BytesWritable value = new BytesWritable();
    private long bytesRead;
    private long bytesTotal;
    private boolean hasNext;

    public void close() throws IOException {
    }

    public Text getCurrentKey() throws IOException, InterruptedException {
        return this.key;
    }

    public BytesWritable getCurrentValue() throws IOException, InterruptedException {
        return this.value;
    }

    public float getProgress() throws IOException, InterruptedException {
        return (float)this.bytesRead / (float)this.bytesTotal;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void initialize(InputSplit inSplit, TaskAttemptContext context) throws IOException, InterruptedException {
        this.bytesTotal = inSplit.getLength();
        Path file = ((FileSplit)inSplit).getPath();
        FileSystem fs = file.getFileSystem(context.getConfiguration());
        FSDataInputStream fileIn = fs.open(file);
        this.key.set(file.toString());
        byte[] buf = new byte[(int)inSplit.getLength()];
        System.out.println("split length: " + inSplit.getLength());
        try {
            fileIn.readFully(buf);
            this.value.set(buf, 0, (int)inSplit.getLength());
            System.out.println("value length: " + this.value.getBytes().length);
            this.hasNext = true;
        }
        catch (Exception e) {
            this.hasNext = false;
        }
        finally {
            fileIn.close();
        }
    }

    public boolean nextKeyValue() throws IOException, InterruptedException {
        if (this.hasNext) {
            this.hasNext = false;
            return true;
        }
        return false;
    }
}

