/*
 * Decompiled with CFR 0.152.
 */
package com.marklogic.mapreduce.utilities;

import com.marklogic.mapreduce.DocumentURI;
import com.marklogic.mapreduce.utilities.AssignmentPolicy;
import com.marklogic.mapreduce.utilities.LegacyAssignmentPolicy;
import java.math.BigInteger;
import java.util.LinkedHashSet;

public class SegmentAssignmentPolicy
extends LegacyAssignmentPolicy {
    public static long rotr(BigInteger value, int shift) {
        return value.shiftRight(shift).xor(value.shiftLeft(64 - shift)).longValue();
    }

    public SegmentAssignmentPolicy() {
    }

    public SegmentAssignmentPolicy(LinkedHashSet<String> uForests) {
        super(uForests);
        this.policy = AssignmentPolicy.Kind.SEGMENT;
    }

    public static int getPlacementId(DocumentURI uri, int size) {
        switch (size) {
            case 0: {
                throw new IllegalArgumentException("getPlacementId(size = 0)");
            }
            case 1: {
                return 0;
            }
        }
        String nk = SegmentAssignmentPolicy.normalize(uri.getUri());
        BigInteger uriKey = SegmentAssignmentPolicy.getUriKey(nk);
        long u = uriKey.longValue();
        u ^= SegmentAssignmentPolicy.rotr(uriKey, 2);
        u ^= SegmentAssignmentPolicy.rotr(uriKey, 3);
        u ^= SegmentAssignmentPolicy.rotr(uriKey, 5);
        u ^= SegmentAssignmentPolicy.rotr(uriKey, 7);
        u ^= SegmentAssignmentPolicy.rotr(uriKey, 11);
        u ^= SegmentAssignmentPolicy.rotr(uriKey, 13);
        u ^= SegmentAssignmentPolicy.rotr(uriKey, 17);
        u ^= SegmentAssignmentPolicy.rotr(uriKey, 19);
        u ^= SegmentAssignmentPolicy.rotr(uriKey, 23);
        u ^= SegmentAssignmentPolicy.rotr(uriKey, 29);
        u ^= SegmentAssignmentPolicy.rotr(uriKey, 31);
        u ^= SegmentAssignmentPolicy.rotr(uriKey, 37);
        u ^= SegmentAssignmentPolicy.rotr(uriKey, 41);
        u ^= SegmentAssignmentPolicy.rotr(uriKey, 43);
        u ^= SegmentAssignmentPolicy.rotr(uriKey, 47);
        u ^= SegmentAssignmentPolicy.rotr(uriKey, 53);
        u ^= SegmentAssignmentPolicy.rotr(uriKey, 59);
        return (int)Long.remainderUnsigned(u ^= SegmentAssignmentPolicy.rotr(uriKey, 61), size);
    }

    @Override
    public int getPlacementForestIndex(DocumentURI uri) {
        return SegmentAssignmentPolicy.getPlacementId(uri, this.forests.length);
    }
}

