/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.documentdb;

import com.microsoft.azure.documentdb.DocumentClient;
import com.microsoft.azure.documentdb.DocumentClientException;
import com.microsoft.azure.documentdb.DocumentQueryClientInternal;
import com.microsoft.azure.documentdb.FeedOptions;
import com.microsoft.azure.documentdb.FeedOptionsBase;
import com.microsoft.azure.documentdb.PartitionResolver;
import com.microsoft.azure.documentdb.Resource;
import com.microsoft.azure.documentdb.SqlQuerySpec;
import com.microsoft.azure.documentdb.internal.ResourceType;
import com.microsoft.azure.documentdb.internal.Utils;
import com.microsoft.azure.documentdb.internal.query.QueryExecutionContext;
import com.microsoft.azure.documentdb.internal.query.QueryExecutionContextFactory;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class QueryIterable<T extends Resource>
implements Iterable<T> {
    private final DocumentClient client;
    private final ResourceType resourceType;
    private final Class<T> classT;
    private final SqlQuerySpec querySpec;
    private final FeedOptionsBase options;
    private final String resourceLink;
    private final Object partitionKey;
    private QueryExecutionContext<T> queryExecutionContext;

    protected QueryIterable(DocumentClient client, ResourceType resourceType, Class<T> classT, String resourceLink, FeedOptionsBase options) {
        this(client, resourceType, classT, resourceLink, null, options, null);
    }

    protected QueryIterable(DocumentClient client, ResourceType resourceType, Class<T> classT, String resourceLink, SqlQuerySpec querySpec, FeedOptionsBase options) {
        this(client, resourceType, classT, resourceLink, querySpec, options, null);
    }

    protected QueryIterable(DocumentClient client, ResourceType resourceType, Class<T> classT, String resourceLink, FeedOptionsBase options, Object partitionKey) {
        this(client, resourceType, classT, resourceLink, null, options, partitionKey);
    }

    protected QueryIterable(DocumentClient client, ResourceType resourceType, Class<T> classT, String resourceLink, SqlQuerySpec querySpec, FeedOptionsBase options, Object partitionKey) {
        this.client = client;
        this.resourceType = resourceType;
        this.classT = classT;
        this.querySpec = querySpec;
        if (options == null) {
            options = new FeedOptions();
        }
        this.options = options;
        this.resourceLink = resourceLink;
        this.partitionKey = partitionKey;
        this.reset();
    }

    private QueryExecutionContext<T> createQueryExecutionContext(DocumentClient client, ResourceType resourceType, Class<T> classT, String resourceLink, SqlQuerySpec querySpec, FeedOptionsBase options, Object partitionKey) {
        PartitionResolver partitionResolver;
        if (resourceType == ResourceType.Document && Utils.isDatabaseLink(resourceLink) && (partitionResolver = client.getPartitionResolver(resourceLink)) != null) {
            return QueryExecutionContextFactory.createQueryExecutionContext(new DocumentQueryClientInternal(client), resourceType, classT, querySpec, options, partitionResolver.resolveForRead(partitionKey));
        }
        return QueryExecutionContextFactory.createQueryExecutionContext(new DocumentQueryClientInternal(client), resourceType, classT, querySpec, options, resourceLink);
    }

    public Map<String, String> getResponseHeaders() {
        return this.queryExecutionContext.getResponseHeaders();
    }

    @Override
    public Iterator<T> iterator() {
        return this.queryExecutionContext;
    }

    public List<T> toList() {
        ArrayList<Resource> list = new ArrayList<Resource>();
        for (Resource t : this) {
            if (t == null) continue;
            list.add(t);
        }
        return list;
    }

    public void reset() {
        this.queryExecutionContext = this.createQueryExecutionContext(this.client, this.resourceType, this.classT, this.resourceLink, this.querySpec, this.options, this.partitionKey);
    }

    public List<T> fetchNextBlock() throws DocumentClientException {
        return this.queryExecutionContext.fetchNextBlock();
    }
}

