/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.documentdb.internal;

import com.microsoft.azure.documentdb.ConnectionPolicy;
import com.microsoft.azure.documentdb.DocumentClientException;
import com.microsoft.azure.documentdb.internal.DocumentServiceRequest;
import com.microsoft.azure.documentdb.internal.EndpointManager;
import com.microsoft.azure.documentdb.internal.RetryPolicy;
import java.net.URI;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class EndpointDiscoveryRetryPolicy
implements RetryPolicy {
    private static final int MAX_RETRY_COUNT = 120;
    private static final int RETRY_INTERVAL_IN_MS = 1000;
    private static final Logger LOGGER = LoggerFactory.getLogger(EndpointDiscoveryRetryPolicy.class);
    private final EndpointManager globalEndpointManager;
    private final ConnectionPolicy connectionPolicy;
    private final DocumentServiceRequest request;
    private URI locationEndpoint;
    private int failoverRetryCount = 0;

    public EndpointDiscoveryRetryPolicy(ConnectionPolicy connectionPolicy, EndpointManager globalEndpointManager, DocumentServiceRequest request) {
        this.connectionPolicy = connectionPolicy;
        this.globalEndpointManager = globalEndpointManager;
        request.clearRouteToLocation();
        this.locationEndpoint = this.globalEndpointManager.resolveServiceEndpoint(request);
        request.routeToLocation(this.locationEndpoint);
        this.request = request;
    }

    @Override
    public long getRetryAfterInMilliseconds() {
        if (!this.request.isReadOnlyRequest()) {
            return this.failoverRetryCount <= 1 ? 0L : 1000L;
        }
        return 1000L;
    }

    @Override
    public boolean shouldRetry(DocumentClientException exception) {
        if (!this.connectionPolicy.getEnableEndpointDiscovery()) {
            return false;
        }
        if (this.failoverRetryCount >= 120) {
            return false;
        }
        ++this.failoverRetryCount;
        if (this.locationEndpoint != null) {
            if (this.request.isReadOnlyRequest()) {
                this.globalEndpointManager.markEndpointUnavailableForRead(this.locationEndpoint);
            } else {
                this.globalEndpointManager.markEndpointUnavailableForWrite(this.locationEndpoint);
            }
        }
        if (!this.request.isReadOnlyRequest()) {
            LOGGER.debug(String.format("Failover happening. retryCount %d", this.failoverRetryCount));
        }
        boolean forceRefresh = exception.getSubStatusCode() != null && exception.getSubStatusCode() == 3;
        this.globalEndpointManager.refreshEndpointList(null, forceRefresh);
        this.request.clearRouteToLocation();
        this.request.routeToLocation(this.failoverRetryCount, false);
        this.locationEndpoint = this.globalEndpointManager.resolveServiceEndpoint(this.request);
        this.request.routeToLocation(this.locationEndpoint);
        return true;
    }
}

