/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.documentdb.internal;

import com.microsoft.azure.documentdb.DocumentClientException;
import com.microsoft.azure.documentdb.internal.DocumentServiceRequest;
import com.microsoft.azure.documentdb.internal.EndpointManager;
import com.microsoft.azure.documentdb.internal.RetryPolicy;
import com.microsoft.azure.documentdb.internal.Utils;
import java.net.URI;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class SessionReadRetryPolicy
implements RetryPolicy {
    private static final int maxRetryCount = 1;
    private static final int retryIntervalInMS = 0;
    private static final Logger LOGGER = LoggerFactory.getLogger(SessionReadRetryPolicy.class);
    private final DocumentServiceRequest currentRequest;
    private final EndpointManager globalEndpointManager;
    private final boolean endpointDiscoveryEnable;
    private boolean canUseMultipleWriteLocations;
    private volatile int sessionTokenRetryCount = 0;
    private URI locationEndpoint;

    public SessionReadRetryPolicy(EndpointManager globalEndpointManager, DocumentServiceRequest request, boolean endpointDiscoveryEnable) {
        this.globalEndpointManager = globalEndpointManager;
        this.currentRequest = request;
        this.endpointDiscoveryEnable = endpointDiscoveryEnable;
        this.canUseMultipleWriteLocations = this.globalEndpointManager.canUseMultipleWriteLocations(request);
        request.clearRouteToLocation();
        this.locationEndpoint = this.globalEndpointManager.resolveServiceEndpoint(request);
        request.routeToLocation(this.locationEndpoint);
    }

    @Override
    public long getRetryAfterInMilliseconds() {
        return 0L;
    }

    @Override
    public boolean shouldRetry(DocumentClientException exception) {
        ++this.sessionTokenRetryCount;
        this.currentRequest.clearRouteToLocation();
        if (!this.endpointDiscoveryEnable) {
            return false;
        }
        if (this.canUseMultipleWriteLocations) {
            List<String> endpoints;
            List<String> list = endpoints = Utils.isReadOnlyOperation(this.currentRequest.getOperationType()) ? this.globalEndpointManager.getOrderedReadEndpoints() : this.globalEndpointManager.getOrderedWriteEndpoints();
            if (this.sessionTokenRetryCount > endpoints.size()) {
                return false;
            }
            this.currentRequest.routeToLocation(this.sessionTokenRetryCount - 1, this.sessionTokenRetryCount > 1);
            this.currentRequest.setShouldClearSessionTokenOnSessionReadFailure(this.sessionTokenRetryCount == endpoints.size());
            this.locationEndpoint = this.globalEndpointManager.resolveServiceEndpoint(this.currentRequest);
            this.currentRequest.routeToLocation(this.locationEndpoint);
            return true;
        }
        if (this.sessionTokenRetryCount > 1) {
            return false;
        }
        this.currentRequest.routeToLocation(this.sessionTokenRetryCount - 1, false);
        this.currentRequest.setShouldClearSessionTokenOnSessionReadFailure(true);
        this.locationEndpoint = this.globalEndpointManager.resolveServiceEndpoint(this.currentRequest);
        this.currentRequest.routeToLocation(this.locationEndpoint);
        return true;
    }
}

